/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.client.HandlerConfiguration;
import com.sun.xml.internal.ws.handler.HandlerProcessor;
import com.sun.xml.internal.ws.handler.HandlerTube;
import com.sun.xml.internal.ws.handler.MessageUpdatableContext;
import com.sun.xml.internal.ws.handler.SOAPHandlerProcessor;
import com.sun.xml.internal.ws.handler.SOAPMessageContextImpl;
import com.sun.xml.internal.ws.message.DataHandlerAttachment;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;

public class ServerSOAPHandlerTube
extends HandlerTube {
    private WSBinding binding;
    private Set<String> roles;

    public ServerSOAPHandlerTube(WSBinding wSBinding, WSDLPort wSDLPort, Tube tube) {
        super(tube, wSDLPort);
        if (wSBinding.getSOAPVersion() != null) {
            // empty if block
        }
        this.binding = wSBinding;
        this.setUpHandlersOnce();
    }

    public ServerSOAPHandlerTube(WSBinding wSBinding, Tube tube, HandlerTube handlerTube) {
        super(tube, handlerTube);
        this.binding = wSBinding;
        this.setUpHandlersOnce();
    }

    private ServerSOAPHandlerTube(ServerSOAPHandlerTube serverSOAPHandlerTube, TubeCloner tubeCloner) {
        super(serverSOAPHandlerTube, tubeCloner);
        this.binding = serverSOAPHandlerTube.binding;
        this.handlers = serverSOAPHandlerTube.handlers;
        this.roles = serverSOAPHandlerTube.roles;
    }

    public AbstractFilterTubeImpl copy(TubeCloner tubeCloner) {
        return new ServerSOAPHandlerTube(this, tubeCloner);
    }

    private void setUpHandlersOnce() {
        this.handlers = new ArrayList();
        HandlerConfiguration handlerConfiguration = ((BindingImpl)this.binding).getHandlerConfig();
        List<SOAPHandler> list = handlerConfiguration.getSoapHandlers();
        if (!list.isEmpty()) {
            this.handlers.addAll(list);
            this.roles = new HashSet<String>();
            this.roles.addAll(handlerConfiguration.getRoles());
        }
    }

    void setUpProcessor() {
        if (!this.handlers.isEmpty()) {
            this.processor = new SOAPHandlerProcessor(false, this, this.binding, this.handlers);
        }
    }

    MessageUpdatableContext getContext(Packet packet) {
        SOAPMessageContextImpl sOAPMessageContextImpl = new SOAPMessageContextImpl(this.binding, packet, this.roles);
        return sOAPMessageContextImpl;
    }

    boolean callHandlersOnRequest(MessageUpdatableContext messageUpdatableContext, boolean bl) {
        boolean bl2;
        try {
            bl2 = this.processor.callHandlersRequest(HandlerProcessor.Direction.INBOUND, messageUpdatableContext, !bl);
        }
        catch (RuntimeException runtimeException) {
            this.remedyActionTaken = true;
            throw runtimeException;
        }
        if (!bl2) {
            this.remedyActionTaken = true;
        }
        return bl2;
    }

    void callHandlersOnResponse(MessageUpdatableContext messageUpdatableContext, boolean bl) {
        Map map = (Map)messageUpdatableContext.get("javax.xml.ws.binding.attachments.outbound");
        AttachmentSet attachmentSet = this.packet.getMessage().getAttachments();
        for (String string : map.keySet()) {
            if (attachmentSet.get(string) != null) continue;
            DataHandlerAttachment dataHandlerAttachment = new DataHandlerAttachment(string, (DataHandler)map.get(string));
            attachmentSet.add(dataHandlerAttachment);
        }
        try {
            this.processor.callHandlersResponse(HandlerProcessor.Direction.OUTBOUND, messageUpdatableContext, bl);
        }
        catch (WebServiceException webServiceException) {
            throw webServiceException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
    }

    void closeHandlers(MessageContext messageContext) {
        this.closeServersideHandlers(messageContext);
    }
}

