/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import javax.management.MBeanServerPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MBeanServerPermissionCollection
extends PermissionCollection {
    private MBeanServerPermission collectionPermission;
    private static final long serialVersionUID = -5661980843569388590L;

    MBeanServerPermissionCollection() {
    }

    @Override
    public synchronized void add(Permission permission) {
        if (!(permission instanceof MBeanServerPermission)) {
            String string = "Permission not an MBeanServerPermission: " + permission;
            throw new IllegalArgumentException(string);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("Read-only permission collection");
        }
        MBeanServerPermission mBeanServerPermission = (MBeanServerPermission)permission;
        if (this.collectionPermission == null) {
            this.collectionPermission = mBeanServerPermission;
        } else if (!this.collectionPermission.implies(permission)) {
            int n = this.collectionPermission.mask | mBeanServerPermission.mask;
            this.collectionPermission = new MBeanServerPermission(n);
        }
    }

    @Override
    public synchronized boolean implies(Permission permission) {
        return this.collectionPermission != null && this.collectionPermission.implies(permission);
    }

    @Override
    public synchronized Enumeration<Permission> elements() {
        Set<Object> set = this.collectionPermission == null ? Collections.emptySet() : Collections.singleton(this.collectionPermission);
        return Collections.enumeration(set);
    }
}

