/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.font.GraphicAttribute;
import java.awt.font.NumericShaper;
import java.awt.font.TextAttribute;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.im.InputMethodHighlight;
import java.io.Serializable;
import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import sun.font.AttributeMap;
import sun.font.EAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeValues
implements Cloneable {
    private int defined;
    private int nondefault;
    private String family = "Default";
    private float weight = 1.0f;
    private float width = 1.0f;
    private float posture;
    private float size = 12.0f;
    private float tracking;
    private NumericShaper numericShaping;
    private AffineTransform transform;
    private GraphicAttribute charReplacement;
    private Paint foreground;
    private Paint background;
    private float justification = 1.0f;
    private Object imHighlight;
    private Font font;
    private byte imUnderline = (byte)-1;
    private byte superscript;
    private byte underline = (byte)-1;
    private byte runDirection = (byte)-2;
    private byte bidiEmbedding;
    private byte kerning;
    private byte ligatures;
    private boolean strikethrough;
    private boolean swapColors;
    private AffineTransform baselineTransform;
    private AffineTransform charTransform;
    private static final AttributeValues DEFAULT = new AttributeValues();
    public static final int MASK_ALL = AttributeValues.getMask((EAttribute[])EAttribute.class.getEnumConstants());
    private static final String DEFINED_KEY = "sun.font.attributevalues.defined_key";

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String string) {
        this.family = string;
        this.update(EAttribute.EFAMILY);
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float f) {
        this.weight = f;
        this.update(EAttribute.EWEIGHT);
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f) {
        this.width = f;
        this.update(EAttribute.EWIDTH);
    }

    public float getPosture() {
        return this.posture;
    }

    public void setPosture(float f) {
        this.posture = f;
        this.update(EAttribute.EPOSTURE);
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float f) {
        this.size = f;
        this.update(EAttribute.ESIZE);
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform == null || affineTransform.isIdentity() ? AttributeValues.DEFAULT.transform : new AffineTransform(affineTransform);
        this.updateDerivedTransforms();
        this.update(EAttribute.ETRANSFORM);
    }

    public void setTransform(TransformAttribute transformAttribute) {
        this.transform = transformAttribute == null || transformAttribute.isIdentity() ? AttributeValues.DEFAULT.transform : transformAttribute.getTransform();
        this.updateDerivedTransforms();
        this.update(EAttribute.ETRANSFORM);
    }

    public int getSuperscript() {
        return this.superscript;
    }

    public void setSuperscript(int n) {
        this.superscript = (byte)n;
        this.update(EAttribute.ESUPERSCRIPT);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.update(EAttribute.EFONT);
    }

    public GraphicAttribute getCharReplacement() {
        return this.charReplacement;
    }

    public void setCharReplacement(GraphicAttribute graphicAttribute) {
        this.charReplacement = graphicAttribute;
        this.update(EAttribute.ECHAR_REPLACEMENT);
    }

    public Paint getForeground() {
        return this.foreground;
    }

    public void setForeground(Paint paint) {
        this.foreground = paint;
        this.update(EAttribute.EFOREGROUND);
    }

    public Paint getBackground() {
        return this.background;
    }

    public void setBackground(Paint paint) {
        this.background = paint;
        this.update(EAttribute.EBACKGROUND);
    }

    public int getUnderline() {
        return this.underline;
    }

    public void setUnderline(int n) {
        this.underline = (byte)n;
        this.update(EAttribute.EUNDERLINE);
    }

    public boolean getStrikethrough() {
        return this.strikethrough;
    }

    public void setStrikethrough(boolean bl) {
        this.strikethrough = bl;
        this.update(EAttribute.ESTRIKETHROUGH);
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public void setRunDirection(int n) {
        this.runDirection = (byte)n;
        this.update(EAttribute.ERUN_DIRECTION);
    }

    public int getBidiEmbedding() {
        return this.bidiEmbedding;
    }

    public void setBidiEmbedding(int n) {
        this.bidiEmbedding = (byte)n;
        this.update(EAttribute.EBIDI_EMBEDDING);
    }

    public float getJustification() {
        return this.justification;
    }

    public void setJustification(float f) {
        this.justification = f;
        this.update(EAttribute.EJUSTIFICATION);
    }

    public Object getInputMethodHighlight() {
        return this.imHighlight;
    }

    public void setInputMethodHighlight(Annotation annotation) {
        this.imHighlight = annotation;
        this.update(EAttribute.EINPUT_METHOD_HIGHLIGHT);
    }

    public void setInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        this.imHighlight = inputMethodHighlight;
        this.update(EAttribute.EINPUT_METHOD_HIGHLIGHT);
    }

    public int getInputMethodUnderline() {
        return this.imUnderline;
    }

    public void setInputMethodUnderline(int n) {
        this.imUnderline = (byte)n;
        this.update(EAttribute.EINPUT_METHOD_UNDERLINE);
    }

    public boolean getSwapColors() {
        return this.swapColors;
    }

    public void setSwapColors(boolean bl) {
        this.swapColors = bl;
        this.update(EAttribute.ESWAP_COLORS);
    }

    public NumericShaper getNumericShaping() {
        return this.numericShaping;
    }

    public void setNumericShaping(NumericShaper numericShaper) {
        this.numericShaping = numericShaper;
        this.update(EAttribute.ENUMERIC_SHAPING);
    }

    public int getKerning() {
        return this.kerning;
    }

    public void setKerning(int n) {
        this.kerning = (byte)n;
        this.update(EAttribute.EKERNING);
    }

    public float getTracking() {
        return this.tracking;
    }

    public void setTracking(float f) {
        this.tracking = (byte)f;
        this.update(EAttribute.ETRACKING);
    }

    public int getLigatures() {
        return this.ligatures;
    }

    public void setLigatures(int n) {
        this.ligatures = (byte)n;
        this.update(EAttribute.ELIGATURES);
    }

    public AffineTransform getBaselineTransform() {
        return this.baselineTransform;
    }

    public AffineTransform getCharTransform() {
        return this.charTransform;
    }

    public static int getMask(EAttribute eAttribute) {
        return eAttribute.mask;
    }

    public static int getMask(EAttribute ... eAttributeArray) {
        int n = 0;
        for (EAttribute eAttribute : eAttributeArray) {
            n |= eAttribute.mask;
        }
        return n;
    }

    public void unsetDefault() {
        this.defined &= this.nondefault;
    }

    public void defineAll(int n) {
        this.defined |= n;
        if ((this.defined & EAttribute.EBASELINE_TRANSFORM.mask) != 0) {
            throw new InternalError("can't define derived attribute");
        }
    }

    public boolean allDefined(int n) {
        return (this.defined & n) == n;
    }

    public boolean anyDefined(int n) {
        return (this.defined & n) != 0;
    }

    public boolean anyNonDefault(int n) {
        return (this.nondefault & n) != 0;
    }

    public boolean isDefined(EAttribute eAttribute) {
        return (this.defined & eAttribute.mask) != 0;
    }

    public boolean isNonDefault(EAttribute eAttribute) {
        return (this.nondefault & eAttribute.mask) != 0;
    }

    public void setDefault(EAttribute eAttribute) {
        if (eAttribute.att == null) {
            throw new InternalError("can't set default derived attribute: " + (Object)((Object)eAttribute));
        }
        this.i_set(eAttribute, DEFAULT);
        this.defined |= eAttribute.mask;
        this.nondefault &= ~eAttribute.mask;
    }

    public void unset(EAttribute eAttribute) {
        if (eAttribute.att == null) {
            throw new InternalError("can't unset derived attribute: " + (Object)((Object)eAttribute));
        }
        this.i_set(eAttribute, DEFAULT);
        this.defined &= ~eAttribute.mask;
        this.nondefault &= ~eAttribute.mask;
    }

    public void set(EAttribute eAttribute, AttributeValues attributeValues) {
        if (eAttribute.att == null) {
            throw new InternalError("can't set derived attribute: " + (Object)((Object)eAttribute));
        }
        if (attributeValues == null || attributeValues == DEFAULT) {
            this.setDefault(eAttribute);
        } else if ((attributeValues.defined & eAttribute.mask) != 0) {
            this.i_set(eAttribute, attributeValues);
            this.update(eAttribute);
        }
    }

    public void set(EAttribute eAttribute, Object object) {
        if (eAttribute.att == null) {
            throw new InternalError("can't set derived attribute: " + (Object)((Object)eAttribute));
        }
        if (object != null) {
            try {
                this.i_set(eAttribute, object);
                this.update(eAttribute);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setDefault(eAttribute);
    }

    public Object get(EAttribute eAttribute) {
        if (eAttribute.att == null) {
            throw new InternalError("can't get derived attribute: " + (Object)((Object)eAttribute));
        }
        if ((this.nondefault & eAttribute.mask) != 0) {
            return this.i_get(eAttribute);
        }
        return null;
    }

    public AttributeValues merge(Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        return this.merge(map, MASK_ALL);
    }

    public AttributeValues merge(Map<? extends AttributedCharacterIterator.Attribute, ?> map, int n) {
        if (map instanceof AttributeMap && ((AttributeMap)map).getValues() != null) {
            this.merge(((AttributeMap)map).getValues(), n);
        } else if (map != null && !map.isEmpty()) {
            for (Map.Entry<AttributedCharacterIterator.Attribute, ?> entry : map.entrySet()) {
                try {
                    EAttribute eAttribute = EAttribute.forAttribute(entry.getKey());
                    if (eAttribute == null || (n & eAttribute.mask) == 0) continue;
                    this.set(eAttribute, entry.getValue());
                }
                catch (ClassCastException classCastException) {}
            }
        }
        return this;
    }

    public AttributeValues merge(AttributeValues attributeValues) {
        return this.merge(attributeValues, MASK_ALL);
    }

    public AttributeValues merge(AttributeValues attributeValues, int n) {
        int n2 = n & attributeValues.defined;
        for (EAttribute eAttribute : EAttribute.atts) {
            if (n2 == 0) break;
            if ((n2 & eAttribute.mask) == 0) continue;
            n2 &= ~eAttribute.mask;
            this.i_set(eAttribute, attributeValues);
            this.update(eAttribute);
        }
        return this;
    }

    public static AttributeValues fromMap(Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        return AttributeValues.fromMap(map, MASK_ALL);
    }

    public static AttributeValues fromMap(Map<? extends AttributedCharacterIterator.Attribute, ?> map, int n) {
        return new AttributeValues().merge(map, n);
    }

    public Map<TextAttribute, Object> toMap(Map<TextAttribute, Object> map) {
        if (map == null) {
            map = new HashMap<TextAttribute, Object>();
        }
        int n = this.defined;
        int n2 = 0;
        while (n != 0) {
            EAttribute eAttribute = EAttribute.atts[n2];
            if ((n & eAttribute.mask) != 0) {
                n &= ~eAttribute.mask;
                map.put(eAttribute.att, this.get(eAttribute));
            }
            ++n2;
        }
        return map;
    }

    public static boolean is16Hashtable(Hashtable<Object, Object> hashtable) {
        return hashtable.containsKey(DEFINED_KEY);
    }

    public static AttributeValues fromSerializableHashtable(Hashtable<Object, Object> hashtable) {
        AttributeValues attributeValues = new AttributeValues();
        if (hashtable != null && !hashtable.isEmpty()) {
            for (Map.Entry<Object, Object> entry : hashtable.entrySet()) {
                Object object = entry.getKey();
                Object object2 = entry.getValue();
                if (object.equals(DEFINED_KEY)) {
                    attributeValues.defineAll((Integer)object2);
                    continue;
                }
                try {
                    EAttribute eAttribute = EAttribute.forAttribute((AttributedCharacterIterator.Attribute)object);
                    if (eAttribute == null) continue;
                    attributeValues.set(eAttribute, object2);
                }
                catch (ClassCastException classCastException) {}
            }
        }
        return attributeValues;
    }

    public Hashtable<Object, Object> toSerializableHashtable() {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        int n = this.defined;
        int n2 = this.defined;
        int n3 = 0;
        while (n2 != 0) {
            EAttribute eAttribute = EAttribute.atts[n3];
            if ((n2 & eAttribute.mask) != 0) {
                n2 &= ~eAttribute.mask;
                Object object = this.get(eAttribute);
                if (object != null) {
                    if (object instanceof Serializable) {
                        hashtable.put(eAttribute.att, object);
                    } else {
                        n &= ~eAttribute.mask;
                    }
                }
            }
            ++n3;
        }
        hashtable.put(DEFINED_KEY, n);
        return hashtable;
    }

    public int hashCode() {
        return this.defined << 8 ^ this.nondefault;
    }

    public boolean equals(Object object) {
        try {
            return this.equals((AttributeValues)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean equals(AttributeValues attributeValues) {
        if (attributeValues == null) {
            return false;
        }
        if (attributeValues == this) {
            return true;
        }
        return this.defined == attributeValues.defined && this.nondefault == attributeValues.nondefault && this.underline == attributeValues.underline && this.strikethrough == attributeValues.strikethrough && this.superscript == attributeValues.superscript && this.width == attributeValues.width && this.kerning == attributeValues.kerning && this.tracking == attributeValues.tracking && this.ligatures == attributeValues.ligatures && this.runDirection == attributeValues.runDirection && this.bidiEmbedding == attributeValues.bidiEmbedding && this.swapColors == attributeValues.swapColors && AttributeValues.equals(this.transform, attributeValues.transform) && AttributeValues.equals(this.foreground, attributeValues.foreground) && AttributeValues.equals(this.background, attributeValues.background) && AttributeValues.equals(this.numericShaping, attributeValues.numericShaping) && AttributeValues.equals(Float.valueOf(this.justification), Float.valueOf(attributeValues.justification)) && AttributeValues.equals(this.charReplacement, attributeValues.charReplacement) && this.size == attributeValues.size && this.weight == attributeValues.weight && this.posture == attributeValues.posture && AttributeValues.equals(this.family, attributeValues.family) && AttributeValues.equals(this.font, attributeValues.font) && this.imUnderline == attributeValues.imUnderline && AttributeValues.equals(this.imHighlight, attributeValues.imHighlight);
    }

    public AttributeValues clone() {
        try {
            AttributeValues attributeValues = (AttributeValues)super.clone();
            if (this.transform != null) {
                attributeValues.transform = new AffineTransform(this.transform);
                attributeValues.updateDerivedTransforms();
            }
            return attributeValues;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        int n = this.defined;
        int n2 = 0;
        while (n != 0) {
            EAttribute eAttribute = EAttribute.atts[n2];
            if ((n & eAttribute.mask) != 0) {
                n &= ~eAttribute.mask;
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((Object)eAttribute);
                stringBuilder.append('=');
                switch (eAttribute) {
                    case EFAMILY: {
                        stringBuilder.append('\"');
                        stringBuilder.append(this.family);
                        stringBuilder.append('\"');
                        break;
                    }
                    case EWEIGHT: {
                        stringBuilder.append(this.weight);
                        break;
                    }
                    case EWIDTH: {
                        stringBuilder.append(this.width);
                        break;
                    }
                    case EPOSTURE: {
                        stringBuilder.append(this.posture);
                        break;
                    }
                    case ESIZE: {
                        stringBuilder.append(this.size);
                        break;
                    }
                    case ETRANSFORM: {
                        stringBuilder.append(this.transform);
                        break;
                    }
                    case ESUPERSCRIPT: {
                        stringBuilder.append(this.superscript);
                        break;
                    }
                    case EFONT: {
                        stringBuilder.append(this.font);
                        break;
                    }
                    case ECHAR_REPLACEMENT: {
                        stringBuilder.append(this.charReplacement);
                        break;
                    }
                    case EFOREGROUND: {
                        stringBuilder.append(this.foreground);
                        break;
                    }
                    case EBACKGROUND: {
                        stringBuilder.append(this.background);
                        break;
                    }
                    case EUNDERLINE: {
                        stringBuilder.append(this.underline);
                        break;
                    }
                    case ESTRIKETHROUGH: {
                        stringBuilder.append(this.strikethrough);
                        break;
                    }
                    case ERUN_DIRECTION: {
                        stringBuilder.append(this.runDirection);
                        break;
                    }
                    case EBIDI_EMBEDDING: {
                        stringBuilder.append(this.bidiEmbedding);
                        break;
                    }
                    case EJUSTIFICATION: {
                        stringBuilder.append(this.justification);
                        break;
                    }
                    case EINPUT_METHOD_HIGHLIGHT: {
                        stringBuilder.append(this.imHighlight);
                        break;
                    }
                    case EINPUT_METHOD_UNDERLINE: {
                        stringBuilder.append(this.imUnderline);
                        break;
                    }
                    case ESWAP_COLORS: {
                        stringBuilder.append(this.swapColors);
                        break;
                    }
                    case ENUMERIC_SHAPING: {
                        stringBuilder.append(this.numericShaping);
                        break;
                    }
                    case EKERNING: {
                        stringBuilder.append(this.kerning);
                        break;
                    }
                    case ELIGATURES: {
                        stringBuilder.append(this.ligatures);
                        break;
                    }
                    case ETRACKING: {
                        stringBuilder.append(this.tracking);
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                if ((this.nondefault & eAttribute.mask) == 0) {
                    stringBuilder.append('*');
                }
            }
            ++n2;
        }
        stringBuilder.append("[btx=" + this.baselineTransform + ", ctx=" + this.charTransform + "]");
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private void update(EAttribute eAttribute) {
        this.defined |= eAttribute.mask;
        if (this.i_validate(eAttribute)) {
            this.nondefault = this.i_equals(eAttribute, DEFAULT) ? (this.nondefault &= ~eAttribute.mask) : (this.nondefault |= eAttribute.mask);
        } else {
            this.setDefault(eAttribute);
        }
    }

    private void i_set(EAttribute eAttribute, AttributeValues attributeValues) {
        switch (eAttribute) {
            case EFAMILY: {
                this.family = attributeValues.family;
                break;
            }
            case EWEIGHT: {
                this.weight = attributeValues.weight;
                break;
            }
            case EWIDTH: {
                this.width = attributeValues.width;
                break;
            }
            case EPOSTURE: {
                this.posture = attributeValues.posture;
                break;
            }
            case ESIZE: {
                this.size = attributeValues.size;
                break;
            }
            case ETRANSFORM: {
                this.transform = attributeValues.transform;
                this.updateDerivedTransforms();
                break;
            }
            case ESUPERSCRIPT: {
                this.superscript = attributeValues.superscript;
                break;
            }
            case EFONT: {
                this.font = attributeValues.font;
                break;
            }
            case ECHAR_REPLACEMENT: {
                this.charReplacement = attributeValues.charReplacement;
                break;
            }
            case EFOREGROUND: {
                this.foreground = attributeValues.foreground;
                break;
            }
            case EBACKGROUND: {
                this.background = attributeValues.background;
                break;
            }
            case EUNDERLINE: {
                this.underline = attributeValues.underline;
                break;
            }
            case ESTRIKETHROUGH: {
                this.strikethrough = attributeValues.strikethrough;
                break;
            }
            case ERUN_DIRECTION: {
                this.runDirection = attributeValues.runDirection;
                break;
            }
            case EBIDI_EMBEDDING: {
                this.bidiEmbedding = attributeValues.bidiEmbedding;
                break;
            }
            case EJUSTIFICATION: {
                this.justification = attributeValues.justification;
                break;
            }
            case EINPUT_METHOD_HIGHLIGHT: {
                this.imHighlight = attributeValues.imHighlight;
                break;
            }
            case EINPUT_METHOD_UNDERLINE: {
                this.imUnderline = attributeValues.imUnderline;
                break;
            }
            case ESWAP_COLORS: {
                this.swapColors = attributeValues.swapColors;
                break;
            }
            case ENUMERIC_SHAPING: {
                this.numericShaping = attributeValues.numericShaping;
                break;
            }
            case EKERNING: {
                this.kerning = attributeValues.kerning;
                break;
            }
            case ELIGATURES: {
                this.ligatures = attributeValues.ligatures;
                break;
            }
            case ETRACKING: {
                this.tracking = attributeValues.tracking;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    private boolean i_equals(EAttribute eAttribute, AttributeValues attributeValues) {
        switch (eAttribute) {
            case EFAMILY: {
                return AttributeValues.equals(this.family, attributeValues.family);
            }
            case EWEIGHT: {
                return this.weight == attributeValues.weight;
            }
            case EWIDTH: {
                return this.width == attributeValues.width;
            }
            case EPOSTURE: {
                return this.posture == attributeValues.posture;
            }
            case ESIZE: {
                return this.size == attributeValues.size;
            }
            case ETRANSFORM: {
                return AttributeValues.equals(this.transform, attributeValues.transform);
            }
            case ESUPERSCRIPT: {
                return this.superscript == attributeValues.superscript;
            }
            case EFONT: {
                return AttributeValues.equals(this.font, attributeValues.font);
            }
            case ECHAR_REPLACEMENT: {
                return AttributeValues.equals(this.charReplacement, attributeValues.charReplacement);
            }
            case EFOREGROUND: {
                return AttributeValues.equals(this.foreground, attributeValues.foreground);
            }
            case EBACKGROUND: {
                return AttributeValues.equals(this.background, attributeValues.background);
            }
            case EUNDERLINE: {
                return this.underline == attributeValues.underline;
            }
            case ESTRIKETHROUGH: {
                return this.strikethrough == attributeValues.strikethrough;
            }
            case ERUN_DIRECTION: {
                return this.runDirection == attributeValues.runDirection;
            }
            case EBIDI_EMBEDDING: {
                return this.bidiEmbedding == attributeValues.bidiEmbedding;
            }
            case EJUSTIFICATION: {
                return this.justification == attributeValues.justification;
            }
            case EINPUT_METHOD_HIGHLIGHT: {
                return AttributeValues.equals(this.imHighlight, attributeValues.imHighlight);
            }
            case EINPUT_METHOD_UNDERLINE: {
                return this.imUnderline == attributeValues.imUnderline;
            }
            case ESWAP_COLORS: {
                return this.swapColors == attributeValues.swapColors;
            }
            case ENUMERIC_SHAPING: {
                return AttributeValues.equals(this.numericShaping, attributeValues.numericShaping);
            }
            case EKERNING: {
                return this.kerning == attributeValues.kerning;
            }
            case ELIGATURES: {
                return this.ligatures == attributeValues.ligatures;
            }
            case ETRACKING: {
                return this.tracking == attributeValues.tracking;
            }
        }
        throw new InternalError();
    }

    private void i_set(EAttribute eAttribute, Object object) {
        switch (eAttribute) {
            case EFAMILY: {
                this.family = ((String)object).trim();
                break;
            }
            case EWEIGHT: {
                this.weight = ((Number)object).floatValue();
                break;
            }
            case EWIDTH: {
                this.width = ((Number)object).floatValue();
                break;
            }
            case EPOSTURE: {
                this.posture = ((Number)object).floatValue();
                break;
            }
            case ESIZE: {
                this.size = ((Number)object).floatValue();
                break;
            }
            case ETRANSFORM: {
                TransformAttribute transformAttribute;
                this.transform = object instanceof TransformAttribute ? ((transformAttribute = (TransformAttribute)object).isIdentity() ? null : transformAttribute.getTransform()) : new AffineTransform((AffineTransform)object);
                this.updateDerivedTransforms();
                break;
            }
            case ESUPERSCRIPT: {
                this.superscript = (byte)((Integer)object).intValue();
                break;
            }
            case EFONT: {
                this.font = (Font)object;
                break;
            }
            case ECHAR_REPLACEMENT: {
                this.charReplacement = (GraphicAttribute)object;
                break;
            }
            case EFOREGROUND: {
                this.foreground = (Paint)object;
                break;
            }
            case EBACKGROUND: {
                this.background = (Paint)object;
                break;
            }
            case EUNDERLINE: {
                this.underline = (byte)((Integer)object).intValue();
                break;
            }
            case ESTRIKETHROUGH: {
                this.strikethrough = (Boolean)object;
                break;
            }
            case ERUN_DIRECTION: {
                if (object instanceof Boolean) {
                    this.runDirection = (byte)(!TextAttribute.RUN_DIRECTION_LTR.equals(object) ? 1 : 0);
                    break;
                }
                this.runDirection = (byte)((Integer)object).intValue();
                break;
            }
            case EBIDI_EMBEDDING: {
                this.bidiEmbedding = (byte)((Integer)object).intValue();
                break;
            }
            case EJUSTIFICATION: {
                this.justification = ((Number)object).floatValue();
                break;
            }
            case EINPUT_METHOD_HIGHLIGHT: {
                if (object instanceof Annotation) {
                    Annotation annotation = (Annotation)object;
                    this.imHighlight = (InputMethodHighlight)annotation.getValue();
                    break;
                }
                this.imHighlight = (InputMethodHighlight)object;
                break;
            }
            case EINPUT_METHOD_UNDERLINE: {
                this.imUnderline = (byte)((Integer)object).intValue();
                break;
            }
            case ESWAP_COLORS: {
                this.swapColors = (Boolean)object;
                break;
            }
            case ENUMERIC_SHAPING: {
                this.numericShaping = (NumericShaper)object;
                break;
            }
            case EKERNING: {
                this.kerning = (byte)((Integer)object).intValue();
                break;
            }
            case ELIGATURES: {
                this.ligatures = (byte)((Integer)object).intValue();
                break;
            }
            case ETRACKING: {
                this.tracking = ((Number)object).floatValue();
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    private Object i_get(EAttribute eAttribute) {
        switch (eAttribute) {
            case EFAMILY: {
                return this.family;
            }
            case EWEIGHT: {
                return Float.valueOf(this.weight);
            }
            case EWIDTH: {
                return Float.valueOf(this.width);
            }
            case EPOSTURE: {
                return Float.valueOf(this.posture);
            }
            case ESIZE: {
                return Float.valueOf(this.size);
            }
            case ETRANSFORM: {
                return this.transform == null ? TransformAttribute.IDENTITY : new TransformAttribute(this.transform);
            }
            case ESUPERSCRIPT: {
                return (int)this.superscript;
            }
            case EFONT: {
                return this.font;
            }
            case ECHAR_REPLACEMENT: {
                return this.charReplacement;
            }
            case EFOREGROUND: {
                return this.foreground;
            }
            case EBACKGROUND: {
                return this.background;
            }
            case EUNDERLINE: {
                return (int)this.underline;
            }
            case ESTRIKETHROUGH: {
                return this.strikethrough;
            }
            case ERUN_DIRECTION: {
                switch (this.runDirection) {
                    case 0: {
                        return TextAttribute.RUN_DIRECTION_LTR;
                    }
                    case 1: {
                        return TextAttribute.RUN_DIRECTION_RTL;
                    }
                }
                return null;
            }
            case EBIDI_EMBEDDING: {
                return (int)this.bidiEmbedding;
            }
            case EJUSTIFICATION: {
                return Float.valueOf(this.justification);
            }
            case EINPUT_METHOD_HIGHLIGHT: {
                return this.imHighlight;
            }
            case EINPUT_METHOD_UNDERLINE: {
                return (int)this.imUnderline;
            }
            case ESWAP_COLORS: {
                return this.swapColors;
            }
            case ENUMERIC_SHAPING: {
                return this.numericShaping;
            }
            case EKERNING: {
                return (int)this.kerning;
            }
            case ELIGATURES: {
                return (int)this.ligatures;
            }
            case ETRACKING: {
                return Float.valueOf(this.tracking);
            }
        }
        throw new InternalError();
    }

    private boolean i_validate(EAttribute eAttribute) {
        switch (eAttribute) {
            case EFAMILY: {
                if (this.family == null || this.family.length() == 0) {
                    this.family = AttributeValues.DEFAULT.family;
                }
                return true;
            }
            case EWEIGHT: {
                return this.weight > 0.0f && this.weight < 10.0f;
            }
            case EWIDTH: {
                return this.width >= 0.5f && this.width < 10.0f;
            }
            case EPOSTURE: {
                return this.posture >= -1.0f && this.posture <= 1.0f;
            }
            case ESIZE: {
                return this.size >= 0.0f;
            }
            case ETRANSFORM: {
                if (this.transform != null && this.transform.isIdentity()) {
                    this.transform = AttributeValues.DEFAULT.transform;
                }
                return true;
            }
            case ESUPERSCRIPT: {
                return this.superscript >= -7 && this.superscript <= 7;
            }
            case EFONT: {
                return true;
            }
            case ECHAR_REPLACEMENT: {
                return true;
            }
            case EFOREGROUND: {
                return true;
            }
            case EBACKGROUND: {
                return true;
            }
            case EUNDERLINE: {
                return this.underline >= -1 && this.underline < 6;
            }
            case ESTRIKETHROUGH: {
                return true;
            }
            case ERUN_DIRECTION: {
                return this.runDirection >= -2 && this.runDirection <= 1;
            }
            case EBIDI_EMBEDDING: {
                return this.bidiEmbedding >= -61 && this.bidiEmbedding < 62;
            }
            case EJUSTIFICATION: {
                this.justification = Math.max(0.0f, Math.min(this.justification, 1.0f));
                return true;
            }
            case EINPUT_METHOD_HIGHLIGHT: {
                return true;
            }
            case EINPUT_METHOD_UNDERLINE: {
                return this.imUnderline >= -1 && this.imUnderline < 6;
            }
            case ESWAP_COLORS: {
                return true;
            }
            case ENUMERIC_SHAPING: {
                return true;
            }
            case EKERNING: {
                return this.kerning >= 0 && this.kerning <= 1;
            }
            case ELIGATURES: {
                return this.ligatures >= 0 && this.ligatures <= 1;
            }
            case ETRACKING: {
                return this.tracking >= -1.0f && this.tracking <= 10.0f;
            }
        }
        throw new InternalError("unknown attribute: " + (Object)((Object)eAttribute));
    }

    public static float getJustification(Map<?, ?> map) {
        if (map != null) {
            if (map instanceof AttributeMap && ((AttributeMap)map).getValues() != null) {
                return ((AttributeMap)map).getValues().justification;
            }
            Object obj = map.get(TextAttribute.JUSTIFICATION);
            if (obj != null && obj instanceof Number) {
                return Math.max(0.0f, Math.min(1.0f, ((Number)obj).floatValue()));
            }
        }
        return AttributeValues.DEFAULT.justification;
    }

    public static NumericShaper getNumericShaping(Map<?, ?> map) {
        if (map != null) {
            if (map instanceof AttributeMap && ((AttributeMap)map).getValues() != null) {
                return ((AttributeMap)map).getValues().numericShaping;
            }
            Object obj = map.get(TextAttribute.NUMERIC_SHAPING);
            if (obj != null && obj instanceof NumericShaper) {
                return (NumericShaper)obj;
            }
        }
        return AttributeValues.DEFAULT.numericShaping;
    }

    public AttributeValues applyIMHighlight() {
        if (this.imHighlight != null) {
            InputMethodHighlight inputMethodHighlight = null;
            inputMethodHighlight = this.imHighlight instanceof InputMethodHighlight ? (InputMethodHighlight)this.imHighlight : (InputMethodHighlight)((Annotation)this.imHighlight).getValue();
            Map<TextAttribute, ?> map = inputMethodHighlight.getStyle();
            if (map == null) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                map = toolkit.mapInputMethodHighlight(inputMethodHighlight);
            }
            if (map != null) {
                return this.clone().merge(map);
            }
        }
        return this;
    }

    public static AffineTransform getBaselineTransform(Map<?, ?> map) {
        if (map != null) {
            AttributeValues attributeValues = null;
            if (map instanceof AttributeMap && ((AttributeMap)map).getValues() != null) {
                attributeValues = ((AttributeMap)map).getValues();
            } else if (map.get(TextAttribute.TRANSFORM) != null) {
                attributeValues = AttributeValues.fromMap(map);
            }
            if (attributeValues != null) {
                return attributeValues.baselineTransform;
            }
        }
        return null;
    }

    public static AffineTransform getCharTransform(Map<?, ?> map) {
        if (map != null) {
            AttributeValues attributeValues = null;
            if (map instanceof AttributeMap && ((AttributeMap)map).getValues() != null) {
                attributeValues = ((AttributeMap)map).getValues();
            } else if (map.get(TextAttribute.TRANSFORM) != null) {
                attributeValues = AttributeValues.fromMap(map);
            }
            if (attributeValues != null) {
                return attributeValues.charTransform;
            }
        }
        return null;
    }

    public void updateDerivedTransforms() {
        if (this.transform == null) {
            this.baselineTransform = null;
            this.charTransform = null;
        } else {
            this.charTransform = new AffineTransform(this.transform);
            this.baselineTransform = AttributeValues.extractXRotation(this.charTransform, true);
            if (this.charTransform.isIdentity()) {
                this.charTransform = null;
            }
            if (this.baselineTransform.isIdentity()) {
                this.baselineTransform = null;
            }
        }
        this.nondefault = this.baselineTransform == null ? (this.nondefault &= ~EAttribute.EBASELINE_TRANSFORM.mask) : (this.nondefault |= EAttribute.EBASELINE_TRANSFORM.mask);
    }

    public static AffineTransform extractXRotation(AffineTransform affineTransform, boolean bl) {
        return AttributeValues.extractRotation(new Point2D.Double(1.0, 0.0), affineTransform, bl);
    }

    public static AffineTransform extractYRotation(AffineTransform affineTransform, boolean bl) {
        return AttributeValues.extractRotation(new Point2D.Double(0.0, 1.0), affineTransform, bl);
    }

    private static AffineTransform extractRotation(Point2D.Double double_, AffineTransform affineTransform, boolean bl) {
        affineTransform.deltaTransform(double_, double_);
        AffineTransform affineTransform2 = AffineTransform.getRotateInstance(double_.x, double_.y);
        try {
            AffineTransform affineTransform3 = affineTransform2.createInverse();
            double d = affineTransform.getTranslateX();
            double d2 = affineTransform.getTranslateY();
            affineTransform.preConcatenate(affineTransform3);
            if (bl && (d != 0.0 || d2 != 0.0)) {
                affineTransform.setTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), 0.0, 0.0);
                affineTransform2.setTransform(affineTransform2.getScaleX(), affineTransform2.getShearY(), affineTransform2.getShearX(), affineTransform2.getScaleY(), d, d2);
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
        return affineTransform2;
    }
}

