/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.lang.reflect.Array;
import java.util.EventListener;

public class EventListenerAggregate {
    private EventListener[] listenerList;

    public EventListenerAggregate(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("listener class is null");
        }
        if (!EventListener.class.isAssignableFrom(clazz)) {
            throw new ClassCastException("listener class " + clazz + " is not assignable to EventListener");
        }
        this.listenerList = (EventListener[])Array.newInstance(clazz, 0);
    }

    private Class getListenerClass() {
        return this.listenerList.getClass().getComponentType();
    }

    public synchronized void add(EventListener eventListener) {
        Class clazz = this.getListenerClass();
        if (!clazz.isInstance(eventListener)) {
            throw new ClassCastException("listener " + eventListener + " is not " + "an instance of listener class " + clazz);
        }
        EventListener[] eventListenerArray = (EventListener[])Array.newInstance(clazz, this.listenerList.length + 1);
        System.arraycopy(this.listenerList, 0, eventListenerArray, 0, this.listenerList.length);
        eventListenerArray[this.listenerList.length] = eventListener;
        this.listenerList = eventListenerArray;
    }

    public synchronized boolean remove(EventListener eventListener) {
        Class clazz = this.getListenerClass();
        if (!clazz.isInstance(eventListener)) {
            throw new ClassCastException("listener " + eventListener + " is not " + "an instance of listener class " + clazz);
        }
        for (int i = 0; i < this.listenerList.length; ++i) {
            if (!this.listenerList[i].equals(eventListener)) continue;
            EventListener[] eventListenerArray = (EventListener[])Array.newInstance(clazz, this.listenerList.length - 1);
            System.arraycopy(this.listenerList, 0, eventListenerArray, 0, i);
            System.arraycopy(this.listenerList, i + 1, eventListenerArray, i, this.listenerList.length - i - 1);
            this.listenerList = eventListenerArray;
            return true;
        }
        return false;
    }

    public synchronized EventListener[] getListenersInternal() {
        return this.listenerList;
    }

    public synchronized EventListener[] getListenersCopy() {
        return this.listenerList.length == 0 ? this.listenerList : (EventListener[])this.listenerList.clone();
    }

    public synchronized int size() {
        return this.listenerList.length;
    }

    public synchronized boolean isEmpty() {
        return this.listenerList.length == 0;
    }
}

