/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Map;
import javax.management.MBeanServer;
import sun.management.snmp.jvmmib.EnumJvmMemoryGCCall;
import sun.management.snmp.jvmmib.EnumJvmMemoryGCVerboseLevel;
import sun.management.snmp.jvmmib.JvmMemoryMBean;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;

public class JvmMemoryImpl
implements JvmMemoryMBean {
    static final EnumJvmMemoryGCCall JvmMemoryGCCallSupported = new EnumJvmMemoryGCCall("supported");
    static final EnumJvmMemoryGCCall JvmMemoryGCCallStart = new EnumJvmMemoryGCCall("start");
    static final EnumJvmMemoryGCCall JvmMemoryGCCallFailed = new EnumJvmMemoryGCCall("failed");
    static final EnumJvmMemoryGCCall JvmMemoryGCCallStarted = new EnumJvmMemoryGCCall("started");
    static final EnumJvmMemoryGCVerboseLevel JvmMemoryGCVerboseLevelVerbose = new EnumJvmMemoryGCVerboseLevel("verbose");
    static final EnumJvmMemoryGCVerboseLevel JvmMemoryGCVerboseLevelSilent = new EnumJvmMemoryGCVerboseLevel("silent");
    static final String heapMemoryTag = "jvmMemory.getHeapMemoryUsage";
    static final String nonHeapMemoryTag = "jvmMemory.getNonHeapMemoryUsage";
    static final Long Long0 = new Long(0L);
    static final MibLogger log = new MibLogger(JvmMemoryImpl.class);

    public JvmMemoryImpl(SnmpMib snmpMib) {
    }

    public JvmMemoryImpl(SnmpMib snmpMib, MBeanServer mBeanServer) {
    }

    private MemoryUsage getMemoryUsage(MemoryType memoryType) {
        if (memoryType == MemoryType.HEAP) {
            return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        }
        return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
    }

    MemoryUsage getNonHeapMemoryUsage() {
        try {
            Map map = JvmContextFactory.getUserData();
            if (map != null) {
                MemoryUsage memoryUsage = (MemoryUsage)map.get(nonHeapMemoryTag);
                if (memoryUsage != null) {
                    log.debug("getNonHeapMemoryUsage", "jvmMemory.getNonHeapMemoryUsage found in cache.");
                    return memoryUsage;
                }
                MemoryUsage memoryUsage2 = this.getMemoryUsage(MemoryType.NON_HEAP);
                map.put(nonHeapMemoryTag, memoryUsage2);
                return memoryUsage2;
            }
            log.trace("getNonHeapMemoryUsage", "ERROR: should never come here!");
            return this.getMemoryUsage(MemoryType.NON_HEAP);
        }
        catch (RuntimeException runtimeException) {
            log.trace("getNonHeapMemoryUsage", "Failed to get NonHeapMemoryUsage: " + runtimeException);
            log.debug("getNonHeapMemoryUsage", runtimeException);
            throw runtimeException;
        }
    }

    MemoryUsage getHeapMemoryUsage() {
        try {
            Map map = JvmContextFactory.getUserData();
            if (map != null) {
                MemoryUsage memoryUsage = (MemoryUsage)map.get(heapMemoryTag);
                if (memoryUsage != null) {
                    log.debug("getHeapMemoryUsage", "jvmMemory.getHeapMemoryUsage found in cache.");
                    return memoryUsage;
                }
                MemoryUsage memoryUsage2 = this.getMemoryUsage(MemoryType.HEAP);
                map.put(heapMemoryTag, memoryUsage2);
                return memoryUsage2;
            }
            log.trace("getHeapMemoryUsage", "ERROR: should never come here!");
            return this.getMemoryUsage(MemoryType.HEAP);
        }
        catch (RuntimeException runtimeException) {
            log.trace("getHeapMemoryUsage", "Failed to get HeapMemoryUsage: " + runtimeException);
            log.debug("getHeapMemoryUsage", runtimeException);
            throw runtimeException;
        }
    }

    public Long getJvmMemoryNonHeapMaxSize() throws SnmpStatusException {
        long l = this.getNonHeapMemoryUsage().getMax();
        if (l > -1L) {
            return new Long(l);
        }
        return Long0;
    }

    public Long getJvmMemoryNonHeapCommitted() throws SnmpStatusException {
        long l = this.getNonHeapMemoryUsage().getCommitted();
        if (l > -1L) {
            return new Long(l);
        }
        return Long0;
    }

    public Long getJvmMemoryNonHeapUsed() throws SnmpStatusException {
        long l = this.getNonHeapMemoryUsage().getUsed();
        if (l > -1L) {
            return new Long(l);
        }
        return Long0;
    }

    public Long getJvmMemoryNonHeapInitSize() throws SnmpStatusException {
        long l = this.getNonHeapMemoryUsage().getInit();
        if (l > -1L) {
            return new Long(l);
        }
        return Long0;
    }

    public Long getJvmMemoryHeapMaxSize() throws SnmpStatusException {
        long l = this.getHeapMemoryUsage().getMax();
        if (l > -1L) {
            return new Long(l);
        }
        return Long0;
    }

    public EnumJvmMemoryGCCall getJvmMemoryGCCall() throws SnmpStatusException {
        EnumJvmMemoryGCCall enumJvmMemoryGCCall;
        Map map = JvmContextFactory.getUserData();
        if (map != null && (enumJvmMemoryGCCall = (EnumJvmMemoryGCCall)map.get("jvmMemory.getJvmMemoryGCCall")) != null) {
            return enumJvmMemoryGCCall;
        }
        return JvmMemoryGCCallSupported;
    }

    public void setJvmMemoryGCCall(EnumJvmMemoryGCCall enumJvmMemoryGCCall) throws SnmpStatusException {
        if (enumJvmMemoryGCCall.intValue() == JvmMemoryGCCallStart.intValue()) {
            block4: {
                Map map = JvmContextFactory.getUserData();
                try {
                    ManagementFactory.getMemoryMXBean().gc();
                    if (map != null) {
                        map.put("jvmMemory.getJvmMemoryGCCall", JvmMemoryGCCallStarted);
                    }
                }
                catch (Exception exception) {
                    if (map == null) break block4;
                    map.put("jvmMemory.getJvmMemoryGCCall", JvmMemoryGCCallFailed);
                }
            }
            return;
        }
        throw new SnmpStatusException(10);
    }

    public void checkJvmMemoryGCCall(EnumJvmMemoryGCCall enumJvmMemoryGCCall) throws SnmpStatusException {
        if (enumJvmMemoryGCCall.intValue() != JvmMemoryGCCallStart.intValue()) {
            throw new SnmpStatusException(10);
        }
    }

    public Long getJvmMemoryHeapCommitted() throws SnmpStatusException {
        long l = this.getHeapMemoryUsage().getCommitted();
        if (l > -1L) {
            return new Long(l);
        }
        return Long0;
    }

    public EnumJvmMemoryGCVerboseLevel getJvmMemoryGCVerboseLevel() throws SnmpStatusException {
        if (ManagementFactory.getMemoryMXBean().isVerbose()) {
            return JvmMemoryGCVerboseLevelVerbose;
        }
        return JvmMemoryGCVerboseLevelSilent;
    }

    public void setJvmMemoryGCVerboseLevel(EnumJvmMemoryGCVerboseLevel enumJvmMemoryGCVerboseLevel) throws SnmpStatusException {
        if (JvmMemoryGCVerboseLevelVerbose.intValue() == enumJvmMemoryGCVerboseLevel.intValue()) {
            ManagementFactory.getMemoryMXBean().setVerbose(true);
        } else {
            ManagementFactory.getMemoryMXBean().setVerbose(false);
        }
    }

    public void checkJvmMemoryGCVerboseLevel(EnumJvmMemoryGCVerboseLevel enumJvmMemoryGCVerboseLevel) throws SnmpStatusException {
    }

    public Long getJvmMemoryHeapUsed() throws SnmpStatusException {
        long l = this.getHeapMemoryUsage().getUsed();
        if (l > -1L) {
            return new Long(l);
        }
        return Long0;
    }

    public Long getJvmMemoryHeapInitSize() throws SnmpStatusException {
        long l = this.getHeapMemoryUsage().getInit();
        if (l > -1L) {
            return new Long(l);
        }
        return Long0;
    }

    public Long getJvmMemoryPendingFinalCount() throws SnmpStatusException {
        long l = ManagementFactory.getMemoryMXBean().getObjectPendingFinalizationCount();
        if (l > -1L) {
            return new Long((int)l);
        }
        return new Long(0L);
    }
}

