/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.InternationalFormatter;

public class DateFormatter
extends InternationalFormatter {
    public DateFormatter() {
        this(DateFormat.getDateInstance());
    }

    public DateFormatter(DateFormat dateFormat) {
        super(dateFormat);
        this.setFormat(dateFormat);
    }

    public void setFormat(DateFormat dateFormat) {
        super.setFormat(dateFormat);
    }

    private Calendar getCalendar() {
        Format format = this.getFormat();
        if (format instanceof DateFormat) {
            return ((DateFormat)format).getCalendar();
        }
        return Calendar.getInstance();
    }

    boolean getSupportsIncrement() {
        return true;
    }

    Object getAdjustField(int n, Map map) {
        for (Object k : map.keySet()) {
            if (!(k instanceof DateFormat.Field) || k != DateFormat.Field.HOUR1 && ((DateFormat.Field)k).getCalendarField() == -1) continue;
            return k;
        }
        return null;
    }

    Object adjustValue(Object object, Map map, Object object2, int n) throws BadLocationException, ParseException {
        if (object2 != null) {
            if (object2 == DateFormat.Field.HOUR1) {
                object2 = DateFormat.Field.HOUR0;
            }
            int n2 = ((DateFormat.Field)object2).getCalendarField();
            Calendar calendar = this.getCalendar();
            if (calendar != null) {
                calendar.setTime((Date)object);
                int n3 = calendar.get(n2);
                try {
                    calendar.add(n2, n);
                    object = calendar.getTime();
                }
                catch (Throwable throwable) {
                    object = null;
                }
                return object;
            }
        }
        return null;
    }
}

