/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalDesktopIconUI
extends BasicDesktopIconUI {
    JButton button;
    JLabel label;
    TitleListener titleListener;
    private int width;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalDesktopIconUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installColorsAndFont(this.desktopIcon, "DesktopIcon.background", "DesktopIcon.foreground", "DesktopIcon.font");
        this.width = UIManager.getInt("DesktopIcon.width");
    }

    protected void installComponents() {
        this.frame = this.desktopIcon.getInternalFrame();
        Icon icon = this.frame.getFrameIcon();
        String string = this.frame.getTitle();
        this.button = new JButton(string, icon);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetalDesktopIconUI.this.deiconize();
            }
        });
        this.button.setFont(this.desktopIcon.getFont());
        this.button.setBackground(this.desktopIcon.getBackground());
        this.button.setForeground(this.desktopIcon.getForeground());
        int n = this.button.getPreferredSize().height;
        MetalBumps metalBumps = new MetalBumps(n / 3, n, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getControl());
        this.label = new JLabel(metalBumps);
        this.label.setBorder(new MatteBorder(0, 2, 0, 1, this.desktopIcon.getBackground()));
        this.desktopIcon.setLayout(new BorderLayout(2, 0));
        this.desktopIcon.add((Component)this.button, "Center");
        this.desktopIcon.add((Component)this.label, "West");
    }

    protected void uninstallComponents() {
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.label);
        this.desktopIcon.remove(this.button);
        this.button = null;
        this.frame = null;
    }

    protected void installListeners() {
        super.installListeners();
        this.titleListener = new TitleListener();
        this.desktopIcon.getInternalFrame().addPropertyChangeListener(this.titleListener);
    }

    protected void uninstallListeners() {
        this.desktopIcon.getInternalFrame().removePropertyChangeListener(this.titleListener);
        this.titleListener = null;
        super.uninstallListeners();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return new Dimension(this.width, this.desktopIcon.getLayout().minimumLayoutSize((Container)this.desktopIcon).height);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    class TitleListener
    implements PropertyChangeListener {
        TitleListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("title")) {
                MetalDesktopIconUI.this.button.setText((String)propertyChangeEvent.getNewValue());
            }
            if (propertyChangeEvent.getPropertyName().equals("frameIcon")) {
                MetalDesktopIconUI.this.button.setIcon((Icon)propertyChangeEvent.getNewValue());
            }
        }
    }
}

