/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import sun.awt.DisplayChangedListener;
import sun.awt.image.BufImgSurfaceData;
import sun.awt.image.RasterListener;
import sun.awt.image.SunWritableRaster;
import sun.awt.image.SurfaceManager;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphicsEnvironment;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.BlitBg;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.SurfaceType;
import sun.security.action.GetPropertyAction;

public abstract class CachingSurfaceManager
extends SurfaceManager
implements RasterListener,
DisplayChangedListener {
    protected BufferedImage bImg;
    protected SurfaceData sdDefault;
    protected SurfaceData sdAccel;
    protected HashMap<Object, SurfaceData> accelSurfaces;
    protected boolean localAccelerationEnabled = false;
    protected static boolean accelerationEnabled;
    protected static boolean allowRasterSteal;
    protected static int accelerationThreshold;

    public CachingSurfaceManager(BufferedImage bufferedImage) {
        Object object;
        this.bImg = bufferedImage;
        this.sdDefault = BufImgSurfaceData.createData(bufferedImage);
        if (accelerationEnabled && bufferedImage.getAccelerationPriority() > 0.0f && (object = bufferedImage.getRaster()) instanceof SunWritableRaster) {
            this.localAccelerationEnabled = true;
            ((SunWritableRaster)object).setRasterListener(this);
            if (this.localAccelerationEnabled) {
                this.accelSurfaces = new HashMap(2);
            }
        }
        object = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (accelerationEnabled && this.localAccelerationEnabled && object instanceof SunGraphicsEnvironment) {
            ((SunGraphicsEnvironment)object).addDisplayChangedListener(this);
        }
    }

    public SurfaceData getSourceSurfaceData(SurfaceData surfaceData, CompositeType compositeType, Color color, boolean bl) {
        if (this.localAccelerationEnabled && surfaceData != this.sdAccel && this.isDestSurfaceAccelerated(surfaceData) && this.isOperationSupported(surfaceData, compositeType, color, bl) && this.sdDefault.increaseNumCopies() > accelerationThreshold) {
            this.validate(surfaceData.getDeviceConfiguration());
            if (this.sdAccel != null && !this.sdAccel.isSurfaceLost()) {
                return this.sdAccel;
            }
        }
        return this.sdDefault;
    }

    public SurfaceData getDestSurfaceData() {
        return this.sdDefault;
    }

    protected abstract boolean isDestSurfaceAccelerated(SurfaceData var1);

    protected boolean isValidAccelSurface(GraphicsConfiguration graphicsConfiguration) {
        return this.getAccelSurface(graphicsConfiguration) != null;
    }

    protected SurfaceData getAccelSurface(GraphicsConfiguration graphicsConfiguration) {
        return this.accelSurfaces != null ? this.accelSurfaces.get(graphicsConfiguration) : null;
    }

    protected abstract boolean isOperationSupported(SurfaceData var1, CompositeType var2, Color var3, boolean var4);

    protected abstract SurfaceData createAccelSurface(GraphicsConfiguration var1, int var2, int var3);

    protected void initAcceleratedSurface(GraphicsConfiguration graphicsConfiguration, int n, int n2) {
        try {
            this.sdAccel = this.getAccelSurface(graphicsConfiguration);
            if (this.sdAccel == null) {
                this.sdAccel = this.createAccelSurface(graphicsConfiguration, n, n2);
                if (this.sdAccel != null) {
                    this.accelSurfaces.put(graphicsConfiguration, this.sdAccel);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            this.sdAccel = null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.sdAccel = null;
        }
        catch (InvalidPipeException invalidPipeException) {
            this.sdAccel = null;
        }
    }

    protected Color getTransparentPixelColor() {
        return null;
    }

    protected void copyDefaultToAccelerated() {
        if (this.accelSurfaces != null) {
            Collection<SurfaceData> collection = this.accelSurfaces.values();
            for (SurfaceData surfaceData : collection) {
                try {
                    GraphicsPrimitive graphicsPrimitive;
                    if (surfaceData == this.sdDefault || surfaceData.isSurfaceLost()) continue;
                    SurfaceType surfaceType = this.sdDefault.getSurfaceType();
                    SurfaceType surfaceType2 = surfaceData.getSurfaceType();
                    Color color = this.getTransparentPixelColor();
                    if (color == null) {
                        graphicsPrimitive = Blit.getFromCache(surfaceType, CompositeType.SrcNoEa, surfaceType2);
                        ((Blit)graphicsPrimitive).Blit(this.sdDefault, surfaceData, AlphaComposite.Src, null, 0, 0, 0, 0, this.bImg.getWidth(), this.bImg.getHeight());
                        continue;
                    }
                    graphicsPrimitive = BlitBg.getFromCache(surfaceType, CompositeType.SrcNoEa, surfaceType2);
                    ((BlitBg)graphicsPrimitive).BlitBg(this.sdDefault, surfaceData, AlphaComposite.SrcOver, null, color.getRGB(), 0, 0, 0, 0, this.bImg.getWidth(), this.bImg.getHeight());
                }
                catch (Exception exception) {
                    if (surfaceData == null) continue;
                    surfaceData.setSurfaceLost(true);
                }
            }
            this.sdDefault.setNeedsBackup(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(GraphicsConfiguration graphicsConfiguration) {
        if (!this.localAccelerationEnabled) return;
        boolean bl = false;
        this.sdAccel = this.getAccelSurface(graphicsConfiguration);
        if (this.sdAccel == null) {
            this.initAcceleratedSurface(graphicsConfiguration, this.bImg.getWidth(), this.bImg.getHeight());
            if (this.sdAccel == null) return;
            bl = true;
        } else if (this.sdAccel.isSurfaceLost()) {
            try {
                this.restoreAcceleratedSurface();
                bl = true;
                this.sdAccel.setSurfaceLost(false);
            }
            catch (InvalidPipeException invalidPipeException) {
                this.flush();
                return;
            }
        }
        if (!this.sdDefault.needsBackup() && !bl) return;
        this.copyDefaultToAccelerated();
    }

    public void rasterChanged() {
        this.sdDefault.setNeedsBackup(true);
    }

    public void rasterStolen() {
        if (!allowRasterSteal) {
            this.localAccelerationEnabled = false;
        }
    }

    public SurfaceData restoreContents() {
        return this.sdDefault;
    }

    protected void restoreAcceleratedSurface() {
    }

    public void displayChanged() {
        if (!accelerationEnabled) {
            return;
        }
        this.invalidateAcceleratedSurfaces();
    }

    public void paletteChanged() {
        this.sdDefault.setNeedsBackup(true);
    }

    public void setAccelerationPriority(float f) {
        if (f == 0.0f) {
            this.setLocalAccelerationEnabled(false);
        }
    }

    public boolean isLocalAccelerationEnabled() {
        return this.localAccelerationEnabled;
    }

    public void setLocalAccelerationEnabled(boolean bl) {
        this.localAccelerationEnabled = bl;
        if (!this.localAccelerationEnabled) {
            this.flush();
        } else if (this.accelSurfaces == null) {
            this.accelSurfaces = new HashMap(2);
        }
    }

    public static void restoreLocalAcceleration(Image image) {
        Object object;
        if (image instanceof BufferedImage && (object = ((BufferedImage)image).getRaster()) instanceof SunWritableRaster) {
            ((SunWritableRaster)object).setStolen(false);
        }
        object = SurfaceManager.getManager(image);
        if (image.getAccelerationPriority() > 0.0f && object instanceof CachingSurfaceManager) {
            ((CachingSurfaceManager)object).setLocalAccelerationEnabled(true);
        }
    }

    public ImageCapabilities getCapabilities(GraphicsConfiguration graphicsConfiguration) {
        return new ImageCapabilitiesGc(graphicsConfiguration);
    }

    public synchronized void flush() {
        this.sdAccel = null;
        if (this.accelSurfaces != null) {
            HashMap<Object, SurfaceData> hashMap = this.accelSurfaces;
            this.accelSurfaces = this.localAccelerationEnabled ? new HashMap(2) : null;
            Collection<SurfaceData> collection = hashMap.values();
            for (SurfaceData surfaceData : collection) {
                surfaceData.flush();
            }
        }
    }

    public synchronized void invalidateAcceleratedSurfaces() {
        this.sdAccel = null;
        if (this.accelSurfaces != null) {
            HashMap<Object, SurfaceData> hashMap = this.accelSurfaces;
            this.accelSurfaces = this.localAccelerationEnabled ? new HashMap(2) : null;
            Collection<SurfaceData> collection = hashMap.values();
            for (SurfaceData surfaceData : collection) {
                surfaceData.invalidate();
            }
        }
    }

    static {
        String string;
        String string2;
        accelerationEnabled = true;
        allowRasterSteal = false;
        accelerationThreshold = 1;
        String string3 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.managedimages"));
        if (string3 != null && string3.equals("false")) {
            accelerationEnabled = false;
            System.out.println("Disabling managed images");
        }
        if ((string2 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.accthreshold"))) != null) {
            try {
                int n = Integer.parseInt(string2);
                if (n >= 0) {
                    accelerationThreshold = n;
                    System.out.println("New Acceleration Threshold: " + accelerationThreshold);
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Error setting new threshold:" + numberFormatException);
            }
        }
        if ((string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.allowrastersteal"))) != null && string.equals("true")) {
            allowRasterSteal = true;
            System.out.println("Raster steal allowed");
        }
    }

    class ImageCapabilitiesGc
    extends ImageCapabilities {
        GraphicsConfiguration gc;

        public ImageCapabilitiesGc(GraphicsConfiguration graphicsConfiguration) {
            super(false);
            this.gc = graphicsConfiguration;
        }

        public boolean isAccelerated() {
            GraphicsConfiguration graphicsConfiguration = this.gc;
            if (graphicsConfiguration == null) {
                graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            }
            return CachingSurfaceManager.this.isValidAccelSurface(graphicsConfiguration);
        }
    }
}

