/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.perf;

import com.sun.deploy.config.Config;
import com.sun.deploy.perf.PerfHelper;
import com.sun.deploy.perf.PerfLabel;
import com.sun.deploy.perf.PerfRollup;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class DeployPerfUtil {
    private static final boolean deployFirstframePerfEnabled;
    private static volatile boolean getenvSupported;
    private static final String DEPLOY_PERF_ENABLED = "DEPLOY_PERF_ENABLED";
    private static final String DEPLOY_PERF_LOG = "DEPLOY_PERF_LOG";
    private static final String DEFAULT_LOGNAME = "deploy_perf.log";
    private static final String DEFAULT_LOGFILE = "deploy_perf.log";
    private static final String INVALID_DEPLOY_PERF_LOG = "The DEPLOY_PERF_LOG variable must point to a file path, not a directory!";
    private static final String MISSING_PARENTS = "Failed to create the parent directories for the file specified by DEPLOY_PERF_LOG!";
    private static final File perfLog;
    private static PerfHelper helper;

    private static String getenv(String string) {
        if (getenvSupported) {
            try {
                return System.getenv(string);
            }
            catch (Error error) {
                getenvSupported = false;
            }
        }
        return null;
    }

    public static boolean isDeployFirstframePerfEnabled() {
        return deployFirstframePerfEnabled;
    }

    public static boolean isEnabled() {
        return perfLog != null;
    }

    public static void put(String string) {
        if (DeployPerfUtil.isEnabled() && helper != null) {
            helper.put(string);
        }
    }

    public static long put(long l, String string) {
        if (DeployPerfUtil.isEnabled() && helper != null) {
            return helper.put(l, string);
        }
        return 0L;
    }

    public static void setInitTime(long l) {
        if (DeployPerfUtil.isEnabled() && helper != null) {
            helper.setInitTime(l);
        }
    }

    public static void write() throws IOException {
        DeployPerfUtil.write(null, false);
    }

    public static synchronized void write(PerfRollup perfRollup, boolean bl) throws IOException {
        if (DeployPerfUtil.isEnabled() && helper != null) {
            if (perfLog.isDirectory()) {
                throw new IllegalStateException(INVALID_DEPLOY_PERF_LOG);
            }
            if (!perfLog.getParentFile().exists() && !perfLog.getParentFile().mkdirs()) {
                throw new IllegalStateException(MISSING_PARENTS);
            }
            PrintStream printStream = null;
            try {
                printStream = new PrintStream(new FileOutputStream(perfLog, false));
                PerfLabel[] perfLabelArray = helper.toArray();
                if (perfLabelArray != null && perfLabelArray.length > 0) {
                    long l = 0L;
                    long l2 = 0L;
                    long l3 = 0L;
                    long l4 = 0L;
                    for (int i = 0; i < perfLabelArray.length; ++i) {
                        long l5 = perfLabelArray[i].getTime();
                        if (l == 0L) {
                            l = l5;
                        } else {
                            l3 = l5 - l;
                            l4 = l5 - l2;
                        }
                        l2 = l5;
                        StringBuffer stringBuffer = new StringBuffer(256);
                        stringBuffer.append(DeployPerfUtil.pad(perfLabelArray[i].getLabel(), 65, true));
                        stringBuffer.append(" , ").append(DeployPerfUtil.pad(l3, 7, true));
                        stringBuffer.append(" , ").append(DeployPerfUtil.pad(l4, 7, true));
                        printStream.println(stringBuffer.toString());
                    }
                } else {
                    printStream.println("The perf label event array is empty.");
                }
                printStream.flush();
                if (perfRollup != null && !bl) {
                    perfRollup.doRollup(perfLabelArray, printStream);
                    printStream.flush();
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                if (printStream != null) {
                    printStream.close();
                }
            }
        }
    }

    public static synchronized void initialize(PerfHelper perfHelper) {
        if (helper == null) {
            helper = perfHelper;
        }
    }

    public static synchronized PerfHelper getPerfHelper() {
        return helper;
    }

    private static File getPerfLog() {
        File file = null;
        try {
            String string = System.getenv(DEPLOY_PERF_ENABLED);
            if (string != null && !string.equalsIgnoreCase("false")) {
                String string2 = System.getenv(DEPLOY_PERF_LOG);
                file = string2 != null ? new File(string2) : new File(Config.getLogDirectory(), "deploy_perf.log");
            }
        }
        catch (Error error) {
            // empty catch block
        }
        return file;
    }

    private static String pad(long l, int n, boolean bl) {
        String string = Long.toString(l);
        return DeployPerfUtil.pad(string, n, bl);
    }

    private static String pad(String string, int n, boolean bl) {
        int n2;
        int n3 = n - string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        if (!bl) {
            for (n2 = 0; n2 < n3; ++n2) {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append(string);
        if (bl) {
            for (n2 = 0; n2 < n3; ++n2) {
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    static {
        getenvSupported = true;
        deployFirstframePerfEnabled = DeployPerfUtil.getenv("DEPLOY_FIRSTFRAME_PERF_ENABLED") != null;
        perfLog = DeployPerfUtil.getPerfLog();
        helper = null;
    }
}

