/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.Iterator;
import java.util.Map;
import sun.nio.cs.US_ASCII;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastCharsetProvider
extends CharsetProvider {
    private Map<String, String> classMap;
    private Map<String, String> aliasMap;
    private Map<String, Charset> cache;
    private String packagePrefix;

    protected FastCharsetProvider(String string, Map<String, String> map, Map<String, String> map2, Map<String, Charset> map3) {
        this.packagePrefix = string;
        this.aliasMap = map;
        this.classMap = map2;
        this.cache = map3;
    }

    private String canonicalize(String string) {
        String string2 = this.aliasMap.get(string);
        return string2 != null ? string2 : string;
    }

    private static String toLower(String string) {
        int n;
        int n2 = string.length();
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            n = string.charAt(i);
            if ((n - 65 | 90 - n) < 0) continue;
            bl = false;
            break;
        }
        if (bl) {
            return string;
        }
        char[] cArray = new char[n2];
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            cArray[n] = (c - 65 | 90 - c) >= 0 ? (char)(c + 32) : (char)c;
        }
        return new String(cArray);
    }

    private Charset lookup(String string) {
        String string2 = this.canonicalize(FastCharsetProvider.toLower(string));
        Charset charset = this.cache.get(string2);
        if (charset != null) {
            return charset;
        }
        String string3 = this.classMap.get(string2);
        if (string3 == null) {
            return null;
        }
        if (string3.equals("US_ASCII")) {
            charset = new US_ASCII();
            this.cache.put(string2, charset);
            return charset;
        }
        try {
            Class<?> clazz = Class.forName(this.packagePrefix + "." + string3, true, this.getClass().getClassLoader());
            charset = (Charset)clazz.newInstance();
            this.cache.put(string2, charset);
            return charset;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Charset charsetForName(String string) {
        FastCharsetProvider fastCharsetProvider = this;
        synchronized (fastCharsetProvider) {
            return this.lookup(this.canonicalize(string));
        }
    }

    @Override
    public final Iterator<Charset> charsets() {
        return new Iterator<Charset>(){
            Iterator<String> i;
            {
                this.i = FastCharsetProvider.this.classMap.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public Charset next() {
                String string = this.i.next();
                return FastCharsetProvider.this.lookup(string);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

