/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.ParseException;
import java.text.PatternEntry;
import java.util.ArrayList;

final class MergeCollation {
    ArrayList patterns = new ArrayList();
    private transient PatternEntry saveEntry = null;
    private transient PatternEntry lastEntry = null;
    private transient StringBuffer excess = new StringBuffer();
    private transient byte[] statusArray = new byte[8192];
    private final byte BITARRAYMASK = 1;
    private final int BYTEPOWER = 3;
    private final int BYTEMASK = 7;

    public MergeCollation(String string) throws ParseException {
        for (int i = 0; i < this.statusArray.length; ++i) {
            this.statusArray[i] = 0;
        }
        this.setPattern(string);
    }

    public String getPattern() {
        return this.getPattern(true);
    }

    public String getPattern(boolean bl) {
        PatternEntry patternEntry;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        PatternEntry patternEntry2 = null;
        ArrayList<PatternEntry> arrayList = null;
        for (n = 0; n < this.patterns.size(); ++n) {
            patternEntry = (PatternEntry)this.patterns.get(n);
            if (patternEntry.extension.length() != 0) {
                if (arrayList == null) {
                    arrayList = new ArrayList<PatternEntry>();
                }
                arrayList.add(patternEntry);
                continue;
            }
            if (arrayList != null) {
                PatternEntry patternEntry3 = this.findLastWithNoExtension(n - 1);
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    patternEntry2 = (PatternEntry)arrayList.get(i);
                    patternEntry2.addToBuffer(stringBuffer, false, bl, patternEntry3);
                }
                arrayList = null;
            }
            patternEntry.addToBuffer(stringBuffer, false, bl, null);
        }
        if (arrayList != null) {
            patternEntry = this.findLastWithNoExtension(n - 1);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                patternEntry2 = (PatternEntry)arrayList.get(i);
                patternEntry2.addToBuffer(stringBuffer, false, bl, patternEntry);
            }
            arrayList = null;
        }
        return stringBuffer.toString();
    }

    private final PatternEntry findLastWithNoExtension(int n) {
        --n;
        while (n >= 0) {
            PatternEntry patternEntry = (PatternEntry)this.patterns.get(n);
            if (patternEntry.extension.length() == 0) {
                return patternEntry;
            }
            --n;
        }
        return null;
    }

    public String emitPattern() {
        return this.emitPattern(true);
    }

    public String emitPattern(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.patterns.size(); ++i) {
            PatternEntry patternEntry = (PatternEntry)this.patterns.get(i);
            if (patternEntry == null) continue;
            patternEntry.addToBuffer(stringBuffer, true, bl, null);
        }
        return stringBuffer.toString();
    }

    public void setPattern(String string) throws ParseException {
        this.patterns.clear();
        this.addPattern(string);
    }

    public void addPattern(String string) throws ParseException {
        if (string == null) {
            return;
        }
        PatternEntry.Parser parser = new PatternEntry.Parser(string);
        PatternEntry patternEntry = parser.next();
        while (patternEntry != null) {
            this.fixEntry(patternEntry);
            patternEntry = parser.next();
        }
    }

    public int getCount() {
        return this.patterns.size();
    }

    public PatternEntry getItemAt(int n) {
        return (PatternEntry)this.patterns.get(n);
    }

    private final void fixEntry(PatternEntry patternEntry) throws ParseException {
        if (this.lastEntry != null && patternEntry.chars.equals(this.lastEntry.chars) && patternEntry.extension.equals(this.lastEntry.extension)) {
            if (patternEntry.strength != 3 && patternEntry.strength != -2) {
                throw new ParseException("The entries " + this.lastEntry + " and " + patternEntry + " are adjacent in the rules, but have conflicting " + "strengths: A character can't be unequal to itself.", -1);
            }
            return;
        }
        boolean bl = true;
        if (patternEntry.strength != -2) {
            int n;
            int n2 = -1;
            if (patternEntry.chars.length() == 1) {
                n = patternEntry.chars.charAt(0);
                int n3 = n >> 3;
                byte by = this.statusArray[n3];
                byte by2 = (byte)(1 << (n & 7));
                if (by != 0 && (by & by2) != 0) {
                    n2 = this.patterns.lastIndexOf(patternEntry);
                } else {
                    this.statusArray[n3] = (byte)(by | by2);
                }
            } else {
                n2 = this.patterns.lastIndexOf(patternEntry);
            }
            if (n2 != -1) {
                this.patterns.remove(n2);
            }
            this.excess.setLength(0);
            n = this.findLastEntry(this.lastEntry, this.excess);
            if (this.excess.length() != 0) {
                patternEntry.extension = this.excess + patternEntry.extension;
                if (n != this.patterns.size()) {
                    this.lastEntry = this.saveEntry;
                    bl = false;
                }
            }
            if (n == this.patterns.size()) {
                this.patterns.add(patternEntry);
                this.saveEntry = patternEntry;
            } else {
                this.patterns.add(n, patternEntry);
            }
        }
        if (bl) {
            this.lastEntry = patternEntry;
        }
    }

    private final int findLastEntry(PatternEntry patternEntry, StringBuffer stringBuffer) throws ParseException {
        int n;
        if (patternEntry == null) {
            return 0;
        }
        if (patternEntry.strength != -2) {
            int n2 = -1;
            if (patternEntry.chars.length() == 1) {
                int n3 = patternEntry.chars.charAt(0) >> 3;
                if ((this.statusArray[n3] & 1 << (patternEntry.chars.charAt(0) & 7)) != 0) {
                    n2 = this.patterns.lastIndexOf(patternEntry);
                }
            } else {
                n2 = this.patterns.lastIndexOf(patternEntry);
            }
            if (n2 == -1) {
                throw new ParseException("couldn't find last entry: " + patternEntry, n2);
            }
            return n2 + 1;
        }
        for (n = this.patterns.size() - 1; n >= 0; --n) {
            PatternEntry patternEntry2 = (PatternEntry)this.patterns.get(n);
            if (!patternEntry2.chars.regionMatches(0, patternEntry.chars, 0, patternEntry2.chars.length())) continue;
            stringBuffer.append(patternEntry.chars.substring(patternEntry2.chars.length(), patternEntry.chars.length()));
            break;
        }
        if (n == -1) {
            throw new ParseException("couldn't find: " + patternEntry, n);
        }
        return n + 1;
    }
}

