/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef _SFX_SFXTYPES_HXX
#define _SFX_SFXTYPES_HXX

#include <tools/debug.hxx>
#ifndef _RC_HXX //autogen
#include <tools/rc.hxx>
#endif
#ifndef _RCID_H //autogen
#include <tools/rcid.h>
#endif
#ifndef _RESID_HXX //autogen
#include <tools/resid.hxx>
#endif
#include <tools/link.hxx>
#ifndef _APP_HXX //autogen
#include <vcl/svapp.hxx>
#endif
#include <vcl/wrkwin.hxx>

#ifndef _VOS_MUTEX_HXX //autogen
#include <vos/mutex.hxx>
#endif

#ifndef DELETEZ
#define DELETEZ(pPtr) ( delete pPtr, pPtr = 0 )
#endif

#ifndef DELETEX
#ifdef DBG_UTIL
#define DELETEX(pPtr) ( delete pPtr, (void*&) pPtr = (void*) 0xFFFFFFFF )
#else
#define DELETEX(pPtr) delete pPtr
#endif
#endif

class SfxShell;
class Timer;

//------------------------------------------------------------------------

// Macro fuer den Call-Profiler unter WinNT
// mit S_CAP kann eine Messung gestarted, mit E_CAP wieder gestoppt werden
#if defined( WNT ) && defined( PROFILE )

extern "C" {
	void StartCAP();
	void StopCAP();
	void DumpCAP();
};

#define S_CAP()   StartCAP();
#define E_CAP()   StopCAP(); DumpCAP();

struct _Capper
{
	_Capper() { S_CAP(); }
	~_Capper() { E_CAP(); }
};

#define CAP _Capper _aCap_

#else

#define S_CAP()
#define E_CAP()
#define CAP

#endif

#ifdef DBG_UTIL
#ifndef DBG
#define DBG(statement) statement
#endif
#define DBG_OUTF(x) DbgOutf x
#else
#ifndef DBG
#define DBG(statement)
#endif
#define DBG_OUTF(x)
#endif

#define TRIM(s) s.EraseLeadingChars().EraseTrailingChars()

//------------------------------------------------------------------------

String SfxShellIdent_Impl( const SfxShell *pSh );

//------------------------------------------------------------------------

#if defined(DBG_UTIL) && ( defined(WNT) || defined(OS2) )

class SfxStack
{
	static unsigned nLevel;

public:
	SfxStack( const char *pName )
	{
		++nLevel;
		DbgOutf( "STACK: enter %3d %s", nLevel, pName );
	}
	~SfxStack()
	{
		DbgOutf( "STACK: leave %3d", nLevel );
		--nLevel;
	}
};

#define SFX_STACK(s) SfxStack aSfxStack_( #s )
#else
#define SFX_STACK(s)
#endif

//------------------------------------------------------------------------

String SearchAndReplace( const String &rSource,
						 const String &rToReplace,
						 const String &rReplacement );

#define SFX_PASSWORD_CODE "_:;*\x9A?()/&[&"
String SfxStringEncode( const String &rSource,
						const char *pKey = SFX_PASSWORD_CODE );
String SfxStringDecode( const String &rSource,
						const char *pKey = SFX_PASSWORD_CODE );


struct StringList_Impl : private Resource
{

	ResId aResId;

	StringList_Impl( const ResId& rErrIdP,  sal_uInt16 nId)
		: Resource( rErrIdP ),aResId(nId, *rErrIdP.GetResMgr()){}
	~StringList_Impl() { FreeResource(); }

	String GetString(){ return String( aResId ); }
	operator sal_Bool(){return IsAvailableRes(aResId.SetRT(RSC_STRING));}

};

#define SFX_DEL_PTRARR(pArr) 									\
			{                                                   \
				for ( sal_uInt16 n = (pArr)->Count(); n--; )        \
					delete (pArr)->GetObject(n);                \
				DELETEX(pArr);                                  \
			}

class SfxBoolResetter
{
	sal_Bool&				_rVar;
	sal_Bool				_bOld;

public:
						SfxBoolResetter( sal_Bool &rVar )
						:	_rVar( rVar ),
							_bOld( rVar )
						{}

						~SfxBoolResetter()
						{ _rVar = _bOld; }
};

#define GPF() *(int*)0 = 0

#endif // #ifndef _SFX_SFXTYPES_HXX


