/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef _SVX_CRSDITEM_HXX
#define _SVX_CRSDITEM_HXX

// include ---------------------------------------------------------------

#include <vcl/vclenum.hxx>
#include <svl/eitem.hxx>
#include <editeng/editengdllapi.h>

class SvXMLUnitConverter;
namespace rtl
{
	class OUString;
}

// class SvxCrossedOutItem -----------------------------------------------

/*
	[Beschreibung]
	Dieses Item beschreibt, ob und wie durchstrichen ist.
*/

class EDITENG_DLLPUBLIC SvxCrossedOutItem : public SfxEnumItem
{
public:
	TYPEINFO();

    SvxCrossedOutItem( const FontStrikeout eSt /*= STRIKEOUT_NONE*/,
                       const sal_uInt16 nId  );

	// "pure virtual Methoden" vom SfxPoolItem
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
                                    String &rText, const IntlWrapper * = 0 ) const;

	virtual SfxPoolItem*    Clone( SfxItemPool *pPool = 0 ) const;
	virtual SfxPoolItem*    Create(SvStream &, sal_uInt16) const;
	virtual SvStream&		Store(SvStream &, sal_uInt16 nItemVersion) const;
	virtual String			GetValueTextByPos( sal_uInt16 nPos ) const;
	virtual sal_uInt16          GetValueCount() const;
	virtual	sal_Bool        	 QueryValue( com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 ) const;
	virtual	sal_Bool			 PutValue( const com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 );

	// MS VC4.0 kommt durcheinander
	void			 		SetValue( sal_uInt16 nNewVal )
								{SfxEnumItem::SetValue(nNewVal); }

	virtual int 			HasBoolValue() const;
	virtual sal_Bool			GetBoolValue() const;
	virtual void			SetBoolValue( sal_Bool bVal );

	inline SvxCrossedOutItem& operator=(const SvxCrossedOutItem& rCross)
		{
			SetValue( rCross.GetValue() );
			return *this;
		}

	// enum cast
	FontStrikeout 			GetStrikeout() const
								{ return (FontStrikeout)GetValue(); }
	void 					SetStrikeout( FontStrikeout eNew )
								{ SetValue( (sal_uInt16)eNew ); }
};

#endif // #ifndef _SVX_CRSDITEM_HXX

