/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef INCLUDED_DRAWINGLAYER_PRIMITIVE3D_POLYPOLYGONPRIMITIVE3D_HXX
#define INCLUDED_DRAWINGLAYER_PRIMITIVE3D_POLYPOLYGONPRIMITIVE3D_HXX

#include <drawinglayer/primitive3d/baseprimitive3d.hxx>
#include <basegfx/polygon/b3dpolypolygon.hxx>
#include <drawinglayer/attribute/materialattribute3d.hxx>

//////////////////////////////////////////////////////////////////////////////

namespace drawinglayer
{
	namespace primitive3d
	{
        /** PolyPolygonMaterialPrimitive3D class

            This primitive defines a planar 3D PolyPolygon filled with a single color.
            This is one of the non-decomposable primitives, so a renderer
            should proccess it.

            It is assumed here that the PolyPolgon is a single plane in 3D.
         */
		class PolyPolygonMaterialPrimitive3D : public BasePrimitive3D
		{
		private:
            /// the PolyPolygon geometry
			basegfx::B3DPolyPolygon						maPolyPolygon;

            /// the fill parameters
			attribute::MaterialAttribute3D				maMaterial;

			/// bitfield
			unsigned									mbDoubleSided : 1;

		public:
            /// constructor
			PolyPolygonMaterialPrimitive3D(
				const basegfx::B3DPolyPolygon& rPolyPolygon, 
				const attribute::MaterialAttribute3D& rMaterial, 
				bool bDoubleSided);

			/// data read access
			const basegfx::B3DPolyPolygon& getB3DPolyPolygon() const { return maPolyPolygon; }
			const attribute::MaterialAttribute3D& getMaterial() const { return maMaterial; }
			bool getDoubleSided() const { return mbDoubleSided; }

			/// compare operator
			virtual bool operator==(const BasePrimitive3D& rPrimitive) const;

			/// get range
			virtual basegfx::B3DRange getB3DRange(const geometry::ViewInformation3D& rViewInformation) const;

			/// provide unique ID
			DeclPrimitrive3DIDBlock()
		};
	} // end of namespace primitive3d
} // end of namespace drawinglayer

//////////////////////////////////////////////////////////////////////////////

#endif //INCLUDED_DRAWINGLAYER_PRIMITIVE3D_POLYPOLYGONPRIMITIVE3D_HXX

//////////////////////////////////////////////////////////////////////////////
// eof
