/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.packaging.mime.internet;

import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeUtility;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;

class AsciiOutputStream
extends OutputStream {
    private boolean breakOnNonAscii;
    private int ascii = 0;
    private int non_ascii = 0;
    private int linelen = 0;
    private boolean longLine = false;
    private boolean badEOL = false;
    private boolean checkEOL = false;
    private int lastb = 0;
    private int ret = 0;

    public AsciiOutputStream(boolean bl, boolean bl2) {
        this.breakOnNonAscii = bl;
        this.checkEOL = bl2 && bl;
    }

    public void write(int n) throws IOException {
        this.check(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        n2 += n;
        for (int i = n; i < n2; ++i) {
            this.check(byArray[i]);
        }
    }

    private final void check(int n) throws IOException {
        if (this.checkEOL && (this.lastb == 13 && (n &= 0xFF) != 10 || this.lastb != 13 && n == 10)) {
            this.badEOL = true;
        }
        if (n == 13 || n == 10) {
            this.linelen = 0;
        } else {
            ++this.linelen;
            if (this.linelen > 998) {
                this.longLine = true;
            }
        }
        if (MimeUtility.nonascii(n)) {
            ++this.non_ascii;
            if (this.breakOnNonAscii) {
                this.ret = 3;
                throw new EOFException();
            }
        } else {
            ++this.ascii;
        }
        this.lastb = n;
    }

    public int getAscii() {
        if (this.ret != 0) {
            return this.ret;
        }
        if (this.badEOL) {
            return 3;
        }
        if (this.non_ascii == 0) {
            if (this.longLine) {
                return 2;
            }
            return 1;
        }
        if (this.ascii > this.non_ascii) {
            return 2;
        }
        return 3;
    }
}

