/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsMenuItemUI;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;

public class WindowsMenuBarUI
extends BasicMenuBarUI {
    private WindowListener windowListener = null;
    private HierarchyListener hierarchyListener = null;
    private Window window = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsMenuBarUI();
    }

    protected void uninstallListeners() {
        this.uninstallWindowListener();
        if (this.hierarchyListener != null) {
            this.menuBar.removeHierarchyListener(this.hierarchyListener);
            this.hierarchyListener = null;
        }
        super.uninstallListeners();
    }

    private void installWindowListener() {
        Container container;
        if (this.windowListener == null && (container = this.menuBar.getTopLevelAncestor()) instanceof Window) {
            this.window = (Window)container;
            this.windowListener = new WindowAdapter(){

                public void windowActivated(WindowEvent windowEvent) {
                    WindowsMenuBarUI.this.menuBar.repaint();
                }

                public void windowDeactivated(WindowEvent windowEvent) {
                    WindowsMenuBarUI.this.menuBar.repaint();
                }
            };
            ((Window)container).addWindowListener(this.windowListener);
        }
    }

    private void uninstallWindowListener() {
        if (this.windowListener != null && this.window != null) {
            this.window.removeWindowListener(this.windowListener);
        }
        this.window = null;
        this.windowListener = null;
    }

    protected void installListeners() {
        if (WindowsLookAndFeel.isOnVista()) {
            this.installWindowListener();
            this.hierarchyListener = new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    if ((hierarchyEvent.getChangeFlags() & 2L) != 0L) {
                        if (WindowsMenuBarUI.this.menuBar.isDisplayable()) {
                            WindowsMenuBarUI.this.installWindowListener();
                        } else {
                            WindowsMenuBarUI.this.uninstallWindowListener();
                        }
                    }
                }
            };
            this.menuBar.addHierarchyListener(this.hierarchyListener);
        }
        super.installListeners();
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.menuBar);
        if (actionMap == null) {
            actionMap = new ActionMapUIResource();
            SwingUtilities.replaceUIActionMap(this.menuBar, actionMap);
        }
        actionMap.put("takeFocus", new TakeFocus());
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            XPStyle xPStyle = XPStyle.getXP();
            XPStyle.Skin skin = xPStyle.getSkin(jComponent, TMSchema.Part.MP_BARBACKGROUND);
            int n = jComponent.getWidth();
            int n2 = jComponent.getHeight();
            TMSchema.State state = WindowsMenuBarUI.isActive(jComponent) ? TMSchema.State.ACTIVE : TMSchema.State.INACTIVE;
            skin.paintSkin(graphics, 0, 0, n, n2, state);
        } else {
            super.paint(graphics, jComponent);
        }
    }

    static boolean isActive(JComponent jComponent) {
        Container container;
        JRootPane jRootPane = jComponent.getRootPane();
        if (jRootPane != null && (container = jRootPane.getParent()) instanceof Window) {
            return ((Window)container).isActive();
        }
        return true;
    }

    private static class TakeFocus
    extends AbstractAction {
        private TakeFocus() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuBar jMenuBar = (JMenuBar)actionEvent.getSource();
            JMenu jMenu = jMenuBar.getMenu(0);
            if (jMenu != null) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                MenuElement[] menuElementArray = new MenuElement[]{jMenuBar, jMenu};
                menuSelectionManager.setSelectedPath(menuElementArray);
                WindowsLookAndFeel.setMnemonicHidden(false);
                WindowsLookAndFeel.repaintRootPane(jMenuBar);
            }
        }
    }
}

