/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class MotifSliderUI
extends BasicSliderUI {
    static final Dimension PREFERRED_HORIZONTAL_SIZE = new Dimension(164, 15);
    static final Dimension PREFERRED_VERTICAL_SIZE = new Dimension(15, 164);
    static final Dimension MINIMUM_HORIZONTAL_SIZE = new Dimension(43, 15);
    static final Dimension MINIMUM_VERTICAL_SIZE = new Dimension(15, 43);

    public MotifSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifSliderUI((JSlider)jComponent);
    }

    public Dimension getPreferredHorizontalSize() {
        return PREFERRED_HORIZONTAL_SIZE;
    }

    public Dimension getPreferredVerticalSize() {
        return PREFERRED_VERTICAL_SIZE;
    }

    public Dimension getMinimumHorizontalSize() {
        return MINIMUM_HORIZONTAL_SIZE;
    }

    public Dimension getMinimumVerticalSize() {
        return MINIMUM_VERTICAL_SIZE;
    }

    protected Dimension getThumbSize() {
        if (this.slider.getOrientation() == 0) {
            return new Dimension(30, 15);
        }
        return new Dimension(15, 30);
    }

    public void paintFocus(Graphics graphics) {
    }

    public void paintTrack(Graphics graphics) {
    }

    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.thumbRect;
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (this.slider.isEnabled()) {
            graphics.setColor(this.slider.getForeground());
        } else {
            graphics.setColor(this.slider.getForeground().darker());
        }
        if (this.slider.getOrientation() == 0) {
            graphics.translate(n, rectangle.y - 1);
            graphics.fillRect(0, 1, n3, n4 - 1);
            graphics.setColor(this.getHighlightColor());
            graphics.drawLine(0, 1, n3 - 1, 1);
            graphics.drawLine(0, 1, 0, n4);
            graphics.drawLine(n3 / 2, 2, n3 / 2, n4 - 1);
            graphics.setColor(this.getShadowColor());
            graphics.drawLine(0, n4, n3 - 1, n4);
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4);
            graphics.drawLine(n3 / 2 - 1, 2, n3 / 2 - 1, n4);
            graphics.translate(-n, -(rectangle.y - 1));
        } else {
            graphics.translate(rectangle.x - 1, 0);
            graphics.fillRect(1, n2, n3 - 1, n4);
            graphics.setColor(this.getHighlightColor());
            graphics.drawLine(1, n2, n3, n2);
            graphics.drawLine(1, n2 + 1, 1, n2 + n4 - 1);
            graphics.drawLine(2, n2 + n4 / 2, n3 - 1, n2 + n4 / 2);
            graphics.setColor(this.getShadowColor());
            graphics.drawLine(2, n2 + n4 - 1, n3, n2 + n4 - 1);
            graphics.drawLine(n3, n2 + n4 - 1, n3, n2);
            graphics.drawLine(2, n2 + n4 / 2 - 1, n3 - 1, n2 + n4 / 2 - 1);
            graphics.translate(-(rectangle.x - 1), 0);
        }
    }
}

