/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef _SVX_TBXFORM_HXX
#define _SVX_TBXFORM_HXX

#include <sfx2/tbxctrl.hxx>
#include <vcl/field.hxx>
#include <vcl/dialog.hxx>

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif

//========================================================================
class SvxFmAbsRecWin : public NumericField
{
	SfxToolBoxControl*	m_pController;
		// for invalidating our content whe losing the focus
public:
	SvxFmAbsRecWin( Window* _pParent, SfxToolBoxControl* _pController );
	~SvxFmAbsRecWin();

	virtual void KeyInput( const KeyEvent& rKeyEvt );
	virtual void LoseFocus();

protected:
	virtual void FirePosition( sal_Bool _bForce );
};


//========================================================================
class SvxFmConfigWin : public SfxPopupWindow
{
private:
	DECL_LINK( TbxSelectHdl, ToolBox* );

public:
	SvxFmConfigWin( sal_uInt16 nId, ResId aRIdWin, ResId aRIdTbx );
	~SvxFmConfigWin();

	void			Update();
	virtual void	PopupModeEnd();
};


//========================================================================
class SvxFmTbxCtlConfig : public SfxToolBoxControl
{
private:
	sal_uInt16 nLastSlot;

protected:
    using SfxToolBoxControl::Select;

public:
	SFX_DECL_TOOLBOX_CONTROL();

	SvxFmTbxCtlConfig( sal_uInt16 nSlotId, sal_uInt16 nId, ToolBox& rTbx );
	~SvxFmTbxCtlConfig() {}

	virtual void				Select( sal_uInt16 nModifier );
	virtual void				StateChanged( sal_uInt16 nSID, SfxItemState eState,
											  const SfxPoolItem* pState );
	virtual SfxPopupWindowType	GetPopupWindowType() const;
	virtual SfxPopupWindow*		CreatePopupWindow();
};

//========================================================================
class FixedText;
class SvxFmTbxCtlAbsRec : public SfxToolBoxControl
{
public:
	SFX_DECL_TOOLBOX_CONTROL();

	SvxFmTbxCtlAbsRec( sal_uInt16 nSlotId, sal_uInt16 nId, ToolBox& rTbx );
	~SvxFmTbxCtlAbsRec();

	virtual Window*	CreateItemWindow( Window* pParent );

	virtual void	StateChanged( sal_uInt16 nSID, SfxItemState eState,
								  const SfxPoolItem* pState );
};

//========================================================================
class SvxFmTbxCtlRecText : public SfxToolBoxControl
{
public:
	SFX_DECL_TOOLBOX_CONTROL();

	SvxFmTbxCtlRecText( sal_uInt16 nSlotId, sal_uInt16 nId, ToolBox& rTbx );
	~SvxFmTbxCtlRecText();

	virtual Window*	CreateItemWindow( Window* pParent );
};

//========================================================================
class SvxFmTbxCtlRecFromText : public SfxToolBoxControl
{
public:
	SFX_DECL_TOOLBOX_CONTROL();

	SvxFmTbxCtlRecFromText( sal_uInt16 nSlotId, sal_uInt16 nId, ToolBox& rTbx );
	~SvxFmTbxCtlRecFromText();

	virtual Window*	CreateItemWindow( Window* pParent );
};

//========================================================================
class SvxFmTbxCtlRecTotal : public SfxToolBoxControl
{
	FixedText* pFixedText;

public:
	SFX_DECL_TOOLBOX_CONTROL();

	SvxFmTbxCtlRecTotal( sal_uInt16 nSlotId, sal_uInt16 nId, ToolBox& rTbx );
	~SvxFmTbxCtlRecTotal();

	virtual Window*	CreateItemWindow( Window* pParent );
	virtual void	StateChanged( sal_uInt16 nSID, SfxItemState eState,
								  const SfxPoolItem* pState );
};

//========================================================================
class SvxFmTbxNextRec : public SfxToolBoxControl
{
public:
	SFX_DECL_TOOLBOX_CONTROL();											 
	SvxFmTbxNextRec( sal_uInt16 nSlotId, sal_uInt16 nId, ToolBox& rTbx );	
};

//========================================================================
class SvxFmTbxPrevRec : public SfxToolBoxControl
{
public:
	SFX_DECL_TOOLBOX_CONTROL();											 
	SvxFmTbxPrevRec( sal_uInt16 nSlotId, sal_uInt16 nId, ToolBox& rTbx );	
};					


#endif

