/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_xmloff.hxx"
#include <com/sun/star/beans/XPropertySetInfo.hpp>
#include <rtl/uuid.h>
#include <rtl/ustrbuf.hxx>
#include <xmloff/nmspmap.hxx>
#include "xmlnmspe.hxx"
#include <xmloff/xmltoken.hxx>
#include "DeepTContext.hxx"
#include "MetaTContext.hxx"
#include "DocumentTContext.hxx"
#ifndef _XMLOFF_NOTESCONTEXT_HXX
#include "NotesTContext.hxx"
#endif
#include "StyleOASISTContext.hxx"
#include "FrameOASISTContext.hxx"
#include "EventOASISTContext.hxx"
#include "DlgOASISTContext.hxx"
#ifndef _XMLOFF_CONTROLOASISTCONTEXT_HXX
#include "ControlOASISTContext.hxx"
#endif
#include "FormPropOASISTContext.hxx"
#include "ChartOASISTContext.hxx"
#include "ChartPlotAreaOASISTContext.hxx"
#include "MutableAttrList.hxx"
#include "ElemTransformerAction.hxx"
#include "AttrTransformerAction.hxx"
#include "TransformerActions.hxx"
#include "FamilyType.hxx"
#include <xmloff/xmluconv.hxx>
#include "Oasis2OOo.hxx"

using ::rtl::OUString;
using ::rtl::OUStringBuffer;
using namespace ::osl;
using namespace ::xmloff::token;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::xml::sax;
using namespace ::com::sun::star::beans;

OUString SAL_CALL Oasis2OOoTransformer_getImplementationName() throw();

enum XMLUserDefinedTransformerAction
{
	XML_ETACTION_META=XML_ETACTION_USER_DEFINED,
	XML_ETACTION_DOCUMENT,
    XML_ETACTION_BODY,
	XML_ETACTION_NOTES,
	XML_ETACTION_TABLE,
	XML_ETACTION_STYLE,
	XML_ETACTION_STYLE_RENAME,
	XML_ETACTION_FRAME,
	XML_ETACTION_EVENT,
	XML_ETACTION_DLG,
	XML_ETACTION_TAB_STOP,
	XML_ETACTION_FORM_CONTROL,
	XML_ETACTION_FORM_PROPERTY,
	XML_ETACTION_CONFIG_ITEM,
	XML_ETACTION_TRACKED_CHANGES,
	XML_ETACTION_CHART,
	XML_ETACTION_CHART_PLOT_AREA
};

#define ENTRY3( n, l, a, p1, p2, p3 ) \
	{ XML_NAMESPACE_##n, XML_##l, a, p1, p2, p3 }
#define ENTRY3QNQ( n, l, a, n1, l1, p2, n3, l3 ) \
	ENTRY3( n, l, a, XMLTransformerActionInit::QNameParam( n1, l1 ), \
			p2, XMLTransformerActionInit::QNameParam( n3, l3 ) )

#define ENTRY2( n, l, a, p1, p2 ) \
	ENTRY3( n, l, a, p1, p2, 0 )
#define ENTRY2QQ( n, l, a, n1, l1, n2, l2 ) \
	ENTRY2( n, l, a, XMLTransformerActionInit::QNameParam( n1, l1 ), \
			XMLTransformerActionInit::QNameParam( n2, l2 ) )
#define ENTRY2QN( n, l, a, n1, l1, p2 ) \
	ENTRY2( n, l, a, XMLTransformerActionInit::QNameParam( n1, l1 ), p2 )

#define ENTRY1( n, l, a, p1 ) \
	ENTRY3( n, l, a, p1, 0, 0 )
#define ENTRY1Q( n, l, a, p1, t1 ) \
	ENTRY1( n, l, a, XMLTransformerActionInit::QNameParam( p1, t1 ) )

#define ENTRY0( n, l, a ) \
	ENTRY3( n, l, a, 0, 0, 0 )

// BM: a macro to put two tokens into one sal_Int32 for the action
// XML_ATACTION_RENAME_ATTRIBUTE
#define RENAME_ENTRY( f, s ) \
    (static_cast< sal_Int32 >(f) | (static_cast< sal_Int32 >(s) << 16))

static XMLTransformerActionInit aActionTable[] =
{
	// add office:class from <office:document> and <office:document-content>
	ENTRY0( OFFICE, DOCUMENT, XML_ETACTION_DOCUMENT ),
	ENTRY0( OFFICE, DOCUMENT_CONTENT, XML_ETACTION_DOCUMENT ),
	ENTRY1Q( OOO, AUTO_TEXT_EVENTS, XML_ETACTION_RENAME_ELEM,
						  XML_NAMESPACE_OFFICE, XML_AUTO_TEXT_EVENTS),

	// add <meta:keywords>
	ENTRY0( OFFICE, META, XML_ETACTION_META ),

    // rename <office:scripts> to <office:script>
    ENTRY1Q( OFFICE, SCRIPTS, XML_ETACTION_RENAME_ELEM,
                        XML_NAMESPACE_OFFICE, XML_SCRIPT ),

	// rename <office:script> to <office:script-data> and process attributes
    ENTRY2QN( OFFICE, SCRIPT, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
                        XML_NAMESPACE_OFFICE, XML_SCRIPT_DATA,
                        OASIS_SCRIPT_ACTIONS ),

    // rename <ooo:libraries> to <script:libraries>
    ENTRY1Q( OOO, LIBRARIES, XML_ETACTION_RENAME_ELEM,
                        XML_NAMESPACE_SCRIPT, XML_LIBRARIES ),

    // rename <ooo:library-linked> to <script:library-linked> and process attributes
    ENTRY2QN( OOO, LIBRARY_LINKED, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
                        XML_NAMESPACE_SCRIPT, XML_LIBRARY_LINKED,
                        OASIS_SCRIPT_ACTIONS ),

    // rename <ooo:library-embedded> to <script:library-embedded> and process attributes
    ENTRY2QN( OOO, LIBRARY_EMBEDDED, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
                        XML_NAMESPACE_SCRIPT, XML_LIBRARY_EMBEDDED,
                        OASIS_SCRIPT_ACTIONS ),

    // rename <ooo:module> to <script:module> and process attributes
    ENTRY2QN( OOO, MODULE, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
                        XML_NAMESPACE_SCRIPT, XML_MODULE,
                        OASIS_SCRIPT_ACTIONS ),

    // rename <ooo:source-code> to <script:source-code>
    ENTRY1Q( OOO, SOURCE_CODE, XML_ETACTION_RENAME_ELEM,
                        XML_NAMESPACE_SCRIPT, XML_SOURCE_CODE ),

	ENTRY0( OFFICE, BODY, XML_ETACTION_BODY ),

	// rename <office:font-face-decls> to <office:font-decl>,
	// rename <style:font-face> to <style:font-decl>, process attrs
	ENTRY1Q( OFFICE, FONT_FACE_DECLS, XML_ETACTION_RENAME_ELEM,
						XML_NAMESPACE_OFFICE, XML_FONT_DECLS ),
	ENTRY2QN( STYLE, FONT_FACE, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
						XML_NAMESPACE_STYLE, XML_FONT_DECL,
		   				OASIS_FONT_FACE_ACTIONS ),

	// remove genre element
	ENTRY0( OFFICE, TEXT, XML_ETACTION_COPY_CONTENT ),
	ENTRY0( OFFICE, DRAWING, XML_ETACTION_COPY_CONTENT ),
	ENTRY0( OFFICE, PRESENTATION, XML_ETACTION_COPY_CONTENT ),
	ENTRY0( OFFICE, SPREADSHEET, XML_ETACTION_COPY_CONTENT ),
	ENTRY0( OFFICE, CHART, XML_ETACTION_COPY_CONTENT ),
	ENTRY0( OFFICE, IMAGE, XML_ETACTION_COPY_CONTENT ),

	// rename <style:page-layout> to <style:page-master>
	// ENTRY1Q( STYLE, PAGE_LAYOUT, RENAME_ELEM,
	//						XML_NAMESPACE_STYLE, XML_PAGE_MASTER ),
	ENTRY1( STYLE, MASTER_PAGE, XML_ETACTION_PROC_ATTRS,
						OASIS_MASTER_PAGE_ACTIONS ),

	// merge <style:*-properties> into <style:properties> and do other
	// styles processing
	ENTRY1( STYLE, STYLE, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_END ),
	ENTRY1( STYLE, DEFAULT_STYLE, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_END ),
	ENTRY2QN( STYLE, PAGE_LAYOUT, XML_ETACTION_STYLE_RENAME,
						XML_NAMESPACE_STYLE, XML_PAGE_MASTER,
		  				XML_FAMILY_TYPE_PAGE_LAYOUT ),
	ENTRY1( NUMBER, NUMBER_STYLE, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_DATA ),
	ENTRY1( NUMBER, CURRENCY_STYLE, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_DATA ),
	ENTRY1( NUMBER, PERCENTAGE_STYLE, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_DATA ),
	ENTRY1( NUMBER, DATE_STYLE, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_DATA ),
	ENTRY1( NUMBER, TIME_STYLE, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_DATA ),
	ENTRY1( NUMBER, BOOLEAN_STYLE, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_DATA ),
	ENTRY1( NUMBER, TEXT_STYLE, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_DATA ),
	ENTRY1( TEXT, LIST_STYLE, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_LIST ),
//	ENTRY0( TEXT, OUTLINE_STYLE, STYLE ),

	ENTRY1( STYLE, HEADER_STYLE, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_HEADER_FOOTER ),
	ENTRY1( STYLE, FOOTER_STYLE, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_HEADER_FOOTER ),
	ENTRY1( TEXT, LIST_LEVEL_STYLE_NUMBER, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_LIST ),
	ENTRY1( TEXT, LIST_LEVEL_STYLE_BULLET, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_LIST ),
	ENTRY1( TEXT, LIST_LEVEL_STYLE_IMAGE, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_LIST ),
	ENTRY1( TEXT, OUTLINE_LEVEL_STYLE, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_LIST ),
	ENTRY1( DRAW, GRADIENT, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_GRADIENT ),
	ENTRY1( DRAW, FILL_IMAGE, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_FILL_IMAGE ),
	ENTRY2QN( DRAW, OPACITY, XML_ETACTION_STYLE_RENAME,
				XML_NAMESPACE_DRAW, XML_TRANSPARENCY,
		 		XML_FAMILY_TYPE_GRADIENT ),
	ENTRY1( DRAW, MARKER, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_MARKER ),
	ENTRY1( DRAW, HATCH, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_HATCH ),
	ENTRY1( DRAW, STROKE_DASH, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_STROKE_DASH ),

	// process <text:h/p>: process style-name attributes,
	// rename <text:h>'s text:outline-level to text:level,
	ENTRY1( TEXT, H, XML_ETACTION_PROC_ATTRS, OASIS_PARA_ACTIONS ),
	ENTRY1( TEXT, P, XML_ETACTION_PROC_ATTRS, OASIS_PARA_ACTIONS ),

	// process <test:list>'s text:style-name attributes
	// rename <text:list> to <text:ordered-list> or <text:unordered-list>
	// TODO: All list currenty are renamed to <text:ordered-list>
	ENTRY2QN( TEXT, LIST, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
			XML_NAMESPACE_TEXT, XML_ORDERED_LIST,
		    OASIS_LIST_STYLE_REF_ACTIONS ),

	// rename <text:note*> to <text:footnote*> or <text:endnote*>
	ENTRY1( TEXT, NOTES_CONFIGURATION, XML_ETACTION_NOTES,
													XML_NOTES_CONFIGURATION),
	ENTRY1( TEXT, NOTE, XML_ETACTION_NOTES, XML_NOTE ),

	// rename <text:footnote> and <text:endnote> to <text:note>
	ENTRY1( TEXT, NOTE_REF, XML_ETACTION_NOTES, XML_NOTE_REF ),

	// rename <text:tab> to <text:tab-stop>
	ENTRY1Q( TEXT, TAB, XML_ETACTION_RENAME_ELEM,
						XML_NAMESPACE_TEXT, XML_TAB_STOP ),


	// replace <table:table tabke:is-sub-table> with <table:sub-table>
	ENTRY0( TABLE, TABLE, XML_ETACTION_TABLE ),

	// merge frame element
	ENTRY0( DRAW, FRAME, XML_ETACTION_FRAME ),

	// process events
	ENTRY1Q( OFFICE, EVENT_LISTENERS, XML_ETACTION_RENAME_ELEM,
		  			XML_NAMESPACE_OFFICE, XML_EVENTS ),
	ENTRY0( SCRIPT, EVENT_LISTENER, XML_ETACTION_EVENT ),
	ENTRY0( SCRIPT, EVENT, XML_ETACTION_EVENT ),
	ENTRY0( PRESENTATION, EVENT_LISTENER, XML_ETACTION_EVENT ),

	// process Basic dialogs
	ENTRY0( DLG, STYLE, XML_ETACTION_DLG ),

	// process length attributes
	ENTRY1( DRAW, RECT, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DRAW, LINE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DRAW, POLYLINE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DRAW, POLYGON, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DRAW, PATH, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DRAW, CIRCLE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DRAW, ELLIPSE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DRAW, CONNECTOR, XML_ETACTION_PROC_ATTRS, OASIS_CONNECTOR_ACTIONS ),
	ENTRY1( DRAW, CAPTION, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DRAW, MEASURE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DRAW, CONTROL, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DRAW, PAGE_THUMBNAIL, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DRAW, G, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
//	ENTRY1( DRAW, FRAME, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DRAW, TEXT_BOX, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( PRESENTATION, PLACEHOLDER, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DRAW, CONTOUR_POLYGON, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DRAW, CONTOUR_PATH, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DRAW, AREA_RECTANGLE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DRAW, AREA_CIRCLE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DRAW, AREA_POLYGON, XML_ETACTION_PROC_ATTRS, OASIS_DRAW_AREA_POLYGON_ACTIONS ),
	ENTRY1( DRAW, GLUE_POINT, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DR3D, SCENE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DR3D, CUBE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DR3D, SPHERE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DR3D, EXTRUDE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( DR3D, ROTATE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( CHART, TITLE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( CHART, SUBTITLE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( CHART, FOOTER, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( CHART, LEGEND, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( CHART, WALL, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( CHART, FLOOR, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( CHART, AXIS, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( CHART, GRID, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( CHART, SERIES, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( CHART, DATA_POINT, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( CHART, MEAN_VALUE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( CHART, ERROR_INDICATOR, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( CHART, REGRESSION_CURVE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( CHART, STOCK_GAIN_MARKER, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( CHART, STOCK_LOSS_MARKER, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
	ENTRY1( CHART, STOCK_RANGE_LINE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),

	ENTRY0( CHART, CHART, XML_ETACTION_CHART ),
    ENTRY0( CHART, PLOT_AREA, XML_ETACTION_CHART_PLOT_AREA ),

	ENTRY0( CONFIG, CONFIG_ITEM, XML_ETACTION_CONFIG_ITEM ),
	ENTRY1Q( TEXT, TRACKED_CHANGES, XML_ETACTION_TRACKED_CHANGES,
						XML_NAMESPACE_TEXT, XML_PROTECTION_KEY ),
	ENTRY1Q( TABLE, TRACKED_CHANGES, XML_ETACTION_TRACKED_CHANGES,
						XML_NAMESPACE_TABLE, XML_PROTECTION_KEY ),

	ENTRY1( TEXT, INDEX_ENTRY_TAB_STOP, XML_ETACTION_PROC_ATTRS,
				  OASIS_INDEX_ENTRY_TAB_STOP_ACTIONS ),
	ENTRY0( STYLE, TAB_STOP, XML_ETACTION_TAB_STOP ),
	ENTRY1( STYLE, BACKGROUND_IMAGE, XML_ETACTION_PROC_ATTRS,
		 			OASIS_BACKGROUND_IMAGE_ACTIONS  ),
	ENTRY1( TEXT, LINENUMBERING_CONFIGURATION, XML_ETACTION_PROC_ATTRS,
				  OASIS_LINENUMBERING_ACTIONS ),
	ENTRY1( STYLE, FOOTNOTE_SEP, XML_ETACTION_PROC_ATTRS,
				   OASIS_FOOTNOTE_SEP_ACTIONS ),
	ENTRY1( STYLE, DROP_CAP, XML_ETACTION_PROC_ATTRS, OASIS_DROP_CAP_ACTIONS ),
	ENTRY1( STYLE, COLUMNS, XML_ETACTION_PROC_ATTRS, OASIS_COLUMNS_ACTIONS ),
	ENTRY1( STYLE, COLUMN, XML_ETACTION_PROC_ATTRS, OASIS_COLUMNS_ACTIONS ),

	// process *:style-name attributes
	ENTRY1( STYLE, MAP, XML_ETACTION_PROC_ATTRS, OASIS_MAP_STYLE_REF_ACTIONS ),
	ENTRY1( TEXT, SPAN, XML_ETACTION_PROC_ATTRS, OASIS_TEXT_STYLE_REF_ACTIONS ),
	ENTRY1( TEXT, A, XML_ETACTION_PROC_ATTRS, OASIS_TEXT_STYLE_REF_ACTIONS ),
	ENTRY1( TEXT, RUBY_TEXT, XML_ETACTION_PROC_ATTRS,
				OASIS_TEXT_STYLE_REF_ACTIONS ),
	ENTRY1( TEXT, TABLE_OF_CONTENT_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
				OASIS_PARA_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, ILLUSTRATION_INDEX_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
				OASIS_PARA_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, TABLE_INDEX_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
				OASIS_PARA_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, OBJECT_INDEX_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
				OASIS_PARA_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, USER_INDEX_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
				OASIS_PARA_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, ALPHABETICAL_INDEX_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
				OASIS_PARA_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, BIBLIOGRAPHY_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
				OASIS_PARA_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, INDEX_SOURCE_STYLE, XML_ETACTION_PROC_ATTRS,
				OASIS_PARA_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, INDEX_TITLE_TEMPLATE, XML_ETACTION_PROC_ATTRS,
				OASIS_PARA_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY3QNQ( TEXT, INDEX_ENTRY_CHAPTER,
			XML_ETACTION_RENAME_ELEM_PROC_ATTRS_COND,
			XML_NAMESPACE_TEXT, XML_INDEX_ENTRY_CHAPTER_NUMBER,
			OASIS_TEXT_STYLE_REF_ACTIONS ,
		   	XML_NAMESPACE_TEXT, XML_TABLE_OF_CONTENT_ENTRY_TEMPLATE),
	ENTRY1( TEXT, INDEX_ENTRY_TEXT, XML_ETACTION_PROC_ATTRS,
				OASIS_TEXT_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, INDEX_ENTRY_PAGE_NUMBER, XML_ETACTION_PROC_ATTRS,
				OASIS_TEXT_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, INDEX_ENTRY_SPAN, XML_ETACTION_PROC_ATTRS,
				OASIS_TEXT_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, INDEX_ENTRY_BIBLIOGRAPHY, XML_ETACTION_PROC_ATTRS,
				OASIS_TEXT_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, INDEX_ENTRY_LINK_START, XML_ETACTION_PROC_ATTRS,
				OASIS_TEXT_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, INDEX_ENTRY_LINK_END, XML_ETACTION_PROC_ATTRS,
				OASIS_TEXT_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( DRAW, PAGE, XML_ETACTION_PROC_ATTRS,
				OASIS_MASTER_PAGE_REF_ACTIONS ), /* generated entry */
    // --> OD 2005-01-10 #i40011#, #i40015#
    // - conversion of attribute <table:style-name> for <table:table-row> and
    //   <table:table-column>
    ENTRY1( TABLE, TABLE_ROW, XML_ETACTION_PROC_ATTRS,
                OASIS_TABLE_STYLE_REF_ACTIONS ),
    ENTRY1( TABLE, TABLE_COLUMN, XML_ETACTION_PROC_ATTRS,
                OASIS_TABLE_STYLE_REF_ACTIONS ),
    // <--

	// rename office:value-* to *:value-*
	ENTRY1( TEXT, VARIABLE_DECL, XML_ETACTION_PROC_ATTRS,
			OASIS_TEXT_VALUE_TYPE_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, VARIABLE_SET, XML_ETACTION_PROC_ATTRS,
			OASIS_TEXT_VALUE_TYPE_ACTIONS), /* generated entry */
	ENTRY1( TEXT, VARIABLE_INPUT, XML_ETACTION_PROC_ATTRS,
			OASIS_TEXT_VALUE_TYPE_ACTIONS), /* generated entry */
	ENTRY1( TEXT, USER_FIELD_DECL, XML_ETACTION_PROC_ATTRS,
			OASIS_TEXT_VALUE_TYPE_ACTIONS), /* generated entry */
	ENTRY1( TEXT, EXPRESSION, XML_ETACTION_PROC_ATTRS,
			OASIS_TEXT_VALUE_TYPE_ACTIONS), /* generated entry */
    ENTRY1( TEXT, USER_DEFINED, XML_ETACTION_PROC_ATTRS,
			OASIS_DATETIME_ACTIONS ), // Add OASIS_TEXT_VALUE_TYPE_ACTIONS if attrs are added to text:user-defined
	ENTRY1( TABLE, TABLE_CELL, XML_ETACTION_PROC_ATTRS,
			OASIS_TABLE_VALUE_TYPE_ACTIONS), /* generated entry */
	ENTRY1( TABLE, COVERED_TABLE_CELL, XML_ETACTION_PROC_ATTRS,
			OASIS_TABLE_VALUE_TYPE_ACTIONS), /* generated entry */
	ENTRY1( TABLE, CHANGE_TRACK_TABLE_CELL, XML_ETACTION_PROC_ATTRS,
			OASIS_TABLE_VALUE_TYPE_ACTIONS), /* generated entry */
//	ENTRY1( FORM, PROPERTY, XML_ETACTION_PROC_ATTRS,
//			OASIS_VALUE_TYPE_ACTIONS), /* TODO: generated entry */
//	ENTRY1( FORM, LIST_PROPERTY, XML_ETACTION_PROC_ATTRS,
//			OASIS_VALUE_TYPE_ACTIONS), /* generated entry */

	ENTRY1( OFFICE, ANNOTATION, XML_ETACTION_MOVE_ELEMS_TO_ATTRS,
			OASIS_ANNOTATION_ACTIONS ), /* generated entry */
	ENTRY1( OFFICE, CHANGE_INFO, XML_ETACTION_MOVE_ELEMS_TO_ATTRS,
			OASIS_CHANGE_INFO_ACTIONS ), /* generated entry */

	ENTRY1( TEXT, DDE_CONNECTION_DECL, XML_ETACTION_PROC_ATTRS,
		 			OASIS_DDE_CONNECTION_DECL_ACTIONS  ),

	ENTRY0( FORM, TEXT, XML_ETACTION_FORM_CONTROL ),
	ENTRY0( FORM, TEXTAREA, XML_ETACTION_FORM_CONTROL ),
	ENTRY0( FORM, FIXED_TEXT, XML_ETACTION_FORM_CONTROL ),
	ENTRY0( FORM, FILE, XML_ETACTION_FORM_CONTROL ),
	ENTRY0( FORM, PASSWORD, XML_ETACTION_FORM_CONTROL ),
	ENTRY0( FORM, FORMATTED_TEXT, XML_ETACTION_FORM_CONTROL ),
	ENTRY0( FORM, BUTTON, XML_ETACTION_FORM_CONTROL ),
	ENTRY0( FORM, IMAGE, XML_ETACTION_FORM_CONTROL ),
	ENTRY0( FORM, CHECKBOX, XML_ETACTION_FORM_CONTROL ),
	ENTRY0( FORM, RADIO, XML_ETACTION_FORM_CONTROL ),
	ENTRY0( FORM, LISTBOX, XML_ETACTION_FORM_CONTROL ),
	ENTRY0( FORM, COMBOBOX, XML_ETACTION_FORM_CONTROL ),
	ENTRY0( FORM, FRAME, XML_ETACTION_FORM_CONTROL ),
	ENTRY0( FORM, HIDDEN, XML_ETACTION_FORM_CONTROL ),
	ENTRY0( FORM, IMAGE_FRAME, XML_ETACTION_FORM_CONTROL ),
	ENTRY0( FORM, GRID, XML_ETACTION_FORM_CONTROL ),
	ENTRY0( FORM, VALUE_RANGE, XML_ETACTION_FORM_CONTROL ),
	ENTRY0( FORM, GENERIC_CONTROL, XML_ETACTION_FORM_CONTROL ),
	ENTRY1( FORM, COLUMN, XML_ETACTION_PROC_ATTRS,
		 			OASIS_FORM_COLUMN_ACTIONS  ),
	ENTRY1( FORM, PROPERTY, XML_ETACTION_FORM_PROPERTY, XML_PROPERTY ),
	ENTRY1( FORM, LIST_PROPERTY, XML_ETACTION_FORM_PROPERTY,
					XML_LIST_PROPERTY ),
	ENTRY1( FORM, LIST_VALUE, XML_ETACTION_FORM_PROPERTY, XML_LIST_VALUE ),

	// process xlink:href
	ENTRY1( META, TEMPLATE, XML_ETACTION_PROC_ATTRS,
		OASIS_XLINK_ACTIONS ), /* generated entry */
	ENTRY1( META, AUTO_RELOAD, XML_ETACTION_PROC_ATTRS,
		OASIS_XLINK_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, SECTION_SOURCE, XML_ETACTION_PROC_ATTRS,
		OASIS_XLINK_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, SCRIPT, XML_ETACTION_PROC_ATTRS,
		OASIS_XLINK_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, ALPHABETICAL_INDEX_AUTO_MARK_FILE, XML_ETACTION_PROC_ATTRS,
		OASIS_XLINK_ACTIONS ), /* generated entry */
	ENTRY1( TABLE, TABLE_SOURCE, XML_ETACTION_PROC_ATTRS,
		OASIS_XLINK_ACTIONS ), /* generated entry */
	ENTRY1( TABLE, CELL_RANGE_SOURCE, XML_ETACTION_PROC_ATTRS,
		OASIS_XLINK_ACTIONS ), /* generated entry */
	ENTRY1( DRAW, A, XML_ETACTION_PROC_ATTRS,
		OASIS_XLINK_ACTIONS ), /* generated entry */
	ENTRY1( PRESENTATION, SOUND, XML_ETACTION_PROC_ATTRS,
		OASIS_XLINK_ACTIONS ), /* generated entry */
	ENTRY1( FORM, FORM, XML_ETACTION_PROC_ATTRS,
		OASIS_FORM_ACTIONS ), /* generated entry */
//	ENTRY1( SVG, FONT_FACE_URI, XML_ETACTION_PROC_ATTRS,
//		OASIS_XLINK_ACTIONS ), /* generated entry */
//	ENTRY1( SVG, DEFINITION_SRC, XML_ETACTION_PROC_ATTRS,
//		OASIS_XLINK_ACTIONS ), /* generated entry */
	ENTRY2QN( CHART, SYMBOL_IMAGE, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
              XML_NAMESPACE_STYLE, XML_SYMBOL_IMAGE,
              OASIS_BACKGROUND_IMAGE_ACTIONS ),
//		OASIS_XLINK_ACTIONS ), /* generated entry */
//  events don't have real URIs
//	ENTRY1( PRESENTATION, EVENT_LISTENER, XML_ETACTION_PROC_ATTRS,
//		OASIS_XLINK_ACTIONS ), /* generated entry */
//	ENTRY1( SCRIPT, EVENT_LISTENER, XML_ETACTION_PROC_ATTRS,
//		OASIS_XLINK_ACTIONS ), /* generated entry */

	// add namespace prefix to name
	ENTRY1( CONFIG, CONFIG_ITEM_SET, XML_ETACTION_PROC_ATTRS,
		OASIS_CONFIG_ITEM_SET_ACTIONS ),

	// add namespace prefix to formula and condition
	//  text:condition
	ENTRY1( TEXT, SECTION, XML_ETACTION_PROC_ATTRS,
		OASIS_FORMULA_ACTIONS ), /* generated entry */
	//  text:formula
	ENTRY1( TEXT, SEQUENCE, XML_ETACTION_PROC_ATTRS,
		OASIS_FORMULA_ACTIONS ), /* generated entry */
	//  text:condition
	ENTRY1( TEXT, DATABASE_NEXT, XML_ETACTION_PROC_ATTRS,
		OASIS_FORMULA_ACTIONS ), /* generated entry */
	//  text:condition
	ENTRY2QN( TEXT, DATABASE_ROW_SELECT, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
		XML_NAMESPACE_TEXT, XML_DATABASE_SELECT,
		OASIS_FORMULA_ACTIONS ), /* generated entry */
	//  text:condition
	ENTRY1( TEXT, CONDITIONAL_TEXT, XML_ETACTION_PROC_ATTRS,
		OASIS_FORMULA_ACTIONS ), /* generated entry */
	//  text:condition
	ENTRY1( TEXT, HIDDEN_TEXT, XML_ETACTION_PROC_ATTRS,
		OASIS_FORMULA_ACTIONS ), /* generated entry */
	//  text:condition
	ENTRY1( TEXT, HIDDEN_PARAGRAPH, XML_ETACTION_PROC_ATTRS,
		OASIS_FORMULA_ACTIONS ), /* generated entry */
	//  text:formula
	ENTRY1( TEXT, TABLE_FORMULA, XML_ETACTION_PROC_ATTRS,
		OASIS_FORMULA_ACTIONS ), /* generated entry */

    //  process table::content-validation
	ENTRY1( TABLE, CONTENT_VALIDATION, XML_ETACTION_PROC_ATTRS,
		OASIS_CONTENT_VALIDATION_ACTIONS ),

	// rename <table:dependencies> to <table:dependences>
	ENTRY1Q( TABLE, DEPENDENCIES, XML_ETACTION_RENAME_ELEM,
						XML_NAMESPACE_TABLE, XML_DEPENDENCES ),
    ENTRY1Q( TABLE, DEPENDENCY, XML_ETACTION_RENAME_ELEM,
                        XML_NAMESPACE_TABLE, XML_DEPENDENCE ),

    // process table::conversion-mode
	ENTRY1( TABLE, CONVERSION_MODE, XML_ETACTION_PROC_ATTRS,
			OASIS_DDE_CONV_MODE_ACTIONS ),

    // process table::data-pilot-member
	ENTRY1( TABLE, DATA_PILOT_MEMBER, XML_ETACTION_PROC_ATTRS,
			OASIS_DATAPILOT_MEMBER_ACTIONS ),

    // process table::data-pilot-level
	ENTRY1( TABLE, DATA_PILOT_LEVEL, XML_ETACTION_PROC_ATTRS,
			OASIS_DATAPILOT_LEVEL_ACTIONS ),

    // process table::source-service
	ENTRY1( TABLE, SOURCE_SERVICE, XML_ETACTION_PROC_ATTRS,
			OASIS_SOURCE_SERVICE_ACTIONS ),

    // entries for date time change (#i36576#)
    ENTRY1( TEXT, DATE, XML_ETACTION_PROC_ATTRS, OASIS_DATETIME_ACTIONS ),
    ENTRY1( TEXT, CREATION_DATE, XML_ETACTION_PROC_ATTRS,
					OASIS_DATETIME_ACTIONS ),
    ENTRY1( TEXT, TIME, XML_ETACTION_PROC_ATTRS, OASIS_DATETIME_ACTIONS ),
    ENTRY1( TEXT, CREATION_TIME, XML_ETACTION_PROC_ATTRS,
					OASIS_DATETIME_ACTIONS ),
    ENTRY1( TEXT, PRINT_TIME, XML_ETACTION_PROC_ATTRS, OASIS_DATETIME_ACTIONS ),
    ENTRY1( TEXT, MODIFICATION_TIME, XML_ETACTION_PROC_ATTRS,
					OASIS_DATETIME_ACTIONS ),
    ENTRY1( TEXT, EDITING_DURATION, XML_ETACTION_PROC_ATTRS,
					OASIS_DATETIME_ACTIONS ),
    ENTRY1( FORM, TIME, XML_ETACTION_PROC_ATTRS, OASIS_DATETIME_ACTIONS ),
    ENTRY1( PRESENTATION, SETTINGS, XML_ETACTION_PROC_ATTRS,
					OASIS_DATETIME_ACTIONS ),

    // fix <text:alphabatical-index-mark text:main-etry>
	ENTRY1( TEXT, ALPHABETICAL_INDEX_MARK, XML_ETACTION_PROC_ATTRS,
            OASIS_ALPHABETICAL_INDEX_MARK_ACTIONS ),
	ENTRY1( TEXT, ALPHABETICAL_INDEX_MARK_START, XML_ETACTION_PROC_ATTRS,
            OASIS_ALPHABETICAL_INDEX_MARK_ACTIONS ),

	// fix id strings in old animation elements
	ENTRY1( PRESENTATION, DIM, XML_ETACTION_PROC_ATTRS, OASIS_ANIMATION_ACTIONS ),
	ENTRY1( PRESENTATION, PLAY, XML_ETACTION_PROC_ATTRS, OASIS_ANIMATION_ACTIONS ),
	ENTRY1( PRESENTATION, SHOW_TEXT, XML_ETACTION_PROC_ATTRS, OASIS_ANIMATION_ACTIONS ),
	ENTRY1( PRESENTATION, SHOW_SHAPE, XML_ETACTION_PROC_ATTRS, OASIS_ANIMATION_ACTIONS ),
	ENTRY1( PRESENTATION, HIDE_TEXT, XML_ETACTION_PROC_ATTRS, OASIS_ANIMATION_ACTIONS ),
	ENTRY1( PRESENTATION, HIDE_SHAPE, XML_ETACTION_PROC_ATTRS, OASIS_ANIMATION_ACTIONS ),

	ENTRY0( OFFICE, TOKEN_INVALID, XML_ETACTION_EOT )
};

// XML_ETACTION_STYLE
static XMLTransformerActionInit aStyleActionTable[] =
{
	ENTRY0( STYLE, FAMILY, XML_ATACTION_STYLE_FAMILY ),
	ENTRY1( STYLE, NAME, XML_ATACTION_DECODE_STYLE_NAME,
		 		XML_FAMILY_TYPE_END ),
	ENTRY1( STYLE, DISPLAY_NAME, XML_ATACTION_STYLE_DISPLAY_NAME,
		 		XML_FAMILY_TYPE_END ),
	ENTRY1( STYLE, PARENT_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
		 		XML_FAMILY_TYPE_END ),
	ENTRY1( STYLE, NEXT_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
		 		XML_FAMILY_TYPE_END ),
	ENTRY1( STYLE, LIST_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
		 		XML_FAMILY_TYPE_LIST ),
	ENTRY1( STYLE, MASTER_PAGE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
		 		XML_FAMILY_TYPE_MASTER_PAGE ),
	ENTRY0( STYLE, DEFAULT_OUTLINE_LEVEL, XML_ATACTION_REMOVE ),
	ENTRY1( TEXT, STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
		 		XML_FAMILY_TYPE_TEXT ),	// list level styles
	ENTRY1( DRAW, NAME, XML_ATACTION_DECODE_STYLE_NAME,
		 		XML_FAMILY_TYPE_END ),
	ENTRY1( DRAW, DISPLAY_NAME, XML_ATACTION_STYLE_DISPLAY_NAME,
		 		XML_FAMILY_TYPE_END ),
	ENTRY0( DRAW, DISTANCE, XML_ATACTION_IN2INCH ),
	ENTRY0( DRAW, DOTS1_LENGTH, XML_ATACTION_IN2INCH ),
	ENTRY0( DRAW, DOTS2_LENGTH, XML_ATACTION_IN2INCH ),
	ENTRY0( SVG, WIDTH, XML_ATACTION_IN2INCH ),
	ENTRY0( SVG, HEIGHT, XML_ATACTION_IN2INCH ),
	ENTRY0( DRAW, START, XML_ATACTION_NEG_PERCENT ),
	ENTRY0( DRAW, END, XML_ATACTION_NEG_PERCENT ),
	ENTRY1( XLINK, HREF, XML_ATACTION_URI_OASIS, sal_True ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_FRAME_ELEM_ACTIONS
static XMLTransformerActionInit aFrameActionTable[] =
{
	ENTRY0( DRAW, TEXT_BOX, XML_ETACTION_COPY ),
	ENTRY0( DRAW, IMAGE, XML_ETACTION_COPY ),
	ENTRY0( DRAW, OBJECT, XML_ETACTION_COPY ),
	ENTRY0( DRAW, OBJECT_OLE, XML_ETACTION_COPY ),
	ENTRY0( DRAW, APPLET, XML_ETACTION_COPY ),
	ENTRY0( DRAW, PLUGIN, XML_ETACTION_COPY ),
	ENTRY0( DRAW, FLOATING_FRAME, XML_ETACTION_COPY ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_EVENT_ELEM_ACTIONS
static XMLTransformerActionInit aEventActionTable[] =
{
	ENTRY0( XLINK, HREF, XML_ATACTION_HREF ),
	ENTRY1( SCRIPT, LANGUAGE, XML_ATACTION_REMOVE_NAMESPACE_PREFIX,
					XML_NAMESPACE_OOO ),
	ENTRY0( SCRIPT, EVENT_NAME, XML_ATACTION_EVENT_NAME ),
	ENTRY0( SCRIPT, MACRO_NAME, XML_ATACTION_MACRO_NAME ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_EVENT_ELEM_ACTIONS
static XMLTransformerActionInit aDlgActionTable[] =
{
	ENTRY0( DLG, BORDER, XML_ATACTION_DLG_BORDER )
};

// action table for OASIS_MASTER_PAGE_ACTIONS
static XMLTransformerActionInit aMasterPageActionTable[] =
{
	ENTRY1( STYLE, NAME, XML_ATACTION_DECODE_STYLE_NAME,
		 		XML_FAMILY_TYPE_MASTER_PAGE ),
	ENTRY1( STYLE, DISPLAY_NAME, XML_ATACTION_STYLE_DISPLAY_NAME,
		 		XML_FAMILY_TYPE_MASTER_PAGE ),
	ENTRY1( STYLE, NEXT_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
		 		XML_FAMILY_TYPE_MASTER_PAGE ),
	ENTRY1Q( STYLE, PAGE_LAYOUT_NAME, XML_ATACTION_RENAME,
						XML_NAMESPACE_STYLE, XML_PAGE_MASTER_NAME ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// action table for OASIS_TEXT_STYLE_REF_ACTIONS
static XMLTransformerActionInit aTextStyleRefActionTable[] =
{
	ENTRY1( TEXT, STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
				XML_FAMILY_TYPE_TEXT ),
	ENTRY1( TEXT, VISITED_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
		  		XML_FAMILY_TYPE_TEXT ),
	ENTRY1( XLINK, HREF, XML_ATACTION_URI_OASIS, sal_False ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// action table for OASIS_PARA_STYLE_REF_ACTIONS
static XMLTransformerActionInit aParaStyleRefActionTable[] =
{
	ENTRY1( TEXT, STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
				XML_FAMILY_TYPE_PARAGRAPH ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};


// action table for OASIS_LIST_STYLE_REF_ACTIONS
static XMLTransformerActionInit aListStyleRefActionTable[] =
{
	ENTRY1( TEXT, STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
				XML_FAMILY_TYPE_LIST ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// action table for OASIS_MASTER_PAGE_REF_ACTIONS
static XMLTransformerActionInit aMasterPageRefActionTable[] =
{
	ENTRY1( DRAW, MASTER_PAGE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
				XML_FAMILY_TYPE_MASTER_PAGE ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// action table for OASIS_MAP_STYLE_REF_ACTIONS
static XMLTransformerActionInit aMapStyleRefActionTable[] =
{
	ENTRY1( STYLE, APPLY_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
				XML_FAMILY_TYPE_END ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// --> OD 2005-01-10 #i40011#, #i40015#
// action table for OASIS_TABLE_STYLE_REF_ACTIONS
static XMLTransformerActionInit aTableStyleRefActionTable[] =
{
    ENTRY1( TABLE, STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
                XML_FAMILY_TYPE_END ),
    ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};
// <--


static XMLTransformerActionInit aFontFaceActionTable[] =
{
	ENTRY1Q( SVG, FONT_FAMILY, XML_ATACTION_RENAME,
						XML_NAMESPACE_FO, XML_FONT_FAMILY ),
	ENTRY1Q( STYLE, FONT_ADORNMENTS, XML_ATACTION_RENAME,
						XML_NAMESPACE_STYLE, XML_FONT_STYLE_NAME ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// action table for OASIS_PARA_ACTIONS
static XMLTransformerActionInit aParaActionTable[] =
{
	ENTRY1( TEXT, STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
				XML_FAMILY_TYPE_PARAGRAPH ),
	ENTRY1( TEXT, COND_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
				XML_FAMILY_TYPE_PARAGRAPH ),
	ENTRY1Q( TEXT, OUTLINE_LEVEL, XML_ATACTION_RENAME,
						XML_NAMESPACE_TEXT, XML_LEVEL ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// !!ATTENTION!! If you change something here, please also change
// aConnectorActionTable if apropriate
static XMLTransformerActionInit aShapeActionTable[] =
{
	ENTRY1( DRAW, STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
				XML_FAMILY_TYPE_GRAPHIC ),
	ENTRY1( DRAW, TEXT_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
		 		XML_FAMILY_TYPE_PARAGRAPH ),
	ENTRY1( PRESENTATION, STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
		 		XML_FAMILY_TYPE_PRESENTATION ),
	ENTRY0( SVG, X, XML_ATACTION_IN2INCH ),
	ENTRY0( SVG, Y, XML_ATACTION_IN2INCH ),
	ENTRY0( SVG, X1, XML_ATACTION_IN2INCH ),
	ENTRY0( SVG, Y1, XML_ATACTION_IN2INCH ),
	ENTRY0( SVG, X2, XML_ATACTION_IN2INCH ),
	ENTRY0( SVG, Y2, XML_ATACTION_IN2INCH ),
	ENTRY0( SVG, CX, XML_ATACTION_IN2INCH ),
	ENTRY0( SVG, CY, XML_ATACTION_IN2INCH ),
	ENTRY0( DRAW, END_X, XML_ATACTION_IN2INCH ),
	ENTRY0( DRAW, END_Y, XML_ATACTION_IN2INCH ),
	ENTRY0( SVG, R, XML_ATACTION_IN2INCH ),
	ENTRY0( SVG, RX, XML_ATACTION_IN2INCH ),
	ENTRY0( SVG, RY, XML_ATACTION_IN2INCH ),
	ENTRY0( SVG, WIDTH, XML_ATACTION_SVG_WIDTH_HEIGHT_OASIS ),
	ENTRY0( SVG, HEIGHT, XML_ATACTION_SVG_WIDTH_HEIGHT_OASIS ),
	ENTRY0( FO, MIN_WIDTH, XML_ATACTION_IN2INCH ),
	ENTRY0( FO, MIN_HEIGHT, XML_ATACTION_IN2INCH ),
	ENTRY0( FO, MAX_WIDTH, XML_ATACTION_IN2INCH ),
	ENTRY0( FO, MAX_HEIGHT, XML_ATACTION_IN2INCH ),
	ENTRY0( DRAW, CORNER_RADIUS, XML_ATACTION_IN2INCH ),
	ENTRY0( DRAW, LINE_SKEW, XML_ATACTION_INS2INCHS ),
	ENTRY0( DRAW, CAPTION_POINT_X, XML_ATACTION_IN2INCH ),
	ENTRY0( DRAW, CAPTION_POINT_Y, XML_ATACTION_IN2INCH ),
	ENTRY0( DR3D, DISTANCE, XML_ATACTION_IN2INCH ),
	ENTRY0( DR3D, FOCAL_LENGTH, XML_ATACTION_IN2INCH ),
	ENTRY1Q( DRAW, CONTROL, XML_ATACTION_RENAME,
					XML_NAMESPACE_FORM, XML_ID ),
	ENTRY1( XLINK, HREF, XML_ATACTION_URI_OASIS, sal_True ),

    // BM: needed by chart:legend.  The legend needs also the draw actions.  As
    // there is no merge mechanism, all actions have to be in the same table
    ENTRY2( CHART, LEGEND_POSITION, XML_ATACTION_RENAME_ATTRIBUTE,
            RENAME_ENTRY( XML_START, XML_LEFT ),
            RENAME_ENTRY( XML_END, XML_RIGHT )),

	ENTRY0( DRAW, ID, XML_ATACTION_DECODE_ID ),

	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_ANIMATION_ACTIONS
static XMLTransformerActionInit aAnimationActionTable[] =
{
	ENTRY0( DRAW, SHAPE_ID, XML_ATACTION_DECODE_ID ),
    ENTRY0( PRESENTATION, DELAY,       XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( PRESENTATION, PAUSE,       XML_ATACTION_RNG2ISO_DATETIME ),

	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_CONNECTOR_ACTIONS
static XMLTransformerActionInit aConnectorActionTable[] =
{
	ENTRY1( DRAW, STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
				XML_FAMILY_TYPE_GRAPHIC ),
	ENTRY1( DRAW, TEXT_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
		 		XML_FAMILY_TYPE_PARAGRAPH ),
	ENTRY1( PRESENTATION, STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
		 		XML_FAMILY_TYPE_PRESENTATION ),
	ENTRY0( SVG, X1, XML_ATACTION_IN2TWIPS ),
	ENTRY0( SVG, Y1, XML_ATACTION_IN2TWIPS ),
	ENTRY0( SVG, X2, XML_ATACTION_IN2TWIPS ),
	ENTRY0( SVG, Y2, XML_ATACTION_IN2TWIPS ),
	ENTRY0( DRAW, END_X, XML_ATACTION_IN2INCH ),
	ENTRY0( DRAW, END_Y, XML_ATACTION_IN2INCH ),
	ENTRY0( SVG, WIDTH, XML_ATACTION_SVG_WIDTH_HEIGHT_OASIS ),
	ENTRY0( SVG, HEIGHT, XML_ATACTION_SVG_WIDTH_HEIGHT_OASIS ),
	ENTRY0( FO, MIN_WIDTH, XML_ATACTION_IN2INCH ),
	ENTRY0( FO, MIN_HEIGHT, XML_ATACTION_IN2INCH ),
	ENTRY0( FO, MAX_WIDTH, XML_ATACTION_IN2INCH ),
	ENTRY0( FO, MAX_HEIGHT, XML_ATACTION_IN2INCH ),
	ENTRY0( DRAW, LINE_SKEW, XML_ATACTION_INS2INCHS ),
	ENTRY1Q( DRAW, CONTROL, XML_ATACTION_RENAME,
					XML_NAMESPACE_FORM, XML_ID ),
	ENTRY1( XLINK, HREF, XML_ATACTION_URI_OASIS, sal_True ),
	ENTRY0( DRAW, START_SHAPE, XML_ATACTION_DECODE_ID ),
	ENTRY0( DRAW, END_SHAPE, XML_ATACTION_DECODE_ID ),

	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_INDEX_ENTRY_TAB_STOP_ACTIONS
static XMLTransformerActionInit aIndexEntryTabStopActionTable[] =
{
	ENTRY0( STYLE, POSITION, XML_ATACTION_IN2INCH ),
	ENTRY1( TEXT, STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
		  		XML_FAMILY_TYPE_TEXT ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_TAB_STOP_ACTIONS
static XMLTransformerActionInit aTabStopActionTable[] =
{
	ENTRY0( STYLE, POSITION, XML_ATACTION_IN2INCH ),
	ENTRY1Q( STYLE, LEADER_TEXT, XML_ATACTION_RENAME,
		  		XML_NAMESPACE_STYLE, XML_LEADER_CHAR ),
	ENTRY0( STYLE, LEADER_STYLE, XML_ATACTION_REMOVE ),
	ENTRY0( STYLE, LEADER_TYPE, XML_ATACTION_REMOVE ),
	ENTRY0( STYLE, LEADER_WIDTH, XML_ATACTION_REMOVE ),
	ENTRY0( STYLE, LEADER_COLOR, XML_ATACTION_REMOVE ),
	ENTRY0( STYLE, LEADER_TEXT_STYLE, XML_ATACTION_REMOVE ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_LINENUMBERING_ACTIONS
static XMLTransformerActionInit aLineNumberingActionTable[] =
{
	ENTRY0( TEXT, OFFSET, XML_ATACTION_IN2INCH ),
	ENTRY1( TEXT, STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
				XML_FAMILY_TYPE_TEXT ),
	ENTRY1Q( TEXT, COUNT_IN_TEXT_BOXES , XML_ATACTION_RENAME,
					XML_NAMESPACE_TEXT, XML_COUNT_IN_FLOATING_FRAMES),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

static XMLTransformerActionInit aFootnoteSepActionTable[] =
{
	ENTRY0( STYLE, WIDTH, XML_ATACTION_IN2INCH ),
	ENTRY0( STYLE, DISTANCE_BEFORE_SEP, XML_ATACTION_IN2INCH ),
	ENTRY0( STYLE, DISTANCE_AFTER_SEP, XML_ATACTION_IN2INCH ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_NOTES_ACTIONS (processed by special context)
static XMLTransformerActionInit aNotesActionTable[] =
{
	ENTRY0( TEXT, NOTE_CLASS, XML_ATACTION_STYLE_FAMILY ),
	ENTRY1( TEXT, CITATION_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
				XML_FAMILY_TYPE_TEXT ),
	ENTRY1( TEXT, CITATION_BODY_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
				XML_FAMILY_TYPE_TEXT ),
	ENTRY1( TEXT, DEFAULT_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
				XML_FAMILY_TYPE_PARAGRAPH ),
	ENTRY1( TEXT, MASTER_PAGE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
				XML_FAMILY_TYPE_MASTER_PAGE ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_DROP_CAP_ACTIONS
static XMLTransformerActionInit aDropCapActionTable[] =
{
	ENTRY0( STYLE, DISTANCE, XML_ATACTION_IN2INCH ),
	ENTRY1( STYLE, STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
				XML_FAMILY_TYPE_TEXT ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

static XMLTransformerActionInit aColumnsActionTable[] =
{
	ENTRY0( STYLE, COLUMN_GAP, XML_ATACTION_IN2INCH ),
	ENTRY0( STYLE, SPACE_BEFORE, XML_ATACTION_REMOVE ),
	ENTRY0( STYLE, SPACE_AFTER, XML_ATACTION_REMOVE ),
	ENTRY1Q( FO, START_INDENT, XML_ATACTION_RENAME_IN2INCH,
		   XML_NAMESPACE_FO, XML_MARGIN_LEFT ),
	ENTRY1Q( FO, END_INDENT, XML_ATACTION_RENAME_IN2INCH,
		   XML_NAMESPACE_FO, XML_MARGIN_RIGHT ),
	ENTRY0( STYLE, WIDTH, XML_ATACTION_IN2INCH ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_TEXT_VALUE_TYPE_ACTIONS
static XMLTransformerActionInit aTextValueTypeActionTable[] =
{
	ENTRY1Q( OFFICE, VALUE_TYPE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_TEXT, XML_VALUE_TYPE ),
	ENTRY1Q( OFFICE, VALUE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_TEXT, XML_VALUE ),
	ENTRY1Q( OFFICE, CURRENCY, XML_ATACTION_RENAME,
		   XML_NAMESPACE_TEXT, XML_CURRENCY ),
	ENTRY1Q( OFFICE, DATE_VALUE, XML_ATACTION_RENAME_RNG2ISO_DATETIME,
		   XML_NAMESPACE_TEXT, XML_DATE_VALUE ),
	ENTRY1Q( OFFICE, TIME_VALUE, XML_ATACTION_RENAME_RNG2ISO_DATETIME,
		   XML_NAMESPACE_TEXT, XML_TIME_VALUE ),
	ENTRY1Q( OFFICE, BOOLEAN_VALUE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_TEXT, XML_BOOLEAN_VALUE ),
	ENTRY1Q( OFFICE, STRING_VALUE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_TEXT, XML_STRING_VALUE ),
	ENTRY0( TEXT, FORMULA, XML_ATACTION_REMOVE_ANY_NAMESPACE_PREFIX ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_TABLE_VALUE_TYPE_ACTIONS
static XMLTransformerActionInit aTableValueTypeActionTable[] =
{
	ENTRY1Q( OFFICE, VALUE_TYPE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_TABLE, XML_VALUE_TYPE ),
	ENTRY1Q( OFFICE, VALUE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_TABLE, XML_VALUE ),
	ENTRY1Q( OFFICE, CURRENCY, XML_ATACTION_RENAME,
		   XML_NAMESPACE_TABLE, XML_CURRENCY ),
	ENTRY1Q( OFFICE, DATE_VALUE, XML_ATACTION_RENAME_RNG2ISO_DATETIME,
		   XML_NAMESPACE_TABLE, XML_DATE_VALUE ),
	ENTRY1Q( OFFICE, TIME_VALUE, XML_ATACTION_RENAME_RNG2ISO_DATETIME,
		   XML_NAMESPACE_TABLE, XML_TIME_VALUE ),
	ENTRY1Q( OFFICE, BOOLEAN_VALUE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_TABLE, XML_BOOLEAN_VALUE ),
	ENTRY1Q( OFFICE, STRING_VALUE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_TABLE, XML_STRING_VALUE ),
	ENTRY1( TABLE, STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
				XML_FAMILY_TYPE_TABLE_CELL ),
	ENTRY0( TABLE, FORMULA, XML_ATACTION_REMOVE_ANY_NAMESPACE_PREFIX ),
	ENTRY1Q( TABLE, CONTENT_VALIDATION_NAME, XML_ATACTION_RENAME,
		   XML_NAMESPACE_TABLE, XML_VALIDATION_NAME ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// action table for OASIS_ANNOTATION_ACTIONS
static XMLTransformerActionInit aAnnotationActionTable[] =
{
	ENTRY1Q( DC, CREATOR, XML_ATACTION_MOVE_FROM_ELEM,
				XML_NAMESPACE_OFFICE, XML_AUTHOR ),
	ENTRY1Q( DC, DATE, XML_ATACTION_MOVE_FROM_ELEM_RNG2ISO_DATETIME,
				XML_NAMESPACE_OFFICE, XML_CREATE_DATE ),
	ENTRY1Q( META, DATE_STRING, XML_ATACTION_MOVE_FROM_ELEM,
				XML_NAMESPACE_OFFICE, XML_CREATE_DATE_STRING ),
    ENTRY0( TEXT, P, XML_ETACTION_EXTRACT_CHARACTERS ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// action table for OASIS_CHANGE_INFO_ACTIONS
static XMLTransformerActionInit aChangeInfoActionTable[] =
{
	ENTRY1Q( DC, CREATOR, XML_ATACTION_MOVE_FROM_ELEM,
				XML_NAMESPACE_OFFICE, XML_CHG_AUTHOR ),
	ENTRY1Q( DC, DATE, XML_ATACTION_MOVE_FROM_ELEM_RNG2ISO_DATETIME,
				XML_NAMESPACE_OFFICE, XML_CHG_DATE_TIME ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_BACKGROUND_IMAGE_ACTIONS
static XMLTransformerActionInit aBackgroundImageActionTable[] =
{
	ENTRY1Q( DRAW, OPACITY, XML_ATACTION_RENAME_NEG_PERCENT,
		 			XML_NAMESPACE_DRAW, XML_TRANSPARENCY ),
	ENTRY1( XLINK, HREF, XML_ATACTION_URI_OASIS, sal_True ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_DDE_CONNECTION_DECL
static XMLTransformerActionInit aDDEConnectionDeclActionTable[] =
{
	ENTRY1Q( OFFICE, NAME, XML_ATACTION_RENAME,
		 			XML_NAMESPACE_TEXT, XML_NAME ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};


// OASIS_FORM_CONTROL_ACTIONS
static XMLTransformerActionInit aFormControlActionTable[] =
{
	ENTRY0( FORM, NAME, XML_ATACTION_MOVE_TO_ELEM ),
	ENTRY2QN( FORM, CONTROL_IMPLEMENTATION,
					XML_ATACTION_RENAME_REMOVE_NAMESPACE_PREFIX,
		   			XML_NAMESPACE_FORM, XML_SERVICE_NAME,
					XML_NAMESPACE_OOO ),
	ENTRY0( FORM, ID, XML_ATACTION_MOVE_TO_ELEM ),
	ENTRY1( XLINK, HREF, XML_ATACTION_URI_OASIS, sal_False ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_FORM_COLUMN_ACTIONS
static XMLTransformerActionInit aFormColumnActionTable[] =
{
	ENTRY1Q( FORM, TEXT_STYLE_NAME, XML_ATACTION_RENAME_DECODE_STYLE_NAME_REF,
						XML_NAMESPACE_FORM, XML_COLUMN_STYLE_NAME ),
	ENTRY2QN( FORM, CONTROL_IMPLEMENTATION,
					XML_ATACTION_RENAME_REMOVE_NAMESPACE_PREFIX,
		   			XML_NAMESPACE_FORM, XML_SERVICE_NAME,
					XML_NAMESPACE_OOO ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_FORM_PROP_ACTIONS
static XMLTransformerActionInit aFormPropActionTable[] =
{
	ENTRY1Q( OFFICE, VALUE_TYPE, XML_ATACTION_RENAME,
		  				XML_NAMESPACE_FORM, XML_PROPERTY_TYPE ),
	ENTRY0( OFFICE, VALUE, XML_ATACTION_REMOVE ),
	ENTRY0( OFFICE, STRING_VALUE, XML_ATACTION_REMOVE ),
	ENTRY0( OFFICE, BOOLEAN_VALUE, XML_ATACTION_REMOVE ),
	ENTRY0( OFFICE, DATE_VALUE, XML_ATACTION_REMOVE ),
	ENTRY0( OFFICE, TIME_VALUE, XML_ATACTION_REMOVE ),
	ENTRY0( OFFICE, CURRENCY, XML_ATACTION_REMOVE ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_XLINK_ACTIONS
static XMLTransformerActionInit aXLinkActionTable[] =
{
	ENTRY1( XLINK, HREF, XML_ATACTION_URI_OASIS, sal_False ),
    ENTRY0( TABLE, REFRESH_DELAY, XML_ATACTION_RNG2ISO_DATETIME ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_CONFIG_ITEM_SET_ACTIONS
static XMLTransformerActionInit aConfigItemSetActionTable[] =
{
	ENTRY1( CONFIG, NAME, XML_ATACTION_REMOVE_NAMESPACE_PREFIX,
					XML_NAMESPACE_OOO ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_FORMULA_ACTIONS
static XMLTransformerActionInit aFormulaActionTable[] =
{
	ENTRY0( TEXT, CONDITION, XML_ATACTION_REMOVE_ANY_NAMESPACE_PREFIX ),
	ENTRY0( TEXT, FORMULA, XML_ATACTION_REMOVE_ANY_NAMESPACE_PREFIX ),
	ENTRY0( TABLE, CONDITION, XML_ATACTION_REMOVE_ANY_NAMESPACE_PREFIX ),
	ENTRY0( TABLE, FORMULA, XML_ATACTION_REMOVE_ANY_NAMESPACE_PREFIX ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_CONTENT_VALIDATION_ACTIONS
static XMLTransformerActionInit aContentValidationActionTable[] =
{
	ENTRY0( TABLE, CONDITION, XML_ATACTION_REMOVE_ANY_NAMESPACE_PREFIX ),
    ENTRY0( TABLE, DISPLAY_LIST, XML_ATACTION_REMOVE ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_DDE_CONV_MODE_ACTIONS
static XMLTransformerActionInit aDDEConvModeActionTable[] =
{
	ENTRY1Q( TABLE, KEEP_TEXT, XML_ATACTION_RENAME,
						XML_NAMESPACE_TABLE, XML_LET_TEXT ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_DATAPILOT_MEMBER_ACTIONS
static XMLTransformerActionInit aDataPilotMemberActionTable[] =
{
	ENTRY1Q( TABLE, SHOW_DETAILS, XML_ATACTION_RENAME,
						XML_NAMESPACE_TABLE, XML_DISPLAY_DETAILS ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_DATAPILOT_LEVEL_ACTIONS
static XMLTransformerActionInit aDataPilotLevelActionTable[] =
{
	ENTRY1Q( TABLE, SHOW_EMPTY, XML_ATACTION_RENAME,
						XML_NAMESPACE_TABLE, XML_DISPLAY_EMPTY ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_SOURCE_SERVICE_ACTIONS
static XMLTransformerActionInit aSourceServiceActionTable[] =
{
	ENTRY1Q( TABLE, USER_NAME, XML_ATACTION_RENAME,
						XML_NAMESPACE_TABLE, XML_USERNAME ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_CHART_ACTIONS
static XMLTransformerActionInit aChartActionTable[] =
{
	ENTRY0( CHART, CLASS, XML_ATACTION_REMOVE_ANY_NAMESPACE_PREFIX ),
	ENTRY1( DRAW, STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
				XML_FAMILY_TYPE_GRAPHIC ),
	ENTRY0( SVG, WIDTH, XML_ATACTION_IN2INCH ),
	ENTRY0( SVG, HEIGHT, XML_ATACTION_IN2INCH ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_FORM_ACTIONS
static XMLTransformerActionInit aFormActionTable[] =
{
	ENTRY2QN( FORM, CONTROL_IMPLEMENTATION,
					XML_ATACTION_RENAME_REMOVE_NAMESPACE_PREFIX,
		   			XML_NAMESPACE_FORM, XML_SERVICE_NAME,
					XML_NAMESPACE_OOO ),
	ENTRY1( XLINK, HREF, XML_ATACTION_URI_OASIS, sal_False ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_ALPHABETICAL_INDEX_MARK_ACTIONS
static XMLTransformerActionInit aAlphabeticalIndexMarkActionTable[] =
{
	ENTRY1Q( TEXT, MAIN_ENTRY, XML_ATACTION_RENAME,
						XML_NAMESPACE_TEXT, XML_MAIN_ETRY ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_DRAW_AREA_POLYGON_ACTIONS (to be added to OASIS_SHAPE_ACTIONS)
static XMLTransformerActionInit aDrawAreaPolygonActionTable[] =
{
	ENTRY1Q( DRAW, POINTS, XML_ATACTION_RENAME,
             XML_NAMESPACE_SVG, XML_POINTS ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_SCRIPT_ACTIONS
static XMLTransformerActionInit aScriptActionTable[] =
{
    ENTRY1( SCRIPT, LANGUAGE, XML_ATACTION_REMOVE_NAMESPACE_PREFIX, XML_NAMESPACE_OOO ),
    ENTRY1Q( OOO, NAME, XML_ATACTION_RENAME, XML_NAMESPACE_SCRIPT, XML_NAME ),
    ENTRY1Q( OOO, READONLY, XML_ATACTION_RENAME, XML_NAMESPACE_SCRIPT, XML_READONLY ),
    ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_DATETIME_ACTIONS
static XMLTransformerActionInit aDateTimeActionTable[] =
{
	ENTRY0( TEXT,   DATE_VALUE,        XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( TEXT,   TIME_VALUE,        XML_ATACTION_RNG2ISO_DATETIME ),
	ENTRY0( TEXT,   DATE_ADJUST,       XML_ATACTION_RNG2ISO_DATETIME ),
	ENTRY0( TEXT,   TIME_ADJUST,       XML_ATACTION_RNG2ISO_DATETIME ),
	ENTRY0( TEXT,   DURATION,          XML_ATACTION_RNG2ISO_DATETIME ),
	ENTRY0( OFFICE, DATE_VALUE,        XML_ATACTION_RNG2ISO_DATETIME ),
	ENTRY0( OFFICE, TIME_VALUE,        XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( FORM,   VALUE,             XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( FORM,   CURRENT_VALUE,     XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( TABLE,  DATE_START,        XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( TABLE,  DATE_END,          XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( TABLE,  REFRESH_DELAY,     XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( PRESENTATION, DELAY,       XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( PRESENTATION, PAUSE,       XML_ATACTION_RNG2ISO_DATETIME ),
	ENTRY0( OFFICE, TOKEN_INVALID,     XML_ATACTION_EOT )
};

static XMLTokenEnum aTokenMap[] =
{
	XML_NONE, XML_SOLID, XML_DOTTED, XML_DASH, XML_LONG_DASH, XML_DOT_DASH,
	XML_DOT_DOT_DASH, XML_WAVE, XML_SMALL_WAVE, XML_TOKEN_END
};

// -----------------------------------------------------------------------------

class XMLTableTransformerContext_Impl : public XMLTransformerContext
{
	::rtl::OUString m_aElemQName;

public:
	TYPEINFO();

	XMLTableTransformerContext_Impl( XMLTransformerBase& rTransformer,
						   const ::rtl::OUString& rQName );

	virtual ~XMLTableTransformerContext_Impl();

	virtual void StartElement( const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttrList );
	virtual void EndElement();
};

TYPEINIT1( XMLTableTransformerContext_Impl, XMLTransformerContext );

XMLTableTransformerContext_Impl::XMLTableTransformerContext_Impl(
		XMLTransformerBase& rImp,
	    const OUString& rQName ) :
	XMLTransformerContext( rImp, rQName ),
	m_aElemQName( rQName )
{
}

XMLTableTransformerContext_Impl::~XMLTableTransformerContext_Impl()
{
}

void XMLTableTransformerContext_Impl::StartElement(
		const Reference< XAttributeList >& rAttrList )
{
	Reference< XAttributeList > xAttrList( rAttrList );

    XMLMutableAttributeList *pMutableAttrList = 0;
    // <--

    sal_Int16 nAttrCount = xAttrList.is() ? xAttrList->getLength() : 0;
	for( sal_Int16 i=0; i < nAttrCount; i++ )
	{
		const OUString& rAttrName = xAttrList->getNameByIndex( i );
		OUString aLocalName;
		sal_uInt16 nPrefix =
			GetTransformer().GetNamespaceMap().GetKeyByAttrName( rAttrName,
																 &aLocalName );
        if( XML_NAMESPACE_TABLE == nPrefix )
        {
            if ( IsXMLToken( aLocalName, XML_IS_SUB_TABLE ) )
            {
                const OUString& rValue = xAttrList->getValueByIndex( i );
                if( IsXMLToken( rValue, XML_TRUE ) )
                {
                    m_aElemQName = GetTransformer().GetNamespaceMap().GetQNameByKey(
                                XML_NAMESPACE_TABLE,
                                ::xmloff::token::GetXMLToken( XML_SUB_TABLE ) );
                    if ( !pMutableAttrList )
                    {
                        pMutableAttrList =
                            new XMLMutableAttributeList( xAttrList );
                        xAttrList = pMutableAttrList;
                    }
                    pMutableAttrList->RemoveAttributeByIndex( i );
                }
                // OD 2005-07-05 #i50521# - no break here for savety reason.
            }
            // --> OD 2005-01-10 #i40011#, #i40015#
            // - convert attribute table:style-name for <table:table>
            else if ( IsXMLToken( aLocalName, XML_STYLE_NAME ) )
            {
                const OUString& rValue = xAttrList->getValueByIndex( i );
                OUString aAttrValue( rValue );
                if( GetTransformer().DecodeStyleName(aAttrValue) )
                {
                    if ( !pMutableAttrList )
                    {
                        pMutableAttrList =
                            new XMLMutableAttributeList( xAttrList );
                        xAttrList = pMutableAttrList;
                    }
                    pMutableAttrList->SetValueByIndex( i, aAttrValue );
                }
            }
            // <--
            else if( IsXMLToken( aLocalName, XML_PRINT ) )
            {
                if ( !pMutableAttrList )
                {
                    pMutableAttrList =
                        new XMLMutableAttributeList( xAttrList );
                    xAttrList = pMutableAttrList;
                }
    			pMutableAttrList->RemoveAttributeByIndex( i );
            }
        }
	}

	GetTransformer().GetDocHandler()->startElement( m_aElemQName, xAttrList );
}

void XMLTableTransformerContext_Impl::EndElement()
{
	GetTransformer().GetDocHandler()->endElement( m_aElemQName );
}

// -----------------------------------------------------------------------------

class XMLBodyOASISTransformerContext_Impl : public XMLTransformerContext
{
	sal_Bool m_bFirstChild;

public:
	TYPEINFO();

	XMLBodyOASISTransformerContext_Impl( XMLTransformerBase& rTransformer,
						   const ::rtl::OUString& rQName );

	virtual ~XMLBodyOASISTransformerContext_Impl();

	virtual void StartElement( const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttrList );

	virtual XMLTransformerContext *CreateChildContext( sal_uInt16 nPrefix,
								   const ::rtl::OUString& rLocalName,
								   const ::rtl::OUString& rQName,
								   const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttrList );
	virtual void EndElement();
};

TYPEINIT1( XMLBodyOASISTransformerContext_Impl, XMLTransformerContext );

XMLBodyOASISTransformerContext_Impl::XMLBodyOASISTransformerContext_Impl(
		XMLTransformerBase& rImp,
	    const OUString& rQName ) :
	XMLTransformerContext( rImp, rQName ),
	m_bFirstChild( sal_False )
{
}

XMLBodyOASISTransformerContext_Impl::~XMLBodyOASISTransformerContext_Impl()
{
}

void XMLBodyOASISTransformerContext_Impl::StartElement(
		const Reference< XAttributeList >& )
{
}

XMLTransformerContext* XMLBodyOASISTransformerContext_Impl::CreateChildContext( sal_uInt16 nPrefix,
								   const ::rtl::OUString& rLocalName,
								   const ::rtl::OUString& rQName,
								   const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttrList )
{
    if (!m_bFirstChild)
    {
        m_bFirstChild = sal_True;
        XMLTransformerContext::StartElement(xAttrList);
    }

    return XMLTransformerContext::CreateChildContext(nPrefix, rLocalName, rQName, xAttrList);
}

void XMLBodyOASISTransformerContext_Impl::EndElement()
{
    if (!m_bFirstChild)
        XMLTransformerContext::StartElement(Reference< XAttributeList >());

    XMLTransformerContext::EndElement();
}

//-----------------------------------------------------------------------------

class XMLTabStopOASISTContext_Impl : public XMLPersElemContentTContext
{
public:
	TYPEINFO();

	XMLTabStopOASISTContext_Impl( XMLTransformerBase& rTransformer,
						   const ::rtl::OUString& rQName );

	virtual ~XMLTabStopOASISTContext_Impl();

	virtual void StartElement( const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttrList );
};

TYPEINIT1( XMLTabStopOASISTContext_Impl, XMLPersElemContentTContext );

XMLTabStopOASISTContext_Impl::XMLTabStopOASISTContext_Impl(
		XMLTransformerBase& rImp,
		const OUString& rQName ) :
	XMLPersElemContentTContext( rImp, rQName )
{
}

XMLTabStopOASISTContext_Impl::~XMLTabStopOASISTContext_Impl()
{
}

void XMLTabStopOASISTContext_Impl::StartElement(
		const Reference< XAttributeList >& rAttrList )
{
	XMLTransformerActions *pActions =
		GetTransformer().GetUserDefinedActions( OASIS_TAB_STOP_ACTIONS  );
	OSL_ENSURE( pActions, "go no actions" );

	sal_Unicode cStyleLeaderChar = 0;
	sal_Int16 nLeaderText = -1;
	Reference< XAttributeList > xAttrList( rAttrList );
	XMLMutableAttributeList *pMutableAttrList = 0;
	sal_Int16 nAttrCount = xAttrList.is() ? xAttrList->getLength() : 0;
	for( sal_Int16 i=0; i < nAttrCount; i++ )
	{
		const OUString& rAttrName = xAttrList->getNameByIndex( i );
		OUString aLocalName;
		sal_uInt16 nPrefix =
			GetTransformer().GetNamespaceMap().GetKeyByAttrName( rAttrName,
																 &aLocalName );
		XMLTransformerActions::key_type aKey( nPrefix, aLocalName );
		XMLTransformerActions::const_iterator aIter =
			pActions->find( aKey );
		if( !(aIter == pActions->end() ) )
		{
			if( !pMutableAttrList )
			{
				pMutableAttrList =
					new XMLMutableAttributeList( xAttrList );
				xAttrList = pMutableAttrList;
			}
			const OUString& rAttrValue = xAttrList->getValueByIndex( i );
			switch( (*aIter).second.m_nActionType )
			{
			case XML_ATACTION_REMOVE:
				if( IsXMLToken( aLocalName, XML_LEADER_STYLE ) )
				{
					if( IsXMLToken( rAttrValue, XML_NONE ) )
						cStyleLeaderChar = ' ';
					else if( IsXMLToken( rAttrValue, XML_DOTTED ) )
						cStyleLeaderChar = '.';
					else
						cStyleLeaderChar = 0;
					pMutableAttrList->RemoveAttributeByIndex( i );
					--i;
					--nAttrCount;
				}
				break;
			case XML_ATACTION_RENAME:
				{
					OUString aNewAttrQName(
						GetTransformer().GetNamespaceMap().GetQNameByKey(
							(*aIter).second.GetQNamePrefixFromParam1(),
							::xmloff::token::GetXMLToken(
							(*aIter).second.GetQNameTokenFromParam1()) ) );
					pMutableAttrList->RenameAttributeByIndex( i,
															  aNewAttrQName );
				}
				if( IsXMLToken( aLocalName, XML_LEADER_TEXT ) )
				{
					if( rAttrValue.getLength() > 1 )
					{
						OUString aAttrValue( rAttrValue.copy( 0, 1 ) );
						pMutableAttrList->SetValueByIndex( i, aAttrValue );
						nLeaderText = i;
					}
				}
				break;
			case XML_ATACTION_IN2INCH:
				{
					OUString aAttrValue( rAttrValue );
					if( XMLTransformerBase::ReplaceSingleInWithInch(
								aAttrValue ) )
						pMutableAttrList->SetValueByIndex( i, aAttrValue );
				}
				break;
			default:
				OSL_ENSURE( !this, "unknown action" );
				break;
			}
		}
	}

	if( cStyleLeaderChar && ' ' != cStyleLeaderChar )
	{
		if( nLeaderText != -1 )
		{
			OUString aNewAttrQName(
				GetTransformer().GetNamespaceMap().GetQNameByKey(
							XML_NAMESPACE_STYLE,
							::xmloff::token::GetXMLToken( XML_LEADER_CHAR ) ) );
			pMutableAttrList->AddAttribute( aNewAttrQName,
									OUString::valueOf( cStyleLeaderChar ) );
		}
	}
	else
	{
		if( nLeaderText != -1 )
			pMutableAttrList->RemoveAttributeByIndex( nLeaderText );
	}

	XMLPersElemContentTContext::StartElement( xAttrList );
}

// -----------------------------------------------------------------------------

class XMLConfigItemTContext_Impl : public XMLTransformerContext
{
	::rtl::OUString m_aContent;
	sal_Bool m_bIsRedlineProtectionKey;
    sal_Bool m_bIsCursorX;
    sal_Bool m_bIsCursorY;

public:

	TYPEINFO();

	XMLConfigItemTContext_Impl( XMLTransformerBase& rTransformer,
						   const ::rtl::OUString& rQName );

	virtual ~XMLConfigItemTContext_Impl();

	virtual void StartElement( const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttrList );
	virtual void EndElement();

	virtual void Characters( const ::rtl::OUString& rChars );
};

TYPEINIT1( XMLConfigItemTContext_Impl, XMLTransformerContext );

XMLConfigItemTContext_Impl::XMLConfigItemTContext_Impl(
		XMLTransformerBase& rImp,
	    const OUString& rQName ) :
	XMLTransformerContext( rImp, rQName ),
	m_bIsRedlineProtectionKey( sal_False ),
    m_bIsCursorX( sal_False ),
    m_bIsCursorY( sal_False )
{
}

XMLConfigItemTContext_Impl::~XMLConfigItemTContext_Impl()
{
}

void XMLConfigItemTContext_Impl::StartElement(
		const Reference< XAttributeList >& rAttrList )
{
	Reference< XAttributeList > xAttrList( rAttrList );

	sal_Int16 nAttrCount = xAttrList.is() ? xAttrList->getLength() : 0;
	for( sal_Int16 i=0; i < nAttrCount; i++ )
	{
		const OUString& rAttrName = xAttrList->getNameByIndex( i );
		OUString aLocalName;
		sal_uInt16 nPrefix =
			GetTransformer().GetNamespaceMap().GetKeyByAttrName( rAttrName,
																 &aLocalName );
		if( XML_NAMESPACE_CONFIG == nPrefix )
        {
			if ( IsXMLToken( aLocalName, XML_NAME ) )
		    {
			    const OUString& rValue = xAttrList->getValueByIndex( i );
			    const sal_Char sRedlineProtectionKey[] = "RedlineProtectionKey";
                const sal_Char sCursorX[] = "CursorPositionX";
                const sal_Char sCursorY[] = "CursorPositionY";
			    if( rValue.equalsAsciiL( sRedlineProtectionKey, sizeof(sRedlineProtectionKey)-1 ) )
				    m_bIsRedlineProtectionKey = sal_True;
                else if( rValue.equalsAsciiL( sCursorX, sizeof(sCursorX)-1 ) )
                    m_bIsCursorX = sal_True;
                else if( rValue.equalsAsciiL( sCursorY, sizeof(sCursorY)-1 ) )
                    m_bIsCursorY = sal_True;

			    break;
		    }
        }
	}

	XMLTransformerContext::StartElement( xAttrList );
}

void XMLConfigItemTContext_Impl::Characters( const ::rtl::OUString& rChars )
{
    rtl::OUString sChars(rChars);
    if (m_bIsRedlineProtectionKey)
	    m_aContent += rChars;
    else if (m_bIsCursorX || m_bIsCursorY)
    {
        sal_Int32 nPos = rChars.toInt32();
        if (m_bIsCursorX && nPos > 255)
            nPos = 255;
        else if (m_bIsCursorY && nPos > 31999)
            nPos = 31999;

        sChars = ::rtl::OUString::valueOf(nPos);
    }

	XMLTransformerContext::Characters( sChars );
}

void XMLConfigItemTContext_Impl::EndElement()
{

	if( m_bIsRedlineProtectionKey )
	{
		const Reference< XPropertySet > rPropSet =
			GetTransformer().GetPropertySet();
		if( rPropSet.is() )
		{
			const sal_Char sRedlineProtectionKey[] = "RedlineProtectionKey";
			OUString aPropName(RTL_CONSTASCII_USTRINGPARAM(sRedlineProtectionKey));
			Reference< XPropertySetInfo > xPropSetInfo(
						rPropSet->getPropertySetInfo() );
			if( xPropSetInfo.is() &&
				xPropSetInfo->hasPropertyByName( aPropName ) )
			{
				Sequence < sal_Int8 > aKey;
				SvXMLUnitConverter::decodeBase64( aKey, m_aContent );
				rPropSet->setPropertyValue( aPropName, makeAny( aKey ) );
			}
		}
	}
	XMLTransformerContext::EndElement();
}

// -----------------------------------------------------------------------------

class XMLTrackedChangesOASISTContext_Impl : public XMLTransformerContext
{
	::rtl::OUString m_aAttrQName;

public:

	TYPEINFO();

	XMLTrackedChangesOASISTContext_Impl( XMLTransformerBase& rTransformer,
						   const ::rtl::OUString& rQName,
		   					sal_uInt16 nPrefix,
							XMLTokenEnum eToken	);

	virtual ~XMLTrackedChangesOASISTContext_Impl();

	virtual void StartElement( const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttrList );
};

TYPEINIT1( XMLTrackedChangesOASISTContext_Impl, XMLTransformerContext );

XMLTrackedChangesOASISTContext_Impl::XMLTrackedChangesOASISTContext_Impl(
		XMLTransformerBase& rImp,
	    const OUString& rQName,
		sal_uInt16 nPrefix,
		XMLTokenEnum eToken	) :
	XMLTransformerContext( rImp, rQName ),
	m_aAttrQName( rImp.GetNamespaceMap().GetQNameByKey( nPrefix,
														GetXMLToken(eToken)) )
{
}

XMLTrackedChangesOASISTContext_Impl::~XMLTrackedChangesOASISTContext_Impl()
{
}

void XMLTrackedChangesOASISTContext_Impl::StartElement(
		const Reference< XAttributeList >& rAttrList )
{
	Reference< XAttributeList > xAttrList( rAttrList );
	const Reference< XPropertySet > rPropSet =
		GetTransformer().GetPropertySet();
	if( rPropSet.is() )
	{
		const sal_Char sRedlineProtectionKey[] = "RedlineProtectionKey";
		OUString aPropName(RTL_CONSTASCII_USTRINGPARAM(sRedlineProtectionKey));
		Reference< XPropertySetInfo > xPropSetInfo(
					rPropSet->getPropertySetInfo() );
		if( xPropSetInfo.is() &&
			xPropSetInfo->hasPropertyByName( aPropName ) )
		{
			Any aAny = rPropSet->getPropertyValue( aPropName);
			Sequence < sal_Int8 > aKey;
			aAny >>= aKey;
			if( aKey.getLength() )
			{
				OUStringBuffer aBuffer;
				SvXMLUnitConverter::encodeBase64( aBuffer, aKey );
				XMLMutableAttributeList *pMutableAttrList =
					new XMLMutableAttributeList( xAttrList );
				xAttrList = pMutableAttrList;
				pMutableAttrList->AddAttribute( m_aAttrQName,
												aBuffer.makeStringAndClear() );
			}
		}
	}
	XMLTransformerContext::StartElement( xAttrList );
}

// -----------------------------------------------------------------------------

XMLTransformerContext *Oasis2OOoTransformer::CreateUserDefinedContext(
							  const TransformerAction_Impl& rAction,
							  const OUString& rQName,
	   						  sal_Bool bPersistent )
{
	switch( rAction.m_nActionType )
	{
	case XML_ETACTION_META:
		return new XMLMetaTransformerContext( *this, rQName );
	case XML_ETACTION_DOCUMENT:
		return new XMLDocumentTransformerContext( *this, rQName );
	case XML_ETACTION_BODY:
		return new XMLBodyOASISTransformerContext_Impl( *this, rQName );
	case XML_ETACTION_NOTES:
		return new XMLNotesTransformerContext( *this, rQName,
				static_cast< XMLTokenEnum>( rAction.m_nParam1 ), bPersistent );
	case XML_ETACTION_TABLE:
		return new XMLTableTransformerContext_Impl( *this, rQName );
	case XML_ETACTION_STYLE:
		return new XMLStyleOASISTContext( *this, rQName, bPersistent );
	case XML_ETACTION_STYLE_RENAME:
		return new XMLStyleOASISTContext( *this, rQName,
					rAction.GetQNamePrefixFromParam1(),
					rAction.GetQNameTokenFromParam1(), bPersistent );
	case XML_ETACTION_FRAME:
		return new XMLFrameOASISTransformerContext( *this, rQName );
	case XML_ETACTION_EVENT:
		return new XMLEventOASISTransformerContext( *this, rQName );
	case XML_ETACTION_DLG:
		return new XMLDlgOASISTransformerContext( *this, rQName );
	case XML_ETACTION_TAB_STOP:
		return new XMLTabStopOASISTContext_Impl( *this, rQName );
	case XML_ETACTION_FORM_CONTROL:
		{
			const XMLTransformerContext *pCurrent = GetCurrentContext();
			return new XMLControlOASISTransformerContext( *this, rQName,
						pCurrent ? pCurrent->HasQName( XML_NAMESPACE_FORM,
										   XML_FORM ) : sal_False  );
		}
	case XML_ETACTION_FORM_PROPERTY:
		return new XMLFormPropOASISTransformerContext( *this, rQName,
				static_cast< XMLTokenEnum >( rAction.m_nParam1 ) );
	case XML_ETACTION_CHART:
		return new XMLChartOASISTransformerContext( *this, rQName );
	case XML_ETACTION_CONFIG_ITEM:
		return new XMLConfigItemTContext_Impl( *this, rQName );
	case XML_ETACTION_TRACKED_CHANGES:
		return new XMLTrackedChangesOASISTContext_Impl( *this, rQName,
			   				rAction.GetQNamePrefixFromParam1(),
							rAction.GetQNameTokenFromParam1() );
	case XML_ETACTION_CHART_PLOT_AREA:
        return new XMLChartPlotAreaOASISTContext( *this, rQName );
	default:
		OSL_ENSURE( !this, "no user defined context found!" );
		break;
	}

	// default is copying
	return new XMLTransformerContext( *this, rQName );
}

XMLTransformerActions *Oasis2OOoTransformer::GetUserDefinedActions(
		sal_uInt16 n )
{
	XMLTransformerActions *pActions = 0;
	if( n < MAX_OASIS_ACTIONS )
	{
		if( !m_aActions[n] )
		{
			if( n<MAX_OASIS_PROP_ACTIONS )
			{
				m_aActions[n] =
					XMLStyleOASISTContext::CreateTransformerActions( n );
			}
			else switch( n )
			{
			case OASIS_STYLE_ACTIONS:
				m_aActions[OASIS_STYLE_ACTIONS] =
					new XMLTransformerActions( aStyleActionTable );
				break;
			case OASIS_FONT_FACE_ACTIONS:
				m_aActions[OASIS_FONT_FACE_ACTIONS] =
					new XMLTransformerActions( aFontFaceActionTable );
				break;
			case OASIS_SHAPE_ACTIONS:
				m_aActions[OASIS_SHAPE_ACTIONS] =
					new XMLTransformerActions( aShapeActionTable );
				break;
			case OASIS_CONNECTOR_ACTIONS:
				m_aActions[OASIS_CONNECTOR_ACTIONS] =
					new XMLTransformerActions( aConnectorActionTable );
				break;
			case OASIS_INDEX_ENTRY_TAB_STOP_ACTIONS:
				m_aActions[OASIS_INDEX_ENTRY_TAB_STOP_ACTIONS] =
					new XMLTransformerActions( aIndexEntryTabStopActionTable );
				break;
			case OASIS_TAB_STOP_ACTIONS:
				m_aActions[OASIS_TAB_STOP_ACTIONS] =
					new XMLTransformerActions( aTabStopActionTable );
				break;
			case OASIS_LINENUMBERING_ACTIONS:
				m_aActions[OASIS_LINENUMBERING_ACTIONS] =
					new XMLTransformerActions( aLineNumberingActionTable );
				break;
			case OASIS_FOOTNOTE_SEP_ACTIONS:
				m_aActions[OASIS_FOOTNOTE_SEP_ACTIONS] =
					new XMLTransformerActions( aFootnoteSepActionTable );
				break;
			case OASIS_DROP_CAP_ACTIONS:
				m_aActions[OASIS_DROP_CAP_ACTIONS] =
					new XMLTransformerActions( aDropCapActionTable );
				break;
			case OASIS_COLUMNS_ACTIONS:
				m_aActions[OASIS_COLUMNS_ACTIONS] =
					new XMLTransformerActions( aColumnsActionTable );
				break;
			case OASIS_TEXT_VALUE_TYPE_ACTIONS:
				m_aActions[OASIS_TEXT_VALUE_TYPE_ACTIONS] =
					new XMLTransformerActions( aTextValueTypeActionTable );
				break;
			case OASIS_TABLE_VALUE_TYPE_ACTIONS:
				m_aActions[OASIS_TABLE_VALUE_TYPE_ACTIONS] =
					new XMLTransformerActions( aTableValueTypeActionTable );
				break;
			case OASIS_PARA_ACTIONS:
				m_aActions[OASIS_PARA_ACTIONS] =
					new XMLTransformerActions( aParaActionTable );
				break;
			case OASIS_LIST_STYLE_REF_ACTIONS:
				m_aActions[OASIS_LIST_STYLE_REF_ACTIONS] =
					new XMLTransformerActions( aListStyleRefActionTable );
				break;
			case OASIS_TEXT_STYLE_REF_ACTIONS:
				m_aActions[OASIS_TEXT_STYLE_REF_ACTIONS] =
					new XMLTransformerActions( aTextStyleRefActionTable );
				break;
			case OASIS_PARA_STYLE_REF_ACTIONS:
				m_aActions[OASIS_PARA_STYLE_REF_ACTIONS] =
					new XMLTransformerActions( aParaStyleRefActionTable );
				break;
			case OASIS_MASTER_PAGE_REF_ACTIONS:
				m_aActions[OASIS_MASTER_PAGE_REF_ACTIONS] =
					new XMLTransformerActions( aMasterPageRefActionTable );
				break;
			case OASIS_MAP_STYLE_REF_ACTIONS:
				m_aActions[OASIS_MAP_STYLE_REF_ACTIONS] =
					new XMLTransformerActions( aMapStyleRefActionTable );
				break;
			case OASIS_MASTER_PAGE_ACTIONS:
				m_aActions[OASIS_MASTER_PAGE_ACTIONS] =
					new XMLTransformerActions( aMasterPageActionTable );
				break;
			case OASIS_NOTES_ACTIONS:
				m_aActions[OASIS_NOTES_ACTIONS] =
					new XMLTransformerActions( aNotesActionTable );
				break;
			case OASIS_ANNOTATION_ACTIONS:
				m_aActions[OASIS_ANNOTATION_ACTIONS] =
					new XMLTransformerActions( aAnnotationActionTable );
				break;
			case OASIS_CHANGE_INFO_ACTIONS:
				m_aActions[OASIS_CHANGE_INFO_ACTIONS] =
					new XMLTransformerActions( aChangeInfoActionTable );
				break;
			case OASIS_FRAME_ELEM_ACTIONS:
				m_aActions[OASIS_FRAME_ELEM_ACTIONS] =
					new XMLTransformerActions( aFrameActionTable );
				break;
			case OASIS_BACKGROUND_IMAGE_ACTIONS:
				m_aActions[OASIS_BACKGROUND_IMAGE_ACTIONS] =
					new XMLTransformerActions( aBackgroundImageActionTable );
				break;
			case OASIS_DDE_CONNECTION_DECL_ACTIONS:
				m_aActions[OASIS_DDE_CONNECTION_DECL_ACTIONS] =
					new XMLTransformerActions( aDDEConnectionDeclActionTable );
				break;
			case OASIS_EVENT_ACTIONS:
				m_aActions[OASIS_EVENT_ACTIONS] =
					new XMLTransformerActions( aEventActionTable );
                break;
			case OASIS_DLG_ACTIONS:
				m_aActions[OASIS_DLG_ACTIONS] =
					new XMLTransformerActions( aDlgActionTable );
				break;
			case OASIS_FORM_CONTROL_ACTIONS:
				m_aActions[OASIS_FORM_CONTROL_ACTIONS] =
					new XMLTransformerActions( aFormControlActionTable );
				break;
			case OASIS_FORM_COLUMN_ACTIONS:
				m_aActions[OASIS_FORM_COLUMN_ACTIONS] =
					new XMLTransformerActions( aFormColumnActionTable );
				break;
			case OASIS_FORM_PROP_ACTIONS:
				m_aActions[OASIS_FORM_PROP_ACTIONS] =
					new XMLTransformerActions( aFormPropActionTable );
				break;
			case OASIS_XLINK_ACTIONS:
				m_aActions[OASIS_XLINK_ACTIONS] =
					new XMLTransformerActions( aXLinkActionTable );
				break;
			case OASIS_CONFIG_ITEM_SET_ACTIONS:
				m_aActions[OASIS_CONFIG_ITEM_SET_ACTIONS] =
					new XMLTransformerActions( aConfigItemSetActionTable );
				break;
			case OASIS_FORMULA_ACTIONS:
				m_aActions[OASIS_FORMULA_ACTIONS] =
					new XMLTransformerActions( aFormulaActionTable );
				break;
			case OASIS_CHART_ACTIONS:
				m_aActions[OASIS_CHART_ACTIONS] =
					new XMLTransformerActions( aChartActionTable );
				break;
			case OASIS_FORM_ACTIONS:
				m_aActions[OASIS_FORM_ACTIONS] =
					new XMLTransformerActions( aFormActionTable );
				break;
            case OASIS_ALPHABETICAL_INDEX_MARK_ACTIONS:
                m_aActions[OASIS_ALPHABETICAL_INDEX_MARK_ACTIONS] =
                    new XMLTransformerActions(
                        aAlphabeticalIndexMarkActionTable );
                break;
            case OASIS_CONTENT_VALIDATION_ACTIONS:
                m_aActions[OASIS_CONTENT_VALIDATION_ACTIONS] =
                    new XMLTransformerActions( aContentValidationActionTable );
			case OASIS_DDE_CONV_MODE_ACTIONS:
				m_aActions[OASIS_DDE_CONV_MODE_ACTIONS] =
					new XMLTransformerActions( aDDEConvModeActionTable );
				break;
			case OASIS_DATAPILOT_MEMBER_ACTIONS:
				m_aActions[OASIS_DATAPILOT_MEMBER_ACTIONS] =
					new XMLTransformerActions( aDataPilotMemberActionTable );
				break;
			case OASIS_DATAPILOT_LEVEL_ACTIONS:
				m_aActions[OASIS_DATAPILOT_LEVEL_ACTIONS] =
					new XMLTransformerActions( aDataPilotLevelActionTable );
				break;
			case OASIS_SOURCE_SERVICE_ACTIONS:
				m_aActions[OASIS_SOURCE_SERVICE_ACTIONS] =
					new XMLTransformerActions( aSourceServiceActionTable );
				break;
            case OASIS_DRAW_AREA_POLYGON_ACTIONS:
                m_aActions[OASIS_DRAW_AREA_POLYGON_ACTIONS] =
                    new XMLTransformerActions( aShapeActionTable );
                m_aActions[OASIS_DRAW_AREA_POLYGON_ACTIONS]
                    ->Add( aDrawAreaPolygonActionTable );
                break;
            case OASIS_SCRIPT_ACTIONS:
				m_aActions[OASIS_SCRIPT_ACTIONS] =
					new XMLTransformerActions( aScriptActionTable );
				break;
            case OASIS_DATETIME_ACTIONS:
                m_aActions[OASIS_DATETIME_ACTIONS] =
                    new XMLTransformerActions( aDateTimeActionTable );
                break;
            // --> OD 2005-01-10 #i40011#, #i40015#
            case OASIS_TABLE_STYLE_REF_ACTIONS:
                m_aActions[OASIS_TABLE_STYLE_REF_ACTIONS] =
                    new XMLTransformerActions( aTableStyleRefActionTable );
                break;
            // <--
			case OASIS_ANIMATION_ACTIONS:
                m_aActions[OASIS_ANIMATION_ACTIONS] =
                    new XMLTransformerActions( aAnimationActionTable );
                break;
			}
		}
		pActions = m_aActions[n];
	}

	return pActions;
}

OUString Oasis2OOoTransformer::GetEventName( const OUString& rName,
											 sal_Bool bForm )
{
	if( bForm && !m_pFormEventMap )
		m_pFormEventMap =
			XMLEventOASISTransformerContext::CreateFormEventMap();
	if( !m_pEventMap )
		m_pEventMap = XMLEventOASISTransformerContext::CreateEventMap();

	OUString aMacroName;
	sal_uInt16 nPrefix =
		GetNamespaceMap().GetKeyByAttrName( rName, &aMacroName );
	return XMLEventOASISTransformerContext::GetEventName(
				nPrefix, aMacroName, *m_pEventMap,
		   		bForm ? m_pFormEventMap : 0	);
}

Oasis2OOoTransformer::Oasis2OOoTransformer() throw() :
	XMLTransformerBase( aActionTable, aTokenMap ),
	m_pEventMap( 0 ),
	m_pFormEventMap( 0 )
{
	GetNamespaceMap().Add( GetXMLToken(XML_NP_OFFICE), GetXMLToken(XML_N_OFFICE), XML_NAMESPACE_OFFICE );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_OFFICE), GetXMLToken(XML_N_OFFICE_OOO), XML_NAMESPACE_OFFICE );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_META), GetXMLToken(XML_N_META), XML_NAMESPACE_META );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_META), GetXMLToken(XML_N_META_OOO), XML_NAMESPACE_META );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_STYLE), GetXMLToken(XML_N_STYLE), XML_NAMESPACE_STYLE );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_STYLE), GetXMLToken(XML_N_STYLE_OOO), XML_NAMESPACE_STYLE );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_NUMBER), GetXMLToken(XML_N_NUMBER), XML_NAMESPACE_NUMBER );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_NUMBER), GetXMLToken(XML_N_NUMBER_OOO), XML_NAMESPACE_NUMBER );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_CONFIG), GetXMLToken(XML_N_CONFIG), XML_NAMESPACE_CONFIG );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_CONFIG), GetXMLToken(XML_N_CONFIG_OOO), XML_NAMESPACE_CONFIG );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_TEXT), GetXMLToken(XML_N_TEXT), XML_NAMESPACE_TEXT );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_TEXT), GetXMLToken(XML_N_TEXT_OOO), XML_NAMESPACE_TEXT );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_TABLE), GetXMLToken(XML_N_TABLE), XML_NAMESPACE_TABLE );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_TABLE), GetXMLToken(XML_N_TABLE_OOO), XML_NAMESPACE_TABLE );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_DRAW), GetXMLToken(XML_N_DRAW), XML_NAMESPACE_DRAW );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_DRAW), GetXMLToken(XML_N_DRAW_OOO), XML_NAMESPACE_DRAW );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_DR3D), GetXMLToken(XML_N_DR3D), XML_NAMESPACE_DR3D );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_DR3D), GetXMLToken(XML_N_DR3D_OOO), XML_NAMESPACE_DR3D );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_PRESENTATION), GetXMLToken(XML_N_PRESENTATION), XML_NAMESPACE_PRESENTATION );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_PRESENTATION), GetXMLToken(XML_N_PRESENTATION_OOO), XML_NAMESPACE_PRESENTATION );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_CHART), GetXMLToken(XML_N_CHART), XML_NAMESPACE_CHART );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_CHART), GetXMLToken(XML_N_CHART_OOO), XML_NAMESPACE_CHART );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_FORM), GetXMLToken(XML_N_FORM), XML_NAMESPACE_FORM );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_FORM), GetXMLToken(XML_N_FORM_OOO), XML_NAMESPACE_FORM );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_SCRIPT), GetXMLToken(XML_N_SCRIPT), XML_NAMESPACE_SCRIPT );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_SCRIPT), GetXMLToken(XML_N_SCRIPT_OOO), XML_NAMESPACE_SCRIPT );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_DLG), GetXMLToken(XML_N_DLG), XML_NAMESPACE_DLG );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_DLG), GetXMLToken(XML_N_DLG), XML_NAMESPACE_DLG );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_FO), GetXMLToken(XML_N_FO_COMPAT), XML_NAMESPACE_FO );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_FO), GetXMLToken(XML_N_FO), XML_NAMESPACE_FO );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_SVG), GetXMLToken(XML_N_SVG_COMPAT), XML_NAMESPACE_SVG );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_SVG), GetXMLToken(XML_N_SVG),  XML_NAMESPACE_SVG );


	for( sal_uInt16 i=0; i<MAX_OASIS_ACTIONS; ++i )
		m_aActions[i] = 0;
}

Oasis2OOoTransformer::~Oasis2OOoTransformer() throw()
{
	for( sal_uInt16 i=0; i<MAX_OASIS_ACTIONS; ++i )
		delete m_aActions[i];
	XMLEventOASISTransformerContext::FlushEventMap( m_pEventMap );
	XMLEventOASISTransformerContext::FlushEventMap( m_pFormEventMap );
}

::com::sun::star::uno::Sequence< sal_Int8 >  static CreateUnoTunnelId()
{
	static osl::Mutex aCreateMutex;
	Guard<osl::Mutex> aGuard( aCreateMutex );
	Sequence< sal_Int8 > aSeq( 16 );
    rtl_createUuid( (sal_uInt8*)aSeq.getArray(), 0,	sal_True );
	return aSeq;
}

const Sequence< sal_Int8 > & Oasis2OOoTransformer::getUnoTunnelId() throw()
{
    static Sequence< sal_Int8 > aSeq = ::CreateUnoTunnelId();
	return aSeq;
}

// XUnoTunnel
sal_Int64 SAL_CALL Oasis2OOoTransformer::getSomething( const Sequence< sal_Int8 >& rId )
	throw(RuntimeException)
{
    if( rId.getLength() == 16
        && 0 == rtl_compareMemory( getUnoTunnelId().getConstArray(),
										rId.getConstArray(), 16 ) )
    {
		return reinterpret_cast< sal_Int64 >( this );
    }
	else
	{
		return (sal_Int64)0;
	}
}

// XServiceInfo
OUString SAL_CALL Oasis2OOoTransformer::getImplementationName()
    throw(RuntimeException)
{
	return Oasis2OOoTransformer_getImplementationName();
}

sal_Bool SAL_CALL Oasis2OOoTransformer::supportsService( const OUString& )
	throw(RuntimeException)
{
    return sal_False;
}

Sequence< OUString > SAL_CALL Oasis2OOoTransformer::getSupportedServiceNames(  )
	throw(RuntimeException)
{
    Sequence<OUString> aSeq(0);
    return aSeq;
}

// Service registration

OUString SAL_CALL Oasis2OOoTransformer_getImplementationName() throw()
{
	return OUString( RTL_CONSTASCII_USTRINGPARAM(
		"com.sun.star.comp.Oasis2OOoTransformer" ) );
}

Sequence< OUString > SAL_CALL Oasis2OOoTransformer_getSupportedServiceNames()
	throw()
{
	const OUString aServiceName( Oasis2OOoTransformer_getImplementationName() );
	const Sequence< OUString > aSeq( &aServiceName, 1 );
	return aSeq;
}

Reference< XInterface > SAL_CALL Oasis2OOoTransformer_createInstance(
		const Reference< XMultiServiceFactory > &)
	throw( Exception )
{
	OSL_TRACE("Creating Oasis2OOoTransformer");
	return (cppu::OWeakObject*)new Oasis2OOoTransformer;
}
