#*************************************************************************
#
# DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
# 
# Copyright 2000, 2010 Oracle and/or its affiliates.
#
# OpenOffice.org - a multi-platform office productivity suite
#
# This file is part of OpenOffice.org.
#
# OpenOffice.org is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# only, as published by the Free Software Foundation.
#
# OpenOffice.org is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License version 3 for more details
# (a copy is included in the LICENSE file that accompanied this code).
#
# You should have received a copy of the GNU Lesser General Public License
# version 3 along with OpenOffice.org.  If not, see
# <http://www.openoffice.org/license.html>
# for a copy of the LGPLv3 License.
#
#*************************************************************************

PRJ=..$/..
PRJNAME=odk
TARGET=copying

#----------------------------------------------------------------
.INCLUDE: settings.mk
.INCLUDE: $(PRJ)$/util$/makefile.pmk
#----------------------------------------------------------------

#----------------------------------------------------
# this makefile is only used for copying the example 
# files into the SDK
#----------------------------------------------------

DRAWING_FILES= \
	$(DESTDIRJAVAEXAMPLES)$/Drawing$/SDraw.java \
	$(DESTDIRJAVAEXAMPLES)$/Drawing$/Makefile

SPREADSHEET_FILES= \
	$(DESTDIRJAVAEXAMPLES)$/Spreadsheet$/SCalc.java		   	\
	$(DESTDIRJAVAEXAMPLES)$/Spreadsheet$/EuroAdaption.java		\
	$(DESTDIRJAVAEXAMPLES)$/Spreadsheet$/ChartTypeChange.java   	\
	$(DESTDIRJAVAEXAMPLES)$/Spreadsheet$/CalcAddins.java	   	\
	$(DESTDIRJAVAEXAMPLES)$/Spreadsheet$/CalcAddins.ods	   	\
	$(DESTDIRJAVAEXAMPLES)$/Spreadsheet$/XCalcAddins.idl	   	\
	$(DESTDIRJAVAEXAMPLES)$/Spreadsheet$/Makefile

TEXT_FILES= \
	$(DESTDIRJAVAEXAMPLES)$/Text$/SWriter.java	   		\
	$(DESTDIRJAVAEXAMPLES)$/Text$/StyleInitialization.java 	\
	$(DESTDIRJAVAEXAMPLES)$/Text$/TextDocumentStructure.java 	\
	$(DESTDIRJAVAEXAMPLES)$/Text$/TextReplace.java 		\
	$(DESTDIRJAVAEXAMPLES)$/Text$/BookmarkInsertion.java 	\
	$(DESTDIRJAVAEXAMPLES)$/Text$/HardFormatting.java 	\
	$(DESTDIRJAVAEXAMPLES)$/Text$/StyleCreation.java  	\
	$(DESTDIRJAVAEXAMPLES)$/Text$/WriterSelector.java  	\
	$(DESTDIRJAVAEXAMPLES)$/Text$/GraphicsInserter.java  	\
	$(DESTDIRJAVAEXAMPLES)$/Text$/oo_smiley.gif  	\
	$(DESTDIRJAVAEXAMPLES)$/Text$/Makefile

DOCUMENTHANDLING_FILES= \
	$(DESTDIRJAVAEXAMPLES)$/DocumentHandling$/DocumentConverter.java	\
	$(DESTDIRJAVAEXAMPLES)$/DocumentHandling$/DocumentLoader.java	\
	$(DESTDIRJAVAEXAMPLES)$/DocumentHandling$/DocumentPrinter.java	\
	$(DESTDIRJAVAEXAMPLES)$/DocumentHandling$/DocumentSaver.java	\
	$(DESTDIRJAVAEXAMPLES)$/DocumentHandling$/Makefile \
	$(DESTDIRJAVAEXAMPLES)$/DocumentHandling$/test$/test1.odt

CONVERTERSERVLET_FILES= \
	$(DESTDIRJAVAEXAMPLES)$/ConverterServlet$/ConverterServlet.html	\
	$(DESTDIRJAVAEXAMPLES)$/ConverterServlet$/ConverterServlet.java	\
	$(DESTDIRJAVAEXAMPLES)$/ConverterServlet$/web.xml	\
	$(DESTDIRJAVAEXAMPLES)$/ConverterServlet$/Makefile			\
	$(DESTDIRJAVAEXAMPLES)$/ConverterServlet$/README

EMBEDDEDOBJECT_FILES= \
	$(DESTDIRJAVAEXAMPLES)$/EmbedDocument$/EmbeddedObject$/EmbeddedObject.xcu \
	$(DESTDIRJAVAEXAMPLES)$/EmbedDocument$/EmbeddedObject$/OwnEmbeddedObject.java \
	$(DESTDIRJAVAEXAMPLES)$/EmbedDocument$/EmbeddedObject$/EditorFrame.java  \
	$(DESTDIRJAVAEXAMPLES)$/EmbedDocument$/EmbeddedObject$/Makefile \
	$(DESTDIRJAVAEXAMPLES)$/EmbedDocument$/EmbeddedObject$/OwnEmbeddedObjectFactory.java

INSPECTOR_FILES= \
	$(DESTDIRJAVAEXAMPLES)$/Inspector$/Inspector.jpg \
	$(DESTDIRJAVAEXAMPLES)$/Inspector$/InspectorThumbnail.jpg \
	$(DESTDIRJAVAEXAMPLES)$/Inspector$/Inspector.uno.xml \
	$(DESTDIRJAVAEXAMPLES)$/Inspector$/Inspector.java \
	$(DESTDIRJAVAEXAMPLES)$/Inspector$/Makefile \
	$(DESTDIRJAVAEXAMPLES)$/Inspector$/TestInspector.java \
	$(DESTDIRJAVAEXAMPLES)$/Inspector$/XInstanceInspector.idl \
	$(DESTDIRJAVAEXAMPLES)$/Inspector$/InstanceInspector.idl \
	$(DESTDIRJAVAEXAMPLES)$/Inspector$/InstanceInspectorTest.odt

NOTESACCESS_FILES= \
	$(DESTDIRJAVAEXAMPLES)$/NotesAccess$/NotesAccess.java \
	$(DESTDIRJAVAEXAMPLES)$/NotesAccess$/Makefile \
	$(DESTDIRJAVAEXAMPLES)$/NotesAccess$/Stocks.nsf

TODO_FILES= \
	$(DESTDIRJAVAEXAMPLES)$/ToDo$/ToDo.java \
	$(DESTDIRJAVAEXAMPLES)$/ToDo$/ToDo.ods  \
	$(DESTDIRJAVAEXAMPLES)$/ToDo$/ToDo.uno.xml  \
	$(DESTDIRJAVAEXAMPLES)$/ToDo$/ToDo.idl  \
	$(DESTDIRJAVAEXAMPLES)$/ToDo$/XToDo.idl  \
	$(DESTDIRJAVAEXAMPLES)$/ToDo$/Makefile

MINIMALCOMPONENT_FILES= \
	$(DESTDIRJAVAEXAMPLES)$/MinimalComponent$/MinimalComponent.idl \
	$(DESTDIRJAVAEXAMPLES)$/MinimalComponent$/MinimalComponent.java\
	$(DESTDIRJAVAEXAMPLES)$/MinimalComponent$/MinimalComponent.uno.xml \
	$(DESTDIRJAVAEXAMPLES)$/MinimalComponent$/TestMinimalComponent.java\
	$(DESTDIRJAVAEXAMPLES)$/MinimalComponent$/Makefile

PROPERTYSET_FILES= \
	$(DESTDIRJAVAEXAMPLES)$/PropertySet$/PropTest.java \
	$(DESTDIRJAVAEXAMPLES)$/PropertySet$/PropertySet.odt \
	$(DESTDIRJAVAEXAMPLES)$/PropertySet$/Makefile

DIR_FILE_LIST= \
	$(DRAWING_FILES) \
	$(SPREADSHEET_FILES) \
	$(TEXT_FILES) \
	$(DOCUMENTHANDLING_FILES) \
	$(CONVERTERSERVLET_FILES) \
	$(EMBEDDEDOBJECT_FILES) \
	$(INSPECTOR_FILES) \
	$(NOTESACCESS_FILES) \
	$(TODO_FILES) \
	$(MINIMALCOMPONENT_FILES) \
	$(PROPERTYSET_FILES)

DIR_DIRECTORY_LIST=$(uniq $(DIR_FILE_LIST:d))
DIR_CREATE_FLAG=$(MISC)$/ex_java_dirs_created.txt
DIR_FILE_FLAG=$(MISC)$/ex_java_files.txt

#--------------------------------------------------
# TARGETS
#--------------------------------------------------
all : \
	$(DIR_FILE_LIST) \
	$(DIR_FILE_FLAG)

#--------------------------------------------------
# use global rules
#--------------------------------------------------   
.INCLUDE: $(PRJ)$/util$/odk_rules.pmk


