/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public abstract class DBCS_ONLY_IBM_EBCDIC_Decoder
extends CharsetDecoder {
    protected static final char REPLACE_CHAR = '\ufffd';
    protected short[] index1;
    protected String index2;
    protected int mask1;
    protected int mask2;
    protected int shift;

    protected DBCS_ONLY_IBM_EBCDIC_Decoder(Charset charset) {
        super(charset, 0.5f, 1.0f);
    }

    private static boolean isValidDoubleByte(int n, int n2) {
        return n == 64 && n2 == 64 || 65 <= n && n <= 254 && 65 <= n2 && n2 <= 254;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        assert (n <= n2);
        n = n <= n2 ? n : n2;
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        assert (n3 <= n4);
        n3 = n3 <= n4 ? n3 : n4;
        try {
            while (n + 1 < n2) {
                int n5 = byArray[n] & 0xFF;
                int n6 = byArray[n + 1] & 0xFF;
                if (!DBCS_ONLY_IBM_EBCDIC_Decoder.isValidDoubleByte(n5, n6)) {
                    CoderResult coderResult = CoderResult.malformedForLength(2);
                    return coderResult;
                }
                int n7 = n5 * 256 + n6;
                char c = this.index2.charAt(this.index1[(n7 & this.mask1) >> this.shift] + (n7 & this.mask2));
                if (c == '\ufffd') {
                    CoderResult coderResult = CoderResult.unmappableForLength(2);
                    return coderResult;
                }
                if (n4 - n3 < 1) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                cArray[n3++] = c;
                n += 2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n - byteBuffer.arrayOffset());
            charBuffer.position(n3 - charBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        try {
            while (byteBuffer.remaining() > 1) {
                int n2;
                int n3 = byteBuffer.get() & 0xFF;
                if (!DBCS_ONLY_IBM_EBCDIC_Decoder.isValidDoubleByte(n3, n2 = byteBuffer.get() & 0xFF)) {
                    CoderResult coderResult = CoderResult.malformedForLength(2);
                    return coderResult;
                }
                int n4 = n3 * 256 + n2;
                char c = this.index2.charAt(this.index1[(n4 & this.mask1) >> this.shift] + (n4 & this.mask2));
                if (c == '\ufffd') {
                    CoderResult coderResult = CoderResult.unmappableForLength(2);
                    return coderResult;
                }
                if (!charBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                charBuffer.put(c);
                n += 2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }
}

