/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;

public class MotifScrollBarButton
extends BasicArrowButton {
    private Color darkShadow = UIManager.getColor("controlShadow");
    private Color lightShadow = UIManager.getColor("controlLtHighlight");

    public MotifScrollBarButton(int n) {
        super(n);
        switch (n) {
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                this.direction = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid direction");
            }
        }
        this.setRequestFocusEnabled(false);
        this.setOpaque(true);
        this.setBackground(UIManager.getColor("ScrollBar.background"));
        this.setForeground(UIManager.getColor("ScrollBar.foreground"));
    }

    public Dimension getPreferredSize() {
        switch (this.direction) {
            case 1: 
            case 5: {
                return new Dimension(11, 12);
            }
        }
        return new Dimension(12, 11);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paint(Graphics graphics) {
        boolean bl;
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
        }
        Color color = (bl = this.getModel().isPressed()) ? this.darkShadow : this.lightShadow;
        Color color2 = bl ? this.lightShadow : this.darkShadow;
        Color color3 = this.getBackground();
        int n3 = n / 2;
        int n4 = n2 / 2;
        int n5 = Math.min(n, n2);
        switch (this.direction) {
            case 1: {
                graphics.setColor(color);
                graphics.drawLine(n3, 0, n3, 0);
                int n6 = n3 - 1;
                int n7 = 1;
                for (int i = 1; i <= n5 - 2; i += 2) {
                    graphics.setColor(color);
                    graphics.drawLine(n6, i, n6, i);
                    if (i >= n5 - 2) {
                        graphics.drawLine(n6, i + 1, n6, i + 1);
                    }
                    graphics.setColor(color3);
                    graphics.drawLine(n6 + 1, i, n6 + n7, i);
                    if (i < n5 - 2) {
                        graphics.drawLine(n6, i + 1, n6 + n7 + 1, i + 1);
                    }
                    graphics.setColor(color2);
                    graphics.drawLine(n6 + n7 + 1, i, n6 + n7 + 1, i);
                    if (i >= n5 - 2) {
                        graphics.drawLine(n6 + 1, i + 1, n6 + n7 + 1, i + 1);
                    }
                    n7 += 2;
                    --n6;
                }
                break;
            }
            case 5: {
                graphics.setColor(color2);
                graphics.drawLine(n3, n5, n3, n5);
                int n8 = n3 - 1;
                int n9 = 1;
                for (int i = n5 - 1; i >= 1; i -= 2) {
                    graphics.setColor(color);
                    graphics.drawLine(n8, i, n8, i);
                    if (i <= 2) {
                        graphics.drawLine(n8, i - 1, n8 + n9 + 1, i - 1);
                    }
                    graphics.setColor(color3);
                    graphics.drawLine(n8 + 1, i, n8 + n9, i);
                    if (i > 2) {
                        graphics.drawLine(n8, i - 1, n8 + n9 + 1, i - 1);
                    }
                    graphics.setColor(color2);
                    graphics.drawLine(n8 + n9 + 1, i, n8 + n9 + 1, i);
                    n9 += 2;
                    --n8;
                }
                break;
            }
            case 3: {
                graphics.setColor(color);
                graphics.drawLine(n5, n4, n5, n4);
                int n10 = n4 - 1;
                int n11 = 1;
                for (int i = n5 - 1; i >= 1; i -= 2) {
                    graphics.setColor(color);
                    graphics.drawLine(i, n10, i, n10);
                    if (i <= 2) {
                        graphics.drawLine(i - 1, n10, i - 1, n10 + n11 + 1);
                    }
                    graphics.setColor(color3);
                    graphics.drawLine(i, n10 + 1, i, n10 + n11);
                    if (i > 2) {
                        graphics.drawLine(i - 1, n10, i - 1, n10 + n11 + 1);
                    }
                    graphics.setColor(color2);
                    graphics.drawLine(i, n10 + n11 + 1, i, n10 + n11 + 1);
                    n11 += 2;
                    --n10;
                }
                break;
            }
            case 7: {
                graphics.setColor(color2);
                graphics.drawLine(0, n4, 0, n4);
                int n12 = n4 - 1;
                int n13 = 1;
                for (int i = 1; i <= n5 - 2; i += 2) {
                    graphics.setColor(color);
                    graphics.drawLine(i, n12, i, n12);
                    if (i >= n5 - 2) {
                        graphics.drawLine(i + 1, n12, i + 1, n12);
                    }
                    graphics.setColor(color3);
                    graphics.drawLine(i, n12 + 1, i, n12 + n13);
                    if (i < n5 - 2) {
                        graphics.drawLine(i + 1, n12, i + 1, n12 + n13 + 1);
                    }
                    graphics.setColor(color2);
                    graphics.drawLine(i, n12 + n13 + 1, i, n12 + n13 + 1);
                    if (i >= n5 - 2) {
                        graphics.drawLine(i + 1, n12 + 1, i + 1, n12 + n13 + 1);
                    }
                    n13 += 2;
                    --n12;
                }
                break;
            }
        }
    }
}

