/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.io.Serializable;

public abstract class Point2D
implements Cloneable {
    protected Point2D() {
    }

    public abstract double getX();

    public abstract double getY();

    public abstract void setLocation(double var1, double var3);

    public void setLocation(Point2D point2D) {
        this.setLocation(point2D.getX(), point2D.getY());
    }

    public static double distanceSq(double d, double d2, double d3, double d4) {
        return (d -= d3) * d + (d2 -= d4) * d2;
    }

    public static double distance(double d, double d2, double d3, double d4) {
        return Math.sqrt((d -= d3) * d + (d2 -= d4) * d2);
    }

    public double distanceSq(double d, double d2) {
        return (d -= this.getX()) * d + (d2 -= this.getY()) * d2;
    }

    public double distanceSq(Point2D point2D) {
        double d = point2D.getX() - this.getX();
        double d2 = point2D.getY() - this.getY();
        return d * d + d2 * d2;
    }

    public double distance(double d, double d2) {
        return Math.sqrt((d -= this.getX()) * d + (d2 -= this.getY()) * d2);
    }

    public double distance(Point2D point2D) {
        double d = point2D.getX() - this.getX();
        double d2 = point2D.getY() - this.getY();
        return Math.sqrt(d * d + d2 * d2);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        long l = java.lang.Double.doubleToLongBits(this.getX());
        return (int)(l ^= java.lang.Double.doubleToLongBits(this.getY()) * 31L) ^ (int)(l >> 32);
    }

    public boolean equals(Object object) {
        if (object instanceof Point2D) {
            Point2D point2D = (Point2D)object;
            return this.getX() == point2D.getX() && this.getY() == point2D.getY();
        }
        return super.equals(object);
    }

    public static class Double
    extends Point2D
    implements Serializable {
        public double x;
        public double y;
        private static final long serialVersionUID = 6150783262733311327L;

        public Double() {
        }

        public Double(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public String toString() {
            return "Point2D.Double[" + this.x + ", " + this.y + "]";
        }
    }

    public static class Float
    extends Point2D
    implements Serializable {
        public float x;
        public float y;
        private static final long serialVersionUID = -2870572449815403710L;

        public Float() {
        }

        public Float(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double d, double d2) {
            this.x = (float)d;
            this.y = (float)d2;
        }

        public void setLocation(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public String toString() {
            return "Point2D.Float[" + this.x + ", " + this.y + "]";
        }
    }
}

