/*
 * Decompiled with CFR 0.152.
 */
package com.sun.awt;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import sun.awt.AWTAccessor;
import sun.awt.SunToolkit;

public final class AWTUtilities {
    private AWTUtilities() {
    }

    public static boolean isTranslucencySupported(Translucency translucency) {
        switch (translucency) {
            case PERPIXEL_TRANSPARENT: {
                return AWTUtilities.isWindowShapingSupported();
            }
            case TRANSLUCENT: {
                return AWTUtilities.isWindowOpacityControlSupported();
            }
            case PERPIXEL_TRANSLUCENT: {
                return AWTUtilities.isWindowTranslucencySupported();
            }
        }
        return false;
    }

    private static boolean isWindowOpacityControlSupported() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (!(toolkit instanceof SunToolkit)) {
            return false;
        }
        return ((SunToolkit)toolkit).isWindowOpacityControlSupported();
    }

    public static void setWindowOpacity(Window window, float f) {
        if (window == null) {
            throw new NullPointerException("The window argument should not be null.");
        }
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("The value of opacity should be in the range [0.0f .. 1.0f].");
        }
        if (!AWTUtilities.isTranslucencySupported(Translucency.TRANSLUCENT)) {
            throw new UnsupportedOperationException("The TRANSLUCENT translucency kind is not supported.");
        }
        if (window.getGraphicsConfiguration().getDevice().getFullScreenWindow() == window && f < 1.0f) {
            throw new IllegalArgumentException("The effects for full-screen windows are not supported.");
        }
        AWTAccessor.getWindowAccessor().setOpacity(window, f);
    }

    public static float getWindowOpacity(Window window) {
        if (window == null) {
            throw new NullPointerException("The window argument should not be null.");
        }
        return AWTAccessor.getWindowAccessor().getOpacity(window);
    }

    private static boolean isWindowShapingSupported() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (!(toolkit instanceof SunToolkit)) {
            return false;
        }
        return ((SunToolkit)toolkit).isWindowShapingSupported();
    }

    public static Shape getWindowShape(Window window) {
        if (window == null) {
            throw new NullPointerException("The window argument should not be null.");
        }
        return AWTAccessor.getWindowAccessor().getShape(window);
    }

    public static void setWindowShape(Window window, Shape shape) {
        if (window == null) {
            throw new NullPointerException("The window argument should not be null.");
        }
        if (!AWTUtilities.isTranslucencySupported(Translucency.PERPIXEL_TRANSPARENT)) {
            throw new UnsupportedOperationException("The PERPIXEL_TRANSPARENT translucency kind is not supported");
        }
        if (window.getGraphicsConfiguration().getDevice().getFullScreenWindow() == window && shape != null) {
            throw new IllegalArgumentException("The effects for full-screen windows are not supported.");
        }
        if (window instanceof Frame && !((Frame)window).isUndecorated() || window instanceof Dialog && !((Dialog)window).isUndecorated()) {
            shape = null;
        }
        AWTAccessor.getWindowAccessor().setShape(window, shape);
    }

    private static boolean isWindowTranslucencySupported() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (!(toolkit instanceof SunToolkit)) {
            return false;
        }
        if (!((SunToolkit)toolkit).isWindowTranslucencySupported()) {
            return false;
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (AWTUtilities.isTranslucencyCapable(graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration())) {
            return true;
        }
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDeviceArray[i].getConfigurations();
            for (int j = 0; j < graphicsConfigurationArray.length; ++j) {
                if (!AWTUtilities.isTranslucencyCapable(graphicsConfigurationArray[j])) continue;
                return true;
            }
        }
        return false;
    }

    public static void setWindowOpaque(Window window, boolean bl) {
        if (window == null) {
            throw new NullPointerException("The window argument should not be null.");
        }
        if (!bl && !AWTUtilities.isTranslucencyCapable(window.getGraphicsConfiguration())) {
            throw new IllegalArgumentException("The window must use a translucency-compatible graphics configuration");
        }
        if (!bl && window.getGraphicsConfiguration().getDevice().getFullScreenWindow() == window) {
            throw new IllegalArgumentException("The effects for full-screen windows are not supported.");
        }
        if (!bl && (window instanceof Frame && !((Frame)window).isUndecorated() || window instanceof Dialog && !((Dialog)window).isUndecorated())) {
            throw new IllegalArgumentException("The effects for decorated windows are not supported.");
        }
        if (!bl && !AWTUtilities.isTranslucencySupported(Translucency.PERPIXEL_TRANSLUCENT)) {
            throw new UnsupportedOperationException("The PERPIXEL_TRANSLUCENT translucency kind is not supported");
        }
        AWTAccessor.getWindowAccessor().setOpaque(window, bl);
    }

    public static boolean isWindowOpaque(Window window) {
        if (window == null) {
            throw new NullPointerException("The window argument should not be null.");
        }
        return AWTAccessor.getWindowAccessor().isOpaque(window);
    }

    public static boolean isTranslucencyCapable(GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration == null) {
            throw new NullPointerException("The gc argument should not be null");
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (!(toolkit instanceof SunToolkit)) {
            return false;
        }
        return ((SunToolkit)toolkit).isTranslucencyCapable(graphicsConfiguration);
    }

    public static void setComponentMixingCutoutShape(Component component, Shape shape) {
        if (component == null) {
            throw new NullPointerException("The component argument should not be null.");
        }
        AWTAccessor.getComponentAccessor().setMixingCutoutShape(component, shape);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Translucency {
        PERPIXEL_TRANSPARENT,
        TRANSLUCENT,
        PERPIXEL_TRANSLUCENT;

    }
}

