/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.Closeable;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.WSService;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.client.ServiceInterceptor;
import com.sun.xml.internal.ws.api.client.ServiceInterceptorFactory;
import com.sun.xml.internal.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.Stubs;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubelineAssembler;
import com.sun.xml.internal.ws.api.pipe.TubelineAssemblerFactory;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.ContainerResolver;
import com.sun.xml.internal.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.client.ClientContainer;
import com.sun.xml.internal.ws.client.HandlerConfigurator;
import com.sun.xml.internal.ws.client.PortInfo;
import com.sun.xml.internal.ws.client.SEIPortInfo;
import com.sun.xml.internal.ws.client.sei.SEIStub;
import com.sun.xml.internal.ws.developer.UsesJAXBContextFeature;
import com.sun.xml.internal.ws.developer.WSBindingProvider;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.RuntimeModeler;
import com.sun.xml.internal.ws.model.SOAPSEIModel;
import com.sun.xml.internal.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLServiceImpl;
import com.sun.xml.internal.ws.resources.ClientMessages;
import com.sun.xml.internal.ws.resources.DispatchMessages;
import com.sun.xml.internal.ws.resources.ProviderApiMessages;
import com.sun.xml.internal.ws.util.JAXWSUtils;
import com.sun.xml.internal.ws.util.ServiceConfigurationError;
import com.sun.xml.internal.ws.util.ServiceFinder;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import com.sun.xml.internal.ws.wsdl.parser.RuntimeWSDLParser;
import java.io.IOException;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.soap.AddressingFeature;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSServiceDelegate
extends WSService {
    private final Map<QName, PortInfo> ports = new HashMap<QName, PortInfo>();
    @NotNull
    private HandlerConfigurator handlerConfigurator = new HandlerConfigurator.HandlerResolverImpl(null);
    private final Class<? extends Service> serviceClass;
    @NotNull
    private final QName serviceName;
    private final Map<QName, SEIPortInfo> seiContext = new HashMap<QName, SEIPortInfo>();
    private Executor executor;
    @Nullable
    private WSDLServiceImpl wsdlService;
    private final Container container;
    @NotNull
    final ServiceInterceptor serviceInterceptor;
    private static final WebServiceFeature[] EMPTY_FEATURES = new WebServiceFeature[0];

    public WSServiceDelegate(URL uRL, QName qName, Class<? extends Service> clazz) {
        this(uRL == null ? null : new StreamSource(uRL.toExternalForm()), qName, clazz);
    }

    public WSServiceDelegate(@Nullable Source source, @NotNull QName qName, final @NotNull Class<? extends Service> clazz) {
        Object object;
        Object object2;
        Container container;
        if (qName == null) {
            throw new WebServiceException(ClientMessages.INVALID_SERVICE_NAME_NULL(qName));
        }
        WSService.InitParams initParams = (WSService.InitParams)INIT_PARAMS.get();
        INIT_PARAMS.set(null);
        if (initParams == null) {
            initParams = EMPTY_PARAMS;
        }
        this.serviceName = qName;
        this.serviceClass = clazz;
        Container container2 = container = initParams.getContainer() != null ? initParams.getContainer() : ContainerResolver.getInstance().getContainer();
        if (container == Container.NONE) {
            container = new ClientContainer();
        }
        this.container = container;
        ServiceInterceptor serviceInterceptor = ServiceInterceptorFactory.load(this, Thread.currentThread().getContextClassLoader());
        ServiceInterceptor serviceInterceptor2 = this.container.getSPI(ServiceInterceptor.class);
        if (serviceInterceptor2 != null) {
            serviceInterceptor = ServiceInterceptor.aggregate(serviceInterceptor, serviceInterceptor2);
        }
        this.serviceInterceptor = serviceInterceptor;
        if (source == null && clazz != Service.class) {
            object2 = AccessController.doPrivileged(new PrivilegedAction<WebServiceClient>(){

                @Override
                public WebServiceClient run() {
                    return clazz.getAnnotation(WebServiceClient.class);
                }
            });
            object = object2.wsdlLocation();
            object = JAXWSUtils.absolutize(JAXWSUtils.getFileOrURLName((String)object));
            source = new StreamSource((String)object);
        }
        object2 = null;
        if (source != null) {
            try {
                object = source.getSystemId() == null ? null : new URL(source.getSystemId());
                WSDLModelImpl wSDLModelImpl = this.parseWSDL((URL)object, source);
                object2 = wSDLModelImpl.getService(this.serviceName);
                if (object2 == null) {
                    throw new WebServiceException(ClientMessages.INVALID_SERVICE_NAME(this.serviceName, this.buildNameList(wSDLModelImpl.getServices().keySet())));
                }
                for (WSDLPortImpl wSDLPortImpl : ((WSDLServiceImpl)object2).getPorts()) {
                    this.ports.put(wSDLPortImpl.getName(), new PortInfo(this, wSDLPortImpl));
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new WebServiceException(ClientMessages.INVALID_WSDL_URL(source.getSystemId()));
            }
        }
        this.wsdlService = object2;
        if (clazz != Service.class && (object = AccessController.doPrivileged(new PrivilegedAction<HandlerChain>(){

            @Override
            public HandlerChain run() {
                return clazz.getAnnotation(HandlerChain.class);
            }
        })) != null) {
            this.handlerConfigurator = new HandlerConfigurator.AnnotationConfigurator(this);
        }
    }

    private WSDLModelImpl parseWSDL(URL uRL, Source source) {
        try {
            return RuntimeWSDLParser.parse(uRL, source, XmlUtil.createDefaultCatalogResolver(), true, this.getContainer(), ServiceFinder.find(WSDLParserExtension.class).toArray());
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
        catch (SAXException sAXException) {
            throw new WebServiceException(sAXException);
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            throw new WebServiceException(serviceConfigurationError);
        }
    }

    @Override
    public Executor getExecutor() {
        if (this.executor != null) {
            return this.executor;
        }
        this.executor = Executors.newCachedThreadPool(new DaemonThreadFactory());
        return this.executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public HandlerResolver getHandlerResolver() {
        return this.handlerConfigurator.getResolver();
    }

    final HandlerConfigurator getHandlerConfigurator() {
        return this.handlerConfigurator;
    }

    @Override
    public void setHandlerResolver(HandlerResolver handlerResolver) {
        this.handlerConfigurator = new HandlerConfigurator.HandlerResolverImpl(handlerResolver);
    }

    @Override
    public <T> T getPort(QName qName, Class<T> clazz) throws WebServiceException {
        return this.getPort(qName, clazz, EMPTY_FEATURES);
    }

    @Override
    public <T> T getPort(QName qName, Class<T> clazz, WebServiceFeature ... webServiceFeatureArray) {
        if (qName == null || clazz == null) {
            throw new IllegalArgumentException();
        }
        WSDLServiceImpl wSDLServiceImpl = this.wsdlService;
        if (wSDLServiceImpl == null && (wSDLServiceImpl = this.getWSDLModelfromSEI(clazz)) == null) {
            throw new WebServiceException(ProviderApiMessages.NO_WSDL_NO_PORT(clazz.getName()));
        }
        WSDLPortImpl wSDLPortImpl = this.getPortModel(wSDLServiceImpl, qName);
        return this.getPort(wSDLPortImpl.getEPR(), qName, clazz, webServiceFeatureArray);
    }

    @Override
    public <T> T getPort(EndpointReference endpointReference, Class<T> clazz, WebServiceFeature ... webServiceFeatureArray) {
        return this.getPort(WSEndpointReference.create(endpointReference), clazz, webServiceFeatureArray);
    }

    @Override
    public <T> T getPort(WSEndpointReference wSEndpointReference, Class<T> clazz, WebServiceFeature ... webServiceFeatureArray) {
        QName qName = RuntimeModeler.getPortTypeName(clazz);
        QName qName2 = this.getPortNameFromEPR(wSEndpointReference, qName);
        return this.getPort(wSEndpointReference, qName2, clazz, webServiceFeatureArray);
    }

    private <T> T getPort(WSEndpointReference wSEndpointReference, QName qName, Class<T> clazz, WebServiceFeature ... webServiceFeatureArray) {
        SEIPortInfo sEIPortInfo = this.addSEI(qName, clazz, webServiceFeatureArray);
        return this.createEndpointIFBaseProxy(wSEndpointReference, qName, clazz, webServiceFeatureArray, sEIPortInfo);
    }

    @Override
    public <T> T getPort(Class<T> clazz, WebServiceFeature ... webServiceFeatureArray) {
        QName qName = RuntimeModeler.getPortTypeName(clazz);
        WSDLServiceImpl wSDLServiceImpl = this.wsdlService;
        if (wSDLServiceImpl == null && (wSDLServiceImpl = this.getWSDLModelfromSEI(clazz)) == null) {
            throw new WebServiceException(ProviderApiMessages.NO_WSDL_NO_PORT(clazz.getName()));
        }
        WSDLPortImpl wSDLPortImpl = wSDLServiceImpl.getMatchingPort(qName);
        if (wSDLPortImpl == null) {
            throw new WebServiceException(ClientMessages.UNDEFINED_PORT_TYPE(qName));
        }
        QName qName2 = wSDLPortImpl.getName();
        return this.getPort(qName2, clazz, webServiceFeatureArray);
    }

    @Override
    public <T> T getPort(Class<T> clazz) throws WebServiceException {
        return this.getPort(clazz, EMPTY_FEATURES);
    }

    @Override
    public void addPort(QName qName, String string, String string2) throws WebServiceException {
        if (this.ports.containsKey(qName)) {
            throw new WebServiceException(DispatchMessages.DUPLICATE_PORT(qName.toString()));
        }
        BindingID bindingID = string == null ? BindingID.SOAP11_HTTP : BindingID.parse(string);
        this.ports.put(qName, new PortInfo(this, string2 == null ? null : EndpointAddress.create(string2), qName, bindingID));
    }

    @Override
    public <T> Dispatch<T> createDispatch(QName qName, Class<T> clazz, Service.Mode mode) throws WebServiceException {
        return this.createDispatch(qName, clazz, mode, EMPTY_FEATURES);
    }

    @Override
    public <T> Dispatch<T> createDispatch(QName qName, WSEndpointReference wSEndpointReference, Class<T> clazz, Service.Mode mode, WebServiceFeature ... webServiceFeatureArray) {
        PortInfo portInfo = this.safeGetPort(qName);
        BindingImpl bindingImpl = portInfo.createBinding(webServiceFeatureArray, null);
        Dispatch<T> dispatch = Stubs.createDispatch(qName, this, bindingImpl, clazz, mode, this.createPipeline(portInfo, bindingImpl), wSEndpointReference);
        this.serviceInterceptor.postCreateDispatch((WSBindingProvider)((Object)dispatch));
        return dispatch;
    }

    @Override
    public <T> Dispatch<T> createDispatch(QName qName, Class<T> clazz, Service.Mode mode, WebServiceFeature ... webServiceFeatureArray) {
        WebServiceFeatureList webServiceFeatureList = new WebServiceFeatureList(webServiceFeatureArray);
        WSEndpointReference wSEndpointReference = null;
        if (webServiceFeatureList.isEnabled(AddressingFeature.class) && this.wsdlService != null && this.wsdlService.get(qName) != null) {
            wSEndpointReference = this.wsdlService.get(qName).getEPR();
        }
        return this.createDispatch(qName, wSEndpointReference, clazz, mode, webServiceFeatureArray);
    }

    @Override
    public <T> Dispatch<T> createDispatch(EndpointReference endpointReference, Class<T> clazz, Service.Mode mode, WebServiceFeature ... webServiceFeatureArray) {
        WSEndpointReference wSEndpointReference = new WSEndpointReference(endpointReference);
        QName qName = this.addPortEpr(wSEndpointReference);
        return this.createDispatch(qName, wSEndpointReference, clazz, mode, webServiceFeatureArray);
    }

    @NotNull
    public PortInfo safeGetPort(QName qName) {
        PortInfo portInfo = this.ports.get(qName);
        if (portInfo == null) {
            throw new WebServiceException(ClientMessages.INVALID_PORT_NAME(qName, this.buildNameList(this.ports.keySet())));
        }
        return portInfo;
    }

    private StringBuilder buildNameList(Collection<QName> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (QName qName : collection) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(qName);
        }
        return stringBuilder;
    }

    private Tube createPipeline(PortInfo portInfo, WSBinding wSBinding) {
        this.checkAllWSDLExtensionsUnderstood(portInfo, wSBinding);
        SOAPSEIModel sOAPSEIModel = null;
        if (portInfo instanceof SEIPortInfo) {
            sOAPSEIModel = ((SEIPortInfo)portInfo).model;
        }
        BindingID bindingID = portInfo.bindingId;
        TubelineAssembler tubelineAssembler = TubelineAssemblerFactory.create(Thread.currentThread().getContextClassLoader(), bindingID);
        if (tubelineAssembler == null) {
            throw new WebServiceException("Unable to process bindingID=" + bindingID);
        }
        return tubelineAssembler.createClient(new ClientTubeAssemblerContext(portInfo.targetEndpoint, portInfo.portModel, this, wSBinding, this.container, ((BindingImpl)wSBinding).createCodec(), sOAPSEIModel));
    }

    private void checkAllWSDLExtensionsUnderstood(PortInfo portInfo, WSBinding wSBinding) {
        if (portInfo.portModel != null && wSBinding.isFeatureEnabled(RespectBindingFeature.class)) {
            ((WSDLPortImpl)portInfo.portModel).areRequiredExtensionsUnderstood();
        }
    }

    public EndpointAddress getEndpointAddress(QName qName) {
        return this.ports.get((Object)qName).targetEndpoint;
    }

    @Override
    public Dispatch<Object> createDispatch(QName qName, JAXBContext jAXBContext, Service.Mode mode) throws WebServiceException {
        return this.createDispatch(qName, jAXBContext, mode, EMPTY_FEATURES);
    }

    @Override
    public Dispatch<Object> createDispatch(QName qName, WSEndpointReference wSEndpointReference, JAXBContext jAXBContext, Service.Mode mode, WebServiceFeature ... webServiceFeatureArray) {
        PortInfo portInfo = this.safeGetPort(qName);
        BindingImpl bindingImpl = portInfo.createBinding(webServiceFeatureArray, null);
        Dispatch<Object> dispatch = Stubs.createJAXBDispatch(qName, this, bindingImpl, jAXBContext, mode, this.createPipeline(portInfo, bindingImpl), wSEndpointReference);
        this.serviceInterceptor.postCreateDispatch((WSBindingProvider)((Object)dispatch));
        return dispatch;
    }

    @Override
    @NotNull
    public Container getContainer() {
        return this.container;
    }

    @Override
    public Dispatch<Object> createDispatch(QName qName, JAXBContext jAXBContext, Service.Mode mode, WebServiceFeature ... webServiceFeatureArray) {
        WebServiceFeatureList webServiceFeatureList = new WebServiceFeatureList(webServiceFeatureArray);
        WSEndpointReference wSEndpointReference = null;
        if (webServiceFeatureList.isEnabled(AddressingFeature.class) && this.wsdlService != null && this.wsdlService.get(qName) != null) {
            wSEndpointReference = this.wsdlService.get(qName).getEPR();
        }
        return this.createDispatch(qName, wSEndpointReference, jAXBContext, mode, webServiceFeatureArray);
    }

    @Override
    public Dispatch<Object> createDispatch(EndpointReference endpointReference, JAXBContext jAXBContext, Service.Mode mode, WebServiceFeature ... webServiceFeatureArray) {
        WSEndpointReference wSEndpointReference = new WSEndpointReference(endpointReference);
        QName qName = this.addPortEpr(wSEndpointReference);
        return this.createDispatch(qName, wSEndpointReference, jAXBContext, mode, webServiceFeatureArray);
    }

    private QName addPortEpr(WSEndpointReference wSEndpointReference) {
        if (wSEndpointReference == null) {
            throw new WebServiceException(ProviderApiMessages.NULL_EPR());
        }
        QName qName = this.getPortNameFromEPR(wSEndpointReference, null);
        PortInfo portInfo = new PortInfo(this, wSEndpointReference.getAddress() == null ? null : EndpointAddress.create(wSEndpointReference.getAddress()), qName, this.getPortModel(this.wsdlService, qName).getBinding().getBindingId());
        if (!this.ports.containsKey(qName)) {
            this.ports.put(qName, portInfo);
        }
        return qName;
    }

    private QName getPortNameFromEPR(@NotNull WSEndpointReference wSEndpointReference, @Nullable QName qName) {
        QName qName2;
        Object object;
        WSEndpointReference.Metadata metadata = wSEndpointReference.getMetaData();
        QName qName3 = metadata.getServiceName();
        QName qName4 = metadata.getPortName();
        if (qName3 != null && !qName3.equals(this.serviceName)) {
            throw new WebServiceException("EndpointReference WSDL ServiceName differs from Service Instance WSDL Service QName.\n The two Service QNames must match");
        }
        if (this.wsdlService == null) {
            object = metadata.getWsdlSource();
            if (object == null) {
                throw new WebServiceException(ProviderApiMessages.NULL_WSDL());
            }
            try {
                WSDLModelImpl wSDLModelImpl = this.parseWSDL(new URL(wSEndpointReference.getAddress()), (Source)object);
                this.wsdlService = wSDLModelImpl.getService(this.serviceName);
                if (this.wsdlService == null) {
                    throw new WebServiceException(ClientMessages.INVALID_SERVICE_NAME(this.serviceName, this.buildNameList(wSDLModelImpl.getServices().keySet())));
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new WebServiceException(ClientMessages.INVALID_ADDRESS(wSEndpointReference.getAddress()));
            }
        }
        if ((qName2 = qName4) == null && qName != null) {
            object = this.wsdlService.getMatchingPort(qName);
            if (object == null) {
                throw new WebServiceException(ClientMessages.UNDEFINED_PORT_TYPE(qName));
            }
            qName2 = ((WSDLPortImpl)object).getName();
        }
        if (qName2 == null) {
            throw new WebServiceException(ProviderApiMessages.NULL_PORTNAME());
        }
        if (this.wsdlService.get(qName2) == null) {
            throw new WebServiceException(ClientMessages.INVALID_EPR_PORT_NAME(qName2, this.buildWsdlPortNames()));
        }
        return qName2;
    }

    private WSDLServiceImpl getWSDLModelfromSEI(final Class clazz) {
        WebService webService = AccessController.doPrivileged(new PrivilegedAction<WebService>(){

            @Override
            public WebService run() {
                return clazz.getAnnotation(WebService.class);
            }
        });
        if (webService == null || webService.wsdlLocation().equals("")) {
            return null;
        }
        String string = webService.wsdlLocation();
        string = JAXWSUtils.absolutize(JAXWSUtils.getFileOrURLName(string));
        StreamSource streamSource = new StreamSource(string);
        WSDLServiceImpl wSDLServiceImpl = null;
        try {
            URL uRL = streamSource.getSystemId() == null ? null : new URL(streamSource.getSystemId());
            WSDLModelImpl wSDLModelImpl = this.parseWSDL(uRL, streamSource);
            wSDLServiceImpl = wSDLModelImpl.getService(this.serviceName);
            if (wSDLServiceImpl == null) {
                throw new WebServiceException(ClientMessages.INVALID_SERVICE_NAME(this.serviceName, this.buildNameList(wSDLModelImpl.getServices().keySet())));
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new WebServiceException(ClientMessages.INVALID_WSDL_URL(streamSource.getSystemId()));
        }
        return wSDLServiceImpl;
    }

    @Override
    public QName getServiceName() {
        return this.serviceName;
    }

    protected Class getServiceClass() {
        return this.serviceClass;
    }

    @Override
    public Iterator<QName> getPorts() throws WebServiceException {
        if (this.ports.isEmpty()) {
            throw new WebServiceException("dii.service.no.wsdl.available");
        }
        return this.ports.keySet().iterator();
    }

    @Override
    public URL getWSDLDocumentLocation() {
        if (this.wsdlService == null) {
            return null;
        }
        try {
            return new URL(this.wsdlService.getParent().getLocation().getSystemId());
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
    }

    private <T> T createEndpointIFBaseProxy(@Nullable WSEndpointReference wSEndpointReference, QName qName, Class<T> clazz, WebServiceFeature[] webServiceFeatureArray, SEIPortInfo sEIPortInfo) {
        if (this.wsdlService == null) {
            throw new WebServiceException(ClientMessages.INVALID_SERVICE_NO_WSDL(this.serviceName));
        }
        if (this.wsdlService.get(qName) == null) {
            throw new WebServiceException(ClientMessages.INVALID_PORT_NAME(qName, this.buildWsdlPortNames()));
        }
        BindingImpl bindingImpl = sEIPortInfo.createBinding(webServiceFeatureArray, clazz);
        SEIStub sEIStub = new SEIStub(this, bindingImpl, sEIPortInfo.model, this.createPipeline(sEIPortInfo, bindingImpl), wSEndpointReference);
        T t = clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, WSBindingProvider.class, Closeable.class}, sEIStub));
        if (this.serviceInterceptor != null) {
            this.serviceInterceptor.postCreateProxy((WSBindingProvider)t, clazz);
        }
        return t;
    }

    private StringBuilder buildWsdlPortNames() {
        HashSet<QName> hashSet = new HashSet<QName>();
        for (WSDLPortImpl wSDLPortImpl : this.wsdlService.getPorts()) {
            hashSet.add(wSDLPortImpl.getName());
        }
        return this.buildNameList(hashSet);
    }

    @NotNull
    private WSDLPortImpl getPortModel(WSDLServiceImpl wSDLServiceImpl, QName qName) {
        WSDLPortImpl wSDLPortImpl = wSDLServiceImpl.get(qName);
        if (wSDLPortImpl == null) {
            throw new WebServiceException(ClientMessages.INVALID_PORT_NAME(qName, this.buildWsdlPortNames()));
        }
        return wSDLPortImpl;
    }

    private SEIPortInfo addSEI(QName qName, Class clazz, WebServiceFeature ... webServiceFeatureArray) throws WebServiceException {
        boolean bl = this.useOwnSEIModel(webServiceFeatureArray);
        if (bl) {
            return this.createSEIPortInfo(qName, clazz, webServiceFeatureArray);
        }
        SEIPortInfo sEIPortInfo = this.seiContext.get(qName);
        if (sEIPortInfo == null) {
            sEIPortInfo = this.createSEIPortInfo(qName, clazz, webServiceFeatureArray);
            this.seiContext.put(sEIPortInfo.portName, sEIPortInfo);
            this.ports.put(sEIPortInfo.portName, sEIPortInfo);
        }
        return sEIPortInfo;
    }

    private SEIPortInfo createSEIPortInfo(QName qName, Class clazz, WebServiceFeature ... webServiceFeatureArray) {
        WSDLPortImpl wSDLPortImpl = this.getPortModel(this.wsdlService, qName);
        RuntimeModeler runtimeModeler = new RuntimeModeler(clazz, this.serviceName, wSDLPortImpl, webServiceFeatureArray);
        runtimeModeler.setClassLoader(clazz.getClassLoader());
        runtimeModeler.setPortName(qName);
        AbstractSEIModelImpl abstractSEIModelImpl = runtimeModeler.buildRuntimeModel();
        return new SEIPortInfo(this, clazz, (SOAPSEIModel)abstractSEIModelImpl, wSDLPortImpl);
    }

    private boolean useOwnSEIModel(WebServiceFeature ... webServiceFeatureArray) {
        return WebServiceFeatureList.getFeature(webServiceFeatureArray, UsesJAXBContextFeature.class) != null;
    }

    public WSDLServiceImpl getWsdlService() {
        return this.wsdlService;
    }

    class DaemonThreadFactory
    implements ThreadFactory {
        DaemonThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(Boolean.TRUE);
            return thread;
        }
    }
}

