/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.AlphaComposite;
import java.awt.Composite;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.MaskBlit;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.RenderQueue;

public abstract class BufferedMaskBlit
extends MaskBlit {
    private static final int ST_INT_ARGB = 0;
    private static final int ST_INT_ARGB_PRE = 1;
    private static final int ST_INT_RGB = 2;
    private static final int ST_INT_BGR = 3;
    private final RenderQueue rq;
    private final int srcTypeVal;
    private Blit blitop;

    protected BufferedMaskBlit(RenderQueue renderQueue, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        super(surfaceType, compositeType, surfaceType2);
        this.rq = renderQueue;
        if (surfaceType == SurfaceType.IntArgb) {
            this.srcTypeVal = 0;
        } else if (surfaceType == SurfaceType.IntArgbPre) {
            this.srcTypeVal = 1;
        } else if (surfaceType == SurfaceType.IntRgb) {
            this.srcTypeVal = 2;
        } else if (surfaceType == SurfaceType.IntBgr) {
            this.srcTypeVal = 3;
        } else {
            throw new InternalError("unrecognized source surface type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MaskBlit(SurfaceData surfaceData, SurfaceData surfaceData2, Composite composite, Region region, int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray, int n7, int n8) {
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        if (byArray == null) {
            if (this.blitop == null) {
                this.blitop = Blit.getFromCache(surfaceData.getSurfaceType(), CompositeType.AnyAlpha, this.getDestType());
            }
            this.blitop.Blit(surfaceData, surfaceData2, composite, region, n, n2, n3, n4, n5, n6);
            return;
        }
        AlphaComposite alphaComposite = (AlphaComposite)composite;
        if (alphaComposite.getRule() != 3) {
            composite = AlphaComposite.SrcOver;
        }
        this.rq.lock();
        try {
            this.validateContext(surfaceData2, composite, region);
            RenderBuffer renderBuffer = this.rq.getBuffer();
            int n9 = 20 + n5 * n6 * 4;
            this.rq.ensureCapacity(n9);
            int n10 = this.enqueueTile(renderBuffer.getAddress(), renderBuffer.position(), surfaceData, surfaceData.getNativeOps(), this.srcTypeVal, byArray, byArray.length, n7, n8, n, n2, n3, n4, n5, n6);
            renderBuffer.position(n10);
        }
        finally {
            this.rq.unlock();
        }
    }

    private native int enqueueTile(long var1, int var3, SurfaceData var4, long var5, int var7, byte[] var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17);

    protected abstract void validateContext(SurfaceData var1, Composite var2, Region var3);
}

