/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.message;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.bind.marshaller.SAX2DOMEx;
import com.sun.xml.internal.ws.addressing.WsaTubeHelper;
import com.sun.xml.internal.ws.addressing.model.InvalidAddressingHeaderException;
import com.sun.xml.internal.ws.api.DistributedPropertySet;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.PropertySet;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.server.TransportBackChannel;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.internal.ws.client.ContentNegotiation;
import com.sun.xml.internal.ws.client.HandlerConfiguration;
import com.sun.xml.internal.ws.message.RelatesToHeader;
import com.sun.xml.internal.ws.message.StringHeader;
import com.sun.xml.internal.ws.util.DOMUtil;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Packet
extends DistributedPropertySet {
    private Message message;
    public boolean wasTransportSecure;
    public static final String INBOUND_TRANSPORT_HEADERS = "com.sun.xml.internal.ws.api.message.packet.inbound.transport.headers";
    public static final String OUTBOUND_TRANSPORT_HEADERS = "com.sun.xml.internal.ws.api.message.packet.outbound.transport.headers";
    @PropertySet.Property(value={"com.sun.xml.internal.ws.handler.config"})
    public HandlerConfiguration handlerConfig;
    @PropertySet.Property(value={"com.sun.xml.internal.ws.client.handle"})
    public BindingProvider proxy;
    public EndpointAddress endpointAddress;
    public ContentNegotiation contentNegotiation;
    public String acceptableMimeTypes;
    public WebServiceContextDelegate webServiceContextDelegate;
    @Nullable
    public TransportBackChannel transportBackChannel;
    @PropertySet.Property(value={"com.sun.xml.internal.ws.api.server.WSEndpoint"})
    public WSEndpoint endpoint;
    @PropertySet.Property(value={"javax.xml.ws.soap.http.soapaction.uri"})
    public String soapAction;
    @PropertySet.Property(value={"com.sun.xml.internal.ws.server.OneWayOperation"})
    public Boolean expectReply;
    @Deprecated
    public Boolean isOneWay;
    private Set<String> handlerScopePropertyNames;
    public final Map<String, Object> invocationProperties;
    private static final PropertySet.PropertyMap model = Packet.parse(Packet.class);

    public Packet(Message message) {
        this();
        this.message = message;
    }

    public Packet() {
        this.invocationProperties = new HashMap<String, Object>();
    }

    private Packet(Packet packet) {
        packet.copySatelliteInto(this);
        this.handlerConfig = packet.handlerConfig;
        this.invocationProperties = packet.invocationProperties;
        this.handlerScopePropertyNames = packet.handlerScopePropertyNames;
        this.contentNegotiation = packet.contentNegotiation;
        this.wasTransportSecure = packet.wasTransportSecure;
        this.endpointAddress = packet.endpointAddress;
    }

    public Packet copy(boolean bl) {
        Packet packet = new Packet(this);
        if (bl) {
            packet.message = this.message.copy();
        }
        return packet;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    @PropertySet.Property(value={"javax.xml.ws.service.endpoint.address"})
    public String getEndPointAddressString() {
        if (this.endpointAddress == null) {
            return null;
        }
        return this.endpointAddress.toString();
    }

    public void setEndPointAddressString(String string) {
        this.endpointAddress = string == null ? null : EndpointAddress.create(string);
    }

    @PropertySet.Property(value={"com.sun.xml.internal.ws.client.ContentNegotiation"})
    public String getContentNegotiationString() {
        return this.contentNegotiation != null ? this.contentNegotiation.toString() : null;
    }

    public void setContentNegotiationString(String string) {
        if (string == null) {
            this.contentNegotiation = null;
        } else {
            try {
                this.contentNegotiation = ContentNegotiation.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.contentNegotiation = ContentNegotiation.none;
            }
        }
    }

    @PropertySet.Property(value={"javax.xml.ws.reference.parameters"})
    @NotNull
    public List<Element> getReferenceParameters() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        HeaderList headerList = this.message.getHeaders();
        for (Header header : headerList) {
            String string = header.getAttribute(AddressingVersion.W3C.nsUri, "IsReferenceParameter");
            if (string == null || !string.equals("true") && !string.equals("1")) continue;
            Document document = DOMUtil.createDom();
            SAX2DOMEx sAX2DOMEx = new SAX2DOMEx(document);
            try {
                header.writeTo(sAX2DOMEx, XmlUtil.DRACONIAN_ERROR_HANDLER);
                arrayList.add((Element)document.getLastChild());
            }
            catch (SAXException sAXException) {
                throw new WebServiceException(sAXException);
            }
        }
        return arrayList;
    }

    @PropertySet.Property(value={"com.sun.xml.internal.ws.api.message.HeaderList"})
    HeaderList getHeaderList() {
        if (this.message == null) {
            return null;
        }
        return this.message.getHeaders();
    }

    public TransportBackChannel keepTransportBackChannelOpen() {
        TransportBackChannel transportBackChannel = this.transportBackChannel;
        this.transportBackChannel = null;
        return transportBackChannel;
    }

    public final Set<String> getHandlerScopePropertyNames(boolean bl) {
        Set<String> set = this.handlerScopePropertyNames;
        if (set == null) {
            if (bl) {
                return Collections.emptySet();
            }
            this.handlerScopePropertyNames = set = new HashSet<String>();
        }
        return set;
    }

    public final Set<String> getApplicationScopePropertyNames(boolean bl) {
        assert (false);
        return new HashSet<String>();
    }

    @Deprecated
    public Packet createResponse(Message message) {
        Packet packet = new Packet(this);
        packet.setMessage(message);
        return packet;
    }

    public Packet createClientResponse(Message message) {
        Packet packet = new Packet(this);
        packet.setMessage(message);
        return packet;
    }

    public Packet createServerResponse(@Nullable Message message, @Nullable WSDLPort wSDLPort, @Nullable SEIModel sEIModel, @NotNull WSBinding wSBinding) {
        Packet packet = this.createClientResponse(message);
        AddressingVersion addressingVersion = wSBinding.getAddressingVersion();
        if (addressingVersion == null) {
            return packet;
        }
        String string = this.getMessage().getHeaders().getAction(addressingVersion, wSBinding.getSOAPVersion());
        if (string == null) {
            return packet;
        }
        if (message == null || wSDLPort != null && this.message.isOneWay(wSDLPort)) {
            return packet;
        }
        this.populateAddressingHeaders(wSBinding, packet, wSDLPort, sEIModel);
        return packet;
    }

    public Packet createServerResponse(@Nullable Message message, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion, @NotNull String string) {
        Packet packet = this.createClientResponse(message);
        if (addressingVersion == null) {
            return packet;
        }
        String string2 = this.getMessage().getHeaders().getAction(addressingVersion, sOAPVersion);
        if (string2 == null) {
            return packet;
        }
        this.populateAddressingHeaders(packet, addressingVersion, sOAPVersion, string);
        return packet;
    }

    public void setResponseMessage(@NotNull Packet packet, @Nullable Message message, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion, @NotNull String string) {
        Packet packet2 = packet.createServerResponse(message, addressingVersion, sOAPVersion, string);
        this.setMessage(packet2.getMessage());
    }

    private void populateAddressingHeaders(Packet packet, AddressingVersion addressingVersion, SOAPVersion sOAPVersion, String string) {
        WSEndpointReference wSEndpointReference;
        WSEndpointReference wSEndpointReference2;
        if (addressingVersion == null) {
            return;
        }
        if (packet.getMessage() == null) {
            return;
        }
        HeaderList headerList = packet.getMessage().getHeaders();
        try {
            wSEndpointReference2 = this.message.getHeaders().getReplyTo(addressingVersion, sOAPVersion);
            if (wSEndpointReference2 != null) {
                headerList.add(new StringHeader(addressingVersion.toTag, wSEndpointReference2.getAddress()));
            }
        }
        catch (InvalidAddressingHeaderException invalidAddressingHeaderException) {
            wSEndpointReference2 = null;
        }
        if (packet.getMessage().getHeaders().getAction(addressingVersion, sOAPVersion) == null) {
            headerList.add(new StringHeader(addressingVersion.actionTag, string));
        }
        headerList.add(new StringHeader(addressingVersion.messageIDTag, packet.getMessage().getID(addressingVersion, sOAPVersion)));
        String string2 = this.getMessage().getHeaders().getMessageID(addressingVersion, sOAPVersion);
        if (string2 != null) {
            headerList.add(new RelatesToHeader(addressingVersion.relatesToTag, string2));
        }
        if (packet.getMessage().isFault()) {
            wSEndpointReference = this.message.getHeaders().getFaultTo(addressingVersion, sOAPVersion);
            if (wSEndpointReference == null) {
                wSEndpointReference = wSEndpointReference2;
            }
        } else {
            wSEndpointReference = wSEndpointReference2;
        }
        if (wSEndpointReference != null) {
            wSEndpointReference.addReferenceParameters(headerList);
        }
    }

    private void populateAddressingHeaders(WSBinding wSBinding, Packet packet, WSDLPort wSDLPort, SEIModel sEIModel) {
        AddressingVersion addressingVersion = wSBinding.getAddressingVersion();
        if (addressingVersion == null) {
            return;
        }
        WsaTubeHelper wsaTubeHelper = addressingVersion.getWsaHelper(wSDLPort, sEIModel, wSBinding);
        String string = packet.message.isFault() ? wsaTubeHelper.getFaultAction(this, packet) : wsaTubeHelper.getOutputAction(this);
        this.populateAddressingHeaders(packet, addressingVersion, wSBinding.getSOAPVersion(), string);
    }

    @Override
    protected PropertySet.PropertyMap getPropertyMap() {
        return model;
    }
}

