/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.io.IOException;
import java.io.Reader;

class CSSParser {
    private static final int IDENTIFIER = 1;
    private static final int BRACKET_OPEN = 2;
    private static final int BRACKET_CLOSE = 3;
    private static final int BRACE_OPEN = 4;
    private static final int BRACE_CLOSE = 5;
    private static final int PAREN_OPEN = 6;
    private static final int PAREN_CLOSE = 7;
    private static final int END = -1;
    private static final char[] charMapping = new char[]{'\u0000', '\u0000', '[', ']', '{', '}', '(', ')', '\u0000'};
    private boolean didPushChar;
    private int pushedChar;
    private StringBuffer unitBuffer;
    private int[] unitStack = new int[2];
    private int stackCount;
    private Reader reader;
    private boolean encounteredRuleSet;
    private CSSParserCallback callback;
    private char[] tokenBuffer = new char[80];
    private int tokenBufferLength;
    private boolean readWS;

    CSSParser() {
        this.unitBuffer = new StringBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse(Reader reader, CSSParserCallback cSSParserCallback, boolean bl) throws IOException {
        this.callback = cSSParserCallback;
        this.tokenBufferLength = 0;
        this.stackCount = 0;
        this.reader = reader;
        this.encounteredRuleSet = false;
        try {
            if (bl) {
                this.parseDeclarationBlock();
            } else {
                while (this.getNextStatement()) {
                }
            }
        }
        finally {
            cSSParserCallback = null;
            reader = null;
        }
    }

    private boolean getNextStatement() throws IOException {
        this.unitBuffer.setLength(0);
        int n = this.nextToken('\u0000');
        switch (n) {
            case 1: {
                if (this.tokenBufferLength > 0) {
                    if (this.tokenBuffer[0] == '@') {
                        this.parseAtRule();
                    } else {
                        this.encounteredRuleSet = true;
                        this.parseRuleSet();
                    }
                }
                return true;
            }
            case 2: 
            case 4: 
            case 6: {
                this.parseTillClosed(n);
                return true;
            }
            case 3: 
            case 5: 
            case 7: {
                throw new RuntimeException("Unexpected top level block close");
            }
            case -1: {
                return false;
            }
        }
        return true;
    }

    private void parseAtRule() throws IOException {
        boolean bl = false;
        boolean bl2 = this.tokenBufferLength == 7 && this.tokenBuffer[0] == '@' && this.tokenBuffer[1] == 'i' && this.tokenBuffer[2] == 'm' && this.tokenBuffer[3] == 'p' && this.tokenBuffer[4] == 'o' && this.tokenBuffer[5] == 'r' && this.tokenBuffer[6] == 't';
        this.unitBuffer.setLength(0);
        block7: while (!bl) {
            int n = this.nextToken(';');
            switch (n) {
                case 1: {
                    if (this.tokenBufferLength > 0 && this.tokenBuffer[this.tokenBufferLength - 1] == ';') {
                        --this.tokenBufferLength;
                        bl = true;
                    }
                    if (this.tokenBufferLength <= 0) break;
                    if (this.unitBuffer.length() > 0 && this.readWS) {
                        this.unitBuffer.append(' ');
                    }
                    this.unitBuffer.append(this.tokenBuffer, 0, this.tokenBufferLength);
                    break;
                }
                case 4: {
                    if (this.unitBuffer.length() > 0 && this.readWS) {
                        this.unitBuffer.append(' ');
                    }
                    this.unitBuffer.append(charMapping[n]);
                    this.parseTillClosed(n);
                    bl = true;
                    int n2 = this.readWS();
                    if (n2 == -1 || n2 == 59) continue block7;
                    this.pushChar(n2);
                    break;
                }
                case 2: 
                case 6: {
                    this.unitBuffer.append(charMapping[n]);
                    this.parseTillClosed(n);
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    throw new RuntimeException("Unexpected close in @ rule");
                }
                case -1: {
                    bl = true;
                }
            }
        }
        if (bl2 && !this.encounteredRuleSet) {
            this.callback.handleImport(this.unitBuffer.toString());
        }
    }

    private void parseRuleSet() throws IOException {
        if (this.parseSelectors()) {
            this.callback.startRule();
            this.parseDeclarationBlock();
            this.callback.endRule();
        }
    }

    private boolean parseSelectors() throws IOException {
        if (this.tokenBufferLength > 0) {
            this.callback.handleSelector(new String(this.tokenBuffer, 0, this.tokenBufferLength));
        }
        this.unitBuffer.setLength(0);
        while (true) {
            int n;
            if ((n = this.nextToken('\u0000')) == 1) {
                if (this.tokenBufferLength <= 0) continue;
                this.callback.handleSelector(new String(this.tokenBuffer, 0, this.tokenBufferLength));
                continue;
            }
            switch (n) {
                case 4: {
                    return true;
                }
                case 2: 
                case 6: {
                    this.parseTillClosed(n);
                    this.unitBuffer.setLength(0);
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    throw new RuntimeException("Unexpected block close in selector");
                }
                case -1: {
                    return false;
                }
            }
        }
    }

    private void parseDeclarationBlock() throws IOException {
        while (true) {
            int n = this.parseDeclaration();
            switch (n) {
                case -1: 
                case 5: {
                    return;
                }
                case 3: 
                case 7: {
                    throw new RuntimeException("Unexpected close in declaration block");
                }
            }
        }
    }

    private int parseDeclaration() throws IOException {
        int n = this.parseIdentifiers(':', false);
        if (n != 1) {
            return n;
        }
        for (int i = this.unitBuffer.length() - 1; i >= 0; --i) {
            this.unitBuffer.setCharAt(i, Character.toLowerCase(this.unitBuffer.charAt(i)));
        }
        this.callback.handleProperty(this.unitBuffer.toString());
        n = this.parseIdentifiers(';', true);
        this.callback.handleValue(this.unitBuffer.toString());
        return n;
    }

    private int parseIdentifiers(char c, boolean bl) throws IOException {
        this.unitBuffer.setLength(0);
        while (true) {
            int n = this.nextToken(c);
            switch (n) {
                case 1: {
                    if (this.tokenBufferLength <= 0) break;
                    if (this.tokenBuffer[this.tokenBufferLength - 1] == c) {
                        if (--this.tokenBufferLength > 0) {
                            if (this.readWS && this.unitBuffer.length() > 0) {
                                this.unitBuffer.append(' ');
                            }
                            this.unitBuffer.append(this.tokenBuffer, 0, this.tokenBufferLength);
                        }
                        return 1;
                    }
                    if (this.readWS && this.unitBuffer.length() > 0) {
                        this.unitBuffer.append(' ');
                    }
                    this.unitBuffer.append(this.tokenBuffer, 0, this.tokenBufferLength);
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    int n2 = this.unitBuffer.length();
                    if (bl) {
                        this.unitBuffer.append(charMapping[n]);
                    }
                    this.parseTillClosed(n);
                    if (bl) break;
                    this.unitBuffer.setLength(n2);
                    break;
                }
                case -1: 
                case 3: 
                case 5: 
                case 7: {
                    return n;
                }
            }
        }
    }

    private void parseTillClosed(int n) throws IOException {
        boolean bl = false;
        this.startBlock(n);
        while (!bl) {
            int n2 = this.nextToken('\u0000');
            switch (n2) {
                case 1: {
                    if (this.unitBuffer.length() > 0 && this.readWS) {
                        this.unitBuffer.append(' ');
                    }
                    if (this.tokenBufferLength <= 0) break;
                    this.unitBuffer.append(this.tokenBuffer, 0, this.tokenBufferLength);
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    if (this.unitBuffer.length() > 0 && this.readWS) {
                        this.unitBuffer.append(' ');
                    }
                    this.unitBuffer.append(charMapping[n2]);
                    this.startBlock(n2);
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    if (this.unitBuffer.length() > 0 && this.readWS) {
                        this.unitBuffer.append(' ');
                    }
                    this.unitBuffer.append(charMapping[n2]);
                    this.endBlock(n2);
                    if (this.inBlock()) break;
                    bl = true;
                    break;
                }
                case -1: {
                    throw new RuntimeException("Unclosed block");
                }
            }
        }
    }

    private int nextToken(char c) throws IOException {
        this.readWS = false;
        int n = this.readWS();
        switch (n) {
            case 39: {
                this.readTill('\'');
                if (this.tokenBufferLength > 0) {
                    --this.tokenBufferLength;
                }
                return 1;
            }
            case 34: {
                this.readTill('\"');
                if (this.tokenBufferLength > 0) {
                    --this.tokenBufferLength;
                }
                return 1;
            }
            case 91: {
                return 2;
            }
            case 93: {
                return 3;
            }
            case 123: {
                return 4;
            }
            case 125: {
                return 5;
            }
            case 40: {
                return 6;
            }
            case 41: {
                return 7;
            }
            case -1: {
                return -1;
            }
        }
        this.pushChar(n);
        this.getIdentifier(c);
        return 1;
    }

    private boolean getIdentifier(char c) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        char c2 = c;
        int n3 = 0;
        this.tokenBufferLength = 0;
        while (!bl2) {
            int n4;
            int n5 = this.readChar();
            switch (n5) {
                case 92: {
                    n4 = 1;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    n4 = 2;
                    n3 = n5 - 48;
                    break;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    n4 = 2;
                    n3 = n5 - 97 + 10;
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    n4 = 2;
                    n3 = n5 - 65 + 10;
                    break;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 34: 
                case 39: 
                case 40: 
                case 41: 
                case 91: 
                case 93: 
                case 123: 
                case 125: {
                    n4 = 3;
                    break;
                }
                case 47: {
                    n4 = 4;
                    break;
                }
                case -1: {
                    bl2 = true;
                    n4 = 0;
                    break;
                }
                default: {
                    n4 = 0;
                }
            }
            if (bl) {
                if (n4 == 2) {
                    n2 = n2 * 16 + n3;
                    if (++n != 4) continue;
                    bl = false;
                    this.append((char)n2);
                    continue;
                }
                bl = false;
                if (n > 0) {
                    this.append((char)n2);
                    this.pushChar(n5);
                    continue;
                }
                if (bl2) continue;
                this.append((char)n5);
                continue;
            }
            if (bl2) continue;
            if (n4 == 1) {
                bl = true;
                n = 0;
                n2 = 0;
                continue;
            }
            if (n4 == 3) {
                bl2 = true;
                this.pushChar(n5);
                continue;
            }
            if (n4 == 4) {
                n5 = this.readChar();
                if (n5 == 42) {
                    bl2 = true;
                    this.readComment();
                    this.readWS = true;
                    continue;
                }
                this.append('/');
                if (n5 == -1) {
                    bl2 = true;
                    continue;
                }
                this.pushChar(n5);
                continue;
            }
            this.append((char)n5);
            if (n5 != c2) continue;
            bl2 = true;
        }
        return this.tokenBufferLength > 0;
    }

    private void readTill(char c) throws IOException {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        char c2 = c;
        int n3 = 0;
        this.tokenBufferLength = 0;
        while (!bl2) {
            int n4;
            int n5 = this.readChar();
            switch (n5) {
                case 92: {
                    n4 = 1;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    n4 = 2;
                    n3 = n5 - 48;
                    break;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    n4 = 2;
                    n3 = n5 - 97 + 10;
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    n4 = 2;
                    n3 = n5 - 65 + 10;
                    break;
                }
                case -1: {
                    throw new RuntimeException("Unclosed " + c);
                }
                default: {
                    n4 = 0;
                }
            }
            if (bl) {
                if (n4 == 2) {
                    n2 = n2 * 16 + n3;
                    if (++n != 4) continue;
                    bl = false;
                    this.append((char)n2);
                    continue;
                }
                if (n > 0) {
                    this.append((char)n2);
                    if (n4 == 1) {
                        bl = true;
                        n = 0;
                        n2 = 0;
                        continue;
                    }
                    if (n5 == c2) {
                        bl2 = true;
                    }
                    this.append((char)n5);
                    bl = false;
                    continue;
                }
                this.append((char)n5);
                bl = false;
                continue;
            }
            if (n4 == 1) {
                bl = true;
                n = 0;
                n2 = 0;
                continue;
            }
            if (n5 == c2) {
                bl2 = true;
            }
            this.append((char)n5);
        }
    }

    private void append(char c) {
        if (this.tokenBufferLength == this.tokenBuffer.length) {
            char[] cArray = new char[this.tokenBuffer.length * 2];
            System.arraycopy(this.tokenBuffer, 0, cArray, 0, this.tokenBuffer.length);
            this.tokenBuffer = cArray;
        }
        this.tokenBuffer[this.tokenBufferLength++] = c;
    }

    private void readComment() throws IOException {
        block4: while (true) {
            int n = this.readChar();
            switch (n) {
                case -1: {
                    throw new RuntimeException("Unclosed comment");
                }
                case 42: {
                    n = this.readChar();
                    if (n == 47) {
                        return;
                    }
                    if (n == -1) {
                        throw new RuntimeException("Unclosed comment");
                    }
                    this.pushChar(n);
                    continue block4;
                }
            }
        }
    }

    private void startBlock(int n) {
        if (this.stackCount == this.unitStack.length) {
            int[] nArray = new int[this.stackCount * 2];
            System.arraycopy(this.unitStack, 0, nArray, 0, this.stackCount);
            this.unitStack = nArray;
        }
        this.unitStack[this.stackCount++] = n;
    }

    private void endBlock(int n) {
        int n2;
        switch (n) {
            case 3: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 4;
                break;
            }
            case 7: {
                n2 = 6;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        if (this.stackCount > 0 && this.unitStack[this.stackCount - 1] == n2) {
            --this.stackCount;
        } else {
            throw new RuntimeException("Unmatched block");
        }
    }

    private boolean inBlock() {
        return this.stackCount > 0;
    }

    private int readWS() throws IOException {
        int n;
        while ((n = this.readChar()) != -1 && Character.isWhitespace((char)n)) {
            this.readWS = true;
        }
        return n;
    }

    private int readChar() throws IOException {
        if (this.didPushChar) {
            this.didPushChar = false;
            return this.pushedChar;
        }
        return this.reader.read();
    }

    private void pushChar(int n) {
        if (this.didPushChar) {
            throw new RuntimeException("Can not handle look ahead of more than one character");
        }
        this.didPushChar = true;
        this.pushedChar = n;
    }

    static interface CSSParserCallback {
        public void handleImport(String var1);

        public void handleSelector(String var1);

        public void startRule();

        public void handleProperty(String var1);

        public void handleValue(String var1);

        public void endRule();
    }
}

