/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityRuntimeException;
import com.sun.org.apache.xml.internal.security.signature.NodeFilter;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.utils.CachedXPathAPIHolder;
import com.sun.org.apache.xml.internal.security.utils.CachedXPathFuncHereAPI;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.utils.PrefixResolverDefault;
import com.sun.org.apache.xpath.internal.objects.XObject;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransformXPath
extends TransformSpi {
    static Logger log = Logger.getLogger(TransformXPath.class.getName());
    public static final String implementedTransformURI = "http://www.w3.org/TR/1999/REC-xpath-19991116";

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput) throws TransformationException {
        try {
            CachedXPathAPIHolder.setDoc(this._transformObject.getElement().getOwnerDocument());
            Element element = XMLUtils.selectDsNode(this._transformObject.getElement().getFirstChild(), "XPath", 0);
            if (element == null) {
                Object[] objectArray = new Object[]{"ds:XPath", "Transform"};
                throw new TransformationException("xml.WrongContent", objectArray);
            }
            Node node = element.getChildNodes().item(0);
            String string = CachedXPathFuncHereAPI.getStrFromNode(node);
            xMLSignatureInput.setNeedsToBeExpanded(this.needsCircunvent(string));
            if (node == null) {
                throw new DOMException(3, "Text must be in ds:Xpath");
            }
            xMLSignatureInput.addNodeFilter(new XPathNodeFilter(element, node, string));
            xMLSignatureInput.setNodeSet(true);
            return xMLSignatureInput;
        }
        catch (DOMException dOMException) {
            throw new TransformationException("empty", dOMException);
        }
    }

    private boolean needsCircunvent(String string) {
        return true;
    }

    class XPathNodeFilter
    implements NodeFilter {
        PrefixResolverDefault prefixResolver;
        CachedXPathFuncHereAPI xPathFuncHereAPI = new CachedXPathFuncHereAPI(CachedXPathAPIHolder.getCachedXPathAPI());
        Node xpathnode;
        String str;

        XPathNodeFilter(Element element, Node node, String string) {
            this.xpathnode = node;
            this.str = string;
            this.prefixResolver = new PrefixResolverDefault(element);
        }

        public boolean isNodeInclude(Node node) {
            try {
                XObject xObject = this.xPathFuncHereAPI.eval(node, this.xpathnode, this.str, this.prefixResolver);
                return xObject.bool();
            }
            catch (TransformerException transformerException) {
                Object[] objectArray = new Object[]{node};
                throw new XMLSecurityRuntimeException("signature.Transform.node", objectArray, transformerException);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{node, new Short(node.getNodeType())};
                throw new XMLSecurityRuntimeException("signature.Transform.nodeAndType", objectArray, exception);
            }
        }
    }
}

