/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.jvm;

import com.sun.deploy.config.Config;
import com.sun.deploy.perf.DefaultPerfHelper;
import com.sun.deploy.perf.DeployPerfUtil;
import com.sun.deploy.perf.PerfHelper;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.SystemUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.plugin2.jvm.JVMEventListener;
import sun.plugin2.util.SystemUtil;

public class JVMLauncher {
    private static final boolean DEBUG = SystemUtil.getenv("JPI_PLUGIN2_DEBUG") != null;
    private long startTimeUserClick;
    private String javaHome;
    private JVMParameters params;
    private Process process;
    private volatile boolean exited;
    private int exitCode = -1;
    private Exception error;
    private List listeners = new ArrayList();

    public JVMLauncher(long l, String string, JVMParameters jVMParameters) {
        this.startTimeUserClick = l;
        this.javaHome = string;
        this.params = jVMParameters;
    }

    public synchronized void addJVMEventListener(JVMEventListener jVMEventListener) {
        this.listeners.add(jVMEventListener);
    }

    public void start() {
        Object object;
        int n;
        String[] stringArray;
        List list;
        Object object2;
        long l = SystemUtils.microTime();
        if (DEBUG) {
            System.out.println("JVMLauncher.start(): now - user.startApplet(): " + (l - this.startTimeUserClick) + " us");
        }
        if (DeployPerfUtil.isEnabled()) {
            DeployPerfUtil.initialize((PerfHelper)new DefaultPerfHelper(this.startTimeUserClick));
        }
        long l2 = DeployPerfUtil.put((long)0L, (String)"JVMLauncher.start() - BEGIN");
        String string = "-D__jvm_launched=" + l;
        int n2 = Config.getMaxCommandLineLength();
        String string2 = this.findJava();
        if (string2 == null) {
            throw new RuntimeException("Unable to locate the java launcher in java.home \"" + this.javaHome + "\"");
        }
        this.exited = false;
        this.error = null;
        if (SystemUtil.isWindowsVista()) {
            object2 = this.findPlugin2VistaLauncher();
            if (object2 == null) {
                throw new RuntimeException("Unable to locate the Java Plug-In's custom launcher for Windows Vista in java.home \"" + System.getProperty("java.home") + "\"");
            }
            n2 -= ((String)object2).length() + 1;
            n2 -= this.javaHome.length() + 1;
            list = this.params.getCommandLineArguments(true, true, true, true, n2 -= string.length() + 1);
            list.add(0, object2);
            list.add(1, this.javaHome);
            list.add(2, string);
        } else {
            int n3;
            n2 -= string2.length() + 1;
            list = this.params.getCommandLineArguments(false, true, true, true, n2 -= string.length() + 1);
            String string3 = null;
            stringArray = list.iterator();
            n = list.size();
            for (n3 = 0; n3 < n && JVMParameters.isJVMCommandLineArgument((String)(string3 = (String)stringArray.next())); ++n3) {
            }
            if (n3 == n) {
                this.exited = true;
                this.error = new RuntimeException("Invalid arguments: no main class found");
                this.fireJVMExited();
                return;
            }
            if (string3 != null && !string3.equals("sun.plugin2.main.client.PluginMain")) {
                this.exited = true;
                this.error = new RuntimeException("Invalid arguments: PluginMain main class not found");
                this.fireJVMExited();
                return;
            }
            list.add(0, string2);
            list.add(1, string);
        }
        DeployPerfUtil.put((String)"JVMLauncher.start() - post param parsing");
        if (DEBUG) {
            object2 = null;
            n = 0;
            object = list.iterator();
            int n4 = list.size();
            for (int i = 0; i < n4; ++i) {
                object2 = (String)object.next();
                n += ((String)object2).length() + 1;
                System.out.println("JVMLauncher.processArg[" + i + "]: " + (String)object2);
            }
            System.out.println("JVMLauncher.processArgs total len: " + n + ", custArgsMaxLen: " + n2);
        }
        DeployPerfUtil.put((String)"JVMLauncher.start() - pre ProcessBuilder cstr");
        object2 = new ProcessBuilder(list);
        DeployPerfUtil.put((String)"JVMLauncher.start() - post ProcessBuilder cstr");
        Map<String, String> map = ((ProcessBuilder)object2).environment();
        DeployPerfUtil.put((String)"JVMLauncher.start() - post ProcessBuilder env mapping");
        String string4 = map.get("LD_LIBRARY_PATH");
        if (string4 != null) {
            stringArray = string4.split(File.pathSeparator);
            object = Config.getJREHome();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith((String)object)) continue;
                stringArray[i] = null;
            }
            String string5 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                string5 = string5 == null ? stringArray[i] : string5 + File.pathSeparator + stringArray[i];
            }
            map.put("LD_LIBRARY_PATH", string5);
        }
        DeployPerfUtil.put((String)"JVMLauncher.start() - post ProcessBuilder env LD_LIBRARY_PATH");
        map.remove("CLASSPATH");
        DeployPerfUtil.put((String)"JVMLauncher.start() - post ProcessBuilder env cleanup ");
        try {
            DeployPerfUtil.put((String)"JVMLauncher.start() - pre process start ");
            this.process = ((ProcessBuilder)object2).start();
            DeployPerfUtil.put((String)"JVMLauncher.start() - post process start ");
            new Thread(new JVMWatcher()).start();
        }
        catch (Exception exception) {
            this.exited = true;
            this.error = exception;
        }
        DeployPerfUtil.put((long)l2, (String)"JVMLauncher.start() - END");
    }

    public JVMParameters getParameters() {
        return this.params;
    }

    public void clearUserArguments() {
        this.params.clearUserArguments();
    }

    public boolean exited() {
        return this.exited;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public Exception getErrorDuringStartup() {
        return this.error;
    }

    public void destroy() {
        this.process.destroy();
    }

    public InputStream getInputStream() {
        return this.process.getInputStream();
    }

    public InputStream getErrorStream() {
        return this.process.getErrorStream();
    }

    private String findJava() {
        String string = SystemUtil.formatExecutableName("java");
        String string2 = this.javaHome + File.separator + "bin" + File.separator + string;
        if (new File(string2).exists()) {
            return string2;
        }
        string2 = this.javaHome + File.separator + "jre" + File.separator + "bin" + File.separator + string;
        if (new File(string2).exists()) {
            return string2;
        }
        return null;
    }

    private String findPlugin2VistaLauncher() {
        String string = System.getProperty("java.home");
        String string2 = "jp2launcher.exe";
        String string3 = string + File.separator + "bin" + File.separator + string2;
        if (new File(string3).exists()) {
            return string3;
        }
        string3 = string + File.separator + "jre" + File.separator + "bin" + File.separator + string2;
        if (new File(string3).exists()) {
            return string3;
        }
        return null;
    }

    private synchronized List copyListeners() {
        return (List)((ArrayList)this.listeners).clone();
    }

    private void fireJVMExited() {
        Iterator iterator = this.copyListeners().iterator();
        while (iterator.hasNext()) {
            JVMEventListener jVMEventListener = (JVMEventListener)iterator.next();
            jVMEventListener.jvmExited(this);
        }
    }

    class JVMWatcher
    implements Runnable {
        JVMWatcher() {
        }

        public void run() {
            boolean bl = false;
            while (!bl) {
                try {
                    JVMLauncher.this.exitCode = JVMLauncher.this.process.waitFor();
                    bl = true;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            JVMLauncher.this.exited = true;
            JVMLauncher.this.fireJVMExited();
        }
    }
}

