/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.FactoryURLClassLoader;
import java.net.JarURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import sun.misc.JavaNetAccess;
import sun.misc.Resource;
import sun.misc.SharedSecrets;
import sun.misc.URLClassPath;
import sun.net.www.ParseUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLClassLoader
extends SecureClassLoader {
    URLClassPath ucp;
    private AccessControlContext acc;
    private static final Method defineClassNoVerifyMethod;

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.ucp = new URLClassPath(uRLArray);
        this.acc = AccessController.getContext();
    }

    public URLClassLoader(URL[] uRLArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.ucp = new URLClassPath(uRLArray);
        this.acc = AccessController.getContext();
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.ucp = new URLClassPath(uRLArray, uRLStreamHandlerFactory);
        this.acc = AccessController.getContext();
    }

    protected void addURL(URL uRL) {
        this.ucp.addURL(uRL);
    }

    public URL[] getURLs() {
        return this.ucp.getURLs();
    }

    @Override
    protected Class<?> findClass(final String string) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    String string2 = string.replace('.', '/').concat(".class");
                    Resource resource = URLClassLoader.this.ucp.getResource(string2, false);
                    if (resource != null) {
                        try {
                            return URLClassLoader.this.defineClass(string, resource, true);
                        }
                        catch (IOException iOException) {
                            throw new ClassNotFoundException(string, iOException);
                        }
                    }
                    throw new ClassNotFoundException(string);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
    }

    private Class defineClass(String string, Resource resource) throws IOException {
        return this.defineClass(string, resource, true);
    }

    private Class defineClass(String string, Resource resource, boolean bl) throws IOException {
        CodeSigner[] codeSignerArray;
        Object object;
        Object object2;
        int n = string.lastIndexOf(46);
        URL uRL = resource.getCodeSourceURL();
        if (n != -1) {
            object2 = string.substring(0, n);
            object = this.getPackage((String)object2);
            codeSignerArray = resource.getManifest();
            if (object != null) {
                if (((Package)object).isSealed()) {
                    if (!((Package)object).isSealed(uRL)) {
                        throw new SecurityException("sealing violation: package " + (String)object2 + " is sealed");
                    }
                } else if (codeSignerArray != null && this.isSealed((String)object2, (Manifest)codeSignerArray)) {
                    throw new SecurityException("sealing violation: can't seal package " + (String)object2 + ": already loaded");
                }
            } else if (codeSignerArray != null) {
                this.definePackage((String)object2, (Manifest)codeSignerArray, uRL);
            } else {
                this.definePackage((String)object2, null, null, null, null, null, null, null);
            }
        }
        object = (object2 = resource.getByteBuffer()) == null ? resource.getBytes() : null;
        codeSignerArray = resource.getCodeSigners();
        CodeSource codeSource = new CodeSource(uRL, codeSignerArray);
        if (!bl) {
            Object[] objectArray = new Object[]{string, object2 == null ? ByteBuffer.wrap((byte[])object) : object2, codeSource};
            try {
                return (Class)defineClassNoVerifyMethod.invoke(this, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof LinkageError) {
                    throw (LinkageError)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new RuntimeException("Error defining class " + string, throwable);
            }
        }
        return object2 != null ? this.defineClass(string, (ByteBuffer)object2, codeSource) : this.defineClass(string, (byte[])object, 0, ((Object)object).length, codeSource);
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        URL uRL2 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string9 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (string4 == null) {
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (string5 == null) {
                string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (string7 == null) {
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (string8 == null) {
                string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string9 == null) {
                string9 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(string9)) {
            uRL2 = uRL;
        }
        return this.definePackage(string, string3, string4, string5, string6, string7, string8, uRL2);
    }

    private boolean isSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    @Override
    public URL findResource(final String string) {
        URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return URLClassLoader.this.ucp.findResource(string, true);
            }
        }, this.acc);
        return uRL != null ? this.ucp.checkURL(uRL) : null;
    }

    @Override
    public Enumeration<URL> findResources(String string) throws IOException {
        final Enumeration enumeration = this.ucp.findResources(string, true);
        return new Enumeration<URL>(){
            private URL url = null;

            private boolean next() {
                URL uRL;
                if (this.url != null) {
                    return true;
                }
                while ((uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        if (!enumeration.hasMoreElements()) {
                            return null;
                        }
                        return enumeration.nextElement();
                    }
                }, URLClassLoader.this.acc)) != null) {
                    this.url = URLClassLoader.this.ucp.checkURL(uRL);
                    if (this.url == null) continue;
                }
                return this.url != null;
            }

            @Override
            public URL nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                URL uRL = this.url;
                this.url = null;
                return uRL;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }
        };
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Object object;
        Object object2;
        Permission permission;
        URLConnection uRLConnection;
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        URL uRL = codeSource.getLocation();
        try {
            uRLConnection = uRL.openConnection();
            permission = uRLConnection.getPermission();
        }
        catch (IOException iOException) {
            permission = null;
            uRLConnection = null;
        }
        if (permission instanceof FilePermission) {
            object2 = permission.getName();
            if (((String)object2).endsWith(File.separator)) {
                object2 = (String)object2 + "-";
                permission = new FilePermission((String)object2, "read");
            }
        } else if (permission == null && uRL.getProtocol().equals("file")) {
            object2 = uRL.getFile().replace('/', File.separatorChar);
            if (((String)(object2 = ParseUtil.decode((String)object2))).endsWith(File.separator)) {
                object2 = (String)object2 + "-";
            }
            permission = new FilePermission((String)object2, "read");
        } else {
            object2 = uRL;
            if (uRLConnection instanceof JarURLConnection) {
                object2 = ((JarURLConnection)uRLConnection).getJarFileURL();
            }
            if ((object = ((URL)object2).getHost()) != null && ((String)object).length() > 0) {
                permission = new SocketPermission((String)object, "connect,accept");
            }
        }
        if (permission != null) {
            object2 = System.getSecurityManager();
            if (object2 != null) {
                object = permission;
                AccessController.doPrivileged(new PrivilegedAction((SecurityManager)object2, (Permission)object){
                    final /* synthetic */ SecurityManager val$sm;
                    final /* synthetic */ Permission val$fp;
                    {
                        this.val$sm = securityManager;
                        this.val$fp = permission;
                    }

                    public Object run() throws SecurityException {
                        this.val$sm.checkPermission(this.val$fp);
                        return null;
                    }
                }, this.acc);
            }
            permissionCollection.add(permission);
        }
        return permissionCollection;
    }

    public static URLClassLoader newInstance(final URL[] uRLArray, final ClassLoader classLoader) {
        AccessControlContext accessControlContext = AccessController.getContext();
        URLClassLoader uRLClassLoader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new FactoryURLClassLoader(uRLArray, classLoader);
            }
        });
        uRLClassLoader.acc = accessControlContext;
        return uRLClassLoader;
    }

    public static URLClassLoader newInstance(final URL[] uRLArray) {
        AccessControlContext accessControlContext = AccessController.getContext();
        URLClassLoader uRLClassLoader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new FactoryURLClassLoader(uRLArray);
            }
        });
        uRLClassLoader.acc = accessControlContext;
        return uRLClassLoader;
    }

    static {
        Method method;
        SharedSecrets.setJavaNetAccess(new JavaNetAccess(){

            public URLClassPath getURLClassPath(URLClassLoader uRLClassLoader) {
                return uRLClassLoader.ucp;
            }
        });
        try {
            method = SecureClassLoader.class.getDeclaredMethod("defineClassNoVerify", String.class, ByteBuffer.class, CodeSource.class);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        defineClassNoVerifyMethod = method;
    }
}

