/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xml.internal.serializer.EncodingInfo;
import com.sun.org.apache.xml.internal.serializer.ObjectFactory;
import com.sun.org.apache.xml.internal.serializer.SecuritySupport;
import com.sun.org.apache.xml.internal.serializer.utils.WrappedRuntimeException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public final class Encodings {
    private static final int m_defaultLastPrintable = 127;
    private static final String ENCODINGS_FILE = "com/sun/org/apache/xml/internal/serializer/Encodings.properties";
    private static final String ENCODINGS_PROP = "com.sun.org.apache.xalan.internal.serialize.encodings";
    static final String DEFAULT_MIME_ENCODING = "UTF-8";
    private static final Hashtable _encodingTableKeyJava = new Hashtable();
    private static final Hashtable _encodingTableKeyMime = new Hashtable();
    private static final EncodingInfo[] _encodings = Encodings.loadEncodingInfo();

    static Writer getWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        for (int i = 0; i < _encodings.length; ++i) {
            if (!Encodings._encodings[i].name.equalsIgnoreCase(string)) continue;
            try {
                return new BufferedWriter(new OutputStreamWriter(outputStream, Encodings._encodings[i].javaName));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        try {
            return new BufferedWriter(new OutputStreamWriter(outputStream, string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedEncodingException(string);
        }
    }

    public static int getLastPrintable() {
        return 127;
    }

    static EncodingInfo getEncodingInfo(String string) {
        String string2 = Encodings.toUpperCaseFast(string);
        EncodingInfo encodingInfo = (EncodingInfo)_encodingTableKeyJava.get(string2);
        if (encodingInfo == null) {
            encodingInfo = (EncodingInfo)_encodingTableKeyMime.get(string2);
        }
        if (encodingInfo == null) {
            encodingInfo = new EncodingInfo(null, null);
        }
        return encodingInfo;
    }

    private static String toUpperCaseFast(String string) {
        boolean bl = false;
        int n = string.length();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ('a' <= c && c <= 'z') {
                c = (char)(c + -32);
                bl = true;
            }
            cArray[i] = c;
        }
        String string2 = bl ? String.valueOf(cArray) : string;
        return string2;
    }

    static String getMimeEncoding(String string) {
        block5: {
            if (null == string) {
                try {
                    string = System.getProperty("file.encoding", "UTF8");
                    if (null != string) {
                        String string2 = string.equalsIgnoreCase("Cp1252") || string.equalsIgnoreCase("ISO8859_1") || string.equalsIgnoreCase("8859_1") || string.equalsIgnoreCase("UTF8") ? DEFAULT_MIME_ENCODING : Encodings.convertJava2MimeEncoding(string);
                        string = null != string2 ? string2 : DEFAULT_MIME_ENCODING;
                        break block5;
                    }
                    string = DEFAULT_MIME_ENCODING;
                }
                catch (SecurityException securityException) {
                    string = DEFAULT_MIME_ENCODING;
                }
            } else {
                string = Encodings.convertJava2MimeEncoding(string);
            }
        }
        return string;
    }

    private static String convertJava2MimeEncoding(String string) {
        EncodingInfo encodingInfo = (EncodingInfo)_encodingTableKeyJava.get(string.toUpperCase());
        if (null != encodingInfo) {
            return encodingInfo.name;
        }
        return string;
    }

    public static String convertMime2JavaEncoding(String string) {
        for (int i = 0; i < _encodings.length; ++i) {
            if (!Encodings._encodings[i].name.equalsIgnoreCase(string)) continue;
            return Encodings._encodings[i].javaName;
        }
        return string;
    }

    private static EncodingInfo[] loadEncodingInfo() {
        URL uRL = null;
        try {
            Object object;
            String string = null;
            InputStream inputStream = null;
            try {
                string = System.getProperty(ENCODINGS_PROP, "");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string != null && string.length() > 0) {
                uRL = new URL(string);
                inputStream = uRL.openStream();
            }
            if (inputStream == null) {
                object = SecuritySupport.getInstance();
                inputStream = ((SecuritySupport)object).getResourceAsStream(ObjectFactory.findClassLoader(), ENCODINGS_FILE);
            }
            object = new Properties();
            if (inputStream != null) {
                ((Properties)object).load(inputStream);
                inputStream.close();
            }
            int n = ((Hashtable)object).size();
            int n2 = 0;
            Enumeration enumeration = ((Hashtable)object).keys();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)enumeration.nextElement();
                String string3 = ((Properties)object).getProperty(string2);
                ++n2;
                int n3 = string3.indexOf(32);
                for (int j = 0; j < n3; ++j) {
                    if (string3.charAt(j) != ',') continue;
                    ++n2;
                }
            }
            EncodingInfo[] encodingInfoArray = new EncodingInfo[n2];
            int n4 = 0;
            enumeration = ((Hashtable)object).keys();
            for (int i = 0; i < n; ++i) {
                String string4;
                String string5 = (String)enumeration.nextElement();
                String string6 = ((Properties)object).getProperty(string5);
                int n5 = string6.indexOf(32);
                if (n5 < 0) {
                    string4 = string6;
                    continue;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string6.substring(0, n5), ",");
                boolean bl = true;
                while (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                    encodingInfoArray[n4] = new EncodingInfo(string4, string5);
                    _encodingTableKeyMime.put(string4.toUpperCase(), encodingInfoArray[n4]);
                    if (bl) {
                        _encodingTableKeyJava.put(string5.toUpperCase(), encodingInfoArray[n4]);
                    }
                    ++n4;
                    bl = false;
                }
            }
            return encodingInfoArray;
        }
        catch (MalformedURLException malformedURLException) {
            throw new WrappedRuntimeException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new WrappedRuntimeException(iOException);
        }
    }

    static boolean isHighUTF16Surrogate(char c) {
        return '\ud800' <= c && c <= '\udbff';
    }

    static boolean isLowUTF16Surrogate(char c) {
        return '\udc00' <= c && c <= '\udfff';
    }

    static int toCodePoint(char c, char c2) {
        int n = (c - 55296 << 10) + (c2 - 56320) + 65536;
        return n;
    }

    static int toCodePoint(char c) {
        char c2 = c;
        return c2;
    }
}

