/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Adjustable;
import java.awt.Insets;
import java.awt.ScrollPane;
import java.awt.event.MouseWheelEvent;
import sun.awt.DebugHelper;

public abstract class ScrollPaneWheelScroller {
    private static final DebugHelper dbg = DebugHelper.create(ScrollPaneWheelScroller.class);

    private ScrollPaneWheelScroller() {
    }

    public static void handleWheelScrolling(ScrollPane scrollPane, MouseWheelEvent mouseWheelEvent) {
        Adjustable adjustable;
        int n = 0;
        if (scrollPane != null && mouseWheelEvent.getScrollAmount() != 0 && (adjustable = ScrollPaneWheelScroller.getAdjustableToScroll(scrollPane)) != null) {
            n = ScrollPaneWheelScroller.getIncrementFromAdjustable(adjustable, mouseWheelEvent);
            ScrollPaneWheelScroller.scrollAdjustable(adjustable, n);
        }
    }

    public static Adjustable getAdjustableToScroll(ScrollPane scrollPane) {
        int n = scrollPane.getScrollbarDisplayPolicy();
        if (n == 1 || n == 2) {
            return scrollPane.getVAdjustable();
        }
        Insets insets = scrollPane.getInsets();
        int n2 = scrollPane.getVScrollbarWidth();
        if (insets.right >= n2) {
            return scrollPane.getVAdjustable();
        }
        int n3 = scrollPane.getHScrollbarHeight();
        if (insets.bottom >= n3) {
            return scrollPane.getHAdjustable();
        }
        return null;
    }

    public static int getIncrementFromAdjustable(Adjustable adjustable, MouseWheelEvent mouseWheelEvent) {
        int n = 0;
        if (mouseWheelEvent.getScrollType() == 0) {
            n = mouseWheelEvent.getUnitsToScroll() * adjustable.getUnitIncrement();
        } else if (mouseWheelEvent.getScrollType() == 1) {
            n = adjustable.getBlockIncrement() * mouseWheelEvent.getWheelRotation();
        }
        return n;
    }

    public static void scrollAdjustable(Adjustable adjustable, int n) {
        int n2 = adjustable.getValue();
        int n3 = adjustable.getMaximum() - adjustable.getVisibleAmount();
        if (n > 0 && n2 < n3) {
            if (n2 + n < n3) {
                adjustable.setValue(n2 + n);
                return;
            }
            adjustable.setValue(n3);
            return;
        }
        if (n < 0 && n2 > adjustable.getMinimum()) {
            if (n2 + n > adjustable.getMinimum()) {
                adjustable.setValue(n2 + n);
                return;
            }
            adjustable.setValue(adjustable.getMinimum());
            return;
        }
    }
}

