/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class LineBorder
extends AbstractBorder {
    private static Border blackLine;
    private static Border grayLine;
    protected int thickness;
    protected Color lineColor;
    protected boolean roundedCorners;

    public static Border createBlackLineBorder() {
        if (blackLine == null) {
            blackLine = new LineBorder(Color.black, 1);
        }
        return blackLine;
    }

    public static Border createGrayLineBorder() {
        if (grayLine == null) {
            grayLine = new LineBorder(Color.gray, 1);
        }
        return grayLine;
    }

    public LineBorder(Color color) {
        this(color, 1, false);
    }

    public LineBorder(Color color, int n) {
        this(color, n, false);
    }

    public LineBorder(Color color, int n, boolean bl) {
        this.lineColor = color;
        this.thickness = n;
        this.roundedCorners = bl;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(this.lineColor);
        for (int i = 0; i < this.thickness; ++i) {
            if (!this.roundedCorners) {
                graphics.drawRect(n + i, n2 + i, n3 - i - i - 1, n4 - i - i - 1);
                continue;
            }
            graphics.drawRoundRect(n + i, n2 + i, n3 - i - i - 1, n4 - i - i - 1, this.thickness, this.thickness);
        }
        graphics.setColor(color);
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        insets.right = insets.bottom = this.thickness;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getThickness() {
        return this.thickness;
    }

    public boolean getRoundedCorners() {
        return this.roundedCorners;
    }

    public boolean isBorderOpaque() {
        return !this.roundedCorners;
    }
}

