/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.RasterListener;

public class SunWritableRaster
extends WritableRaster {
    protected RasterListener listener;
    private boolean isStolen;

    public SunWritableRaster(SampleModel sampleModel, Point point) {
        super(sampleModel, point);
        this.isStolen = false;
    }

    public SunWritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        super(sampleModel, dataBuffer, point);
        this.isStolen = true;
    }

    public SunWritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, WritableRaster writableRaster) {
        super(sampleModel, dataBuffer, rectangle, point, writableRaster);
        this.isStolen = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRasterListener(RasterListener rasterListener) {
        boolean bl;
        if (rasterListener == null) {
            return;
        }
        SunWritableRaster sunWritableRaster = this;
        synchronized (sunWritableRaster) {
            if (this.listener == null) {
                this.listener = rasterListener;
                bl = this.isStolen;
            } else {
                bl = true;
            }
        }
        if (bl) {
            rasterListener.rasterStolen();
        }
    }

    public void notifyChanged() {
        if (this.listener != null) {
            this.listener.rasterChanged();
        }
    }

    public void notifyStolen() {
        this.setStolen(true);
    }

    public void setStolen(boolean bl) {
        this.isStolen = bl;
        if (this.listener != null && this.isStolen) {
            this.listener.rasterStolen();
        }
    }

    public DataBuffer getDataBuffer() {
        this.notifyStolen();
        return super.getDataBuffer();
    }

    public void setDataElements(int n, int n2, Object object) {
        super.setDataElements(n, n2, object);
        this.notifyChanged();
    }

    public void setDataElements(int n, int n2, Raster raster) {
        super.setDataElements(n, n2, raster);
        this.notifyChanged();
    }

    public void setDataElements(int n, int n2, int n3, int n4, Object object) {
        super.setDataElements(n, n2, n3, n4, object);
        this.notifyChanged();
    }

    public void setRect(Raster raster) {
        super.setRect(raster);
        this.notifyChanged();
    }

    public void setRect(int n, int n2, Raster raster) {
        super.setRect(n, n2, raster);
        this.notifyChanged();
    }

    public void setPixel(int n, int n2, int[] nArray) {
        super.setPixel(n, n2, nArray);
        this.notifyChanged();
    }

    public void setPixel(int n, int n2, float[] fArray) {
        super.setPixel(n, n2, fArray);
        this.notifyChanged();
    }

    public void setPixel(int n, int n2, double[] dArray) {
        super.setPixel(n, n2, dArray);
        this.notifyChanged();
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] nArray) {
        super.setPixels(n, n2, n3, n4, nArray);
        this.notifyChanged();
    }

    public void setPixels(int n, int n2, int n3, int n4, float[] fArray) {
        super.setPixels(n, n2, n3, n4, fArray);
        this.notifyChanged();
    }

    public void setPixels(int n, int n2, int n3, int n4, double[] dArray) {
        super.setPixels(n, n2, n3, n4, dArray);
        this.notifyChanged();
    }

    public void setSample(int n, int n2, int n3, int n4) {
        super.setSample(n, n2, n3, n4);
        this.notifyChanged();
    }

    public void setSample(int n, int n2, int n3, float f) {
        super.setSample(n, n2, n3, f);
        this.notifyChanged();
    }

    public void setSample(int n, int n2, int n3, double d) {
        super.setSample(n, n2, n3, d);
        this.notifyChanged();
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        super.setSamples(n, n2, n3, n4, n5, nArray);
        this.notifyChanged();
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        super.setSamples(n, n2, n3, n4, n5, fArray);
        this.notifyChanged();
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        super.setSamples(n, n2, n3, n4, n5, dArray);
        this.notifyChanged();
    }
}

