/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Window;
import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;

final class LayoutComparator
implements Comparator,
Serializable {
    private static final int ROW_TOLERANCE = 10;
    private boolean horizontal = true;
    private boolean leftToRight = true;

    LayoutComparator() {
    }

    void setComponentOrientation(ComponentOrientation componentOrientation) {
        this.horizontal = componentOrientation.isHorizontal();
        this.leftToRight = componentOrientation.isLeftToRight();
    }

    public int compare(Object object, Object object2) {
        Component component = (Component)object;
        Component component2 = (Component)object2;
        if (component == component2) {
            return 0;
        }
        if (component.getParent() != component2.getParent()) {
            LinkedList<Component> linkedList = new LinkedList<Component>();
            while (component != null) {
                linkedList.add(component);
                if (component instanceof Window) break;
                component = component.getParent();
            }
            if (component == null) {
                throw new ClassCastException();
            }
            LinkedList<Component> linkedList2 = new LinkedList<Component>();
            while (component2 != null) {
                linkedList2.add(component2);
                if (component2 instanceof Window) break;
                component2 = component2.getParent();
            }
            if (component2 == null) {
                throw new ClassCastException();
            }
            ListIterator listIterator = linkedList.listIterator(linkedList.size());
            ListIterator listIterator2 = linkedList2.listIterator(linkedList2.size());
            do {
                if (!listIterator.hasPrevious()) {
                    return -1;
                }
                component = (Component)listIterator.previous();
                if (!listIterator2.hasPrevious()) {
                    return 1;
                }
                component2 = (Component)listIterator2.previous();
            } while (component == component2);
        }
        int n = component.getX();
        int n2 = component.getY();
        int n3 = component2.getX();
        int n4 = component2.getY();
        int n5 = component.getParent().getComponentZOrder(component) - component2.getParent().getComponentZOrder(component2);
        if (this.horizontal) {
            if (this.leftToRight) {
                if (Math.abs(n2 - n4) < 10) {
                    return n < n3 ? -1 : (n > n3 ? 1 : n5);
                }
                return n2 < n4 ? -1 : 1;
            }
            if (Math.abs(n2 - n4) < 10) {
                return n > n3 ? -1 : (n < n3 ? 1 : n5);
            }
            return n2 < n4 ? -1 : 1;
        }
        if (this.leftToRight) {
            if (Math.abs(n - n3) < 10) {
                return n2 < n4 ? -1 : (n2 > n4 ? 1 : n5);
            }
            return n < n3 ? -1 : 1;
        }
        if (Math.abs(n - n3) < 10) {
            return n2 < n4 ? -1 : (n2 > n4 ? 1 : n5);
        }
        return n > n3 ? -1 : 1;
    }
}

