/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.JsseJce;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;

final class EphemeralKeyManager {
    private static final int INDEX_RSA512 = 0;
    private static final int INDEX_RSA1024 = 1;
    private final EphemeralKeyPair[] keys = new EphemeralKeyPair[]{new EphemeralKeyPair(null), new EphemeralKeyPair(null)};

    EphemeralKeyManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyPair getRSAKeyPair(boolean bl, SecureRandom secureRandom) {
        int n;
        int n2;
        if (bl) {
            n2 = 512;
            n = 0;
        } else {
            n2 = 1024;
            n = 1;
        }
        EphemeralKeyPair[] ephemeralKeyPairArray = this.keys;
        synchronized (this.keys) {
            KeyPair keyPair = this.keys[n].getKeyPair();
            if (keyPair == null) {
                try {
                    KeyPairGenerator keyPairGenerator = JsseJce.getKeyPairGenerator("RSA");
                    keyPairGenerator.initialize(n2, secureRandom);
                    this.keys[n] = new EphemeralKeyPair(keyPairGenerator.genKeyPair());
                    keyPair = this.keys[n].getKeyPair();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return keyPair;
        }
    }

    private static class EphemeralKeyPair {
        private static final int MAX_USE = 200;
        private static final long USE_INTERVAL = 3600000L;
        private KeyPair keyPair;
        private int uses;
        private long expirationTime;

        private EphemeralKeyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
            this.expirationTime = System.currentTimeMillis() + 3600000L;
        }

        private boolean isValid() {
            return this.keyPair != null && this.uses < 200 && System.currentTimeMillis() < this.expirationTime;
        }

        private KeyPair getKeyPair() {
            if (!this.isValid()) {
                this.keyPair = null;
                return null;
            }
            ++this.uses;
            return this.keyPair;
        }
    }
}

