/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.dtd.nonvalidating;

import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.XMLSymbols;
import com.sun.org.apache.xerces.internal.xni.Augmentations;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLLocator;
import com.sun.org.apache.xerces.internal.xni.XMLResourceIdentifier;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLDTDContentModelSource;
import com.sun.org.apache.xerces.internal.xni.parser.XMLDTDSource;
import com.sun.xml.internal.stream.dtd.nonvalidating.XMLAttributeDecl;
import com.sun.xml.internal.stream.dtd.nonvalidating.XMLElementDecl;
import com.sun.xml.internal.stream.dtd.nonvalidating.XMLNotationDecl;
import com.sun.xml.internal.stream.dtd.nonvalidating.XMLSimpleType;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class DTDGrammar {
    public static final int TOP_LEVEL_SCOPE = -1;
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private static final short LIST_FLAG = 128;
    private static final short LIST_MASK = -129;
    private static final boolean DEBUG = false;
    protected XMLDTDSource fDTDSource = null;
    protected XMLDTDContentModelSource fDTDContentModelSource = null;
    protected int fCurrentElementIndex;
    protected int fCurrentAttributeIndex;
    protected boolean fReadingExternalDTD = false;
    private SymbolTable fSymbolTable;
    private ArrayList notationDecls = new ArrayList();
    private int fElementDeclCount = 0;
    private QName[][] fElementDeclName = new QName[4][];
    private short[][] fElementDeclType = new short[4][];
    private int[][] fElementDeclFirstAttributeDeclIndex = new int[4][];
    private int[][] fElementDeclLastAttributeDeclIndex = new int[4][];
    private int fAttributeDeclCount = 0;
    private QName[][] fAttributeDeclName = new QName[4][];
    private short[][] fAttributeDeclType = new short[4][];
    private String[][][] fAttributeDeclEnumeration = new String[4][][];
    private short[][] fAttributeDeclDefaultType = new short[4][];
    private String[][] fAttributeDeclDefaultValue = new String[4][];
    private String[][] fAttributeDeclNonNormalizedDefaultValue = new String[4][];
    private int[][] fAttributeDeclNextAttributeDeclIndex = new int[4][];
    private QNameHashtable fElementIndexMap = new QNameHashtable();
    private QName fQName = new QName();
    protected XMLAttributeDecl fAttributeDecl = new XMLAttributeDecl();
    private XMLElementDecl fElementDecl = new XMLElementDecl();
    private XMLSimpleType fSimpleType = new XMLSimpleType();
    Hashtable fElementDeclTab = new Hashtable();

    public DTDGrammar(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
    }

    public int getAttributeDeclIndex(int n, String string) {
        if (n == -1) {
            return -1;
        }
        int n2 = this.getFirstAttributeDeclIndex(n);
        while (n2 != -1) {
            this.getAttributeDecl(n2, this.fAttributeDecl);
            if (this.fAttributeDecl.name.rawname == string || string.equals(this.fAttributeDecl.name.rawname)) {
                return n2;
            }
            n2 = this.getNextAttributeDeclIndex(n2);
        }
        return -1;
    }

    public void startDTD(XMLLocator xMLLocator, Augmentations augmentations) throws XNIException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void elementDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        XMLElementDecl xMLElementDecl = (XMLElementDecl)this.fElementDeclTab.get(string);
        if (xMLElementDecl != null) {
            if (xMLElementDecl.type != -1) return;
            this.fCurrentElementIndex = this.getElementDeclIndex(string);
        } else {
            this.fCurrentElementIndex = this.createElementDecl();
        }
        XMLElementDecl xMLElementDecl2 = new XMLElementDecl();
        QName qName = new QName(null, string, string, null);
        xMLElementDecl2.name.setValues(qName);
        xMLElementDecl2.scope = -1;
        if (string2.equals("EMPTY")) {
            xMLElementDecl2.type = 1;
        } else if (string2.equals("ANY")) {
            xMLElementDecl2.type = 0;
        } else if (string2.startsWith("(")) {
            xMLElementDecl2.type = string2.indexOf("#PCDATA") > 0 ? (short)2 : (short)3;
        }
        this.fElementDeclTab.put(string, xMLElementDecl2);
        this.fElementDecl = xMLElementDecl2;
        this.setElementDecl(this.fCurrentElementIndex, this.fElementDecl);
        int n = this.fCurrentElementIndex >> 8;
        this.ensureElementDeclCapacity(n);
    }

    public void attributeDecl(String string, String string2, String string3, String[] stringArray, String string4, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
        if (string3 != XMLSymbols.fCDATASymbol && xMLString != null) {
            this.normalizeDefaultAttrValue(xMLString);
        }
        if (!this.fElementDeclTab.containsKey(string)) {
            this.fCurrentElementIndex = this.createElementDecl();
            XMLElementDecl xMLElementDecl = new XMLElementDecl();
            xMLElementDecl.name.setValues(null, string, string, null);
            xMLElementDecl.scope = -1;
            this.fElementDeclTab.put(string, xMLElementDecl);
            this.setElementDecl(this.fCurrentElementIndex, xMLElementDecl);
        }
        int n = this.getElementDeclIndex(string);
        if (this.getAttributeDeclIndex(n, string2) != -1) {
            return;
        }
        this.fCurrentAttributeIndex = this.createAttributeDecl();
        this.fSimpleType.clear();
        if (string4 != null) {
            if (string4.equals("#FIXED")) {
                this.fSimpleType.defaultType = 1;
            } else if (string4.equals("#IMPLIED")) {
                this.fSimpleType.defaultType = 0;
            } else if (string4.equals("#REQUIRED")) {
                this.fSimpleType.defaultType = (short)2;
            }
        }
        this.fSimpleType.defaultValue = xMLString != null ? xMLString.toString() : null;
        this.fSimpleType.nonNormalizedDefaultValue = xMLString2 != null ? xMLString2.toString() : null;
        this.fSimpleType.enumeration = stringArray;
        if (string3.equals("CDATA")) {
            this.fSimpleType.type = 0;
        } else if (string3.equals("ID")) {
            this.fSimpleType.type = (short)3;
        } else if (string3.startsWith("IDREF")) {
            this.fSimpleType.type = (short)4;
            if (string3.indexOf("S") > 0) {
                this.fSimpleType.list = true;
            }
        } else if (string3.equals("ENTITIES")) {
            this.fSimpleType.type = 1;
            this.fSimpleType.list = true;
        } else if (string3.equals("ENTITY")) {
            this.fSimpleType.type = 1;
        } else if (string3.equals("NMTOKENS")) {
            this.fSimpleType.type = (short)5;
            this.fSimpleType.list = true;
        } else if (string3.equals("NMTOKEN")) {
            this.fSimpleType.type = (short)5;
        } else if (string3.startsWith("NOTATION")) {
            this.fSimpleType.type = (short)6;
        } else if (string3.startsWith("ENUMERATION")) {
            this.fSimpleType.type = (short)2;
        } else {
            System.err.println("!!! unknown attribute type " + string3);
        }
        this.fQName.setValues(null, string2, string2, null);
        this.fAttributeDecl.setValues(this.fQName, this.fSimpleType, false);
        this.setAttributeDecl(n, this.fCurrentAttributeIndex, this.fAttributeDecl);
        int n2 = this.fCurrentAttributeIndex >> 8;
        this.ensureAttributeDeclCapacity(n2);
    }

    public SymbolTable getSymbolTable() {
        return this.fSymbolTable;
    }

    public int getFirstElementDeclIndex() {
        return this.fElementDeclCount >= 0 ? 0 : -1;
    }

    public int getNextElementDeclIndex(int n) {
        return n < this.fElementDeclCount - 1 ? n + 1 : -1;
    }

    public int getElementDeclIndex(String string) {
        int n = this.fElementIndexMap.get(string);
        return n;
    }

    public int getElementDeclIndex(QName qName) {
        return this.getElementDeclIndex(qName.rawname);
    }

    public short getContentSpecType(int n) {
        if (n < 0 || n >= this.fElementDeclCount) {
            return -1;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        if (this.fElementDeclType[n2][n3] == -1) {
            return -1;
        }
        return (short)(this.fElementDeclType[n2][n3] & 0xFFFFFF7F);
    }

    public boolean getElementDecl(int n, XMLElementDecl xMLElementDecl) {
        if (n < 0 || n >= this.fElementDeclCount) {
            return false;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        xMLElementDecl.name.setValues(this.fElementDeclName[n2][n3]);
        if (this.fElementDeclType[n2][n3] == -1) {
            xMLElementDecl.type = (short)-1;
            xMLElementDecl.simpleType.list = false;
        } else {
            xMLElementDecl.type = (short)(this.fElementDeclType[n2][n3] & 0xFFFFFF7F);
            xMLElementDecl.simpleType.list = (this.fElementDeclType[n2][n3] & 0x80) != 0;
        }
        xMLElementDecl.simpleType.defaultType = (short)-1;
        xMLElementDecl.simpleType.defaultValue = null;
        return true;
    }

    public int getFirstAttributeDeclIndex(int n) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclFirstAttributeDeclIndex[n2][n3];
    }

    public int getNextAttributeDeclIndex(int n) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fAttributeDeclNextAttributeDeclIndex[n2][n3];
    }

    public boolean getAttributeDecl(int n, XMLAttributeDecl xMLAttributeDecl) {
        boolean bl;
        short s;
        if (n < 0 || n >= this.fAttributeDeclCount) {
            return false;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        xMLAttributeDecl.name.setValues(this.fAttributeDeclName[n2][n3]);
        if (this.fAttributeDeclType[n2][n3] == -1) {
            s = -1;
            bl = false;
        } else {
            s = (short)(this.fAttributeDeclType[n2][n3] & 0xFFFFFF7F);
            bl = (this.fAttributeDeclType[n2][n3] & 0x80) != 0;
        }
        xMLAttributeDecl.simpleType.setValues(s, this.fAttributeDeclName[n2][n3].localpart, this.fAttributeDeclEnumeration[n2][n3], bl, this.fAttributeDeclDefaultType[n2][n3], this.fAttributeDeclDefaultValue[n2][n3], this.fAttributeDeclNonNormalizedDefaultValue[n2][n3]);
        return true;
    }

    public boolean isCDATAAttribute(QName qName, QName qName2) {
        int n = this.getElementDeclIndex(qName);
        return !this.getAttributeDecl(n, this.fAttributeDecl) || this.fAttributeDecl.simpleType.type == 0;
    }

    public void printElements() {
        int n = 0;
        XMLElementDecl xMLElementDecl = new XMLElementDecl();
        while (this.getElementDecl(n++, xMLElementDecl)) {
            System.out.println("element decl: " + xMLElementDecl.name + ", " + xMLElementDecl.name.rawname);
        }
    }

    public void printAttributes(int n) {
        int n2 = this.getFirstAttributeDeclIndex(n);
        System.out.print(n);
        System.out.print(" [");
        while (n2 != -1) {
            System.out.print(' ');
            System.out.print(n2);
            this.printAttribute(n2);
            if ((n2 = this.getNextAttributeDeclIndex(n2)) == -1) continue;
            System.out.print(",");
        }
        System.out.println(" ]");
    }

    protected int createElementDecl() {
        int n = this.fElementDeclCount >> 8;
        int n2 = this.fElementDeclCount & 0xFF;
        this.ensureElementDeclCapacity(n);
        this.fElementDeclName[n][n2] = new QName();
        this.fElementDeclType[n][n2] = -1;
        this.fElementDeclFirstAttributeDeclIndex[n][n2] = -1;
        this.fElementDeclLastAttributeDeclIndex[n][n2] = -1;
        return this.fElementDeclCount++;
    }

    protected void setElementDecl(int n, XMLElementDecl xMLElementDecl) {
        if (n < 0 || n >= this.fElementDeclCount) {
            return;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        int n4 = xMLElementDecl.scope;
        this.fElementDeclName[n2][n3].setValues(xMLElementDecl.name);
        this.fElementDeclType[n2][n3] = xMLElementDecl.type;
        if (xMLElementDecl.simpleType.list) {
            short[] sArray = this.fElementDeclType[n2];
            int n5 = n3;
            sArray[n5] = (short)(sArray[n5] | 0x80);
        }
        this.fElementIndexMap.put(xMLElementDecl.name.rawname, n);
    }

    protected void setFirstAttributeDeclIndex(int n, int n2) {
        if (n < 0 || n >= this.fElementDeclCount) {
            return;
        }
        int n3 = n >> 8;
        int n4 = n & 0xFF;
        this.fElementDeclFirstAttributeDeclIndex[n3][n4] = n2;
    }

    protected int createAttributeDecl() {
        int n = this.fAttributeDeclCount >> 8;
        int n2 = this.fAttributeDeclCount & 0xFF;
        this.ensureAttributeDeclCapacity(n);
        this.fAttributeDeclName[n][n2] = new QName();
        this.fAttributeDeclType[n][n2] = -1;
        this.fAttributeDeclEnumeration[n][n2] = null;
        this.fAttributeDeclDefaultType[n][n2] = 0;
        this.fAttributeDeclDefaultValue[n][n2] = null;
        this.fAttributeDeclNonNormalizedDefaultValue[n][n2] = null;
        this.fAttributeDeclNextAttributeDeclIndex[n][n2] = -1;
        return this.fAttributeDeclCount++;
    }

    protected void setAttributeDecl(int n, int n2, XMLAttributeDecl xMLAttributeDecl) {
        int n3 = n2 >> 8;
        int n4 = n2 & 0xFF;
        this.fAttributeDeclName[n3][n4].setValues(xMLAttributeDecl.name);
        this.fAttributeDeclType[n3][n4] = xMLAttributeDecl.simpleType.type;
        if (xMLAttributeDecl.simpleType.list) {
            short[] sArray = this.fAttributeDeclType[n3];
            int n5 = n4;
            sArray[n5] = (short)(sArray[n5] | 0x80);
        }
        this.fAttributeDeclEnumeration[n3][n4] = xMLAttributeDecl.simpleType.enumeration;
        this.fAttributeDeclDefaultType[n3][n4] = xMLAttributeDecl.simpleType.defaultType;
        this.fAttributeDeclDefaultValue[n3][n4] = xMLAttributeDecl.simpleType.defaultValue;
        this.fAttributeDeclNonNormalizedDefaultValue[n3][n4] = xMLAttributeDecl.simpleType.nonNormalizedDefaultValue;
        int n6 = n >> 8;
        int n7 = n & 0xFF;
        int n8 = this.fElementDeclFirstAttributeDeclIndex[n6][n7];
        while (n8 != -1 && n8 != n2) {
            n3 = n8 >> 8;
            n4 = n8 & 0xFF;
            n8 = this.fAttributeDeclNextAttributeDeclIndex[n3][n4];
        }
        if (n8 == -1) {
            if (this.fElementDeclFirstAttributeDeclIndex[n6][n7] == -1) {
                this.fElementDeclFirstAttributeDeclIndex[n6][n7] = n2;
            } else {
                n8 = this.fElementDeclLastAttributeDeclIndex[n6][n7];
                n3 = n8 >> 8;
                n4 = n8 & 0xFF;
                this.fAttributeDeclNextAttributeDeclIndex[n3][n4] = n2;
            }
            this.fElementDeclLastAttributeDeclIndex[n6][n7] = n2;
        }
    }

    public void notationDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        XMLNotationDecl xMLNotationDecl = new XMLNotationDecl();
        xMLNotationDecl.setValues(string, xMLResourceIdentifier.getPublicId(), xMLResourceIdentifier.getLiteralSystemId(), xMLResourceIdentifier.getBaseSystemId());
        this.notationDecls.add(xMLNotationDecl);
    }

    public List getNotationDecls() {
        return this.notationDecls;
    }

    private void printAttribute(int n) {
        XMLAttributeDecl xMLAttributeDecl = new XMLAttributeDecl();
        if (this.getAttributeDecl(n, xMLAttributeDecl)) {
            System.out.print(" { ");
            System.out.print(xMLAttributeDecl.name.localpart);
            System.out.print(" }");
        }
    }

    private void ensureElementDeclCapacity(int n) {
        if (n >= this.fElementDeclName.length) {
            this.fElementDeclName = DTDGrammar.resize(this.fElementDeclName, this.fElementDeclName.length * 2);
            this.fElementDeclType = DTDGrammar.resize(this.fElementDeclType, this.fElementDeclType.length * 2);
            this.fElementDeclFirstAttributeDeclIndex = DTDGrammar.resize(this.fElementDeclFirstAttributeDeclIndex, this.fElementDeclFirstAttributeDeclIndex.length * 2);
            this.fElementDeclLastAttributeDeclIndex = DTDGrammar.resize(this.fElementDeclLastAttributeDeclIndex, this.fElementDeclLastAttributeDeclIndex.length * 2);
        } else if (this.fElementDeclName[n] != null) {
            return;
        }
        this.fElementDeclName[n] = new QName[256];
        this.fElementDeclType[n] = new short[256];
        this.fElementDeclFirstAttributeDeclIndex[n] = new int[256];
        this.fElementDeclLastAttributeDeclIndex[n] = new int[256];
    }

    private void ensureAttributeDeclCapacity(int n) {
        if (n >= this.fAttributeDeclName.length) {
            this.fAttributeDeclName = DTDGrammar.resize(this.fAttributeDeclName, this.fAttributeDeclName.length * 2);
            this.fAttributeDeclType = DTDGrammar.resize(this.fAttributeDeclType, this.fAttributeDeclType.length * 2);
            this.fAttributeDeclEnumeration = DTDGrammar.resize(this.fAttributeDeclEnumeration, this.fAttributeDeclEnumeration.length * 2);
            this.fAttributeDeclDefaultType = DTDGrammar.resize(this.fAttributeDeclDefaultType, this.fAttributeDeclDefaultType.length * 2);
            this.fAttributeDeclDefaultValue = DTDGrammar.resize(this.fAttributeDeclDefaultValue, this.fAttributeDeclDefaultValue.length * 2);
            this.fAttributeDeclNonNormalizedDefaultValue = DTDGrammar.resize(this.fAttributeDeclNonNormalizedDefaultValue, this.fAttributeDeclNonNormalizedDefaultValue.length * 2);
            this.fAttributeDeclNextAttributeDeclIndex = DTDGrammar.resize(this.fAttributeDeclNextAttributeDeclIndex, this.fAttributeDeclNextAttributeDeclIndex.length * 2);
        } else if (this.fAttributeDeclName[n] != null) {
            return;
        }
        this.fAttributeDeclName[n] = new QName[256];
        this.fAttributeDeclType[n] = new short[256];
        this.fAttributeDeclEnumeration[n] = new String[256][];
        this.fAttributeDeclDefaultType[n] = new short[256];
        this.fAttributeDeclDefaultValue[n] = new String[256];
        this.fAttributeDeclNonNormalizedDefaultValue[n] = new String[256];
        this.fAttributeDeclNextAttributeDeclIndex[n] = new int[256];
    }

    private static short[][] resize(short[][] sArray, int n) {
        short[][] sArrayArray = new short[n][];
        System.arraycopy(sArray, 0, sArrayArray, 0, sArray.length);
        return sArrayArray;
    }

    private static int[][] resize(int[][] nArray, int n) {
        int[][] nArrayArray = new int[n][];
        System.arraycopy(nArray, 0, nArrayArray, 0, nArray.length);
        return nArrayArray;
    }

    private static QName[][] resize(QName[][] qNameArray, int n) {
        QName[][] qNameArray2 = new QName[n][];
        System.arraycopy(qNameArray, 0, qNameArray2, 0, qNameArray.length);
        return qNameArray2;
    }

    private static String[][] resize(String[][] stringArray, int n) {
        String[][] stringArray2 = new String[n][];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    private static String[][][] resize(String[][][] stringArray, int n) {
        String[][][] stringArray2 = new String[n][][];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    private boolean normalizeDefaultAttrValue(XMLString xMLString) {
        int n = xMLString.length;
        boolean bl = true;
        int n2 = xMLString.offset;
        int n3 = xMLString.offset + xMLString.length;
        for (int i = xMLString.offset; i < n3; ++i) {
            if (xMLString.ch[i] == ' ') {
                if (bl) continue;
                xMLString.ch[n2++] = 32;
                bl = true;
                continue;
            }
            if (n2 != i) {
                xMLString.ch[n2] = xMLString.ch[i];
            }
            ++n2;
            bl = false;
        }
        if (n2 != n3) {
            if (bl) {
                --n2;
            }
            xMLString.length = n2 - xMLString.offset;
            return true;
        }
        return false;
    }

    public void endDTD(Augmentations augmentations) throws XNIException {
    }

    protected static final class QNameHashtable {
        public static final boolean UNIQUE_STRINGS = true;
        private static final int INITIAL_BUCKET_SIZE = 4;
        private static final int HASHTABLE_SIZE = 101;
        private Object[][] fHashTable = new Object[101][];

        protected QNameHashtable() {
        }

        public void put(String string, int n) {
            int n2 = (this.hash(string) + 2) % 101;
            Object[] objectArray = this.fHashTable[n2];
            if (objectArray == null) {
                objectArray = new Object[9];
                objectArray[0] = new int[]{1};
                objectArray[1] = string;
                objectArray[2] = new int[]{n};
                this.fHashTable[n2] = objectArray;
            } else {
                int n3;
                int n4 = ((int[])objectArray[0])[0];
                int n5 = 1 + 2 * n4;
                if (n5 == objectArray.length) {
                    n3 = n4 + 4;
                    Object[] objectArray2 = new Object[1 + 2 * n3];
                    System.arraycopy(objectArray, 0, objectArray2, 0, n5);
                    objectArray = objectArray2;
                    this.fHashTable[n2] = objectArray;
                }
                n3 = 0;
                int n6 = 1;
                for (int i = 0; i < n4; ++i) {
                    if ((String)objectArray[n6] == string) {
                        ((int[])objectArray[n6 + 1])[0] = n;
                        n3 = 1;
                        break;
                    }
                    n6 += 2;
                }
                if (n3 == 0) {
                    objectArray[n5++] = string;
                    objectArray[n5] = new int[]{n};
                    ((int[])objectArray[0])[0] = ++n4;
                }
            }
        }

        public int get(String string) {
            int n = (this.hash(string) + 2) % 101;
            Object[] objectArray = this.fHashTable[n];
            if (objectArray == null) {
                return -1;
            }
            int n2 = ((int[])objectArray[0])[0];
            int n3 = 1;
            for (int i = 0; i < n2; ++i) {
                if ((String)objectArray[n3] == string) {
                    return ((int[])objectArray[n3 + 1])[0];
                }
                n3 += 2;
            }
            return -1;
        }

        protected int hash(String string) {
            if (string == null) {
                return 0;
            }
            int n = 0;
            int n2 = string.length();
            for (int i = 0; i < n2; ++i) {
                n = n * 37 + string.charAt(i);
            }
            return n & 0x7FFFFFF;
        }
    }
}

