/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import sun.print.ServiceDialog;
import sun.print.SunAlternateMedia;

public class ServiceUI {
    public static PrintService printDialog(GraphicsConfiguration graphicsConfiguration, int n, int n2, PrintService[] printServiceArray, PrintService printService, DocFlavor docFlavor, PrintRequestAttributeSet printRequestAttributeSet) throws HeadlessException {
        int n3 = -1;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (printServiceArray == null || printServiceArray.length == 0) {
            throw new IllegalArgumentException("services must be non-null and non-empty");
        }
        if (printRequestAttributeSet == null) {
            throw new IllegalArgumentException("attributes must be non-null");
        }
        if (printService != null) {
            for (int i = 0; i < printServiceArray.length; ++i) {
                if (!((Object)printServiceArray[i]).equals(printService)) continue;
                n3 = i;
                break;
            }
            if (n3 < 0) {
                throw new IllegalArgumentException("services must contain defaultService");
            }
        } else {
            n3 = 0;
        }
        Component component = null;
        Rectangle rectangle = graphicsConfiguration == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds() : graphicsConfiguration.getBounds();
        ServiceDialog serviceDialog = component instanceof Frame ? new ServiceDialog(graphicsConfiguration, n + rectangle.x, n2 + rectangle.y, printServiceArray, n3, docFlavor, printRequestAttributeSet, (Frame)component) : new ServiceDialog(graphicsConfiguration, n + rectangle.x, n2 + rectangle.y, printServiceArray, n3, docFlavor, printRequestAttributeSet, (Dialog)component);
        Rectangle rectangle2 = serviceDialog.getBounds();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            rectangle = rectangle.union(graphicsDeviceArray[i].getDefaultConfiguration().getBounds());
        }
        if (!rectangle.contains(rectangle2)) {
            serviceDialog.setLocationRelativeTo(component);
        }
        serviceDialog.show();
        if (serviceDialog.getStatus() == 1) {
            PrintRequestAttributeSet printRequestAttributeSet2 = serviceDialog.getAttributes();
            Class<Destination> clazz = Destination.class;
            Class<SunAlternateMedia> clazz2 = SunAlternateMedia.class;
            Class<Fidelity> clazz3 = Fidelity.class;
            if (printRequestAttributeSet.containsKey(clazz) && !printRequestAttributeSet2.containsKey(clazz)) {
                printRequestAttributeSet.remove(clazz);
            }
            if (printRequestAttributeSet.containsKey(clazz2) && !printRequestAttributeSet2.containsKey(clazz2)) {
                printRequestAttributeSet.remove(clazz2);
            }
            printRequestAttributeSet.addAll(printRequestAttributeSet2);
            Fidelity fidelity = (Fidelity)printRequestAttributeSet.get(clazz3);
            if (fidelity != null && fidelity == Fidelity.FIDELITY_TRUE) {
                ServiceUI.removeUnsupportedAttributes(serviceDialog.getPrintService(), docFlavor, printRequestAttributeSet);
            }
        }
        return serviceDialog.getPrintService();
    }

    private static void removeUnsupportedAttributes(PrintService printService, DocFlavor docFlavor, AttributeSet attributeSet) {
        AttributeSet attributeSet2 = printService.getUnsupportedAttributes(docFlavor, attributeSet);
        if (attributeSet2 != null) {
            Attribute[] attributeArray = attributeSet2.toArray();
            for (int i = 0; i < attributeArray.length; ++i) {
                Class<? extends Attribute> clazz = attributeArray[i].getCategory();
                if (printService.isAttributeCategorySupported(clazz)) {
                    Attribute attribute = (Attribute)printService.getDefaultAttributeValue(clazz);
                    if (attribute != null) {
                        attributeSet.add(attribute);
                        continue;
                    }
                    attributeSet.remove(clazz);
                    continue;
                }
                attributeSet.remove(clazz);
            }
        }
    }
}

