/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.text.normalizer.CharTrie;
import sun.text.normalizer.ICUData;
import sun.text.normalizer.NormalizerImpl;
import sun.text.normalizer.RangeValueIterator;
import sun.text.normalizer.Trie;
import sun.text.normalizer.TrieIterator;
import sun.text.normalizer.UCharacter;
import sun.text.normalizer.UCharacterPropertyReader;
import sun.text.normalizer.UTF16;
import sun.text.normalizer.UnicodeSet;
import sun.text.normalizer.VersionInfo;

public final class UCharacterProperty
implements Trie.DataManipulate {
    public CharTrie m_trie_;
    public char[] m_trieIndex_;
    public char[] m_trieData_;
    public int m_trieInitialValue_;
    public int[] m_property_;
    public VersionInfo m_unicodeVersion_;
    public static final int EXC_UPPERCASE_ = 0;
    public static final int EXC_LOWERCASE_ = 1;
    public static final int EXC_TITLECASE_ = 2;
    public static final int EXC_UNUSED_ = 3;
    public static final int EXC_NUMERIC_VALUE_ = 4;
    public static final int EXC_DENOMINATOR_VALUE_ = 5;
    public static final int EXC_MIRROR_MAPPING_ = 6;
    public static final int EXC_SPECIAL_CASING_ = 7;
    public static final int EXC_CASE_FOLDING_ = 8;
    public static final int EXC_COMBINING_CLASS_ = 9;
    public static final char LATIN_SMALL_LETTER_I_ = 'i';
    public static final int TYPE_MASK = 31;
    public static final int EXCEPTION_MASK = 32;
    char[] m_case_;
    int[] m_exception_;
    CharTrie m_additionalTrie_;
    int[] m_additionalVectors_;
    int m_additionalColumnsCount_;
    int m_maxBlockScriptValue_;
    int m_maxJTGValue_;
    private static UCharacterProperty INSTANCE_ = null;
    private static final String DATA_FILE_NAME_ = "/sun/text/resources/uprops.icu";
    private static final int DATA_BUFFER_SIZE_ = 25000;
    private static final int EXC_GROUP_ = 8;
    private static final int EXC_GROUP_MASK_ = 255;
    private static final int EXC_DIGIT_MASK_ = 65535;
    private static final byte[] FLAGS_OFFSET_ = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    private static final int VALUE_SHIFT_ = 20;
    private static final int UNSIGNED_VALUE_MASK_AFTER_SHIFT_ = 2047;
    private static final int NUMERIC_TYPE_SHIFT = 12;
    private static final int SUPPLEMENTARY_FOLD_INDICATOR_MASK_ = 32768;
    private static final int SUPPLEMENTARY_FOLD_OFFSET_MASK_ = Short.MAX_VALUE;
    private static final int LEAD_SURROGATE_SHIFT_ = 10;
    private static final int SURROGATE_OFFSET_ = -56613888;
    private static final int LAST_CHAR_MASK_ = 65535;
    private static final int FIRST_NIBBLE_SHIFT_ = 4;
    private static final int LAST_NIBBLE_MASK_ = 15;
    private static final int AGE_SHIFT_ = 24;
    private static final int TAB = 9;
    private static final int LF = 10;
    private static final int FF = 12;
    private static final int CR = 13;
    private static final int U_A = 65;
    private static final int U_Z = 90;
    private static final int U_a = 97;
    private static final int U_z = 122;
    private static final int DEL = 127;
    private static final int NL = 133;
    private static final int NBSP = 160;
    private static final int CGJ = 847;
    private static final int FIGURESP = 8199;
    private static final int HAIRSP = 8202;
    private static final int ZWNJ = 8204;
    private static final int ZWJ = 8205;
    private static final int RLM = 8207;
    private static final int NNBSP = 8239;
    private static final int WJ = 8288;
    private static final int INHSWAP = 8298;
    private static final int NOMDIG = 8303;
    private static final int ZWNBSP = 65279;

    public void setIndexData(CharTrie.FriendAgent friendAgent) {
        this.m_trieIndex_ = friendAgent.getPrivateIndex();
        this.m_trieData_ = friendAgent.getPrivateData();
        this.m_trieInitialValue_ = friendAgent.getPrivateInitialValue();
    }

    public int getFoldingOffset(int n) {
        if ((n & 0x8000) != 0) {
            return n & Short.MAX_VALUE;
        }
        return 0;
    }

    public int getProperty(int n) {
        if (n < 55296 || n > 56319 && n < 65536) {
            try {
                return this.m_property_[this.m_trieData_[(this.m_trieIndex_[n >> 5] << 2) + (n & 0x1F)]];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return this.m_property_[this.m_trieInitialValue_];
            }
        }
        if (n <= 56319) {
            return this.m_property_[this.m_trieData_[(this.m_trieIndex_[320 + (n >> 5)] << 2) + (n & 0x1F)]];
        }
        if (n <= 0x10FFFF) {
            return this.m_property_[this.m_trie_.getSurrogateValue(UTF16.getLeadSurrogate(n), (char)(n & 0x3FF))];
        }
        return this.m_property_[this.m_trieInitialValue_];
    }

    public static int getSignedValue(int n) {
        return n >> 20;
    }

    public static int getExceptionIndex(int n) {
        return n >> 20 & 0x7FF;
    }

    public boolean hasExceptionValue(int n, int n2) {
        return (this.m_exception_[n] & 1 << n2) != 0;
    }

    public int getException(int n, int n2) {
        if (n2 == 9) {
            return this.m_exception_[n];
        }
        int n3 = this.m_exception_[n];
        ++n;
        n = this.addExceptionOffset(n3, n2, n);
        return this.m_exception_[n];
    }

    public void getFoldCase(int n, int n2, StringBuffer stringBuffer) {
        n += 2;
        while (n2 > 0) {
            stringBuffer.append(this.m_case_[n]);
            ++n;
            --n2;
        }
    }

    public int getAdditional(int n) {
        return this.m_additionalVectors_[this.m_additionalTrie_.getCodePointValue(n)];
    }

    public VersionInfo getAge(int n) {
        int n2 = this.getAdditional(n) >> 24;
        return VersionInfo.getInstance(n2 >> 4 & 0xF, n2 & 0xF, 0, 0);
    }

    public static int getRawSupplementary(char c, char c2) {
        return (c << 10) + c2 + -56613888;
    }

    public static UCharacterProperty getInstance() throws RuntimeException {
        if (INSTANCE_ == null) {
            try {
                INSTANCE_ = new UCharacterProperty();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        return INSTANCE_;
    }

    public static boolean isRuleWhiteSpace(int n) {
        return n >= 9 && n <= 8233 && (n <= 13 || n == 32 || n == 133 || n == 8206 || n == 8207 || n >= 8232);
    }

    private UCharacterProperty() throws IOException {
        InputStream inputStream = ICUData.getRequiredStream(DATA_FILE_NAME_);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 25000);
        UCharacterPropertyReader uCharacterPropertyReader = new UCharacterPropertyReader(bufferedInputStream);
        uCharacterPropertyReader.read(this);
        bufferedInputStream.close();
        this.m_trie_.putIndexData(this);
    }

    private int addExceptionOffset(int n, int n2, int n3) {
        int n4 = n3;
        if (n2 >= 8) {
            n4 += FLAGS_OFFSET_[n & 0xFF];
            n >>= 8;
            n2 -= 8;
        }
        int n5 = (1 << n2) - 1;
        return n4 += FLAGS_OFFSET_[n & n5];
    }

    public UnicodeSet addPropertyStarts(UnicodeSet unicodeSet) {
        int n;
        int n2;
        TrieIterator trieIterator = new TrieIterator(this.m_trie_);
        RangeValueIterator.Element element = new RangeValueIterator.Element();
        while (trieIterator.next(element)) {
            unicodeSet.add(element.start);
        }
        TrieIterator trieIterator2 = new TrieIterator(this.m_additionalTrie_);
        RangeValueIterator.Element element2 = new RangeValueIterator.Element();
        while (trieIterator2.next(element2)) {
            unicodeSet.add(element2.start);
        }
        unicodeSet.add(9);
        unicodeSet.add(14);
        unicodeSet.add(28);
        unicodeSet.add(32);
        unicodeSet.add(133);
        unicodeSet.add(134);
        unicodeSet.add(127);
        unicodeSet.add(8202);
        unicodeSet.add(8208);
        unicodeSet.add(8298);
        unicodeSet.add(8304);
        unicodeSet.add(65279);
        unicodeSet.add(65280);
        unicodeSet.add(160);
        unicodeSet.add(161);
        unicodeSet.add(8199);
        unicodeSet.add(8200);
        unicodeSet.add(8239);
        unicodeSet.add(8240);
        unicodeSet.add(12295);
        unicodeSet.add(12296);
        unicodeSet.add(19968);
        unicodeSet.add(19969);
        unicodeSet.add(20108);
        unicodeSet.add(20109);
        unicodeSet.add(19977);
        unicodeSet.add(19978);
        unicodeSet.add(22235);
        unicodeSet.add(22236);
        unicodeSet.add(20116);
        unicodeSet.add(20117);
        unicodeSet.add(20845);
        unicodeSet.add(20846);
        unicodeSet.add(19971);
        unicodeSet.add(19972);
        unicodeSet.add(20843);
        unicodeSet.add(20844);
        unicodeSet.add(20061);
        unicodeSet.add(20062);
        unicodeSet.add(97);
        unicodeSet.add(123);
        unicodeSet.add(65);
        unicodeSet.add(91);
        unicodeSet.add(8288);
        unicodeSet.add(65520);
        unicodeSet.add(65532);
        unicodeSet.add(917504);
        unicodeSet.add(921600);
        unicodeSet.add(847);
        unicodeSet.add(848);
        unicodeSet.add(8204);
        unicodeSet.add(8206);
        unicodeSet.add(4352);
        int n3 = 1;
        for (n2 = 4442; n2 <= 4447; ++n2) {
            n = UCharacter.getIntPropertyValue(n2, 4107);
            if (n3 == n) continue;
            n3 = n;
            unicodeSet.add(n2);
        }
        unicodeSet.add(4448);
        n3 = 2;
        for (n2 = 4515; n2 <= 4519; ++n2) {
            n = UCharacter.getIntPropertyValue(n2, 4107);
            if (n3 == n) continue;
            n3 = n;
            unicodeSet.add(n2);
        }
        unicodeSet.add(4520);
        n3 = 3;
        for (n2 = 4602; n2 <= 4607; ++n2) {
            n = UCharacter.getIntPropertyValue(n2, 4107);
            if (n3 == n) continue;
            n3 = n;
            unicodeSet.add(n2);
        }
        return unicodeSet;
    }

    public UnicodeSet getInclusions() {
        UnicodeSet unicodeSet = new UnicodeSet();
        NormalizerImpl.addPropertyStarts(unicodeSet);
        this.addPropertyStarts(unicodeSet);
        return unicodeSet;
    }
}

