/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.NativeLibLoader;
import sun.awt.image.SunWritableRaster;

public class IntegerComponentRaster
extends SunWritableRaster {
    static final int TYPE_CUSTOM = 0;
    static final int TYPE_BYTE_SAMPLES = 1;
    static final int TYPE_USHORT_SAMPLES = 2;
    static final int TYPE_INT_SAMPLES = 3;
    static final int TYPE_BYTE_BANDED_SAMPLES = 4;
    static final int TYPE_USHORT_BANDED_SAMPLES = 5;
    static final int TYPE_INT_BANDED_SAMPLES = 6;
    static final int TYPE_BYTE_PACKED_SAMPLES = 7;
    static final int TYPE_USHORT_PACKED_SAMPLES = 8;
    static final int TYPE_INT_PACKED_SAMPLES = 9;
    static final int TYPE_INT_8BIT_SAMPLES = 10;
    static final int TYPE_BYTE_BINARY_SAMPLES = 11;
    protected int bandOffset;
    protected int[] dataOffsets;
    protected int scanlineStride;
    protected int pixelStride;
    protected int[] data;
    protected int numDataElems;
    int type;
    private int maxX;
    private int maxY;

    private static native void initIDs();

    public IntegerComponentRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public IntegerComponentRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public IntegerComponentRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, IntegerComponentRaster integerComponentRaster) {
        super(sampleModel, dataBuffer, rectangle, point, integerComponentRaster);
        int n;
        boolean bl;
        SinglePixelPackedSampleModel singlePixelPackedSampleModel;
        this.maxX = this.minX + this.width;
        this.maxY = this.minY + this.height;
        if (!(dataBuffer instanceof DataBufferInt)) {
            throw new RasterFormatException("IntegerComponentRasters must haveinteger DataBuffers");
        }
        DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
        this.data = dataBufferInt.getData();
        if (dataBufferInt.getNumBanks() != 1) {
            throw new RasterFormatException("DataBuffer for IntegerComponentRasters must only have 1 bank.");
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            int[] nArray = singlePixelPackedSampleModel.getBitOffsets();
            bl = false;
            for (n = 1; n < nArray.length; ++n) {
                if (nArray[n] % 8 == 0) continue;
                bl = true;
            }
        } else {
            throw new RasterFormatException("IntegerComponentRasters must have SinglePixelPackedSampleModel");
        }
        this.type = bl ? 9 : 10;
        this.scanlineStride = singlePixelPackedSampleModel.getScanlineStride();
        this.pixelStride = 1;
        this.dataOffsets = new int[1];
        this.dataOffsets[0] = dataBufferInt.getOffset();
        this.bandOffset = this.dataOffsets[0];
        n = rectangle.x - point.x;
        int n2 = rectangle.y - point.y;
        this.dataOffsets[0] = this.dataOffsets[0] + (n + n2 * this.scanlineStride);
        this.numDataElems = singlePixelPackedSampleModel.getNumDataElements();
        this.verify(false);
    }

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public int getDataOffset(int n) {
        return this.dataOffsets[n];
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelStride() {
        return this.pixelStride;
    }

    public int[] getDataStorage() {
        return this.data;
    }

    public Object getDataElements(int n, int n2, Object object) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray = object == null ? new int[this.numDataElements] : (int[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        for (int i = 0; i < this.numDataElements; ++i) {
            nArray[i] = this.data[this.dataOffsets[i] + n3];
        }
        return nArray;
    }

    public Object getDataElements(int n, int n2, int n3, int n4, Object object) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray = object instanceof int[] ? (int[])object : new int[this.numDataElements * n3 * n4];
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5;
            int n9 = 0;
            while (n9 < n3) {
                for (int i = 0; i < this.numDataElements; ++i) {
                    nArray[n6++] = this.data[this.dataOffsets[i] + n8];
                }
                ++n9;
                n8 += this.pixelStride;
            }
            ++n7;
            n5 += this.scanlineStride;
        }
        return nArray;
    }

    public void setDataElements(int n, int n2, Object object) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray = (int[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        for (int i = 0; i < this.numDataElements; ++i) {
            this.data[this.dataOffsets[i] + n3] = nArray[i];
        }
        this.notifyChanged();
    }

    public void setDataElements(int n, int n2, Raster raster) {
        int n3 = n + raster.getMinX();
        int n4 = n2 + raster.getMinY();
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        if (n3 < this.minX || n4 < this.minY || n3 + n5 > this.maxX || n4 + n6 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(n3, n4, n5, n6, raster);
    }

    private void setDataElements(int n, int n2, int n3, int n4, Raster raster) {
        int n5;
        Object object;
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        int n6 = raster.getMinX();
        int n7 = raster.getMinY();
        int[] nArray = null;
        if (raster instanceof IntegerComponentRaster && this.pixelStride == 1 && this.numDataElements == 1) {
            int n8;
            object = (IntegerComponentRaster)raster;
            if (((Raster)object).getNumDataElements() != 1) {
                throw new ArrayIndexOutOfBoundsException("Number of bands does not match");
            }
            nArray = ((IntegerComponentRaster)object).getDataStorage();
            n5 = ((IntegerComponentRaster)object).getScanlineStride();
            int n9 = n8 = ((IntegerComponentRaster)object).getDataOffset(0);
            int n10 = this.dataOffsets[0] + (n2 - this.minY) * this.scanlineStride + (n - this.minX);
            if (((IntegerComponentRaster)object).getPixelStride() == this.pixelStride) {
                n3 *= this.pixelStride;
                for (int i = 0; i < n4; ++i) {
                    System.arraycopy(nArray, n9, this.data, n10, n3);
                    n9 += n5;
                    n10 += this.scanlineStride;
                }
                this.notifyChanged();
                return;
            }
        }
        object = null;
        for (n5 = 0; n5 < n4; ++n5) {
            object = raster.getDataElements(n6, n7 + n5, n3, 1, object);
            this.setDataElements(n, n2 + n5, n3, 1, object);
        }
    }

    public void setDataElements(int n, int n2, int n3, int n4, Object object) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray = (int[])object;
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5;
            int n9 = 0;
            while (n9 < n3) {
                for (int i = 0; i < this.numDataElements; ++i) {
                    this.data[this.dataOffsets[i] + n8] = nArray[n6++];
                }
                ++n9;
                n8 += this.pixelStride;
            }
            ++n7;
            n5 += this.scanlineStride;
        }
        this.notifyChanged();
    }

    public WritableRaster createWritableChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < this.minX) {
            throw new RasterFormatException("x lies outside raster");
        }
        if (n2 < this.minY) {
            throw new RasterFormatException("y lies outside raster");
        }
        if (n + n3 < n || n + n3 > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n7 = n5 - n;
        int n8 = n6 - n2;
        this.notifyStolen();
        return new IntegerComponentRaster(sampleModel, this.dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n7, this.sampleModelTranslateY + n8), this);
    }

    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        return this.createWritableChild(n, n2, n3, n4, n5, n6, nArray);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new RasterFormatException("negative " + (n <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n, n2);
        return new IntegerComponentRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    private void verify(boolean bl) {
        if (this.dataOffsets[0] < 0) {
            throw new RasterFormatException("Data offset (" + this.dataOffsets[0] + ") must be >= 0");
        }
        int n = 0;
        for (int i = 0; i < this.numDataElements; ++i) {
            int n2 = (this.height - 1) * this.scanlineStride + (this.width - 1) * this.pixelStride + this.dataOffsets[i];
            if (n2 <= n) continue;
            n = n2;
        }
        if (this.data.length < n) {
            throw new RasterFormatException("Data array too small (should be " + n + " but is " + this.data.length + " )");
        }
    }

    public String toString() {
        return new String("IntegerComponentRaster: width = " + this.width + " height = " + this.height + " #Bands = " + this.numBands + " #DataElements " + this.numDataElements + " xOff = " + this.sampleModelTranslateX + " yOff = " + this.sampleModelTranslateY + " dataOffset[0] " + this.dataOffsets[0]);
    }

    static {
        NativeLibLoader.loadLibraries();
        IntegerComponentRaster.initIDs();
    }
}

