/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEG;
import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import com.sun.imageio.plugins.jpeg.JPEGImageWriter;
import com.sun.imageio.plugins.jpeg.JPEGMetadata;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import com.sun.imageio.plugins.jpeg.SOFMarkerSegment;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class JFIFMarkerSegment
extends MarkerSegment {
    int majorVersion;
    int minorVersion;
    int resUnits;
    int Xdensity;
    int Ydensity;
    int thumbWidth;
    int thumbHeight;
    JFIFThumbRGB thumb = null;
    ArrayList extSegments = new ArrayList();
    ICCMarkerSegment iccSegment = null;
    private static final int THUMB_JPEG = 16;
    private static final int THUMB_PALETTE = 17;
    private static final int THUMB_UNASSIGNED = 18;
    private static final int THUMB_RGB = 19;
    private static final int DATA_SIZE = 14;
    private static final int ID_SIZE = 5;
    private final int MAX_THUMB_WIDTH = 255;
    private final int MAX_THUMB_HEIGHT = 255;
    private final boolean debug = false;
    private boolean inICC = false;
    private ICCMarkerSegment tempICCSegment = null;

    JFIFMarkerSegment() {
        super(224);
        this.majorVersion = 1;
        this.minorVersion = 2;
        this.resUnits = 0;
        this.Xdensity = 1;
        this.Ydensity = 1;
        this.thumbWidth = 0;
        this.thumbHeight = 0;
    }

    JFIFMarkerSegment(JPEGBuffer jPEGBuffer) throws IOException {
        super(jPEGBuffer);
        jPEGBuffer.bufPtr += 5;
        this.majorVersion = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
        this.minorVersion = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
        this.resUnits = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
        this.Xdensity = (jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF) << 8;
        this.Xdensity |= jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        this.Ydensity = (jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF) << 8;
        this.Ydensity |= jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        this.thumbWidth = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        this.thumbHeight = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        jPEGBuffer.bufAvail -= 14;
        if (this.thumbWidth > 0) {
            this.thumb = new JFIFThumbRGB(jPEGBuffer, this.thumbWidth, this.thumbHeight);
        }
    }

    JFIFMarkerSegment(Node node) throws IIOInvalidTreeException {
        this();
        this.updateFromNativeNode(node, true);
    }

    protected Object clone() {
        JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)super.clone();
        if (!this.extSegments.isEmpty()) {
            jFIFMarkerSegment.extSegments = new ArrayList();
            for (JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment : this.extSegments) {
                jFIFMarkerSegment.extSegments.add(jFIFExtensionMarkerSegment.clone());
            }
        }
        if (this.iccSegment != null) {
            jFIFMarkerSegment.iccSegment = (ICCMarkerSegment)this.iccSegment.clone();
        }
        return jFIFMarkerSegment;
    }

    void addJFXX(JPEGBuffer jPEGBuffer, JPEGImageReader jPEGImageReader) throws IOException {
        this.extSegments.add(new JFIFExtensionMarkerSegment(jPEGBuffer, jPEGImageReader));
    }

    void addICC(JPEGBuffer jPEGBuffer) throws IOException {
        if (!this.inICC) {
            if (this.iccSegment != null) {
                throw new IIOException("> 1 ICC APP2 Marker Segment not supported");
            }
            this.tempICCSegment = new ICCMarkerSegment(jPEGBuffer);
            if (!this.inICC) {
                this.iccSegment = this.tempICCSegment;
                this.tempICCSegment = null;
            }
        } else if (this.tempICCSegment.addData(jPEGBuffer)) {
            this.iccSegment = this.tempICCSegment;
            this.tempICCSegment = null;
        }
    }

    void addICC(ICC_ColorSpace iCC_ColorSpace) throws IOException {
        if (this.iccSegment != null) {
            throw new IIOException("> 1 ICC APP2 Marker Segment not supported");
        }
        this.iccSegment = new ICCMarkerSegment(iCC_ColorSpace);
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("app0JFIF");
        iIOMetadataNode.setAttribute("majorVersion", Integer.toString(this.majorVersion));
        iIOMetadataNode.setAttribute("minorVersion", Integer.toString(this.minorVersion));
        iIOMetadataNode.setAttribute("resUnits", Integer.toString(this.resUnits));
        iIOMetadataNode.setAttribute("Xdensity", Integer.toString(this.Xdensity));
        iIOMetadataNode.setAttribute("Ydensity", Integer.toString(this.Ydensity));
        iIOMetadataNode.setAttribute("thumbWidth", Integer.toString(this.thumbWidth));
        iIOMetadataNode.setAttribute("thumbHeight", Integer.toString(this.thumbHeight));
        if (!this.extSegments.isEmpty()) {
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("JFXX");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            for (JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment : this.extSegments) {
                iIOMetadataNode2.appendChild(jFIFExtensionMarkerSegment.getNativeNode());
            }
        }
        if (this.iccSegment != null) {
            iIOMetadataNode.appendChild(this.iccSegment.getNativeNode());
        }
        return iIOMetadataNode;
    }

    void updateFromNativeNode(Node node, boolean bl) throws IIOInvalidTreeException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap.getLength() > 0) {
            int n = JFIFMarkerSegment.getAttributeValue(node, namedNodeMap, "majorVersion", 0, 255, false);
            this.majorVersion = n != -1 ? n : this.majorVersion;
            n = JFIFMarkerSegment.getAttributeValue(node, namedNodeMap, "minorVersion", 0, 255, false);
            this.minorVersion = n != -1 ? n : this.minorVersion;
            n = JFIFMarkerSegment.getAttributeValue(node, namedNodeMap, "resUnits", 0, 2, false);
            this.resUnits = n != -1 ? n : this.resUnits;
            n = JFIFMarkerSegment.getAttributeValue(node, namedNodeMap, "Xdensity", 1, 65535, false);
            this.Xdensity = n != -1 ? n : this.Xdensity;
            n = JFIFMarkerSegment.getAttributeValue(node, namedNodeMap, "Ydensity", 1, 65535, false);
            this.Ydensity = n != -1 ? n : this.Ydensity;
            n = JFIFMarkerSegment.getAttributeValue(node, namedNodeMap, "thumbWidth", 0, 255, false);
            this.thumbWidth = n != -1 ? n : this.thumbWidth;
            n = JFIFMarkerSegment.getAttributeValue(node, namedNodeMap, "thumbHeight", 0, 255, false);
            int n2 = this.thumbHeight = n != -1 ? n : this.thumbHeight;
        }
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            if (n > 2) {
                throw new IIOInvalidTreeException("app0JFIF node cannot have > 2 children", node);
            }
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                String string = node2.getNodeName();
                if (string.equals("JFXX")) {
                    if (!this.extSegments.isEmpty() && bl) {
                        throw new IIOInvalidTreeException("app0JFIF node cannot have > 1 JFXX node", node);
                    }
                    NodeList nodeList2 = node2.getChildNodes();
                    int n3 = nodeList2.getLength();
                    for (int j = 0; j < n3; ++j) {
                        Node node3 = nodeList2.item(j);
                        this.extSegments.add(new JFIFExtensionMarkerSegment(node3));
                    }
                }
                if (!string.equals("app2ICC")) continue;
                if (this.iccSegment != null && bl) {
                    throw new IIOInvalidTreeException("> 1 ICC APP2 Marker Segment not supported", node);
                }
                this.iccSegment = new ICCMarkerSegment(node2);
            }
        }
    }

    int getThumbnailWidth(int n) {
        if (this.thumb != null) {
            if (n == 0) {
                return this.thumb.getWidth();
            }
            --n;
        }
        JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment = (JFIFExtensionMarkerSegment)this.extSegments.get(n);
        return jFIFExtensionMarkerSegment.thumb.getWidth();
    }

    int getThumbnailHeight(int n) {
        if (this.thumb != null) {
            if (n == 0) {
                return this.thumb.getHeight();
            }
            --n;
        }
        JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment = (JFIFExtensionMarkerSegment)this.extSegments.get(n);
        return jFIFExtensionMarkerSegment.thumb.getHeight();
    }

    BufferedImage getThumbnail(ImageInputStream imageInputStream, int n, JPEGImageReader jPEGImageReader) throws IOException {
        jPEGImageReader.thumbnailStarted(n);
        BufferedImage bufferedImage = null;
        if (this.thumb != null && n == 0) {
            bufferedImage = this.thumb.getThumbnail(imageInputStream, jPEGImageReader);
        } else {
            if (this.thumb != null) {
                --n;
            }
            JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment = (JFIFExtensionMarkerSegment)this.extSegments.get(n);
            bufferedImage = jFIFExtensionMarkerSegment.thumb.getThumbnail(imageInputStream, jPEGImageReader);
        }
        jPEGImageReader.thumbnailComplete();
        return bufferedImage;
    }

    void write(ImageOutputStream imageOutputStream, JPEGImageWriter jPEGImageWriter) throws IOException {
        this.write(imageOutputStream, null, jPEGImageWriter);
    }

    void write(ImageOutputStream imageOutputStream, BufferedImage bufferedImage, JPEGImageWriter jPEGImageWriter) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = null;
        if (bufferedImage != null) {
            n = bufferedImage.getWidth();
            n2 = bufferedImage.getHeight();
            if (n > 255 || n2 > 255) {
                jPEGImageWriter.warningOccurred(12);
            }
            n = Math.min(n, 255);
            n2 = Math.min(n2, 255);
            nArray = bufferedImage.getRaster().getPixels(0, 0, n, n2, (int[])null);
            n3 = nArray.length;
        }
        this.length = 16 + n3;
        this.writeTag(imageOutputStream);
        byte[] byArray = new byte[]{74, 70, 73, 70, 0};
        imageOutputStream.write(byArray);
        imageOutputStream.write(this.majorVersion);
        imageOutputStream.write(this.minorVersion);
        imageOutputStream.write(this.resUnits);
        JFIFMarkerSegment.write2bytes(imageOutputStream, this.Xdensity);
        JFIFMarkerSegment.write2bytes(imageOutputStream, this.Ydensity);
        imageOutputStream.write(n);
        imageOutputStream.write(n2);
        if (nArray != null) {
            jPEGImageWriter.thumbnailStarted(0);
            this.writeThumbnailData(imageOutputStream, nArray, jPEGImageWriter);
            jPEGImageWriter.thumbnailComplete();
        }
    }

    void writeThumbnailData(ImageOutputStream imageOutputStream, int[] nArray, JPEGImageWriter jPEGImageWriter) throws IOException {
        int n = nArray.length / 20;
        if (n == 0) {
            n = 1;
        }
        for (int i = 0; i < nArray.length; ++i) {
            imageOutputStream.write(nArray[i]);
            if (i <= n || i % n != 0) continue;
            jPEGImageWriter.thumbnailProgress((float)i * 100.0f / (float)nArray.length);
        }
    }

    void writeWithThumbs(ImageOutputStream imageOutputStream, List list, JPEGImageWriter jPEGImageWriter) throws IOException {
        if (list != null) {
            JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment = null;
            if (list.size() == 1) {
                if (!this.extSegments.isEmpty()) {
                    jFIFExtensionMarkerSegment = (JFIFExtensionMarkerSegment)this.extSegments.get(0);
                }
                this.writeThumb(imageOutputStream, (BufferedImage)list.get(0), jFIFExtensionMarkerSegment, 0, true, jPEGImageWriter);
            } else {
                this.write(imageOutputStream, jPEGImageWriter);
                for (int i = 0; i < list.size(); ++i) {
                    jFIFExtensionMarkerSegment = null;
                    if (i < this.extSegments.size()) {
                        jFIFExtensionMarkerSegment = (JFIFExtensionMarkerSegment)this.extSegments.get(i);
                    }
                    this.writeThumb(imageOutputStream, (BufferedImage)list.get(i), jFIFExtensionMarkerSegment, i, false, jPEGImageWriter);
                }
            }
        } else {
            this.write(imageOutputStream, jPEGImageWriter);
        }
    }

    private void writeThumb(ImageOutputStream imageOutputStream, BufferedImage bufferedImage, JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment, int n, boolean bl, JPEGImageWriter jPEGImageWriter) throws IOException {
        ColorModel colorModel = bufferedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorModel instanceof IndexColorModel) {
            if (bl) {
                this.write(imageOutputStream, jPEGImageWriter);
            }
            if (jFIFExtensionMarkerSegment == null || jFIFExtensionMarkerSegment.code == 17) {
                this.writeJFXXSegment(n, bufferedImage, imageOutputStream, jPEGImageWriter);
            } else {
                BufferedImage bufferedImage2 = ((IndexColorModel)colorModel).convertToIntDiscrete(bufferedImage.getRaster(), false);
                jFIFExtensionMarkerSegment.setThumbnail(bufferedImage2);
                jPEGImageWriter.thumbnailStarted(n);
                jFIFExtensionMarkerSegment.write(imageOutputStream, jPEGImageWriter);
                jPEGImageWriter.thumbnailComplete();
            }
        } else if (colorSpace.getType() == 5) {
            if (jFIFExtensionMarkerSegment == null) {
                if (bl) {
                    this.write(imageOutputStream, bufferedImage, jPEGImageWriter);
                } else {
                    this.writeJFXXSegment(n, bufferedImage, imageOutputStream, jPEGImageWriter);
                }
            } else {
                if (bl) {
                    this.write(imageOutputStream, jPEGImageWriter);
                }
                if (jFIFExtensionMarkerSegment.code == 17) {
                    this.writeJFXXSegment(n, bufferedImage, imageOutputStream, jPEGImageWriter);
                    jPEGImageWriter.warningOccurred(14);
                } else {
                    jFIFExtensionMarkerSegment.setThumbnail(bufferedImage);
                    jPEGImageWriter.thumbnailStarted(n);
                    jFIFExtensionMarkerSegment.write(imageOutputStream, jPEGImageWriter);
                    jPEGImageWriter.thumbnailComplete();
                }
            }
        } else if (colorSpace.getType() == 6) {
            if (jFIFExtensionMarkerSegment == null) {
                if (bl) {
                    BufferedImage bufferedImage3 = JFIFMarkerSegment.expandGrayThumb(bufferedImage);
                    this.write(imageOutputStream, bufferedImage3, jPEGImageWriter);
                } else {
                    this.writeJFXXSegment(n, bufferedImage, imageOutputStream, jPEGImageWriter);
                }
            } else {
                if (bl) {
                    this.write(imageOutputStream, jPEGImageWriter);
                }
                if (jFIFExtensionMarkerSegment.code == 19) {
                    BufferedImage bufferedImage4 = JFIFMarkerSegment.expandGrayThumb(bufferedImage);
                    this.writeJFXXSegment(n, bufferedImage4, imageOutputStream, jPEGImageWriter);
                } else if (jFIFExtensionMarkerSegment.code == 16) {
                    jFIFExtensionMarkerSegment.setThumbnail(bufferedImage);
                    jPEGImageWriter.thumbnailStarted(n);
                    jFIFExtensionMarkerSegment.write(imageOutputStream, jPEGImageWriter);
                    jPEGImageWriter.thumbnailComplete();
                } else if (jFIFExtensionMarkerSegment.code == 17) {
                    this.writeJFXXSegment(n, bufferedImage, imageOutputStream, jPEGImageWriter);
                    jPEGImageWriter.warningOccurred(15);
                }
            }
        } else {
            jPEGImageWriter.warningOccurred(9);
        }
    }

    private void writeJFXXSegment(int n, BufferedImage bufferedImage, ImageOutputStream imageOutputStream, JPEGImageWriter jPEGImageWriter) throws IOException {
        JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment = null;
        try {
            jFIFExtensionMarkerSegment = new JFIFExtensionMarkerSegment(bufferedImage);
        }
        catch (IllegalThumbException illegalThumbException) {
            jPEGImageWriter.warningOccurred(9);
            return;
        }
        jPEGImageWriter.thumbnailStarted(n);
        jFIFExtensionMarkerSegment.write(imageOutputStream, jPEGImageWriter);
        jPEGImageWriter.thumbnailComplete();
    }

    private static BufferedImage expandGrayThumb(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, null);
        return bufferedImage2;
    }

    static void writeDefaultJFIF(ImageOutputStream imageOutputStream, List list, ICC_Profile iCC_Profile, JPEGImageWriter jPEGImageWriter) throws IOException {
        JFIFMarkerSegment jFIFMarkerSegment = new JFIFMarkerSegment();
        jFIFMarkerSegment.writeWithThumbs(imageOutputStream, list, jPEGImageWriter);
        if (iCC_Profile != null) {
            JFIFMarkerSegment.writeICC(iCC_Profile, imageOutputStream);
        }
    }

    void print() {
        this.printTag("JFIF");
        System.out.print("Version ");
        System.out.print(this.majorVersion);
        System.out.println(".0" + Integer.toString(this.minorVersion));
        System.out.print("Resolution units: ");
        System.out.println(this.resUnits);
        System.out.print("X density: ");
        System.out.println(this.Xdensity);
        System.out.print("Y density: ");
        System.out.println(this.Ydensity);
        System.out.print("Thumbnail Width: ");
        System.out.println(this.thumbWidth);
        System.out.print("Thumbnail Height: ");
        System.out.println(this.thumbHeight);
        if (!this.extSegments.isEmpty()) {
            for (JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment : this.extSegments) {
                jFIFExtensionMarkerSegment.print();
            }
        }
        if (this.iccSegment != null) {
            this.iccSegment.print();
        }
    }

    static void writeICC(ICC_Profile iCC_Profile, ImageOutputStream imageOutputStream) throws IOException {
        int n = 2;
        int n2 = "ICC_PROFILE".length() + 1;
        int n3 = 2;
        int n4 = 65535 - n - n2 - n3;
        byte[] byArray = iCC_Profile.getData();
        int n5 = byArray.length / n4;
        if (byArray.length % n4 != 0) {
            ++n5;
        }
        int n6 = 1;
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            int n8 = Math.min(byArray.length - n7, n4);
            int n9 = n8 + n3 + n2 + n;
            imageOutputStream.write(255);
            imageOutputStream.write(226);
            MarkerSegment.write2bytes(imageOutputStream, n9);
            byte[] byArray2 = "ICC_PROFILE".getBytes("US-ASCII");
            imageOutputStream.write(byArray2);
            imageOutputStream.write(0);
            imageOutputStream.write(n6++);
            imageOutputStream.write(n5);
            imageOutputStream.write(byArray, n7, n8);
            n7 += n8;
        }
    }

    class ICCMarkerSegment
    extends MarkerSegment {
        ArrayList chunks;
        byte[] profile;
        private static final int ID_SIZE = 12;
        int chunksRead;
        int numChunks;

        ICCMarkerSegment(ICC_ColorSpace iCC_ColorSpace) {
            super(226);
            this.chunks = null;
            this.profile = null;
            this.chunks = null;
            this.chunksRead = 0;
            this.numChunks = 0;
            this.profile = iCC_ColorSpace.getProfile().getData();
        }

        ICCMarkerSegment(JPEGBuffer jPEGBuffer) throws IOException {
            super(jPEGBuffer);
            this.chunks = null;
            this.profile = null;
            jPEGBuffer.bufPtr += 12;
            jPEGBuffer.bufAvail -= 12;
            this.length -= 12;
            int n = jPEGBuffer.buf[jPEGBuffer.bufPtr] & 0xFF;
            this.numChunks = jPEGBuffer.buf[jPEGBuffer.bufPtr + 1] & 0xFF;
            if (n > this.numChunks) {
                throw new IIOException("Image format Error; chunk num > num chunks");
            }
            if (this.numChunks == 1) {
                this.length -= 2;
                this.profile = new byte[this.length];
                jPEGBuffer.bufPtr += 2;
                jPEGBuffer.bufAvail -= 2;
                jPEGBuffer.readData(this.profile);
                JFIFMarkerSegment.this.inICC = false;
            } else {
                byte[] byArray = new byte[this.length];
                this.length -= 2;
                jPEGBuffer.readData(byArray);
                this.chunks = new ArrayList();
                this.chunks.add(byArray);
                this.chunksRead = 1;
                JFIFMarkerSegment.this.inICC = true;
            }
        }

        ICCMarkerSegment(Node node) throws IIOInvalidTreeException {
            IIOMetadataNode iIOMetadataNode;
            ICC_Profile iCC_Profile;
            super(226);
            this.chunks = null;
            this.profile = null;
            if (node instanceof IIOMetadataNode && (iCC_Profile = (ICC_Profile)(iIOMetadataNode = (IIOMetadataNode)node).getUserObject()) != null) {
                this.profile = iCC_Profile.getData();
            }
        }

        protected Object clone() {
            ICCMarkerSegment iCCMarkerSegment = (ICCMarkerSegment)super.clone();
            if (this.profile != null) {
                iCCMarkerSegment.profile = (byte[])this.profile.clone();
            }
            return iCCMarkerSegment;
        }

        boolean addData(JPEGBuffer jPEGBuffer) throws IOException {
            ++jPEGBuffer.bufPtr;
            --jPEGBuffer.bufAvail;
            int n = (jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF) << 8;
            n |= jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
            jPEGBuffer.bufAvail -= 2;
            n -= 2;
            jPEGBuffer.bufPtr += 12;
            jPEGBuffer.bufAvail -= 12;
            n -= 12;
            int n2 = jPEGBuffer.buf[jPEGBuffer.bufPtr] & 0xFF;
            if (n2 > this.numChunks) {
                throw new IIOException("Image format Error; chunk num > num chunks");
            }
            int n3 = jPEGBuffer.buf[jPEGBuffer.bufPtr + 1] & 0xFF;
            if (this.numChunks != n3) {
                throw new IIOException("Image format Error; icc num chunks mismatch");
            }
            boolean bl = false;
            byte[] byArray = new byte[n -= 2];
            jPEGBuffer.readData(byArray);
            this.chunks.add(byArray);
            this.length += n;
            ++this.chunksRead;
            if (this.chunksRead < this.numChunks) {
                JFIFMarkerSegment.this.inICC = true;
            } else {
                this.profile = new byte[this.length];
                int n4 = 0;
                for (int i = 1; i <= this.numChunks; ++i) {
                    boolean bl2 = false;
                    for (int j = 0; j < this.chunks.size(); ++j) {
                        byte[] byArray2 = (byte[])this.chunks.get(j);
                        if (byArray2[0] != i) continue;
                        System.arraycopy(byArray2, 2, this.profile, n4, byArray2.length - 2);
                        n4 += byArray2.length - 2;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    throw new IIOException("Image Format Error: Missing ICC chunk num " + i);
                }
                this.chunks = null;
                this.chunksRead = 0;
                this.numChunks = 0;
                JFIFMarkerSegment.this.inICC = false;
                bl = true;
            }
            return bl;
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("app2ICC");
            if (this.profile != null) {
                iIOMetadataNode.setUserObject(ICC_Profile.getInstance(this.profile));
            }
            return iIOMetadataNode;
        }

        void write(ImageOutputStream imageOutputStream) throws IOException {
        }

        void print() {
            this.printTag("ICC Profile APP2");
        }
    }

    private class IllegalThumbException
    extends Exception {
        private IllegalThumbException() {
        }
    }

    class JFIFExtensionMarkerSegment
    extends MarkerSegment {
        int code;
        JFIFThumb thumb;
        private static final int DATA_SIZE = 6;
        private static final int ID_SIZE = 5;

        JFIFExtensionMarkerSegment(JPEGBuffer jPEGBuffer, JPEGImageReader jPEGImageReader) throws IOException {
            super(jPEGBuffer);
            jPEGBuffer.bufPtr += 5;
            this.code = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
            jPEGBuffer.bufAvail -= 6;
            if (this.code == 16) {
                this.thumb = new JFIFThumbJPEG(jPEGBuffer, this.length, jPEGImageReader);
            } else {
                jPEGBuffer.loadBuf(2);
                int n = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
                int n2 = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
                jPEGBuffer.bufAvail -= 2;
                this.thumb = this.code == 17 ? new JFIFThumbPalette(jPEGBuffer, n, n2) : new JFIFThumbRGB(jPEGBuffer, n, n2);
            }
        }

        JFIFExtensionMarkerSegment(Node node) throws IIOInvalidTreeException {
            super(224);
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap.getLength() > 0) {
                this.code = JFIFExtensionMarkerSegment.getAttributeValue(node, namedNodeMap, "extensionCode", 16, 19, false);
                if (this.code == 18) {
                    throw new IIOInvalidTreeException("invalid extensionCode attribute value", node);
                }
            } else {
                this.code = 18;
            }
            if (node.getChildNodes().getLength() != 1) {
                throw new IIOInvalidTreeException("app0JFXX node must have exactly 1 child", node);
            }
            Node node2 = node.getFirstChild();
            String string = node2.getNodeName();
            if (string.equals("JFIFthumbJPEG")) {
                if (this.code == 18) {
                    this.code = 16;
                }
                this.thumb = new JFIFThumbJPEG(node2);
            } else if (string.equals("JFIFthumbPalette")) {
                if (this.code == 18) {
                    this.code = 17;
                }
                this.thumb = new JFIFThumbPalette(node2);
            } else if (string.equals("JFIFthumbRGB")) {
                if (this.code == 18) {
                    this.code = 19;
                }
                this.thumb = new JFIFThumbRGB(node2);
            } else {
                throw new IIOInvalidTreeException("unrecognized app0JFXX child node", node);
            }
        }

        JFIFExtensionMarkerSegment(BufferedImage bufferedImage) throws IllegalThumbException {
            super(224);
            ColorModel colorModel = bufferedImage.getColorModel();
            int n = colorModel.getColorSpace().getType();
            if (colorModel.hasAlpha()) {
                throw new IllegalThumbException();
            }
            if (colorModel instanceof IndexColorModel) {
                this.code = 17;
                this.thumb = new JFIFThumbPalette(bufferedImage);
            } else if (n == 5) {
                this.code = 19;
                this.thumb = new JFIFThumbRGB(bufferedImage);
            } else if (n == 6) {
                this.code = 16;
                this.thumb = new JFIFThumbJPEG(bufferedImage);
            } else {
                throw new IllegalThumbException();
            }
        }

        void setThumbnail(BufferedImage bufferedImage) {
            try {
                switch (this.code) {
                    case 17: {
                        this.thumb = new JFIFThumbPalette(bufferedImage);
                        break;
                    }
                    case 19: {
                        this.thumb = new JFIFThumbRGB(bufferedImage);
                        break;
                    }
                    case 16: {
                        this.thumb = new JFIFThumbJPEG(bufferedImage);
                    }
                }
            }
            catch (IllegalThumbException illegalThumbException) {
                throw new InternalError("Illegal thumb in setThumbnail!");
            }
        }

        protected Object clone() {
            JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment = (JFIFExtensionMarkerSegment)super.clone();
            if (this.thumb != null) {
                jFIFExtensionMarkerSegment.thumb = (JFIFThumb)this.thumb.clone();
            }
            return jFIFExtensionMarkerSegment;
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("app0JFXX");
            iIOMetadataNode.setAttribute("extensionCode", Integer.toString(this.code));
            iIOMetadataNode.appendChild(this.thumb.getNativeNode());
            return iIOMetadataNode;
        }

        void write(ImageOutputStream imageOutputStream, JPEGImageWriter jPEGImageWriter) throws IOException {
            this.length = 8 + this.thumb.getLength();
            this.writeTag(imageOutputStream);
            byte[] byArray = new byte[]{74, 70, 88, 88, 0};
            imageOutputStream.write(byArray);
            imageOutputStream.write(this.code);
            this.thumb.write(imageOutputStream, jPEGImageWriter);
        }

        void print() {
            this.printTag("JFXX");
            this.thumb.print();
        }
    }

    abstract class JFIFThumb
    implements Cloneable {
        long streamPos = -1L;

        abstract int getLength();

        abstract int getWidth();

        abstract int getHeight();

        abstract BufferedImage getThumbnail(ImageInputStream var1, JPEGImageReader var2) throws IOException;

        protected JFIFThumb() {
        }

        protected JFIFThumb(JPEGBuffer jPEGBuffer) throws IOException {
            this.streamPos = jPEGBuffer.getStreamPosition();
        }

        abstract void print();

        abstract IIOMetadataNode getNativeNode();

        abstract void write(ImageOutputStream var1, JPEGImageWriter var2) throws IOException;

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    class JFIFThumbJPEG
    extends JFIFThumb {
        JPEGMetadata thumbMetadata;
        byte[] data;
        private static final int PREAMBLE_SIZE = 6;

        JFIFThumbJPEG(JPEGBuffer jPEGBuffer, int n, JPEGImageReader jPEGImageReader) throws IOException {
            super(jPEGBuffer);
            this.thumbMetadata = null;
            this.data = null;
            long l = this.streamPos + (long)(n - 6);
            jPEGBuffer.iis.seek(this.streamPos);
            this.thumbMetadata = new JPEGMetadata(false, true, jPEGBuffer.iis, jPEGImageReader);
            jPEGBuffer.iis.seek(l);
            jPEGBuffer.bufAvail = 0;
            jPEGBuffer.bufPtr = 0;
        }

        JFIFThumbJPEG(Node node) throws IIOInvalidTreeException {
            this.thumbMetadata = null;
            this.data = null;
            if (node.getChildNodes().getLength() > 1) {
                throw new IIOInvalidTreeException("JFIFThumbJPEG node must have 0 or 1 child", node);
            }
            Node node2 = node.getFirstChild();
            if (node2 != null) {
                String string = node2.getNodeName();
                if (!string.equals("markerSequence")) {
                    throw new IIOInvalidTreeException("JFIFThumbJPEG child must be a markerSequence node", node);
                }
                this.thumbMetadata = new JPEGMetadata(false, true);
                this.thumbMetadata.setFromMarkerSequenceNode(node2);
            }
        }

        JFIFThumbJPEG(BufferedImage bufferedImage) throws IllegalThumbException {
            this.thumbMetadata = null;
            this.data = null;
            int n = 4096;
            int n2 = 65527;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
                MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(byteArrayOutputStream);
                JPEGImageWriter jPEGImageWriter = new JPEGImageWriter(null);
                jPEGImageWriter.setOutput(memoryCacheImageOutputStream);
                JPEGMetadata jPEGMetadata = (JPEGMetadata)jPEGImageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(bufferedImage), null);
                MarkerSegment markerSegment = jPEGMetadata.findMarkerSegment(JFIFMarkerSegment.class, true);
                if (markerSegment == null) {
                    throw new IllegalThumbException();
                }
                jPEGMetadata.markerSequence.remove(markerSegment);
                jPEGImageWriter.write(new IIOImage(bufferedImage, null, (IIOMetadata)jPEGMetadata));
                jPEGImageWriter.dispose();
                if (byteArrayOutputStream.size() > n2) {
                    throw new IllegalThumbException();
                }
                this.data = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new IllegalThumbException();
            }
        }

        int getWidth() {
            int n = 0;
            SOFMarkerSegment sOFMarkerSegment = (SOFMarkerSegment)this.thumbMetadata.findMarkerSegment(SOFMarkerSegment.class, true);
            if (sOFMarkerSegment != null) {
                n = sOFMarkerSegment.samplesPerLine;
            }
            return n;
        }

        int getHeight() {
            int n = 0;
            SOFMarkerSegment sOFMarkerSegment = (SOFMarkerSegment)this.thumbMetadata.findMarkerSegment(SOFMarkerSegment.class, true);
            if (sOFMarkerSegment != null) {
                n = sOFMarkerSegment.numLines;
            }
            return n;
        }

        BufferedImage getThumbnail(ImageInputStream imageInputStream, JPEGImageReader jPEGImageReader) throws IOException {
            imageInputStream.mark();
            imageInputStream.seek(this.streamPos);
            JPEGImageReader jPEGImageReader2 = new JPEGImageReader(null);
            jPEGImageReader2.setInput(imageInputStream);
            jPEGImageReader2.addIIOReadProgressListener(new ThumbnailReadListener(jPEGImageReader));
            BufferedImage bufferedImage = jPEGImageReader2.read(0, null);
            jPEGImageReader2.dispose();
            imageInputStream.reset();
            return bufferedImage;
        }

        protected Object clone() {
            JFIFThumbJPEG jFIFThumbJPEG = (JFIFThumbJPEG)super.clone();
            if (this.thumbMetadata != null) {
                jFIFThumbJPEG.thumbMetadata = (JPEGMetadata)this.thumbMetadata.clone();
            }
            return jFIFThumbJPEG;
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("JFIFthumbJPEG");
            if (this.thumbMetadata != null) {
                iIOMetadataNode.appendChild(this.thumbMetadata.getNativeTree());
            }
            return iIOMetadataNode;
        }

        int getLength() {
            if (this.data == null) {
                return 0;
            }
            return this.data.length;
        }

        void write(ImageOutputStream imageOutputStream, JPEGImageWriter jPEGImageWriter) throws IOException {
            int n = this.data.length / 20;
            if (n == 0) {
                n = 1;
            }
            int n2 = 0;
            while (n2 < this.data.length) {
                int n3 = Math.min(n, this.data.length - n2);
                imageOutputStream.write(this.data, n2, n3);
                float f = (float)(n2 += n) * 100.0f / (float)this.data.length;
                if (f > 100.0f) {
                    f = 100.0f;
                }
                jPEGImageWriter.thumbnailProgress(f);
            }
        }

        void print() {
            System.out.println("JFIF thumbnail stored as JPEG");
        }

        private class ThumbnailReadListener
        implements IIOReadProgressListener {
            JPEGImageReader reader = null;

            ThumbnailReadListener(JPEGImageReader jPEGImageReader) {
                this.reader = jPEGImageReader;
            }

            public void sequenceStarted(ImageReader imageReader, int n) {
            }

            public void sequenceComplete(ImageReader imageReader) {
            }

            public void imageStarted(ImageReader imageReader, int n) {
            }

            public void imageProgress(ImageReader imageReader, float f) {
                this.reader.thumbnailProgress(f);
            }

            public void imageComplete(ImageReader imageReader) {
            }

            public void thumbnailStarted(ImageReader imageReader, int n, int n2) {
            }

            public void thumbnailProgress(ImageReader imageReader, float f) {
            }

            public void thumbnailComplete(ImageReader imageReader) {
            }

            public void readAborted(ImageReader imageReader) {
            }
        }
    }

    class JFIFThumbPalette
    extends JFIFThumbUncompressed {
        private static final int PALETTE_SIZE = 768;

        JFIFThumbPalette(JPEGBuffer jPEGBuffer, int n, int n2) throws IOException {
            super(jPEGBuffer, n, n2, 768 + n * n2, "JFIFThumbPalette");
        }

        JFIFThumbPalette(Node node) throws IIOInvalidTreeException {
            super(node, "JFIFThumbPalette");
        }

        JFIFThumbPalette(BufferedImage bufferedImage) throws IllegalThumbException {
            super(bufferedImage);
            IndexColorModel indexColorModel = (IndexColorModel)this.thumbnail.getColorModel();
            if (indexColorModel.getMapSize() > 256) {
                throw new IllegalThumbException();
            }
        }

        int getLength() {
            return this.thumbWidth * this.thumbHeight + 768;
        }

        BufferedImage getThumbnail(ImageInputStream imageInputStream, JPEGImageReader jPEGImageReader) throws IOException {
            imageInputStream.mark();
            imageInputStream.seek(this.streamPos);
            byte[] byArray = new byte[768];
            float f = 768.0f / (float)this.getLength();
            this.readByteBuffer(imageInputStream, byArray, jPEGImageReader, f, 0.0f);
            DataBufferByte dataBufferByte = new DataBufferByte(this.thumbWidth * this.thumbHeight);
            this.readByteBuffer(imageInputStream, dataBufferByte.getData(), jPEGImageReader, 1.0f - f, f);
            imageInputStream.read();
            imageInputStream.reset();
            IndexColorModel indexColorModel = new IndexColorModel(8, 256, byArray, 0, false);
            SampleModel sampleModel = indexColorModel.createCompatibleSampleModel(this.thumbWidth, this.thumbHeight);
            WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBufferByte, null);
            return new BufferedImage(indexColorModel, writableRaster, false, null);
        }

        void write(ImageOutputStream imageOutputStream, JPEGImageWriter jPEGImageWriter) throws IOException {
            super.write(imageOutputStream, jPEGImageWriter);
            byte[] byArray = new byte[768];
            IndexColorModel indexColorModel = (IndexColorModel)this.thumbnail.getColorModel();
            byte[] byArray2 = new byte[256];
            byte[] byArray3 = new byte[256];
            byte[] byArray4 = new byte[256];
            indexColorModel.getReds(byArray2);
            indexColorModel.getGreens(byArray3);
            indexColorModel.getBlues(byArray4);
            for (int i = 0; i < 256; ++i) {
                byArray[i * 3] = byArray2[i];
                byArray[i * 3 + 1] = byArray3[i];
                byArray[i * 3 + 2] = byArray4[i];
            }
            imageOutputStream.write(byArray);
            this.writePixels(imageOutputStream, jPEGImageWriter);
        }
    }

    class JFIFThumbRGB
    extends JFIFThumbUncompressed {
        JFIFThumbRGB(JPEGBuffer jPEGBuffer, int n, int n2) throws IOException {
            super(jPEGBuffer, n, n2, n * n2 * 3, "JFIFthumbRGB");
        }

        JFIFThumbRGB(Node node) throws IIOInvalidTreeException {
            super(node, "JFIFthumbRGB");
        }

        JFIFThumbRGB(BufferedImage bufferedImage) throws IllegalThumbException {
            super(bufferedImage);
        }

        int getLength() {
            return this.thumbWidth * this.thumbHeight * 3;
        }

        BufferedImage getThumbnail(ImageInputStream imageInputStream, JPEGImageReader jPEGImageReader) throws IOException {
            imageInputStream.mark();
            imageInputStream.seek(this.streamPos);
            DataBufferByte dataBufferByte = new DataBufferByte(this.getLength());
            this.readByteBuffer(imageInputStream, dataBufferByte.getData(), jPEGImageReader, 1.0f, 0.0f);
            imageInputStream.reset();
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, this.thumbWidth, this.thumbHeight, this.thumbWidth * 3, 3, new int[]{0, 1, 2}, null);
            ComponentColorModel componentColorModel = new ComponentColorModel(JPEG.JCS.sRGB, false, false, 1, 0);
            return new BufferedImage(componentColorModel, writableRaster, false, null);
        }

        void write(ImageOutputStream imageOutputStream, JPEGImageWriter jPEGImageWriter) throws IOException {
            super.write(imageOutputStream, jPEGImageWriter);
            this.writePixels(imageOutputStream, jPEGImageWriter);
        }
    }

    abstract class JFIFThumbUncompressed
    extends JFIFThumb {
        BufferedImage thumbnail;
        int thumbWidth;
        int thumbHeight;
        String name;

        JFIFThumbUncompressed(JPEGBuffer jPEGBuffer, int n, int n2, int n3, String string) throws IOException {
            super(jPEGBuffer);
            this.thumbnail = null;
            this.thumbWidth = n;
            this.thumbHeight = n2;
            jPEGBuffer.skipData(n3);
            this.name = string;
        }

        JFIFThumbUncompressed(Node node, String string) throws IIOInvalidTreeException {
            this.thumbnail = null;
            this.thumbWidth = 0;
            this.thumbHeight = 0;
            this.name = string;
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            if (n > 2) {
                throw new IIOInvalidTreeException(string + " node cannot have > 2 attributes", node);
            }
            if (n != 0) {
                int n2 = MarkerSegment.getAttributeValue(node, namedNodeMap, "thumbWidth", 0, 255, false);
                this.thumbWidth = n2 != -1 ? n2 : this.thumbWidth;
                n2 = MarkerSegment.getAttributeValue(node, namedNodeMap, "thumbHeight", 0, 255, false);
                this.thumbHeight = n2 != -1 ? n2 : this.thumbHeight;
            }
        }

        JFIFThumbUncompressed(BufferedImage bufferedImage) {
            this.thumbnail = null;
            this.thumbnail = bufferedImage;
            this.thumbWidth = bufferedImage.getWidth();
            this.thumbHeight = bufferedImage.getHeight();
            this.name = null;
        }

        void readByteBuffer(ImageInputStream imageInputStream, byte[] byArray, JPEGImageReader jPEGImageReader, float f, float f2) throws IOException {
            int n = Math.max((int)((float)(byArray.length / 20) / f), 1);
            int n2 = 0;
            while (n2 < byArray.length) {
                int n3 = Math.min(n, byArray.length - n2);
                imageInputStream.read(byArray, n2, n3);
                float f3 = (float)(n2 += n) * 100.0f / (float)byArray.length * f + f2;
                if (f3 > 100.0f) {
                    f3 = 100.0f;
                }
                jPEGImageReader.thumbnailProgress(f3);
            }
        }

        int getWidth() {
            return this.thumbWidth;
        }

        int getHeight() {
            return this.thumbHeight;
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(this.name);
            iIOMetadataNode.setAttribute("thumbWidth", Integer.toString(this.thumbWidth));
            iIOMetadataNode.setAttribute("thumbHeight", Integer.toString(this.thumbHeight));
            return iIOMetadataNode;
        }

        void write(ImageOutputStream imageOutputStream, JPEGImageWriter jPEGImageWriter) throws IOException {
            if (this.thumbWidth > 255 || this.thumbHeight > 255) {
                jPEGImageWriter.warningOccurred(12);
            }
            this.thumbWidth = Math.min(this.thumbWidth, 255);
            this.thumbHeight = Math.min(this.thumbHeight, 255);
            imageOutputStream.write(this.thumbWidth);
            imageOutputStream.write(this.thumbHeight);
        }

        void writePixels(ImageOutputStream imageOutputStream, JPEGImageWriter jPEGImageWriter) throws IOException {
            if (this.thumbWidth > 255 || this.thumbHeight > 255) {
                jPEGImageWriter.warningOccurred(12);
            }
            this.thumbWidth = Math.min(this.thumbWidth, 255);
            this.thumbHeight = Math.min(this.thumbHeight, 255);
            int[] nArray = this.thumbnail.getRaster().getPixels(0, 0, this.thumbWidth, this.thumbHeight, (int[])null);
            JFIFMarkerSegment.this.writeThumbnailData(imageOutputStream, nArray, jPEGImageWriter);
        }

        void print() {
            System.out.print(this.name + " width: ");
            System.out.println(this.thumbWidth);
            System.out.print(this.name + " height: ");
            System.out.println(this.thumbHeight);
        }
    }
}

