/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;

public class AttributeClass {
    private String myName;
    private int myType;
    private int nameLen;
    private Object myValue;
    public static final int TAG_UNSUPPORTED_VALUE = 16;
    public static final int TAG_INT = 33;
    public static final int TAG_BOOL = 34;
    public static final int TAG_ENUM = 35;
    public static final int TAG_OCTET = 48;
    public static final int TAG_DATE = 49;
    public static final int TAG_RESOLUTION = 50;
    public static final int TAG_RANGE_INTEGER = 51;
    public static final int TAG_TEXT_LANGUAGE = 53;
    public static final int TAG_NAME_LANGUAGE = 54;
    public static final int TAG_TEXT_WO_LANGUAGE = 65;
    public static final int TAG_NAME_WO_LANGUAGE = 66;
    public static final int TAG_KEYWORD = 68;
    public static final int TAG_URI = 69;
    public static final int TAG_CHARSET = 71;
    public static final int TAG_NATURALLANGUAGE = 72;
    public static final int TAG_MIME_MEDIATYPE = 73;
    public static final int TAG_MEMBER_ATTRNAME = 74;
    public static final AttributeClass ATTRIBUTES_CHARSET = new AttributeClass("attributes-charset", 71, "utf-8");
    public static final AttributeClass ATTRIBUTES_NATURAL_LANGUAGE = new AttributeClass("attributes-natural-language", 72, "en");

    protected AttributeClass(String string, int n, Object object) {
        this.myName = string;
        this.myType = n;
        this.nameLen = string.length();
        this.myValue = object;
    }

    public byte getType() {
        return (byte)this.myType;
    }

    public char[] getLenChars() {
        char[] cArray = new char[]{'\u0000', (char)this.nameLen};
        return cArray;
    }

    public Object getObjectValue() {
        return this.myValue;
    }

    public int getIntValue() {
        byte[] byArray = (byte[])this.myValue;
        if (byArray != null) {
            byte[] byArray2 = new byte[4];
            for (int i = 0; i < 4; ++i) {
                byArray2[i] = byArray[i + 1];
            }
            return this.convertToInt(byArray2);
        }
        return 0;
    }

    public int[] getArrayOfIntValues() {
        byte[] byArray = (byte[])this.myValue;
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            int n = byteArrayInputStream.available();
            byteArrayInputStream.mark(n);
            byteArrayInputStream.skip(n - 1);
            int n2 = byteArrayInputStream.read();
            byteArrayInputStream.reset();
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                int n3 = byteArrayInputStream.read();
                if (n3 != 4) {
                    return null;
                }
                byte[] byArray2 = new byte[n3];
                byteArrayInputStream.read(byArray2, 0, n3);
                nArray[i] = this.convertToInt(byArray2);
            }
            return nArray;
        }
        return null;
    }

    public int[] getIntRangeValue() {
        int[] nArray = new int[]{0, 0};
        byte[] byArray = (byte[])this.myValue;
        if (byArray != null) {
            int n = 4;
            for (int i = 0; i < 2; ++i) {
                byte[] byArray2 = new byte[n];
                for (int j = 0; j < n; ++j) {
                    byArray2[j] = byArray[j + 4 * i + 1];
                }
                nArray[i] = this.convertToInt(byArray2);
            }
        }
        return nArray;
    }

    public String getStringValue() {
        String string = null;
        byte[] byArray = (byte[])this.myValue;
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            int n = byteArrayInputStream.read();
            byte[] byArray2 = new byte[n];
            byteArrayInputStream.read(byArray2, 0, n);
            try {
                string = new String(byArray2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return string;
    }

    public String[] getArrayOfStringValues() {
        byte[] byArray = (byte[])this.myValue;
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            int n = byteArrayInputStream.available();
            byteArrayInputStream.mark(n);
            byteArrayInputStream.skip(n - 1);
            int n2 = byteArrayInputStream.read();
            byteArrayInputStream.reset();
            String[] stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                int n3 = byteArrayInputStream.read();
                byte[] byArray2 = new byte[n3];
                byteArrayInputStream.read(byArray2, 0, n3);
                try {
                    stringArray[i] = new String(byArray2, "UTF-8");
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            return stringArray;
        }
        return null;
    }

    public byte getByteValue() {
        byte[] byArray = (byte[])this.myValue;
        if (byArray != null && byArray.length >= 2) {
            return byArray[1];
        }
        return 0;
    }

    public String getName() {
        return this.myName;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof AttributeClass && object.toString().equals(((AttributeClass)object).toString());
    }

    public String toString() {
        return this.myName;
    }

    private int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    private int convertToInt(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        n += this.unsignedByteToInt(byArray[n2++]) << 24;
        n += this.unsignedByteToInt(byArray[n2++]) << 16;
        n += this.unsignedByteToInt(byArray[n2++]) << 8;
        return n += this.unsignedByteToInt(byArray[n2++]) << 0;
    }
}

