/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.DeniedCertStore;
import com.sun.deploy.security.DeploySSLCertStore;
import com.sun.deploy.security.RootCertStore;
import com.sun.deploy.security.SSLRootCertStore;
import com.sun.deploy.security.SessionCertStore;
import com.sun.deploy.security.TrustDeciderDialog;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.Trace;
import com.sun.net.ssl.internal.ssl.X509ExtendedTrustManager;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public final class X509ExtendedDeployTrustManager
extends X509ExtendedTrustManager {
    private X509ExtendedTrustManager trustManager = null;
    private static CertStore rootStore = null;
    private static CertStore sslRootStore = null;
    private static CertStore permanentStore = null;
    private static CertStore sessionStore = null;
    private static CertStore deniedStore = null;
    private static CertStore browserSSLRootStore = null;
    private static boolean isBrowserSSLRootStoreLoaded = false;
    private String[] supportedAlgs = new String[]{"HTTPS"};

    public static void reset() {
        rootStore = RootCertStore.getCertStore();
        sslRootStore = SSLRootCertStore.getCertStore();
        permanentStore = DeploySSLCertStore.getCertStore();
        sessionStore = new SessionCertStore();
        deniedStore = new DeniedCertStore();
        if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
            Service service = ServiceManager.getService();
            browserSSLRootStore = service.getBrowserSSLRootCertStore();
            isBrowserSSLRootStoreLoaded = false;
        }
    }

    public X509ExtendedDeployTrustManager() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
        trustManagerFactory.init((KeyStore)null);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        this.trustManager = (X509ExtendedTrustManager)trustManagerArray[0];
    }

    public synchronized void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkClientTrusted(x509CertificateArray, string, null, null);
    }

    public synchronized void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, String string2, String string3) throws CertificateException {
        if (string3 != null && !this.isSupportedAlgorithm(string3)) {
            return;
        }
        boolean bl = false;
        int n = 0;
        if (this.trustManager == null) {
            throw new IllegalStateException("TrustManager should not be null");
        }
        int n2 = -1;
        try {
            rootStore.load();
            sslRootStore.load();
            permanentStore.load();
            sessionStore.load();
            deniedStore.load();
            if (browserSSLRootStore != null && !isBrowserSSLRootStoreLoaded) {
                browserSSLRootStore.load();
                isBrowserSSLRootStoreLoaded = true;
            }
            if (deniedStore.contains(x509CertificateArray[0])) {
                throw new CertificateException("Certificate has been denied");
            }
            try {
                this.trustManager.checkClientTrusted(x509CertificateArray, string, string2, string3);
                return;
            }
            catch (CertificateException certificateException) {
                int n3;
                if (sessionStore.contains(x509CertificateArray[0])) {
                    return;
                }
                if (permanentStore.contains(x509CertificateArray[0])) {
                    return;
                }
                if (!(x509CertificateArray == null || x509CertificateArray.length <= 0 || rootStore.verify(x509CertificateArray[n3 = x509CertificateArray.length - 1]) || sslRootStore.verify(x509CertificateArray[n3]) || browserSSLRootStore != null && browserSSLRootStore.verify(x509CertificateArray[n3]))) {
                    bl = true;
                }
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    try {
                        x509CertificateArray[i].checkValidity();
                        continue;
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        n = -1;
                        continue;
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        n = 1;
                    }
                }
                if (!Trace.isAutomationEnabled()) {
                    if (!Config.getBooleanProperty("deployment.security.https.warning.show") && !bl && n == 0 && CertUtils.checkWildcardDomainList(string2, CertUtils.getServername(x509CertificateArray[0]))) {
                        Trace.msgSecurityPrintln("x509trustmgr.check.validcert");
                        n2 = 0;
                    } else {
                        Trace.msgSecurityPrintln("x509trustmgr.check.invalidcert");
                        n2 = TrustDeciderDialog.showDialog(x509CertificateArray, null, 0, x509CertificateArray.length, bl, n, null, new AppInfo(), true, string2);
                    }
                } else {
                    Trace.msgSecurityPrintln("x509trustmgr.automation.ignoreclientcert");
                    n2 = 0;
                }
                if (n2 == 0) {
                    sessionStore.add(x509CertificateArray[0]);
                    sessionStore.save();
                } else if (n2 == 2) {
                    CertStore certStore = DeploySSLCertStore.getUserCertStore();
                    certStore.load(true);
                    if (certStore.add(x509CertificateArray[0])) {
                        certStore.save();
                    }
                } else {
                    deniedStore.add(x509CertificateArray[0]);
                    deniedStore.save();
                }
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (n2 != 0 && n2 != 2) {
            throw new CertificateException("Java couldn't trust Client");
        }
    }

    public synchronized void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkServerTrusted(x509CertificateArray, string, null, null);
    }

    public synchronized void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, String string2, String string3) throws CertificateException {
        if (string3 != null && !this.isSupportedAlgorithm(string3)) {
            return;
        }
        boolean bl = false;
        int n = 0;
        if (this.trustManager == null) {
            throw new IllegalStateException("TrustManager should not be null");
        }
        int n2 = -1;
        try {
            rootStore.load();
            sslRootStore.load();
            permanentStore.load();
            sessionStore.load();
            deniedStore.load();
            if (browserSSLRootStore != null && !isBrowserSSLRootStoreLoaded) {
                browserSSLRootStore.load();
                isBrowserSSLRootStoreLoaded = true;
            }
            if (deniedStore.contains(x509CertificateArray[0])) {
                throw new CertificateException("Certificate has been denied");
            }
            try {
                this.trustManager.checkServerTrusted(x509CertificateArray, string, string2, string3);
                return;
            }
            catch (CertificateException certificateException) {
                int n3;
                if (sessionStore.contains(x509CertificateArray[0])) {
                    return;
                }
                if (permanentStore.contains(x509CertificateArray[0])) {
                    return;
                }
                if (!(x509CertificateArray == null || x509CertificateArray.length <= 0 || rootStore.verify(x509CertificateArray[n3 = x509CertificateArray.length - 1]) || sslRootStore.verify(x509CertificateArray[n3]) || browserSSLRootStore != null && browserSSLRootStore.verify(x509CertificateArray[n3]))) {
                    bl = true;
                }
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    try {
                        x509CertificateArray[i].checkValidity();
                        continue;
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        n = -1;
                        continue;
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        n = 1;
                    }
                }
                if (!Trace.isAutomationEnabled()) {
                    if (!Config.getBooleanProperty("deployment.security.https.warning.show") && !bl && n == 0 && CertUtils.checkWildcardDomainList(string2, CertUtils.getServername(x509CertificateArray[0]))) {
                        Trace.msgSecurityPrintln("x509trustmgr.check.validcert");
                        n2 = 0;
                    } else {
                        Trace.msgSecurityPrintln("x509trustmgr.check.invalidcert");
                        n2 = TrustDeciderDialog.showDialog(x509CertificateArray, null, 0, x509CertificateArray.length, bl, n, null, new AppInfo(), true, string2);
                    }
                } else {
                    Trace.msgSecurityPrintln("x509trustmgr.automation.ignoreservercert");
                    n2 = 0;
                }
                if (n2 == 0) {
                    sessionStore.add(x509CertificateArray[0]);
                    sessionStore.save();
                } else if (n2 == 2) {
                    CertStore certStore = DeploySSLCertStore.getUserCertStore();
                    certStore.load(true);
                    if (certStore.add(x509CertificateArray[0])) {
                        certStore.save();
                    }
                } else {
                    deniedStore.add(x509CertificateArray[0]);
                    deniedStore.save();
                }
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (n2 != 0 && n2 != 2) {
            throw new CertificateException("Java couldn't trust Server");
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    private boolean isSupportedAlgorithm(String string) {
        for (int i = 0; i < this.supportedAlgs.length; ++i) {
            if (!string.toUpperCase().equals(this.supportedAlgs[i])) continue;
            return true;
        }
        return false;
    }

    static {
        X509ExtendedDeployTrustManager.reset();
    }
}

