/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.unmarshaller;

import com.sun.xml.internal.bind.WhiteSpaceProcessor;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.InterningXmlVisitor;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.StAXConnector;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.UnmarshallerImpl;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.XmlVisitor;
import java.lang.reflect.Constructor;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StAXStreamConnector
extends StAXConnector {
    private final XMLStreamReader staxStreamReader;
    protected final StringBuilder buffer = new StringBuilder();
    protected boolean textReported = false;
    private final Attributes attributes = new Attributes(){

        public int getLength() {
            return StAXStreamConnector.this.staxStreamReader.getAttributeCount();
        }

        public String getURI(int n) {
            String string = StAXStreamConnector.this.staxStreamReader.getAttributeNamespace(n);
            if (string == null) {
                return "";
            }
            return string;
        }

        public String getLocalName(int n) {
            return StAXStreamConnector.this.staxStreamReader.getAttributeLocalName(n);
        }

        public String getQName(int n) {
            String string = StAXStreamConnector.this.staxStreamReader.getAttributePrefix(n);
            if (string == null || string.length() == 0) {
                return this.getLocalName(n);
            }
            return string + ':' + this.getLocalName(n);
        }

        public String getType(int n) {
            return StAXStreamConnector.this.staxStreamReader.getAttributeType(n);
        }

        public String getValue(int n) {
            return StAXStreamConnector.this.staxStreamReader.getAttributeValue(n);
        }

        public int getIndex(String string, String string2) {
            for (int i = this.getLength() - 1; i >= 0; --i) {
                if (!string2.equals(this.getLocalName(i)) || !string.equals(this.getURI(i))) continue;
                return i;
            }
            return -1;
        }

        public int getIndex(String string) {
            for (int i = this.getLength() - 1; i >= 0; --i) {
                if (!string.equals(this.getQName(i))) continue;
                return i;
            }
            return -1;
        }

        public String getType(String string, String string2) {
            int n = this.getIndex(string, string2);
            if (n < 0) {
                return null;
            }
            return this.getType(n);
        }

        public String getType(String string) {
            int n = this.getIndex(string);
            if (n < 0) {
                return null;
            }
            return this.getType(n);
        }

        public String getValue(String string, String string2) {
            int n = this.getIndex(string, string2);
            if (n < 0) {
                return null;
            }
            return this.getValue(n);
        }

        public String getValue(String string) {
            int n = this.getIndex(string);
            if (n < 0) {
                return null;
            }
            return this.getValue(n);
        }
    };
    private static final Class FI_STAX_READER_CLASS = StAXStreamConnector.initFIStAXReaderClass();
    private static final Constructor<? extends StAXConnector> FI_CONNECTOR_CTOR = StAXStreamConnector.initFastInfosetConnectorClass();
    private static final Class STAX_EX_READER_CLASS = StAXStreamConnector.initStAXExReader();
    private static final Constructor<? extends StAXConnector> STAX_EX_CONNECTOR_CTOR = StAXStreamConnector.initStAXExConnector();

    public static StAXConnector create(XMLStreamReader xMLStreamReader, XmlVisitor xmlVisitor) {
        Class<?> clazz = xMLStreamReader.getClass();
        if (FI_STAX_READER_CLASS != null && FI_STAX_READER_CLASS.isAssignableFrom(clazz) && FI_CONNECTOR_CTOR != null) {
            try {
                return FI_CONNECTOR_CTOR.newInstance(xMLStreamReader, xmlVisitor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean bl = clazz.getName().equals("com.sun.xml.internal.stream.XMLReaderImpl");
        if (!(StAXStreamConnector.getBoolProp(xMLStreamReader, "org.codehaus.stax2.internNames") && StAXStreamConnector.getBoolProp(xMLStreamReader, "org.codehaus.stax2.internNsUris") || bl || StAXStreamConnector.checkImplementaionNameOfSjsxp(xMLStreamReader))) {
            xmlVisitor = new InterningXmlVisitor(xmlVisitor);
        }
        if (STAX_EX_READER_CLASS != null && STAX_EX_READER_CLASS.isAssignableFrom(clazz)) {
            try {
                return STAX_EX_CONNECTOR_CTOR.newInstance(xMLStreamReader, xmlVisitor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new StAXStreamConnector(xMLStreamReader, xmlVisitor);
    }

    private static boolean checkImplementaionNameOfSjsxp(XMLStreamReader xMLStreamReader) {
        try {
            Object object = xMLStreamReader.getProperty("http://java.sun.com/xml/stream/properties/implementation-name");
            return object != null && object.equals("sjsxp");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean getBoolProp(XMLStreamReader xMLStreamReader, String string) {
        try {
            Object object = xMLStreamReader.getProperty(string);
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected StAXStreamConnector(XMLStreamReader xMLStreamReader, XmlVisitor xmlVisitor) {
        super(xmlVisitor);
        this.staxStreamReader = xMLStreamReader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void bridge() throws XMLStreamException {
        try {
            int n = 0;
            int n2 = this.staxStreamReader.getEventType();
            if (n2 == 7) {
                while (!this.staxStreamReader.isStartElement()) {
                    n2 = this.staxStreamReader.next();
                }
            }
            if (n2 != 1) {
                throw new IllegalStateException("The current event is not START_ELEMENT\n but " + n2);
            }
            this.handleStartDocument(this.staxStreamReader.getNamespaceContext());
            block8: while (true) {
                switch (n2) {
                    case 1: {
                        this.handleStartElement();
                        ++n;
                        break;
                    }
                    case 2: {
                        this.handleEndElement();
                        if (--n != 0) break;
                        break block8;
                    }
                    case 4: 
                    case 6: 
                    case 12: {
                        this.handleCharacters();
                    }
                }
                n2 = this.staxStreamReader.next();
            }
            this.staxStreamReader.next();
            this.handleEndDocument();
            return;
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException(sAXException);
        }
    }

    @Override
    protected Location getCurrentLocation() {
        return this.staxStreamReader.getLocation();
    }

    @Override
    protected String getCurrentQName() {
        return this.getQName(this.staxStreamReader.getPrefix(), this.staxStreamReader.getLocalName());
    }

    private void handleEndElement() throws SAXException {
        this.processText(false);
        this.tagName.uri = StAXStreamConnector.fixNull(this.staxStreamReader.getNamespaceURI());
        this.tagName.local = this.staxStreamReader.getLocalName();
        this.visitor.endElement(this.tagName);
        int n = this.staxStreamReader.getNamespaceCount();
        for (int i = n - 1; i >= 0; --i) {
            this.visitor.endPrefixMapping(StAXStreamConnector.fixNull(this.staxStreamReader.getNamespacePrefix(i)));
        }
    }

    private void handleStartElement() throws SAXException {
        this.processText(true);
        int n = this.staxStreamReader.getNamespaceCount();
        for (int i = 0; i < n; ++i) {
            this.visitor.startPrefixMapping(StAXStreamConnector.fixNull(this.staxStreamReader.getNamespacePrefix(i)), StAXStreamConnector.fixNull(this.staxStreamReader.getNamespaceURI(i)));
        }
        this.tagName.uri = StAXStreamConnector.fixNull(this.staxStreamReader.getNamespaceURI());
        this.tagName.local = this.staxStreamReader.getLocalName();
        this.tagName.atts = this.attributes;
        this.visitor.startElement(this.tagName);
    }

    protected void handleCharacters() throws XMLStreamException, SAXException {
        if (this.predictor.expectText()) {
            this.buffer.append(this.staxStreamReader.getTextCharacters(), this.staxStreamReader.getTextStart(), this.staxStreamReader.getTextLength());
        }
    }

    private void processText(boolean bl) throws SAXException {
        if (!(!this.predictor.expectText() || bl && WhiteSpaceProcessor.isWhiteSpace(this.buffer))) {
            if (this.textReported) {
                this.textReported = false;
            } else {
                this.visitor.text(this.buffer);
            }
        }
        this.buffer.setLength(0);
    }

    private static Class initFIStAXReaderClass() {
        try {
            Class<?> clazz = UnmarshallerImpl.class.getClassLoader().loadClass("com.sun.xml.internal.org.jvnet.fastinfoset.stax.FastInfosetStreamReader");
            Class<?> clazz2 = UnmarshallerImpl.class.getClassLoader().loadClass("com.sun.xml.internal.fastinfoset.stax.StAXDocumentParser");
            if (clazz.isAssignableFrom(clazz2)) {
                return clazz2;
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Constructor<? extends StAXConnector> initFastInfosetConnectorClass() {
        try {
            if (FI_STAX_READER_CLASS == null) {
                return null;
            }
            Class<?> clazz = UnmarshallerImpl.class.getClassLoader().loadClass("com.sun.xml.internal.bind.v2.runtime.unmarshaller.FastInfosetConnector");
            return clazz.getConstructor(FI_STAX_READER_CLASS, XmlVisitor.class);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class initStAXExReader() {
        try {
            return UnmarshallerImpl.class.getClassLoader().loadClass("com.sun.xml.internal.org.jvnet.staxex.XMLStreamReaderEx");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Constructor<? extends StAXConnector> initStAXExConnector() {
        try {
            Class<?> clazz = UnmarshallerImpl.class.getClassLoader().loadClass("com.sun.xml.internal.bind.v2.runtime.unmarshaller.StAXExConnector");
            return clazz.getConstructor(STAX_EX_READER_CLASS, XmlVisitor.class);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

