/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReentrantReadWriteLock
implements ReadWriteLock,
Serializable {
    private static final long serialVersionUID = -6992448646407690164L;
    private final ReadLock readerLock;
    private final WriteLock writerLock;
    private final Sync sync;

    public ReentrantReadWriteLock() {
        this(false);
    }

    public ReentrantReadWriteLock(boolean bl) {
        this.sync = bl ? new FairSync() : new NonfairSync();
        this.readerLock = new ReadLock(this);
        this.writerLock = new WriteLock(this);
    }

    @Override
    public WriteLock writeLock() {
        return this.writerLock;
    }

    @Override
    public ReadLock readLock() {
        return this.readerLock;
    }

    public final boolean isFair() {
        return this.sync instanceof FairSync;
    }

    protected Thread getOwner() {
        return this.sync.getOwner();
    }

    public int getReadLockCount() {
        return this.sync.getReadLockCount();
    }

    public boolean isWriteLocked() {
        return this.sync.isWriteLocked();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.sync.isHeldExclusively();
    }

    public int getWriteHoldCount() {
        return this.sync.getWriteHoldCount();
    }

    public int getReadHoldCount() {
        return this.sync.getReadHoldCount();
    }

    protected Collection<Thread> getQueuedWriterThreads() {
        return this.sync.getExclusiveQueuedThreads();
    }

    protected Collection<Thread> getQueuedReaderThreads() {
        return this.sync.getSharedQueuedThreads();
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final boolean hasQueuedThread(Thread thread) {
        return this.sync.isQueued(thread);
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    protected Collection<Thread> getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    public boolean hasWaiters(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.hasWaiters((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    public int getWaitQueueLength(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.getWaitQueueLength((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    protected Collection<Thread> getWaitingThreads(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.getWaitingThreads((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    public String toString() {
        int n = this.sync.getCount();
        int n2 = Sync.exclusiveCount(n);
        int n3 = Sync.sharedCount(n);
        return super.toString() + "[Write locks = " + n2 + ", Read locks = " + n3 + "]";
    }

    static final class FairSync
    extends Sync {
        private static final long serialVersionUID = -2274990926593161451L;

        FairSync() {
        }

        final boolean writerShouldBlock(Thread thread) {
            return !this.isFirst(thread);
        }

        final boolean readerShouldBlock(Thread thread) {
            return !this.isFirst(thread);
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = -8159625535654395037L;

        NonfairSync() {
        }

        final boolean writerShouldBlock(Thread thread) {
            return false;
        }

        final boolean readerShouldBlock(Thread thread) {
            return this.apparentlyFirstQueuedIsExclusive();
        }
    }

    public static class ReadLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -5992448646407690164L;
        private final Sync sync;

        protected ReadLock(ReentrantReadWriteLock reentrantReadWriteLock) {
            this.sync = reentrantReadWriteLock.sync;
        }

        public void lock() {
            this.sync.acquireShared(1);
        }

        public void lockInterruptibly() throws InterruptedException {
            this.sync.acquireSharedInterruptibly(1);
        }

        public boolean tryLock() {
            return this.sync.tryReadLock();
        }

        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.sync.tryAcquireSharedNanos(1, timeUnit.toNanos(l));
        }

        public void unlock() {
            this.sync.releaseShared(1);
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            int n = this.sync.getReadLockCount();
            return super.toString() + "[Read locks = " + n + "]";
        }
    }

    static abstract class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 6317671515068378041L;
        static final int SHARED_SHIFT = 16;
        static final int SHARED_UNIT = 65536;
        static final int MAX_COUNT = 65535;
        static final int EXCLUSIVE_MASK = 65535;
        transient ThreadLocalHoldCounter readHolds = new ThreadLocalHoldCounter();
        transient HoldCounter cachedHoldCounter;

        static int sharedCount(int n) {
            return n >>> 16;
        }

        static int exclusiveCount(int n) {
            return n & 0xFFFF;
        }

        Sync() {
            this.setState(this.getState());
        }

        abstract boolean readerShouldBlock(Thread var1);

        abstract boolean writerShouldBlock(Thread var1);

        protected final boolean tryRelease(int n) {
            int n2 = this.getState() - n;
            if (Thread.currentThread() != this.getExclusiveOwnerThread()) {
                throw new IllegalMonitorStateException();
            }
            if (Sync.exclusiveCount(n2) == 0) {
                this.setExclusiveOwnerThread(null);
                this.setState(n2);
                return true;
            }
            this.setState(n2);
            return false;
        }

        protected final boolean tryAcquire(int n) {
            Thread thread = Thread.currentThread();
            int n2 = this.getState();
            int n3 = Sync.exclusiveCount(n2);
            if (n2 != 0) {
                if (n3 == 0 || thread != this.getExclusiveOwnerThread()) {
                    return false;
                }
                if (n3 + Sync.exclusiveCount(n) > 65535) {
                    throw new Error("Maximum lock count exceeded");
                }
            }
            if (n3 == 0 && this.writerShouldBlock(thread) || !this.compareAndSetState(n2, n2 + n)) {
                return false;
            }
            this.setExclusiveOwnerThread(thread);
            return true;
        }

        protected final boolean tryReleaseShared(int n) {
            int n2;
            int n3;
            HoldCounter holdCounter = this.cachedHoldCounter;
            Thread thread = Thread.currentThread();
            if (holdCounter == null || holdCounter.tid != thread.getId()) {
                holdCounter = (HoldCounter)this.readHolds.get();
            }
            if (holdCounter.tryDecrement() <= 0) {
                throw new IllegalMonitorStateException();
            }
            while (!this.compareAndSetState(n3 = this.getState(), n2 = n3 - 65536)) {
            }
            return n2 == 0;
        }

        protected final int tryAcquireShared(int n) {
            Thread thread = Thread.currentThread();
            int n2 = this.getState();
            if (Sync.exclusiveCount(n2) != 0 && this.getExclusiveOwnerThread() != thread) {
                return -1;
            }
            if (Sync.sharedCount(n2) == 65535) {
                throw new Error("Maximum lock count exceeded");
            }
            if (!this.readerShouldBlock(thread) && this.compareAndSetState(n2, n2 + 65536)) {
                HoldCounter holdCounter = this.cachedHoldCounter;
                if (holdCounter == null || holdCounter.tid != thread.getId()) {
                    this.cachedHoldCounter = holdCounter = (HoldCounter)this.readHolds.get();
                }
                ++holdCounter.count;
                return 1;
            }
            return this.fullTryAcquireShared(thread);
        }

        final int fullTryAcquireShared(Thread thread) {
            int n;
            HoldCounter holdCounter = this.cachedHoldCounter;
            if (holdCounter == null || holdCounter.tid != thread.getId()) {
                holdCounter = (HoldCounter)this.readHolds.get();
            }
            do {
                int n2;
                if ((n2 = Sync.exclusiveCount(n = this.getState())) != 0 && this.getExclusiveOwnerThread() != thread || (holdCounter.count | n2) == 0 && this.readerShouldBlock(thread)) {
                    return -1;
                }
                if (Sync.sharedCount(n) != 65535) continue;
                throw new Error("Maximum lock count exceeded");
            } while (!this.compareAndSetState(n, n + 65536));
            this.cachedHoldCounter = holdCounter;
            ++holdCounter.count;
            return 1;
        }

        final boolean tryWriteLock() {
            Thread thread = Thread.currentThread();
            int n = this.getState();
            if (n != 0) {
                int n2 = Sync.exclusiveCount(n);
                if (n2 == 0 || thread != this.getExclusiveOwnerThread()) {
                    return false;
                }
                if (n2 == 65535) {
                    throw new Error("Maximum lock count exceeded");
                }
            }
            if (!this.compareAndSetState(n, n + 1)) {
                return false;
            }
            this.setExclusiveOwnerThread(thread);
            return true;
        }

        final boolean tryReadLock() {
            int n;
            Thread thread = Thread.currentThread();
            do {
                if (Sync.exclusiveCount(n = this.getState()) != 0 && this.getExclusiveOwnerThread() != thread) {
                    return false;
                }
                if (Sync.sharedCount(n) != 65535) continue;
                throw new Error("Maximum lock count exceeded");
            } while (!this.compareAndSetState(n, n + 65536));
            HoldCounter holdCounter = this.cachedHoldCounter;
            if (holdCounter == null || holdCounter.tid != thread.getId()) {
                this.cachedHoldCounter = holdCounter = (HoldCounter)this.readHolds.get();
            }
            ++holdCounter.count;
            return true;
        }

        protected final boolean isHeldExclusively() {
            return this.getExclusiveOwnerThread() == Thread.currentThread();
        }

        final AbstractQueuedSynchronizer.ConditionObject newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject(this);
        }

        final Thread getOwner() {
            return Sync.exclusiveCount(this.getState()) == 0 ? null : this.getExclusiveOwnerThread();
        }

        final int getReadLockCount() {
            return Sync.sharedCount(this.getState());
        }

        final boolean isWriteLocked() {
            return Sync.exclusiveCount(this.getState()) != 0;
        }

        final int getWriteHoldCount() {
            return this.isHeldExclusively() ? Sync.exclusiveCount(this.getState()) : 0;
        }

        final int getReadHoldCount() {
            return this.getReadLockCount() == 0 ? 0 : ((HoldCounter)this.readHolds.get()).count;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.readHolds = new ThreadLocalHoldCounter();
            this.setState(0);
        }

        final int getCount() {
            return this.getState();
        }

        static final class HoldCounter {
            int count;
            final long tid = Thread.currentThread().getId();

            HoldCounter() {
            }

            int tryDecrement() {
                int n = this.count;
                if (n > 0) {
                    this.count = n - 1;
                }
                return n;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class ThreadLocalHoldCounter
        extends ThreadLocal<HoldCounter> {
            ThreadLocalHoldCounter() {
            }

            @Override
            public HoldCounter initialValue() {
                return new HoldCounter();
            }
        }
    }

    public static class WriteLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -4992448646407690164L;
        private final Sync sync;

        protected WriteLock(ReentrantReadWriteLock reentrantReadWriteLock) {
            this.sync = reentrantReadWriteLock.sync;
        }

        public void lock() {
            this.sync.acquire(1);
        }

        public void lockInterruptibly() throws InterruptedException {
            this.sync.acquireInterruptibly(1);
        }

        public boolean tryLock() {
            return this.sync.tryWriteLock();
        }

        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.sync.tryAcquireNanos(1, timeUnit.toNanos(l));
        }

        public void unlock() {
            this.sync.release(1);
        }

        public Condition newCondition() {
            return this.sync.newCondition();
        }

        public String toString() {
            Thread thread = this.sync.getOwner();
            return super.toString() + (thread == null ? "[Unlocked]" : "[Locked by thread " + thread.getName() + "]");
        }

        public boolean isHeldByCurrentThread() {
            return this.sync.isHeldExclusively();
        }

        public int getHoldCount() {
            return this.sync.getWriteHoldCount();
        }
    }
}

