/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.writers;

import com.sun.org.apache.xerces.internal.util.XMLChar;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class UTF8OutputStreamWriter
extends Writer {
    OutputStream out;
    int lastUTF16CodePoint = 0;

    public UTF8OutputStreamWriter(OutputStream outputStream) {
        this.out = outputStream;
    }

    public String getEncoding() {
        return "UTF-8";
    }

    public void write(int n) throws IOException {
        if (this.lastUTF16CodePoint != 0) {
            int n2 = ((this.lastUTF16CodePoint & 0x3FF) << 10 | n & 0x3FF) + 65536;
            if (n2 < 0 || n2 >= 0x200000) {
                throw new IOException("Atttempting to write invalid Unicode code point '" + n2 + "'");
            }
            this.out.write(0xF0 | n2 >> 18);
            this.out.write(0x80 | n2 >> 12 & 0x3F);
            this.out.write(0x80 | n2 >> 6 & 0x3F);
            this.out.write(0x80 | n2 & 0x3F);
            this.lastUTF16CodePoint = 0;
            return;
        }
        if (n < 128) {
            this.out.write(n);
        } else if (n < 2048) {
            this.out.write(0xC0 | n >> 6);
            this.out.write(0x80 | n & 0x3F);
        } else if (n <= 65535) {
            if (!XMLChar.isHighSurrogate(n) && !XMLChar.isLowSurrogate(n)) {
                this.out.write(0xE0 | n >> 12);
                this.out.write(0x80 | n >> 6 & 0x3F);
                this.out.write(0x80 | n & 0x3F);
            } else {
                this.lastUTF16CodePoint = n;
            }
        }
    }

    public void write(char[] cArray) throws IOException {
        for (int i = 0; i < cArray.length; ++i) {
            this.write(cArray[i]);
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(cArray[n + i]);
        }
    }

    public void write(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.write(string.charAt(i));
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(string.charAt(n + i));
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        if (this.lastUTF16CodePoint != 0) {
            throw new IllegalStateException("Attempting to close a UTF8OutputStreamWriter while awaiting for a UTF-16 code unit");
        }
        this.out.close();
    }
}

