/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.naming.cosnaming;

import com.sun.corba.se.impl.logging.NamingSystemException;
import com.sun.corba.se.impl.naming.cosnaming.InternalBindingKey;
import com.sun.corba.se.impl.naming.cosnaming.InternalBindingValue;
import com.sun.corba.se.impl.naming.cosnaming.NamingContextDataStore;
import com.sun.corba.se.impl.naming.cosnaming.NamingContextImpl;
import com.sun.corba.se.impl.naming.cosnaming.TransientBindingIterator;
import com.sun.corba.se.spi.orb.ORB;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.BindingIteratorHelper;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.BindingTypeHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.PortableServer.POA;

public class TransientNamingContext
extends NamingContextImpl
implements NamingContextDataStore {
    private Logger readLogger;
    private Logger updateLogger;
    private Logger lifecycleLogger;
    private NamingSystemException wrapper;
    private final Hashtable theHashtable = new Hashtable();
    public Object localRoot;

    public TransientNamingContext(ORB oRB, Object object, POA pOA) throws Exception {
        super(oRB, pOA);
        this.wrapper = NamingSystemException.get(oRB, "naming");
        this.localRoot = object;
        this.readLogger = oRB.getLogger("naming.read");
        this.updateLogger = oRB.getLogger("naming.update");
        this.lifecycleLogger = oRB.getLogger("naming.lifecycle");
        this.lifecycleLogger.fine("Root TransientNamingContext LIFECYCLE.CREATED");
    }

    public final void Bind(NameComponent nameComponent, Object object, BindingType bindingType) throws SystemException {
        InternalBindingKey internalBindingKey = new InternalBindingKey(nameComponent);
        NameComponent[] nameComponentArray = new NameComponent[]{nameComponent};
        Binding binding = new Binding(nameComponentArray, bindingType);
        InternalBindingValue internalBindingValue = new InternalBindingValue(binding, null);
        internalBindingValue.theObjectRef = object;
        InternalBindingValue internalBindingValue2 = this.theHashtable.put(internalBindingKey, internalBindingValue);
        if (internalBindingValue2 != null) {
            this.updateLogger.warning("<<NAMING BIND>>Name " + this.getName(nameComponent) + " Was Already Bound");
            throw this.wrapper.transNcBindAlreadyBound();
        }
        if (this.updateLogger.isLoggable(Level.FINE)) {
            this.updateLogger.fine("<<NAMING BIND>><<SUCCESS>>Name Component: " + nameComponent.id + "." + nameComponent.kind);
        }
    }

    public final Object Resolve(NameComponent nameComponent, BindingTypeHolder bindingTypeHolder) throws SystemException {
        if (nameComponent.id.length() == 0 && nameComponent.kind.length() == 0) {
            bindingTypeHolder.value = BindingType.ncontext;
            return this.localRoot;
        }
        InternalBindingKey internalBindingKey = new InternalBindingKey(nameComponent);
        InternalBindingValue internalBindingValue = (InternalBindingValue)this.theHashtable.get(internalBindingKey);
        if (internalBindingValue == null) {
            return null;
        }
        if (this.readLogger.isLoggable(Level.FINE)) {
            this.readLogger.fine("<<NAMING RESOLVE>><<SUCCESS>>Namecomponent :" + this.getName(nameComponent));
        }
        bindingTypeHolder.value = internalBindingValue.theBinding.binding_type;
        return internalBindingValue.theObjectRef;
    }

    public final Object Unbind(NameComponent nameComponent) throws SystemException {
        InternalBindingKey internalBindingKey = new InternalBindingKey(nameComponent);
        InternalBindingValue internalBindingValue = (InternalBindingValue)this.theHashtable.remove(internalBindingKey);
        if (internalBindingValue == null) {
            if (this.updateLogger.isLoggable(Level.FINE)) {
                this.updateLogger.fine("<<NAMING UNBIND>><<FAILURE>> There was no binding with the name " + this.getName(nameComponent) + " to Unbind ");
            }
            return null;
        }
        if (this.updateLogger.isLoggable(Level.FINE)) {
            this.updateLogger.fine("<<NAMING UNBIND>><<SUCCESS>> NameComponent:  " + this.getName(nameComponent));
        }
        return internalBindingValue.theObjectRef;
    }

    public final void List(int n, BindingListHolder bindingListHolder, BindingIteratorHolder bindingIteratorHolder) throws SystemException {
        try {
            BindingIterator bindingIterator;
            TransientBindingIterator transientBindingIterator = new TransientBindingIterator(this.orb, (Hashtable)this.theHashtable.clone(), this.nsPOA);
            transientBindingIterator.list(n, bindingListHolder);
            byte[] byArray = this.nsPOA.activate_object(transientBindingIterator);
            Object object = this.nsPOA.id_to_reference(byArray);
            bindingIteratorHolder.value = bindingIterator = BindingIteratorHelper.narrow(object);
        }
        catch (SystemException systemException) {
            this.readLogger.warning("<<NAMING LIST>><<FAILURE>>" + systemException);
            throw systemException;
        }
        catch (Exception exception) {
            this.readLogger.severe("<<NAMING LIST>><<FAILURE>>" + exception);
            throw this.wrapper.transNcListGotExc(exception);
        }
    }

    public final NamingContext NewContext() throws SystemException {
        try {
            TransientNamingContext transientNamingContext = new TransientNamingContext(this.orb, this.localRoot, this.nsPOA);
            byte[] byArray = this.nsPOA.activate_object(transientNamingContext);
            Object object = this.nsPOA.id_to_reference(byArray);
            this.lifecycleLogger.fine("TransientNamingContext LIFECYCLE.CREATE SUCCESSFUL");
            return NamingContextHelper.narrow(object);
        }
        catch (SystemException systemException) {
            this.lifecycleLogger.log(Level.WARNING, "<<LIFECYCLE CREATE>><<FAILURE>>", systemException);
            throw systemException;
        }
        catch (Exception exception) {
            this.lifecycleLogger.log(Level.WARNING, "<<LIFECYCLE CREATE>><<FAILURE>>", exception);
            throw this.wrapper.transNcNewctxGotExc(exception);
        }
    }

    public final void Destroy() throws SystemException {
        try {
            byte[] byArray = this.nsPOA.servant_to_id(this);
            if (byArray != null) {
                this.nsPOA.deactivate_object(byArray);
            }
            if (this.lifecycleLogger.isLoggable(Level.FINE)) {
                this.lifecycleLogger.fine("<<LIFECYCLE DESTROY>><<SUCCESS>>");
            }
        }
        catch (SystemException systemException) {
            this.lifecycleLogger.log(Level.WARNING, "<<LIFECYCLE DESTROY>><<FAILURE>>", systemException);
            throw systemException;
        }
        catch (Exception exception) {
            this.lifecycleLogger.log(Level.WARNING, "<<LIFECYCLE DESTROY>><<FAILURE>>", exception);
            throw this.wrapper.transNcDestroyGotExc(exception);
        }
    }

    private String getName(NameComponent nameComponent) {
        return nameComponent.id + "." + nameComponent.kind;
    }

    public final boolean IsEmpty() {
        return this.theHashtable.isEmpty();
    }
}

