/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class BoxView
extends CompositeView {
    int majorAxis;
    int majorSpan;
    int minorSpan;
    boolean majorReqValid;
    boolean minorReqValid;
    SizeRequirements majorRequest;
    SizeRequirements minorRequest;
    boolean majorAllocValid;
    int[] majorOffsets;
    int[] majorSpans;
    boolean minorAllocValid;
    int[] minorOffsets;
    int[] minorSpans;
    Rectangle tempRect = new Rectangle();

    public BoxView(Element element, int n) {
        super(element);
        this.majorAxis = n;
        this.majorOffsets = new int[0];
        this.majorSpans = new int[0];
        this.majorReqValid = false;
        this.majorAllocValid = false;
        this.minorOffsets = new int[0];
        this.minorSpans = new int[0];
        this.minorReqValid = false;
        this.minorAllocValid = false;
    }

    public int getAxis() {
        return this.majorAxis;
    }

    public void setAxis(int n) {
        boolean bl = n != this.majorAxis;
        this.majorAxis = n;
        if (bl) {
            this.preferenceChanged(null, true, true);
        }
    }

    public void layoutChanged(int n) {
        if (n == this.majorAxis) {
            this.majorAllocValid = false;
        } else {
            this.minorAllocValid = false;
        }
    }

    protected boolean isLayoutValid(int n) {
        if (n == this.majorAxis) {
            return this.majorAllocValid;
        }
        return this.minorAllocValid;
    }

    protected void paintChild(Graphics graphics, Rectangle rectangle, int n) {
        View view = this.getView(n);
        view.paint(graphics, rectangle);
    }

    public void replace(int n, int n2, View[] viewArray) {
        super.replace(n, n2, viewArray);
        int n3 = viewArray != null ? viewArray.length : 0;
        this.majorOffsets = this.updateLayoutArray(this.majorOffsets, n, n3);
        this.majorSpans = this.updateLayoutArray(this.majorSpans, n, n3);
        this.majorReqValid = false;
        this.majorAllocValid = false;
        this.minorOffsets = this.updateLayoutArray(this.minorOffsets, n, n3);
        this.minorSpans = this.updateLayoutArray(this.minorSpans, n, n3);
        this.minorReqValid = false;
        this.minorAllocValid = false;
    }

    int[] updateLayoutArray(int[] nArray, int n, int n2) {
        int n3 = this.getViewCount();
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        System.arraycopy(nArray, n, nArray2, n + n2, n3 - n2 - n);
        return nArray2;
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        boolean bl = this.isLayoutValid(this.majorAxis);
        super.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        if (bl && !this.isLayoutValid(this.majorAxis)) {
            Container container = this.getContainer();
            if (shape != null && container != null) {
                int n = documentEvent.getOffset();
                int n2 = this.getViewIndexAtPosition(n);
                Rectangle rectangle = this.getInsideAllocation(shape);
                if (this.majorAxis == 0) {
                    rectangle.x += this.majorOffsets[n2];
                    rectangle.width -= this.majorOffsets[n2];
                } else {
                    rectangle.y += this.minorOffsets[n2];
                    rectangle.height -= this.minorOffsets[n2];
                }
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    public void preferenceChanged(View view, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = this.majorAxis == 0 ? bl : bl2;
        boolean bl5 = bl3 = this.majorAxis == 0 ? bl2 : bl;
        if (bl4) {
            this.majorReqValid = false;
            this.majorAllocValid = false;
        }
        if (bl3) {
            this.minorReqValid = false;
            this.minorAllocValid = false;
        }
        super.preferenceChanged(view, bl, bl2);
    }

    public int getResizeWeight(int n) {
        this.checkRequests(n);
        if (n == this.majorAxis ? this.majorRequest.preferred != this.majorRequest.minimum || this.majorRequest.preferred != this.majorRequest.maximum : this.minorRequest.preferred != this.minorRequest.minimum || this.minorRequest.preferred != this.minorRequest.maximum) {
            return 1;
        }
        return 0;
    }

    void setSpanOnAxis(int n, float f) {
        if (n == this.majorAxis) {
            if (this.majorSpan != (int)f) {
                this.majorAllocValid = false;
            }
            if (!this.majorAllocValid) {
                this.majorSpan = (int)f;
                this.checkRequests(this.majorAxis);
                this.layoutMajorAxis(this.majorSpan, n, this.majorOffsets, this.majorSpans);
                this.majorAllocValid = true;
                this.updateChildSizes();
            }
        } else {
            if ((int)f != this.minorSpan) {
                this.minorAllocValid = false;
            }
            if (!this.minorAllocValid) {
                this.minorSpan = (int)f;
                this.checkRequests(n);
                this.layoutMinorAxis(this.minorSpan, n, this.minorOffsets, this.minorSpans);
                this.minorAllocValid = true;
                this.updateChildSizes();
            }
        }
    }

    void updateChildSizes() {
        int n = this.getViewCount();
        if (this.majorAxis == 0) {
            for (int i = 0; i < n; ++i) {
                View view = this.getView(i);
                view.setSize(this.majorSpans[i], this.minorSpans[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                View view = this.getView(i);
                view.setSize(this.minorSpans[i], this.majorSpans[i]);
            }
        }
    }

    float getSpanOnAxis(int n) {
        if (n == this.majorAxis) {
            return this.majorSpan;
        }
        return this.minorSpan;
    }

    public void setSize(float f, float f2) {
        this.layout(Math.max(0, (int)(f - (float)this.getLeftInset() - (float)this.getRightInset())), Math.max(0, (int)(f2 - (float)this.getTopInset() - (float)this.getBottomInset())));
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        int n = this.getViewCount();
        int n2 = rectangle.x + this.getLeftInset();
        int n3 = rectangle.y + this.getTopInset();
        Rectangle rectangle2 = graphics.getClipBounds();
        for (int i = 0; i < n; ++i) {
            this.tempRect.x = n2 + this.getOffset(0, i);
            this.tempRect.y = n3 + this.getOffset(1, i);
            this.tempRect.width = this.getSpan(0, i);
            this.tempRect.height = this.getSpan(1, i);
            int n4 = this.tempRect.x;
            int n5 = n4 + this.tempRect.width;
            int n6 = this.tempRect.y;
            int n7 = n6 + this.tempRect.height;
            int n8 = rectangle2.x;
            int n9 = n8 + rectangle2.width;
            int n10 = rectangle2.y;
            int n11 = n10 + rectangle2.height;
            if (n5 < n8 || n7 < n10 || n9 < n4 || n11 < n6) continue;
            this.paintChild(graphics, this.tempRect, i);
        }
    }

    public Shape getChildAllocation(int n, Shape shape) {
        if (shape != null) {
            Shape shape2 = super.getChildAllocation(n, shape);
            if (shape2 != null && !this.isAllocationValid()) {
                Rectangle rectangle;
                Rectangle rectangle2 = rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
                if (rectangle.width == 0 && rectangle.height == 0) {
                    return null;
                }
            }
            return shape2;
        }
        return null;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        if (!this.isAllocationValid()) {
            Rectangle rectangle = shape.getBounds();
            this.setSize(rectangle.width, rectangle.height);
        }
        return super.modelToView(n, shape, bias);
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        if (!this.isAllocationValid()) {
            Rectangle rectangle = shape.getBounds();
            this.setSize(rectangle.width, rectangle.height);
        }
        return super.viewToModel(f, f2, shape, biasArray);
    }

    public float getAlignment(int n) {
        this.checkRequests(n);
        if (n == this.majorAxis) {
            return this.majorRequest.alignment;
        }
        return this.minorRequest.alignment;
    }

    public float getPreferredSpan(int n) {
        float f;
        this.checkRequests(n);
        float f2 = f = n == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        if (n == this.majorAxis) {
            return (float)this.majorRequest.preferred + f;
        }
        return (float)this.minorRequest.preferred + f;
    }

    public float getMinimumSpan(int n) {
        float f;
        this.checkRequests(n);
        float f2 = f = n == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        if (n == this.majorAxis) {
            return (float)this.majorRequest.minimum + f;
        }
        return (float)this.minorRequest.minimum + f;
    }

    public float getMaximumSpan(int n) {
        float f;
        this.checkRequests(n);
        float f2 = f = n == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        if (n == this.majorAxis) {
            return (float)this.majorRequest.maximum + f;
        }
        return (float)this.minorRequest.maximum + f;
    }

    protected boolean isAllocationValid() {
        return this.majorAllocValid && this.minorAllocValid;
    }

    protected boolean isBefore(int n, int n2, Rectangle rectangle) {
        if (this.majorAxis == 0) {
            return n < rectangle.x;
        }
        return n2 < rectangle.y;
    }

    protected boolean isAfter(int n, int n2, Rectangle rectangle) {
        if (this.majorAxis == 0) {
            return n > rectangle.width + rectangle.x;
        }
        return n2 > rectangle.height + rectangle.y;
    }

    protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
        int n3 = this.getViewCount();
        if (this.majorAxis == 0) {
            if (n < rectangle.x + this.majorOffsets[0]) {
                this.childAllocation(0, rectangle);
                return this.getView(0);
            }
            for (int i = 0; i < n3; ++i) {
                if (n >= rectangle.x + this.majorOffsets[i]) continue;
                this.childAllocation(i - 1, rectangle);
                return this.getView(i - 1);
            }
            this.childAllocation(n3 - 1, rectangle);
            return this.getView(n3 - 1);
        }
        if (n2 < rectangle.y + this.majorOffsets[0]) {
            this.childAllocation(0, rectangle);
            return this.getView(0);
        }
        for (int i = 0; i < n3; ++i) {
            if (n2 >= rectangle.y + this.majorOffsets[i]) continue;
            this.childAllocation(i - 1, rectangle);
            return this.getView(i - 1);
        }
        this.childAllocation(n3 - 1, rectangle);
        return this.getView(n3 - 1);
    }

    protected void childAllocation(int n, Rectangle rectangle) {
        rectangle.x += this.getOffset(0, n);
        rectangle.y += this.getOffset(1, n);
        rectangle.width = this.getSpan(0, n);
        rectangle.height = this.getSpan(1, n);
    }

    protected void layout(int n, int n2) {
        this.setSpanOnAxis(0, n);
        this.setSpanOnAxis(1, n2);
    }

    public int getWidth() {
        int n = this.majorAxis == 0 ? this.majorSpan : this.minorSpan;
        return n += this.getLeftInset() - this.getRightInset();
    }

    public int getHeight() {
        int n = this.majorAxis == 1 ? this.majorSpan : this.minorSpan;
        return n += this.getTopInset() - this.getBottomInset();
    }

    protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        float f;
        long l = 0L;
        int n3 = this.getViewCount();
        for (int i = 0; i < n3; ++i) {
            View view = this.getView(i);
            nArray2[i] = (int)view.getPreferredSpan(n2);
            l += (long)nArray2[i];
        }
        long l2 = (long)n - l;
        float f2 = 0.0f;
        int[] nArray3 = null;
        if (l2 != 0L) {
            long l3 = 0L;
            nArray3 = new int[n3];
            for (int i = 0; i < n3; ++i) {
                int n4;
                View view = this.getView(i);
                if (l2 < 0L) {
                    n4 = (int)view.getMinimumSpan(n2);
                    nArray3[i] = nArray2[i] - n4;
                } else {
                    n4 = (int)view.getMaximumSpan(n2);
                    nArray3[i] = n4 - nArray2[i];
                }
                l3 += (long)n4;
            }
            f = Math.abs(l3 - l);
            f2 = (float)l2 / f;
            f2 = Math.min(f2, 1.0f);
            f2 = Math.max(f2, -1.0f);
        }
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            nArray[i] = n5;
            if (l2 != 0L) {
                f = f2 * (float)nArray3[i];
                int n6 = i;
                nArray2[n6] = nArray2[n6] + Math.round(f);
            }
            n5 = (int)Math.min((long)n5 + (long)nArray2[i], Integer.MAX_VALUE);
        }
    }

    protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = this.getViewCount();
        for (int i = 0; i < n3; ++i) {
            View view = this.getView(i);
            int n4 = (int)view.getMaximumSpan(n2);
            if (n4 < n) {
                float f = view.getAlignment(n2);
                nArray[i] = (int)((float)(n - n4) * f);
                nArray2[i] = n4;
                continue;
            }
            int n5 = (int)view.getMinimumSpan(n2);
            nArray[i] = 0;
            nArray2[i] = Math.max(n5, n);
        }
    }

    protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n2 = this.getViewCount();
        for (int i = 0; i < n2; ++i) {
            View view = this.getView(i);
            f += view.getMinimumSpan(n);
            f2 += view.getPreferredSpan(n);
            f3 += view.getMaximumSpan(n);
        }
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        sizeRequirements.alignment = 0.5f;
        sizeRequirements.minimum = (int)f;
        sizeRequirements.preferred = (int)f2;
        sizeRequirements.maximum = (int)f3;
        return sizeRequirements;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        int n2 = 0;
        long l = 0L;
        int n3 = Integer.MAX_VALUE;
        int n4 = this.getViewCount();
        for (int i = 0; i < n4; ++i) {
            View view = this.getView(i);
            n2 = Math.max((int)view.getMinimumSpan(n), n2);
            l = Math.max((long)((int)view.getPreferredSpan(n)), l);
            n3 = Math.max((int)view.getMaximumSpan(n), n3);
        }
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
            sizeRequirements.alignment = 0.5f;
        }
        sizeRequirements.preferred = (int)l;
        sizeRequirements.minimum = n2;
        sizeRequirements.maximum = n3;
        return sizeRequirements;
    }

    void checkRequests(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid axis: " + n);
        }
        if (n == this.majorAxis) {
            if (!this.majorReqValid) {
                this.majorRequest = this.calculateMajorAxisRequirements(n, this.majorRequest);
                this.majorReqValid = true;
            }
        } else if (!this.minorReqValid) {
            this.minorRequest = this.calculateMinorAxisRequirements(n, this.minorRequest);
            this.minorReqValid = true;
        }
    }

    protected void baselineLayout(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = (int)((float)n * this.getAlignment(n2));
        int n4 = n - n3;
        int n5 = this.getViewCount();
        for (int i = 0; i < n5; ++i) {
            float f;
            View view = this.getView(i);
            float f2 = view.getAlignment(n2);
            if (view.getResizeWeight(n2) > 0) {
                float f3 = view.getMinimumSpan(n2);
                float f4 = view.getMaximumSpan(n2);
                if (f2 == 0.0f) {
                    f = Math.max(Math.min(f4, (float)n4), f3);
                } else if (f2 == 1.0f) {
                    f = Math.max(Math.min(f4, (float)n3), f3);
                } else {
                    float f5 = Math.min((float)n3 / f2, (float)n4 / (1.0f - f2));
                    f = Math.max(Math.min(f4, f5), f3);
                }
            } else {
                f = view.getPreferredSpan(n2);
            }
            nArray[i] = n3 - (int)(f * f2);
            nArray2[i] = (int)f;
        }
    }

    protected SizeRequirements baselineRequirements(int n, SizeRequirements sizeRequirements) {
        SizeRequirements sizeRequirements2 = new SizeRequirements();
        SizeRequirements sizeRequirements3 = new SizeRequirements();
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        sizeRequirements.alignment = 0.5f;
        int n2 = this.getViewCount();
        for (int i = 0; i < n2; ++i) {
            View view = this.getView(i);
            float f = view.getAlignment(n);
            float f2 = view.getPreferredSpan(n);
            int n3 = (int)(f * f2);
            int n4 = (int)(f2 - (float)n3);
            sizeRequirements2.preferred = Math.max(n3, sizeRequirements2.preferred);
            sizeRequirements3.preferred = Math.max(n4, sizeRequirements3.preferred);
            if (view.getResizeWeight(n) > 0) {
                f2 = view.getMinimumSpan(n);
                n3 = (int)(f * f2);
                n4 = (int)(f2 - (float)n3);
                sizeRequirements2.minimum = Math.max(n3, sizeRequirements2.minimum);
                sizeRequirements3.minimum = Math.max(n4, sizeRequirements3.minimum);
                f2 = view.getMaximumSpan(n);
                n3 = (int)(f * f2);
                n4 = (int)(f2 - (float)n3);
                sizeRequirements2.maximum = Math.max(n3, sizeRequirements2.maximum);
                sizeRequirements3.maximum = Math.max(n4, sizeRequirements3.maximum);
                continue;
            }
            sizeRequirements2.minimum = Math.max(n3, sizeRequirements2.minimum);
            sizeRequirements3.minimum = Math.max(n4, sizeRequirements3.minimum);
            sizeRequirements2.maximum = Math.max(n3, sizeRequirements2.maximum);
            sizeRequirements3.maximum = Math.max(n4, sizeRequirements3.maximum);
        }
        sizeRequirements.preferred = (int)Math.min((long)sizeRequirements2.preferred + (long)sizeRequirements3.preferred, Integer.MAX_VALUE);
        if (sizeRequirements.preferred > 0) {
            sizeRequirements.alignment = (float)sizeRequirements2.preferred / (float)sizeRequirements.preferred;
        }
        if (sizeRequirements.alignment == 0.0f) {
            sizeRequirements.minimum = sizeRequirements3.minimum;
            sizeRequirements.maximum = sizeRequirements3.maximum;
        } else if (sizeRequirements.alignment == 1.0f) {
            sizeRequirements.minimum = sizeRequirements2.minimum;
            sizeRequirements.maximum = sizeRequirements2.maximum;
        } else {
            sizeRequirements.minimum = Math.round(Math.max((float)sizeRequirements2.minimum / sizeRequirements.alignment, (float)sizeRequirements3.minimum / (1.0f - sizeRequirements.alignment)));
            sizeRequirements.maximum = Math.round(Math.min((float)sizeRequirements2.maximum / sizeRequirements.alignment, (float)sizeRequirements3.maximum / (1.0f - sizeRequirements.alignment)));
        }
        return sizeRequirements;
    }

    protected int getOffset(int n, int n2) {
        int[] nArray = n == this.majorAxis ? this.majorOffsets : this.minorOffsets;
        return nArray[n2];
    }

    protected int getSpan(int n, int n2) {
        int[] nArray = n == this.majorAxis ? this.majorSpans : this.minorSpans;
        return nArray[n2];
    }

    protected boolean flipEastAndWestAtEnds(int n, Position.Bias bias) {
        View view;
        int n2;
        int n3;
        if (this.majorAxis == 1 && (n3 = this.getViewIndexAtPosition(n2 = bias == Position.Bias.Backward ? Math.max(0, n - 1) : n)) != -1 && (view = this.getView(n3)) != null && view instanceof CompositeView) {
            return ((CompositeView)view).flipEastAndWestAtEnds(n, bias);
        }
        return false;
    }
}

