/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute.standard;

import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.print.attribute.Attribute;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.standard.PrinterStateReason;
import javax.print.attribute.standard.Severity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrinterStateReasons
extends HashMap<PrinterStateReason, Severity>
implements PrintServiceAttribute {
    private static final long serialVersionUID = -3731791085163619457L;

    public PrinterStateReasons() {
    }

    public PrinterStateReasons(int n) {
        super(n);
    }

    public PrinterStateReasons(int n, float f) {
        super(n, f);
    }

    public PrinterStateReasons(Map<PrinterStateReason, Severity> map) {
        this();
        for (Map.Entry<PrinterStateReason, Severity> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Severity put(PrinterStateReason printerStateReason, Severity severity) {
        if (printerStateReason == null) {
            throw new NullPointerException("reason is null");
        }
        if (severity == null) {
            throw new NullPointerException("severity is null");
        }
        return super.put(printerStateReason, severity);
    }

    @Override
    public final Class<? extends Attribute> getCategory() {
        return PrinterStateReasons.class;
    }

    @Override
    public final String getName() {
        return "printer-state-reasons";
    }

    public Set<PrinterStateReason> printerStateReasonSet(Severity severity) {
        if (severity == null) {
            throw new NullPointerException("severity is null");
        }
        return new PrinterStateReasonSet(severity, this.entrySet());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PrinterStateReasonSet
    extends AbstractSet<PrinterStateReason> {
        private Severity mySeverity;
        private Set myEntrySet;

        public PrinterStateReasonSet(Severity severity, Set set) {
            this.mySeverity = severity;
            this.myEntrySet = set;
        }

        @Override
        public int size() {
            int n = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
            return n;
        }

        @Override
        public Iterator iterator() {
            return new PrinterStateReasonSetIterator(this.mySeverity, this.myEntrySet.iterator());
        }
    }

    private class PrinterStateReasonSetIterator
    implements Iterator {
        private Severity mySeverity;
        private Iterator myIterator;
        private Map.Entry myEntry;

        public PrinterStateReasonSetIterator(Severity severity, Iterator iterator) {
            this.mySeverity = severity;
            this.myIterator = iterator;
            this.goToNext();
        }

        private void goToNext() {
            this.myEntry = null;
            while (this.myEntry == null && this.myIterator.hasNext()) {
                this.myEntry = (Map.Entry)this.myIterator.next();
                if ((Severity)this.myEntry.getValue() == this.mySeverity) continue;
                this.myEntry = null;
            }
        }

        public boolean hasNext() {
            return this.myEntry != null;
        }

        public Object next() {
            if (this.myEntry == null) {
                throw new NoSuchElementException();
            }
            Object k = this.myEntry.getKey();
            this.goToNext();
            return k;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

